/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.cnf;

import java.io.Serializable;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.Propagatable;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.IVecInt;

public abstract class WLClause
implements Propagatable,
Constr,
Serializable {
    private static final long serialVersionUID = 1L;
    protected double activity;
    protected final int[] lits;
    protected final ILits voc;

    public WLClause(IVecInt iVecInt, ILits iLits) {
        this.lits = new int[iVecInt.size()];
        iVecInt.moveTo(this.lits);
        assert (iVecInt.size() == 0);
        this.voc = iLits;
        this.activity = 0.0;
    }

    public void calcReason(int n, IVecInt iVecInt) {
        int n2;
        int[] nArray = this.lits;
        int n3 = n2 = n == -1 ? 0 : 1;
        while (n2 < nArray.length) {
            assert (this.voc.isFalsified(nArray[n2]));
            iVecInt.push(nArray[n2] ^ 1);
            ++n2;
        }
    }

    public void remove(UnitPropagationListener unitPropagationListener) {
        this.voc.watches(this.lits[0] ^ 1).remove(this);
        this.voc.watches(this.lits[1] ^ 1).remove(this);
    }

    public boolean simplify() {
        for (int n : this.lits) {
            if (!this.voc.isSatisfied(n)) continue;
            return true;
        }
        return false;
    }

    public boolean propagate(UnitPropagationListener unitPropagationListener, int n) {
        int n2;
        int[] nArray = this.lits;
        if (nArray[0] == (n ^ 1)) {
            nArray[0] = nArray[1];
            nArray[1] = n ^ 1;
        }
        int n3 = n ^ 1;
        for (n2 = 2; n2 < nArray.length; ++n2) {
            if (!this.voc.isFalsified(nArray[n2])) {
                nArray[1] = nArray[n2];
                nArray[n2] = n3;
                this.voc.watch(nArray[1] ^ 1, this);
                return true;
            }
            int n4 = n3;
            n3 = nArray[n2];
            nArray[n2] = n4;
        }
        for (n2 = 2; n2 < nArray.length; ++n2) {
            nArray[n2 - 1] = nArray[n2];
        }
        nArray[nArray.length - 1] = n3;
        this.voc.watch(n, this);
        return unitPropagationListener.enqueue(nArray[0], this);
    }

    public boolean locked() {
        return this.voc.getReason(this.lits[0]) == this;
    }

    public double getActivity() {
        return this.activity;
    }

    public void setActivity(double d) {
        this.activity = d;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int n : this.lits) {
            stringBuffer.append(Lits.toString(n));
            stringBuffer.append("[");
            stringBuffer.append(this.voc.valueToString(n));
            stringBuffer.append("]");
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public int get(int n) {
        return this.lits[n];
    }

    public void rescaleBy(double d) {
        this.activity *= d;
    }

    public int size() {
        return this.lits.length;
    }

    public void assertConstraint(UnitPropagationListener unitPropagationListener) {
        boolean bl = unitPropagationListener.enqueue(this.lits[0], this);
        assert (bl);
    }

    public ILits getVocabulary() {
        return this.voc;
    }

    public int[] getLits() {
        int[] nArray = new int[this.size()];
        System.arraycopy(this.lits, 0, nArray, 0, this.size());
        return nArray;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            WLClause wLClause = (WLClause)object;
            if (this.lits.length != wLClause.lits.length) {
                return false;
            }
            for (int n : this.lits) {
                boolean bl = false;
                for (int n2 : wLClause.lits) {
                    if (n != n2) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        long l = 0L;
        for (int n : this.lits) {
            l += (long)n;
        }
        return (int)l / this.lits.length;
    }

    public boolean canBePropagatedMultipleTimes() {
        return false;
    }

    public Constr toConstraint() {
        return this;
    }
}

