/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util;

import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.ParsePosition;

public class DebugMessage {
    private static final TermDirectFormat TERM_FORMAT = new TermDirectFormat();
    private final boolean mTermDirect;
    private final String mMsg;
    private final Object[] mParams;

    public DebugMessage(String msg, Object ... params) {
        this(false, msg, params);
    }

    public DebugMessage(boolean termDirect, String msg, Object ... params) {
        this.mTermDirect = termDirect;
        this.mMsg = msg;
        this.mParams = params;
    }

    public String toString() {
        MessageFormat mf = new MessageFormat(this.mMsg);
        if (this.mTermDirect) {
            for (int i = 0; i < this.mParams.length; ++i) {
                if (!(this.mParams[i] instanceof Term)) continue;
                mf.setFormatByArgumentIndex(i, TERM_FORMAT);
            }
        }
        return mf.format(this.mParams, new StringBuffer(), (FieldPosition)null).toString();
    }

    private static class TermDirectFormat
    extends Format {
        private static final long serialVersionUID = -6518060753837104534L;

        private TermDirectFormat() {
        }

        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            return toAppendTo.append(((Term)obj).toStringDirect());
        }

        public Object parseObject(String source, ParsePosition pos) {
            throw new UnsupportedOperationException();
        }
    }
}

