/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharingSet<E>
extends AbstractSet<E> {
    private SharingSetData<E> mData;

    public SharingSet() {
        this.mData = new SharingSetData();
    }

    public SharingSet(SharingSet<E> other) {
        this.mData = other.mData.share();
    }

    public SharingSet(E obj) {
        this.mData = new SharingSetData<E>(obj);
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            Iterator<E> mSink;
            {
                this.mSink = ((SharingSet)SharingSet.this).mData.mRep.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.mSink.hasNext();
            }

            @Override
            public E next() {
                return this.mSink.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove not allowed on SharingSet iterator");
            }
        };
    }

    @Override
    public int size() {
        return this.mData.mRep.size();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        SharingSetData<E> data = this.mData.detach();
        boolean res = data.mRep.removeAll(c);
        if (res) {
            this.mData = data;
        }
        return res;
    }

    @Override
    public boolean add(E e) {
        if (this.mData.mRep.contains(e)) {
            return false;
        }
        this.mData = this.mData.detach();
        return this.mData.mRep.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (this.mData.mRep.containsAll(c)) {
            return false;
        }
        this.mData = this.mData.detach();
        return this.mData.mRep.addAll(c);
    }

    public boolean addShared(SharingSet<E> other) {
        if (other == null) {
            return false;
        }
        if (this.mData.mRep.isEmpty() && this.mData.mSharing == 0) {
            this.mData = other.mData.share();
            return true;
        }
        return this.addAll(other.mData.mRep);
    }

    @Override
    public boolean contains(Object o) {
        return this.mData.mRep.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.mData.mRep.containsAll(c);
    }

    @Override
    public boolean remove(Object o) {
        if (this.mData.mRep.contains(o)) {
            this.mData = this.mData.detach();
            return this.mData.mRep.remove(o);
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SharingSetData<E> {
        Set<E> mRep;
        int mSharing;

        SharingSetData() {
            this.mRep = new HashSet();
            this.mSharing = 0;
        }

        SharingSetData(SharingSetData<E> other) {
            this.mRep = new HashSet<E>(other.mRep);
            this.mSharing = 0;
        }

        SharingSetData(E obj) {
            this.mRep = Collections.singleton(obj);
            this.mSharing = 1;
        }

        SharingSetData<E> share() {
            ++this.mSharing;
            return this;
        }

        SharingSetData<E> detach() {
            if (this.mSharing != 0) {
                --this.mSharing;
                return new SharingSetData<SharingSetData>(this);
            }
            return this;
        }
    }
}

