/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.util;

import de.uni_freiburg.informatik.ultimate.util.ScopeUtils;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopedIdentityHashMap<K, V>
extends AbstractMap<K, V> {
    IdentityHashMap<K, V> mMap = new IdentityHashMap();
    IdentityHashMap<K, V>[] mHistory = new IdentityHashMap[5];
    int mCurScope = -1;

    private IdentityHashMap<K, V> undoMap() {
        return this.mHistory[this.mCurScope];
    }

    private void recordUndo(K key, V value) {
        IdentityHashMap<K, V> old;
        if (this.mCurScope != -1 && !(old = this.undoMap()).containsKey(key)) {
            old.put(key, value);
        }
    }

    private void undoEntry(Map.Entry<K, V> old) {
        if (old.getValue() == null) {
            this.mMap.remove(old.getKey());
        } else {
            this.mMap.put(old.getKey(), old.getValue());
        }
    }

    public void beginScope() {
        if (this.mCurScope == this.mHistory.length - 1) {
            this.mHistory = ScopeUtils.grow(this.mHistory);
        }
        this.mHistory[++this.mCurScope] = new IdentityHashMap();
    }

    public void endScope() {
        for (Map.Entry<K, V> old : this.undoMap().entrySet()) {
            this.undoEntry(old);
        }
        this.mHistory[this.mCurScope--] = null;
        if (ScopeUtils.shouldShrink(this.mHistory)) {
            this.mHistory = ScopeUtils.shrink(this.mHistory);
        }
    }

    public Iterable<Map.Entry<K, V>> currentScopeEntries() {
        if (this.mCurScope == -1) {
            return this.entrySet();
        }
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    Iterator<Map.Entry<K, V>> mBacking;
                    Map.Entry<K, V> mLast;
                    {
                        this.mBacking = ScopedIdentityHashMap.this.undoMap().entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.mBacking.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        this.mLast = this.mBacking.next();
                        final Object key = this.mLast.getKey();
                        return new Map.Entry<K, V>(){

                            @Override
                            public K getKey() {
                                return key;
                            }

                            @Override
                            public V getValue() {
                                return ScopedIdentityHashMap.this.mMap.get(key);
                            }

                            @Override
                            public V setValue(V value) {
                                return ScopedIdentityHashMap.this.mMap.put(key, value);
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        this.mBacking.remove();
                        ScopedIdentityHashMap.this.undoEntry(this.mLast);
                    }
                };
            }

            @Override
            public int size() {
                return ScopedIdentityHashMap.this.undoMap().size();
            }
        };
    }

    public Iterable<K> currentScopeKeys() {
        if (this.mCurScope == -1) {
            return this.keySet();
        }
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return new Iterator<K>(){
                    Iterator<Map.Entry<K, V>> mBacking;
                    Map.Entry<K, V> mLast;
                    {
                        this.mBacking = ScopedIdentityHashMap.this.undoMap().entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.mBacking.hasNext();
                    }

                    @Override
                    public K next() {
                        this.mLast = this.mBacking.next();
                        return this.mLast.getKey();
                    }

                    @Override
                    public void remove() {
                        this.mBacking.remove();
                        ScopedIdentityHashMap.this.undoEntry(this.mLast);
                    }
                };
            }

            @Override
            public int size() {
                return ScopedIdentityHashMap.this.undoMap().size();
            }
        };
    }

    public Iterable<V> currentScopeValues() {
        if (this.mCurScope == -1) {
            return this.values();
        }
        return new AbstractSet<V>(){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    Iterator<Map.Entry<K, V>> mBacking;
                    Map.Entry<K, V> mLast;
                    {
                        this.mBacking = ScopedIdentityHashMap.this.undoMap().entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.mBacking.hasNext();
                    }

                    @Override
                    public V next() {
                        this.mLast = this.mBacking.next();
                        return ScopedIdentityHashMap.this.mMap.get(this.mLast.getKey());
                    }

                    @Override
                    public void remove() {
                        this.mBacking.remove();
                        ScopedIdentityHashMap.this.undoEntry(this.mLast);
                    }
                };
            }

            @Override
            public int size() {
                return ScopedIdentityHashMap.this.undoMap().size();
            }
        };
    }

    @Override
    public void clear() {
        this.mMap.clear();
        this.mHistory = new IdentityHashMap[5];
    }

    @Override
    public boolean containsKey(Object key) {
        return this.mMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.mMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.mMap.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.mMap.isEmpty();
    }

    public boolean isEmptyScope() {
        return this.mCurScope == -1;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    Iterator<Map.Entry<K, V>> mBacking;
                    Map.Entry<K, V> mLast;
                    {
                        this.mBacking = ScopedIdentityHashMap.this.mMap.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.mBacking.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        this.mLast = this.mBacking.next();
                        return this.mLast;
                    }

                    @Override
                    public void remove() {
                        this.mBacking.remove();
                        ScopedIdentityHashMap.this.recordUndo(this.mLast.getKey(), this.mLast.getValue());
                    }
                };
            }

            @Override
            public int size() {
                return ScopedIdentityHashMap.this.mMap.size();
            }
        };
    }

    @Override
    public V put(K key, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        V oldval = this.mMap.put(key, value);
        this.recordUndo(key, oldval);
        return oldval;
    }

    @Override
    public V remove(Object key) {
        V oldval = this.mMap.remove(key);
        this.recordUndo(key, oldval);
        return oldval;
    }

    @Override
    public int size() {
        return this.mMap.size();
    }

    public int currentScopeSize() {
        return this.undoMap().size();
    }

    public int getActiveScopeNum() {
        return this.mCurScope + 1;
    }
}

