/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.util;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.HashMap;
import java.util.Map;

public class DAGSize
extends NonRecursive {
    private Map<Term, Long> mCache = new HashMap<Term, Long>();
    private boolean mComputeTreeSize;
    private long mSize = 0L;

    public void reset() {
        super.reset();
        this.mCache.clear();
        this.mSize = 0L;
    }

    public int size(Term term) {
        this.mComputeTreeSize = false;
        this.run(new TermOnceWalker(new FormulaUnLet().unlet(term)));
        return (int)this.mSize;
    }

    public long treesize(Term term) {
        this.mComputeTreeSize = true;
        this.run(new TermOnceWalker(new FormulaUnLet().unlet(term)));
        return this.mSize;
    }

    private class TermOnceWalker
    extends NonRecursive.TermWalker {
        public TermOnceWalker(Term term) {
            super(term);
        }

        public void walk(NonRecursive walker) {
            if (DAGSize.this.mCache.containsKey(this.mTerm)) {
                if (DAGSize.this.mComputeTreeSize) {
                    DAGSize.this.mSize = DAGSize.this.mSize + (Long)DAGSize.this.mCache.get(this.mTerm);
                }
                return;
            }
            if (DAGSize.this.mComputeTreeSize) {
                DAGSize.this.enqueueWalker(new TreeSizeCache(this.mTerm));
            } else {
                DAGSize.this.mCache.put(this.mTerm, 0L);
            }
            ++DAGSize.this.mSize;
            super.walk(walker);
        }

        public void walk(NonRecursive walker, ConstantTerm term) {
        }

        public void walk(NonRecursive walker, AnnotatedTerm term) {
            walker.enqueueWalker(new TermOnceWalker(term.getSubterm()));
        }

        public void walk(NonRecursive walker, ApplicationTerm term) {
            for (Term t : term.getParameters()) {
                walker.enqueueWalker(new TermOnceWalker(t));
            }
        }

        public void walk(NonRecursive walker, LetTerm term) {
            throw new InternalError("Input should be unletted");
        }

        public void walk(NonRecursive walker, QuantifiedFormula term) {
            walker.enqueueWalker(new TermOnceWalker(term.getSubformula()));
        }

        public void walk(NonRecursive walker, TermVariable term) {
        }
    }

    private class TreeSizeCache
    implements NonRecursive.Walker {
        long mSizeBefore = 0L;
        Term mTerm;

        public TreeSizeCache(Term term) {
            this.mSizeBefore = DAGSize.this.mSize;
            this.mTerm = term;
        }

        public void walk(NonRecursive walker) {
            DAGSize.this.mCache.put(this.mTerm, DAGSize.this.mSize - this.mSizeBefore);
        }
    }
}

