/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.util;

import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;

public final class Coercion {
    private Coercion() {
    }

    public static Term toInt(Term t) {
        assert (t.getSort().getName().equals("Real"));
        if (t instanceof ConstantTerm) {
            Rational val = SMTAffineTerm.create(t).getConstant();
            assert (val.isIntegral());
            return val.toTerm(t.getTheory().getSort("Int", new Sort[0]));
        }
        return t.getTheory().term("to_int", t);
    }

    public static Term toReal(Term t) {
        assert (t.getSort().getName().equals("Int"));
        if (t instanceof ConstantTerm) {
            SMTAffineTerm tmp = SMTAffineTerm.create(t);
            assert (tmp.getConstant().isIntegral());
            return tmp.getConstant().toTerm(t.getTheory().getSort("Real", new Sort[0]));
        }
        return t.getTheory().term("to_real", t);
    }

    public static Term coerce(Term t, Sort s) {
        if (t.getSort() == s) {
            return t;
        }
        if (s.getName().equals("Int")) {
            return Coercion.toInt(t);
        }
        if (s.getName().equals("Real")) {
            return Coercion.toReal(t);
        }
        throw new InternalError("Should only be called with numeric sort!");
    }

    public static Term buildApp(FunctionSymbol fsymb, Term[] args) {
        Sort[] paramSorts = fsymb.getParameterSorts();
        if (fsymb.getTheory().getLogic().isIRA()) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].getSort() == paramSorts[i]) continue;
                args[i] = Coercion.coerce(args[i], paramSorts[i]);
            }
        }
        return fsymb.getTheory().term(fsymb, args);
    }

    public static Term buildEq(Term lhs, Term rhs) {
        if (lhs.getSort() != rhs.getSort()) {
            assert (lhs.getTheory().getLogic().isIRA());
            if (!lhs.getSort().getName().equals("Real")) {
                lhs = Coercion.toReal(lhs);
            }
            if (!rhs.getSort().getName().equals("Real")) {
                rhs = Coercion.toReal(rhs);
            }
        }
        return lhs.getTheory().term("=", lhs, rhs);
    }

    public static Term buildDistinct(Term lhs, Term rhs) {
        if (lhs.getSort() != rhs.getSort()) {
            assert (lhs.getTheory().getLogic().isIRA());
            if (!lhs.getSort().getName().equals("Real")) {
                lhs = Coercion.toReal(lhs);
            }
            if (!rhs.getSort().getName().equals("Real")) {
                rhs = Coercion.toReal(rhs);
            }
        }
        return lhs.getTheory().distinct(lhs, rhs);
    }
}

