/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.logic.MutableRational;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitNumber;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableInfinitNumber
implements Comparable<MutableInfinitNumber> {
    MutableRational mA;
    int mEps;

    public MutableInfinitNumber() {
        this(Rational.ZERO, 0);
    }

    public MutableInfinitNumber(Rational a, int eps) {
        this.mA = new MutableRational(a);
        this.mEps = eps;
    }

    public MutableInfinitNumber(InfinitNumber other) {
        this.mA = new MutableRational(other.mA);
        this.mEps = other.mEps;
    }

    public MutableInfinitNumber(MutableInfinitNumber other) {
        this.mA = new MutableRational(other.mA);
        this.mEps = other.mEps;
    }

    MutableInfinitNumber assign(MutableInfinitNumber other) {
        this.mA = new MutableRational(other.mA);
        this.mEps = other.mEps;
        return this;
    }

    MutableInfinitNumber assign(InfinitNumber other) {
        this.mA = new MutableRational(other.mA);
        this.mEps = other.mEps;
        return this;
    }

    public MutableInfinitNumber add(InfinitNumber other) {
        this.mA.add(other.mA);
        this.mEps = InfinitNumber.normEpsilon(this.mEps + other.mEps);
        return this;
    }

    public MutableInfinitNumber sub(InfinitNumber other) {
        this.mA.sub(other.mA);
        this.mEps = InfinitNumber.normEpsilon(this.mEps - other.mEps);
        return this;
    }

    public MutableInfinitNumber mul(Rational c) {
        this.mA.mul(c);
        this.mEps *= c.signum();
        return this;
    }

    public MutableInfinitNumber div(Rational c) {
        this.mA.div(c);
        this.mEps *= c.signum();
        return this;
    }

    public MutableInfinitNumber addmul(InfinitNumber fac1, Rational fac2) {
        this.mA.addmul(fac1.mA, fac2);
        this.mEps = InfinitNumber.normEpsilon(this.mEps + fac1.mEps * fac2.signum());
        return this;
    }

    public MutableInfinitNumber addmul(InfinitNumber fac1, BigInteger fac2) {
        this.mA.addmul(fac1.mA, fac2);
        this.mEps = InfinitNumber.normEpsilon(this.mEps + fac1.mEps * fac2.signum());
        return this;
    }

    public MutableInfinitNumber subdiv(InfinitNumber s, Rational d) {
        this.mA.subdiv(s.mA, d);
        this.mEps = InfinitNumber.normEpsilon(this.mEps - s.mEps) * d.signum();
        return this;
    }

    public MutableInfinitNumber negate() {
        this.mA.negate();
        this.mEps = -this.mEps;
        return this;
    }

    @Override
    public int compareTo(MutableInfinitNumber arg0) {
        int ac = this.mA.compareTo(arg0.mA);
        if (ac == 0) {
            return this.mEps - arg0.mEps;
        }
        return ac;
    }

    @Override
    public int compareTo(InfinitNumber other) {
        int ac = this.mA.compareTo(other.mA);
        if (ac == 0) {
            return this.mEps - other.mEps;
        }
        return ac;
    }

    public boolean equals(Object o) {
        if (o instanceof InfinitNumber) {
            InfinitNumber n = (InfinitNumber)o;
            return this.mA.equals(n.mA) && this.mEps == n.mEps;
        }
        if (o instanceof MutableInfinitNumber) {
            MutableInfinitNumber n = (MutableInfinitNumber)o;
            return this.mA.equals(n.mA) && this.mEps == n.mEps;
        }
        return false;
    }

    public int hashCode() {
        return this.mA.hashCode() + 257 * this.mEps;
    }

    public boolean isInfinity() {
        return this.mA.equals(Rational.POSITIVE_INFINITY) || this.mA.equals(Rational.NEGATIVE_INFINITY);
    }

    public String toString() {
        if (this.mEps == 0) {
            return this.mA.toString();
        }
        return this.mA + (this.mEps > 0 ? "+" : "-") + "eps";
    }

    public InfinitNumber toInfinitNumber() {
        return new InfinitNumber(this.mA.toRational(), this.mEps);
    }
}

