/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.Explainer;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitNumber;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinVar;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LiteralReason;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MutableAffinTerm;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;

public abstract class LAReason {
    private final LinVar mVar;
    protected InfinitNumber mBound;
    private LAReason mOldReason;
    private final boolean mIsUpper;
    private final LiteralReason mLastlit;

    public LAReason(LinVar var, InfinitNumber bound, boolean isUpper, LiteralReason lastLit) {
        this.mVar = var;
        this.mBound = bound;
        this.mIsUpper = isUpper;
        this.mLastlit = lastLit == null ? (LiteralReason)this : lastLit;
    }

    public InfinitNumber getBound() {
        return this.mBound;
    }

    public InfinitNumber getExactBound() {
        return this.mBound;
    }

    public LinVar getVar() {
        return this.mVar;
    }

    public boolean isUpper() {
        return this.mIsUpper;
    }

    public LAReason getOldReason() {
        return this.mOldReason;
    }

    public void setOldReason(LAReason old) {
        this.mOldReason = old;
    }

    public LiteralReason getLastLiteral() {
        return this.mLastlit;
    }

    abstract InfinitNumber explain(Explainer var1, InfinitNumber var2, Rational var3);

    public String toString() {
        return this.mVar + (this.mIsUpper ? "<=" : ">=") + this.mBound;
    }

    public int hashCode() {
        return HashUtils.hashJenkins(this.mBound.hashCode(), (Object)this.mVar);
    }

    public Term toSMTLIB(Theory smtTheory, boolean useAuxVars) {
        MutableAffinTerm at = new MutableAffinTerm();
        at.add(Rational.ONE, this.mVar);
        at.add(this.mBound.negate());
        if (!this.mIsUpper) {
            at.add(this.mVar.getEpsilon());
        }
        Term posTerm = at.toSMTLibLeq0(smtTheory, useAuxVars);
        return this.mIsUpper ? posTerm : smtTheory.term("not", posTerm);
    }
}

