/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitNumber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExactInfinitNumber
implements Comparable<ExactInfinitNumber> {
    public static final ExactInfinitNumber POSITIVE_INFINITY = new ExactInfinitNumber(Rational.POSITIVE_INFINITY, Rational.ZERO);
    public static final ExactInfinitNumber NEGATIVE_INFINITY = new ExactInfinitNumber(Rational.NEGATIVE_INFINITY, Rational.ZERO);
    private final Rational mReal;
    private final Rational mEps;

    public ExactInfinitNumber() {
        this.mReal = this.mEps = Rational.ZERO;
    }

    public ExactInfinitNumber(Rational real) {
        this.mReal = real;
        this.mEps = Rational.ZERO;
    }

    public ExactInfinitNumber(Rational real, Rational eps) {
        this.mReal = real;
        this.mEps = eps;
    }

    public ExactInfinitNumber(InfinitNumber approx) {
        this.mReal = approx.mA;
        this.mEps = Rational.valueOf(approx.mEps, 1L);
    }

    public Rational getRealValue() {
        return this.mReal;
    }

    public Rational getEpsilon() {
        return this.mEps;
    }

    public String toString() {
        if (this.mEps.signum() == 0) {
            return this.mReal.toString();
        }
        if (this.mEps.signum() > 0) {
            return this.mReal.toString() + "+" + this.mEps.toString() + "eps";
        }
        return this.mReal.toString() + "-" + this.mEps.abs().toString() + "eps";
    }

    public boolean equals(Object o) {
        if (o instanceof ExactInfinitNumber) {
            ExactInfinitNumber n = (ExactInfinitNumber)o;
            return this.mReal.equals(n.mReal) && this.mEps.equals(n.mEps);
        }
        return false;
    }

    public int hashCode() {
        return this.mReal.hashCode() + 65537 * this.mEps.hashCode();
    }

    public ExactInfinitNumber add(Rational real) {
        return new ExactInfinitNumber(this.mReal.add(real), this.mEps);
    }

    public ExactInfinitNumber add(InfinitNumber other) {
        return new ExactInfinitNumber(this.mReal.add(other.mA), this.mEps.add(Rational.valueOf(other.mEps, 1L)));
    }

    public ExactInfinitNumber add(ExactInfinitNumber other) {
        return new ExactInfinitNumber(this.mReal.add(other.mReal), this.mEps.add(other.mEps));
    }

    public ExactInfinitNumber sub(ExactInfinitNumber other) {
        return new ExactInfinitNumber(this.mReal.sub(other.mReal), this.mEps.sub(other.mEps));
    }

    public ExactInfinitNumber isub(InfinitNumber first) {
        return new ExactInfinitNumber(first.mA.sub(this.mReal), Rational.valueOf(first.mEps, 1L).sub(this.mEps));
    }

    public ExactInfinitNumber negate() {
        return new ExactInfinitNumber(this.mReal.negate(), this.mEps.negate());
    }

    public ExactInfinitNumber mul(Rational c) {
        return new ExactInfinitNumber(this.mReal.mul(c), this.mEps.mul(c));
    }

    public ExactInfinitNumber div(Rational d) {
        return new ExactInfinitNumber(this.mReal.div(d), this.mEps.div(d));
    }

    public InfinitNumber toInfinitNumber() {
        if (this.mEps == Rational.ZERO) {
            return new InfinitNumber(this.mReal, 0);
        }
        if (this.mEps == Rational.MONE) {
            return new InfinitNumber(this.mReal, -1);
        }
        if (this.mEps == Rational.ONE) {
            return new InfinitNumber(this.mReal, 1);
        }
        return null;
    }

    public InfinitNumber toInfinitNumberFloor() {
        return new InfinitNumber(this.mReal, this.mEps.floor().signum());
    }

    public InfinitNumber toInfinitNumberCeil() {
        return new InfinitNumber(this.mReal, this.mEps.ceil().signum());
    }

    @Override
    public int compareTo(ExactInfinitNumber other) {
        int cmp = this.mReal.compareTo(other.mReal);
        return cmp == 0 ? this.mEps.compareTo(other.mEps) : cmp;
    }

    public int signum() {
        return this.mReal == Rational.ZERO ? this.mEps.signum() : this.mReal.signum();
    }

    public boolean isInfinite() {
        return !this.mReal.isRational();
    }
}

