/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure;

import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAppTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CongruenceBlockPair;
import java.util.HashSet;

public class UpdatableCongruenceBlocker {
    private final HashSet<CongruenceBlockPair> mBlocked = new HashSet();
    private HashSet<CongruenceBlockPair> mRoots;

    public void block(CCAppTerm t) {
        this.mBlocked.add(CongruenceBlockPair.getPair(t));
        this.mRoots.add(CongruenceBlockPair.getRootPair(t));
    }

    public void remove(CCAppTerm t) {
        this.mBlocked.remove(CongruenceBlockPair.getPair(t));
    }

    public void update() {
        this.mRoots = new HashSet();
        for (CongruenceBlockPair p : this.mBlocked) {
            this.mRoots.add(p.getRoot());
        }
    }

    public void done() {
        this.mRoots = null;
    }

    public boolean isBlocked(CCAppTerm t) {
        return this.mRoots.contains(CongruenceBlockPair.getRootPair(t));
    }
}

