/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure;

import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.ArraySortInterpretation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.Model;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.SharedTermEvaluator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAppTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCBaseTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CClosure;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelBuilder {
    private final HashMap<CCTerm, Integer> mProduced = new HashMap();
    private final HashMap<CCTerm, Delay> mDelayed = new HashMap();
    private final Deque<Delay> mTodo = new ArrayDeque<Delay>();
    private final CClosure mCClosure;

    public ModelBuilder(CClosure closure, List<CCTerm> terms, Model model, Theory t, SharedTermEvaluator ste, CCTerm trueNode, CCTerm falseNode) {
        this.mCClosure = closure;
        Rational biggest = Rational.MONE;
        HashSet<CCTerm> delayed = new HashSet<CCTerm>();
        for (CCTerm term : terms) {
            int value;
            if (term != term.mRepStar) continue;
            Term smtterm = term.toSMTTerm(t);
            if (smtterm.getSort().isNumericSort()) {
                Rational v;
                if (term.getSharedTerm() != null && term.getSharedTerm().validShared()) {
                    v = ste.evaluate(term.getSharedTerm(), t);
                } else if (smtterm instanceof ConstantTerm) {
                    v = (Rational)((ConstantTerm)smtterm).getValue();
                } else {
                    delayed.add(term);
                    continue;
                }
                biggest = v.compareTo(biggest) > 0 ? v : biggest;
                value = model.putNumeric(v);
            } else if (term == trueNode.mRepStar) {
                value = model.getTrueIdx();
            } else if (term == falseNode.mRepStar || smtterm.getSort() == t.getBooleanSort()) {
                value = model.getFalseIdx();
            } else if (smtterm.getSort().isArraySort()) {
                ArraySortInterpretation arrSort = (ArraySortInterpretation)model.provideSortInterpretation(smtterm.getSort());
                value = arrSort.createEmptyArrayValue();
            } else {
                value = model.extendFresh(smtterm.getSort());
            }
            term.mModelVal = value;
            for (CCTerm mem : term.mMembers) {
                this.add(model, mem, value, t);
            }
        }
        biggest = biggest.add(Rational.ONE).floor();
        for (CCTerm term : delayed) {
            int idx;
            term.mModelVal = idx = model.putNumeric(biggest);
            for (CCTerm mem : term.mMembers) {
                this.add(model, mem, idx, t);
            }
            biggest = biggest.add(Rational.ONE);
        }
        this.finishModel(model, t);
    }

    private void add(Model model, CCTerm term, int value, Theory t) {
        if (term instanceof CCBaseTerm) {
            CCBaseTerm bt = (CCBaseTerm)term;
            if (!bt.isFunctionSymbol()) {
                this.mProduced.put(term, value);
                return;
            }
            FunctionSymbol symb = bt.getFunctionSymbol();
            if (!symb.isIntern()) {
                model.map(symb, value);
                this.mProduced.put(term, value);
            }
        } else {
            CCAppTerm app = (CCAppTerm)term;
            assert (!app.mIsFunc);
            this.addApp(model, app, value, t);
        }
    }

    private void addApp(Model model, CCAppTerm app, int value, Theory t) {
        ArgHelper args = new ArgHelper();
        CCTerm walk = app;
        boolean enqueued = false;
        while (walk instanceof CCAppTerm) {
            CCAppTerm appwalk = walk;
            Integer val = this.mProduced.get(appwalk.getArg());
            if (val == null) {
                Delay delay;
                if (!enqueued) {
                    delay = this.mDelayed.get(app);
                    if (delay == null) {
                        delay = new Delay(app, value);
                        this.mDelayed.put(app, delay);
                    } else if (!delay.isInitialized()) {
                        delay.initialize(value);
                    }
                    this.mTodo.push(delay);
                    enqueued = true;
                }
                if ((delay = this.mDelayed.get(appwalk.getArg())) == null) {
                    delay = new Delay(appwalk.getArg());
                    this.mDelayed.put(appwalk.getArg(), delay);
                }
                this.mTodo.push(delay);
            } else {
                args.add(val);
            }
            walk = appwalk.getFunc();
        }
        if (!enqueued) {
            CCBaseTerm base = (CCBaseTerm)walk;
            if (base.isFunctionSymbol() && (!this.mCClosure.isArrayTheory() || base.mParentPosition != this.mCClosure.getSelectNum() && base.mParentPosition != this.mCClosure.getStoreNum() && base.mParentPosition != this.mCClosure.getDiffNum())) {
                FunctionSymbol fs = base.getFunctionSymbol();
                model.map(fs, args.toArray(), value);
            }
            this.mProduced.put(app, value);
        }
    }

    private void finishModel(Model model, Theory t) {
        while (!this.mTodo.isEmpty()) {
            Delay d = this.mTodo.pop();
            if (this.mProduced.containsKey(d.getTerm())) continue;
            assert (d.isInitialized());
            this.add(model, d.getTerm(), d.getValue(), t);
        }
    }

    private static class Delay {
        private final CCTerm mTerm;
        private int mValue;
        private boolean mInitialized;

        public Delay(CCTerm term) {
            this.mTerm = term;
            this.mInitialized = false;
        }

        public Delay(CCTerm term, int value) {
            this.mTerm = term;
            this.mValue = value;
            this.mInitialized = true;
        }

        public boolean isInitialized() {
            return this.mInitialized;
        }

        public void initialize(int value) {
            assert (!this.mInitialized);
            this.mValue = value;
            this.mInitialized = true;
        }

        public CCTerm getTerm() {
            return this.mTerm;
        }

        public int getValue() {
            return this.mValue;
        }
    }

    private static class ArgHelper {
        private int[] mArgs = new int[4];
        private int mNextPos = 0;

        public void add(int arg) {
            if (this.mNextPos == this.mArgs.length) {
                int[] old = this.mArgs;
                this.mArgs = new int[old.length << 1];
                System.arraycopy(old, 0, this.mArgs, 0, old.length);
            }
            this.mArgs[this.mNextPos++] = arg;
        }

        public int[] toArray() {
            int[] res = new int[this.mNextPos];
            int pos = 0;
            for (int i = this.mNextPos - 1; i >= 0; --i) {
                res[pos++] = this.mArgs[i];
            }
            return res;
        }
    }
}

