/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure;

import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SharedTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLEngine;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.ITheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.SimpleList;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.Model;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.SharedTermEvaluator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.LeafNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAppTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCBaseTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCParentInfo;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTermPairHash;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CongruencePath;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.ModelBuilder;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.StackData;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.EQAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.ArrayQueue;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.SymmetricPair;
import de.uni_freiburg.informatik.ultimate.util.DebugMessage;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;

public class CClosure
implements ITheory {
    final DPLLEngine mEngine;
    final ArrayList<CCTerm> mAllTerms = new ArrayList();
    final CCTermPairHash mPairHash = new CCTermPairHash();
    final ArrayQueue<Literal> mPendingLits = new ArrayQueue();
    final ScopedHashMap<Object, CCBaseTerm> mSymbolicTerms = new ScopedHashMap();
    int mNumFunctionPositions;
    int mMergeDepth;
    final ArrayDeque<CCTerm> mMerges = new ArrayDeque();
    final ArrayDeque<SymmetricPair<CCAppTerm>> mPendingCongruences = new ArrayDeque();
    private long mInvertEdgeTime;
    private long mEqTime;
    private long mCcTime;
    private long mSetRepTime;
    private long mCcCount;
    private long mMergeCount;
    private int mStoreNum;
    private int mSelectNum;
    private int mDiffNum;
    private CCTermPairHash.Info mLastInfo;

    public CClosure(DPLLEngine engine) {
        this.mEngine = engine;
    }

    public CCTerm createAnonTerm(SharedTerm flat) {
        CCBaseTerm term = new CCBaseTerm(false, this.mNumFunctionPositions, (Object)flat, flat);
        this.mAllTerms.add(term);
        return term;
    }

    public CCTerm createAppTerm(boolean isFunc, CCTerm func, CCTerm arg) {
        CCAppTerm term;
        CCAppTerm congruentTerm;
        assert (func.mIsFunc);
        CCParentInfo info = arg.mRepStar.mCCPars.getExistingParentInfo(func.mParentPosition);
        if (info != null) {
            SimpleList<CCAppTerm.Parent> prevParents = info.mCCParents;
            assert (prevParents.wellformed());
            for (CCAppTerm.Parent termpar : prevParents) {
                CCAppTerm term2 = termpar.getData();
                if (term2.mFunc != func || term2.mArg != arg) continue;
                return term2;
            }
        }
        if ((congruentTerm = (term = new CCAppTerm(isFunc, isFunc ? func.mParentPosition + 1 : 0, func, arg, null, this)).addParentInfo(this)) != null) {
            this.addPendingCongruence(term, congruentTerm);
        }
        return term;
    }

    private CCTerm convertFuncTerm(FunctionSymbol sym, CCTerm[] args, int numArgs) {
        if (numArgs == 0) {
            CCBaseTerm term = this.mSymbolicTerms.get(sym);
            if (term == null) {
                term = new CCBaseTerm(args.length > 0, this.mNumFunctionPositions, sym, null);
                this.mNumFunctionPositions += args.length;
                this.mSymbolicTerms.put(sym, term);
            }
            return term;
        }
        CCTerm pred = this.convertFuncTerm(sym, args, numArgs - 1);
        return this.createAppTerm(numArgs < args.length, pred, args[numArgs - 1]);
    }

    public CCTerm getFuncTerm(FunctionSymbol sym) {
        CCBaseTerm term = this.mSymbolicTerms.get(sym);
        if (term == null) {
            term = this.mSymbolicTerms.get(sym.getName());
            if (term == null) {
                term = new CCBaseTerm(sym.getParameterSorts().length > 0, this.mNumFunctionPositions, sym, null);
                this.mNumFunctionPositions += sym.getParameterSorts().length;
            } else {
                term = new CCBaseTerm(term.mIsFunc, term.mParentPosition, sym, null);
            }
            this.mSymbolicTerms.put(sym, term);
        }
        return term;
    }

    public void insertEqualityEntry(CCTerm t1, CCTerm t2, CCEquality.Entry eqentry) {
        if (t1.mMergeTime > t2.mMergeTime) {
            CCTerm tmp = t1;
            t1 = t2;
            t2 = tmp;
        }
        if (t1.mRep == t1) {
            assert (t2.mRep == t2);
            CCTermPairHash.Info info = this.mPairHash.getInfo(t1, t2);
            if (info == null) {
                info = new CCTermPairHash.Info(t1, t2);
                this.mPairHash.add(info);
            }
            info.mEqlits.prependIntoJoined(eqentry, true);
        } else {
            boolean isLast = t1.mRep == t2;
            boolean found = false;
            for (CCTermPairHash.Info.Entry pentry : t1.mPairInfos) {
                CCTermPairHash.Info info = pentry.getInfo();
                if (pentry.mOther != t2) continue;
                info.mEqlits.prependIntoJoined(eqentry, isLast);
                found = true;
                break;
            }
            if (!found) {
                CCTermPairHash.Info info = new CCTermPairHash.Info(t1, t2);
                info.mRhsEntry.unlink();
                info.mEqlits.prependIntoJoined(eqentry, isLast);
            }
            if (!isLast) {
                this.insertEqualityEntry(t1.mRep, t2, eqentry);
            }
        }
    }

    public CCEquality createCCEquality(int stackLevel, CCTerm t1, CCTerm t2) {
        assert (t1 != t2);
        CCEquality eq = null;
        assert (t1.invariant());
        assert (t2.invariant());
        eq = new CCEquality(stackLevel, t1, t2);
        this.insertEqualityEntry(t1, t2, eq.getEntry());
        this.mEngine.addAtom(eq);
        assert (t1.invariant());
        assert (t2.invariant());
        assert (t1.pairHashValid(this));
        assert (t2.pairHashValid(this));
        if (t1.mRepStar == t2.mRepStar) {
            if (this.mEngine.getLogger().isDebugEnabled()) {
                this.mEngine.getLogger().debug("CC-Prop: " + eq + " repStar: " + t1.mRepStar);
            }
            this.mPendingLits.add(eq);
        } else {
            CCEquality diseq = this.mPairHash.getInfo((CCTerm)t1.mRepStar, (CCTerm)t2.mRepStar).mDiseq;
            if (diseq != null) {
                if (this.mEngine.getLogger().isDebugEnabled()) {
                    this.mEngine.getLogger().debug("CC-Prop: " + eq.negate() + " diseq: " + diseq);
                }
                eq.mDiseqReason = diseq;
                this.mPendingLits.add(eq.negate());
            }
        }
        return eq;
    }

    public boolean knowsConstant(FunctionSymbol sym) {
        return this.mSymbolicTerms.containsKey(sym);
    }

    public CCTerm createFuncTerm(FunctionSymbol sym, CCTerm[] subterms, SharedTerm fapp) {
        CCTerm term = this.convertFuncTerm(sym, subterms, subterms.length);
        if (term.mFlatTerm == null) {
            this.mAllTerms.add(term);
        }
        term.mFlatTerm = fapp;
        return term;
    }

    public void addTerm(CCTerm term, SharedTerm shared) {
        term.mFlatTerm = shared;
        this.mAllTerms.add(term);
    }

    public void backtrackLiteral(Literal literal) {
        if (!(literal.getAtom() instanceof CCEquality)) {
            return;
        }
        CCEquality eq = (CCEquality)literal.getAtom();
        if (eq.mStackDepth != -1) {
            this.backtrackStack(eq.mStackDepth);
            eq.mStackDepth = -1;
            if (literal != eq) {
                this.undoSep(eq);
            }
        }
    }

    public Clause computeConflictClause() {
        Clause res = this.checkpoint();
        if (res == null) {
            res = this.checkpoint();
        }
        assert (this.mPendingCongruences.isEmpty());
        return res;
    }

    public Literal getPropagatedLiteral() {
        Literal lit = this.mPendingLits.poll();
        assert (lit == null || this.checkPending(lit));
        return lit;
    }

    public Clause getUnitClause(Literal lit) {
        if (lit.getAtom() instanceof LAEquality) {
            LAEquality laeq = (LAEquality)lit.getAtom();
            for (CCEquality eq : laeq.getDependentEqualities()) {
                if (eq.getStackPosition() < 0 || eq.getStackPosition() >= laeq.getStackPosition() || eq.getDecideStatus().getSign() != lit.getSign()) continue;
                return new Clause(new Literal[]{eq.getDecideStatus().negate(), lit}, new LeafNode(-6, EQAnnotation.EQ));
            }
            throw new AssertionError((Object)("Cannot find explanation for " + laeq));
        }
        if (lit instanceof CCEquality) {
            CCEquality eq = (CCEquality)lit;
            return this.computeCycle(eq);
        }
        CCEquality eq = (CCEquality)lit.negate();
        return this.computeAntiCycle(eq);
    }

    public Clause setLiteral(Literal literal) {
        if (!(literal.getAtom() instanceof CCEquality)) {
            return null;
        }
        CCEquality eq = (CCEquality)literal.getAtom();
        LAEquality laeq = eq.getLASharedData();
        if (laeq != null) {
            assert (((List)laeq.getDependentEqualities()).contains(eq));
            if (laeq.getDecideStatus() != null && laeq.getDecideStatus().getSign() != literal.getSign()) {
                return new Clause(new Literal[]{laeq.getDecideStatus().negate(), literal.negate()}, new LeafNode(-6, EQAnnotation.EQ));
            }
            this.mPendingLits.add(literal == eq ? laeq : laeq.negate());
        }
        if (literal == eq) {
            if (eq.getLhs().mRepStar != eq.getRhs().mRepStar) {
                eq.mStackDepth = this.mMerges.size();
                Clause conflict = eq.getLhs().merge(this, eq.getRhs(), eq);
                if (conflict != null) {
                    return conflict;
                }
            }
        } else {
            Clause conflict;
            CCTerm left = eq.getLhs().mRepStar;
            CCTerm right = eq.getRhs().mRepStar;
            if (left == right && (conflict = this.computeCycle(eq)) != null) {
                return conflict;
            }
            this.separate(left, right, eq);
            eq.mStackDepth = this.mMerges.size();
        }
        return null;
    }

    private void separate(CCTerm lhs, CCTerm rhs, CCEquality atom) {
        if (this.mLastInfo == null || !this.mLastInfo.equals(lhs, rhs)) {
            this.mLastInfo = this.mPairHash.getInfo(lhs, rhs);
            assert (this.mLastInfo != null);
        }
        if (this.mLastInfo.mDiseq != null) {
            return;
        }
        this.mLastInfo.mDiseq = atom;
        for (CCEquality.Entry eqentry : this.mLastInfo.mEqlits) {
            CCEquality eq = eqentry.getCCEquality();
            if (eq.getDecideStatus() != null) continue;
            eq.mDiseqReason = atom;
            this.addPending(eq.negate());
        }
    }

    private void undoSep(CCEquality atom) {
        atom.mDiseqReason = null;
        CCTermPairHash.Info destInfo = this.mPairHash.getInfo(atom.getLhs().mRepStar, atom.getRhs().mRepStar);
        if (destInfo != null && destInfo.mDiseq != null) {
            destInfo = this.mPairHash.getInfo(atom.getLhs().mRepStar, atom.getRhs().mRepStar);
            if (destInfo.mDiseq == atom) {
                destInfo.mDiseq = null;
            }
        }
    }

    public Clause computeCycle(CCEquality eq) {
        CongruencePath congPath = new CongruencePath(this);
        Clause res = congPath.computeCycle(eq, this.mEngine.isProofGenerationEnabled());
        assert (res.getSize() != 2 || res.getLiteral(0).negate() != res.getLiteral(1));
        return res;
    }

    public Clause computeCycle(CCTerm lconstant, CCTerm rconstant) {
        CongruencePath congPath = new CongruencePath(this);
        return congPath.computeCycle(lconstant, rconstant, this.mEngine.isProofGenerationEnabled());
    }

    public Clause computeAntiCycle(CCEquality eq) {
        CCTerm left = eq.getLhs();
        CCTerm right = eq.getRhs();
        CCEquality diseq = eq.mDiseqReason;
        assert (left.mRepStar != right.mRepStar);
        assert (diseq.getLhs().mRepStar == left.mRepStar || diseq.getLhs().mRepStar == right.mRepStar);
        assert (diseq.getRhs().mRepStar == left.mRepStar || diseq.getRhs().mRepStar == right.mRepStar);
        left.invertEqualEdges(this);
        left.mEqualEdge = right;
        left.mOldRep = left.mRepStar;
        assert (left.mOldRep.mReasonLiteral == null);
        left.mOldRep.mReasonLiteral = eq;
        Clause c = this.computeCycle(diseq);
        assert (left.mEqualEdge == right && left.mOldRep == left.mRepStar);
        left.mOldRep.mReasonLiteral = null;
        left.mOldRep = null;
        left.mEqualEdge = null;
        return c;
    }

    public void addPending(Literal eq) {
        assert (this.checkPending(eq));
        this.mPendingLits.add(eq);
    }

    private boolean checkPending(Literal literal) {
        if (literal.negate() instanceof CCEquality) {
            CCEquality eq = (CCEquality)literal.negate();
            CCTerm left = eq.getLhs();
            CCTerm right = eq.getRhs();
            CCEquality diseq = eq.mDiseqReason;
            assert (left.mRepStar != right.mRepStar);
            assert (diseq.getLhs().mRepStar == left.mRepStar || diseq.getLhs().mRepStar == right.mRepStar);
            assert (diseq.getRhs().mRepStar == left.mRepStar || diseq.getRhs().mRepStar == right.mRepStar);
            return true;
        }
        if (literal instanceof CCEquality) {
            CCEquality eq = (CCEquality)literal;
            return eq.getLhs().mRepStar == eq.getRhs().mRepStar;
        }
        if (literal.getAtom() instanceof LAEquality) {
            LAEquality laeq = (LAEquality)literal.getAtom();
            for (CCEquality eq : laeq.getDependentEqualities()) {
                if (eq.getDecideStatus() == null || eq.getDecideStatus().getSign() != literal.getSign()) continue;
                return true;
            }
        }
        return false;
    }

    public Clause checkpoint() {
        if (!this.mPendingCongruences.isEmpty()) {
            Clause res = this.buildCongruence(true);
            return res;
        }
        return null;
    }

    public Term convertTermToSMT(CCTerm t) {
        return t.toSMTTerm(this.mEngine.getSMTTheory());
    }

    public Term convertEqualityToSMT(CCTerm t1, CCTerm t2) {
        return this.mEngine.getSMTTheory().equals(this.convertTermToSMT(t1), this.convertTermToSMT(t2));
    }

    public void dumpModel(LogProxy logger) {
        logger.info("Equivalence Classes:");
        for (CCTerm t : this.mAllTerms) {
            if (t != t.mRepStar) continue;
            StringBuilder sb = new StringBuilder();
            String comma = "";
            for (CCTerm t2 : t.mMembers) {
                sb.append(comma).append(t2);
                comma = "=";
            }
            logger.info(sb.toString());
        }
    }

    private boolean checkCongruence() {
        for (CCTerm t1 : this.mAllTerms) {
            boolean skip = true;
            for (CCTerm t2 : this.mAllTerms) {
                if (skip) {
                    if (t1 != t2) continue;
                    skip = false;
                    continue;
                }
                if (!(t1 instanceof CCAppTerm) || !(t2 instanceof CCAppTerm)) continue;
                CCAppTerm a1 = (CCAppTerm)t1;
                CCAppTerm a2 = (CCAppTerm)t2;
                if (a1.mFunc.mRepStar != a2.mFunc.mRepStar || a1.mArg.mRepStar != a2.mArg.mRepStar || a1.mRepStar == a2.mRepStar) continue;
                System.err.println("Should be congruent: " + t1 + " and " + t2);
                return false;
            }
        }
        return true;
    }

    public void printStatistics(LogProxy logger) {
        logger.info("CCTimes: iE " + this.mInvertEdgeTime + " eq " + this.mEqTime + " cc " + this.mCcTime + " setRep " + this.mSetRepTime);
        logger.info("Merges: " + this.mMergeCount + ", cc:" + this.mCcCount);
    }

    public Literal getSuggestion() {
        return null;
    }

    public void decreasedDecideLevel(int currentDecideLevel) {
    }

    public void increasedDecideLevel(int currentDecideLevel) {
    }

    public Clause backtrackComplete() {
        this.mPendingLits.clear();
        return this.buildCongruence(true);
    }

    public void restart(int iteration) {
    }

    public Clause startCheck() {
        return null;
    }

    public void endCheck() {
    }

    void addPendingCongruence(CCAppTerm first, CCAppTerm second) {
        assert (first.mLeftParInfo.inList() && second.mLeftParInfo.inList());
        assert (first.mRightParInfo.inList() && second.mRightParInfo.inList());
        this.mPendingCongruences.add(new SymmetricPair<CCAppTerm>(first, second));
    }

    void prependPendingCongruence(CCAppTerm first, CCAppTerm second) {
        assert (first.mLeftParInfo.inList() && second.mLeftParInfo.inList());
        assert (first.mRightParInfo.inList() && second.mRightParInfo.inList());
        this.mPendingCongruences.addFirst(new SymmetricPair<CCAppTerm>(first, second));
    }

    private Clause buildCongruence(boolean checked) {
        SymmetricPair<CCAppTerm> cong;
        while ((cong = this.mPendingCongruences.poll()) != null) {
            this.mEngine.getLogger().debug(new DebugMessage("PC {0}", cong));
            Clause res = null;
            CCAppTerm lhs = cong.getFirst();
            CCAppTerm rhs = cong.getSecond();
            if (lhs.mArg.mRepStar == rhs.mArg.mRepStar && lhs.mFunc.mRepStar == rhs.mFunc.mRepStar) {
                res = lhs.merge(this, rhs, null);
            } else assert (checked) : "Unchecked buildCongruence with non-holding congruence!";
            if (res == null) continue;
            return res;
        }
        return null;
    }

    private void backtrackStack(int todepth) {
        while (this.mMerges.size() > todepth) {
            CCTerm top = this.mMerges.pop();
            top.mRepStar.invertEqualEdges(this);
            boolean isCongruence = top.mOldRep.mReasonLiteral == null;
            CCTerm lhs = top;
            CCTerm rhs = top.mEqualEdge;
            top.undoMerge(this, top.mEqualEdge);
            if (!isCongruence) continue;
            assert (rhs instanceof CCAppTerm);
            this.prependPendingCongruence((CCAppTerm)lhs, (CCAppTerm)rhs);
        }
    }

    public int getStackDepth() {
        return this.mMerges.size();
    }

    public void removeAtom(DPLLAtom atom) {
        if (atom instanceof CCEquality) {
            CCEquality cceq = (CCEquality)atom;
            this.removeCCEquality(cceq.getLhs(), cceq.getRhs(), cceq);
        }
    }

    private void removeCCEquality(CCTerm t1, CCTerm t2, CCEquality eq) {
        if (t1.mMergeTime > t2.mMergeTime) {
            CCTerm tmp = t1;
            t1 = t2;
            t2 = tmp;
        }
        if (t1.mRep == t1) {
            assert (t2.mRep == t2);
            CCTermPairHash.Info info = this.mPairHash.getInfo(t1, t2);
            if (info == null) {
                return;
            }
            info.mEqlits.prepareRemove(eq.getEntry());
            eq.getEntry().removeFromList();
            if (info.isEmpty()) {
                this.mPairHash.removePairInfo(info);
            }
        } else {
            boolean isLast = t1.mRep == t2;
            boolean found = false;
            for (CCTermPairHash.Info.Entry pentry : t1.mPairInfos) {
                CCTermPairHash.Info info = pentry.getInfo();
                if (pentry.mOther != t2) continue;
                info.mEqlits.prepareRemove(eq.getEntry());
                found = true;
                break;
            }
            assert (found);
            if (isLast) {
                eq.getEntry().removeFromList();
            } else {
                this.removeCCEquality(t1.mRep, t2, eq);
            }
        }
        if (eq.getLASharedData() != null) {
            eq.getLASharedData().removeDependentAtom(eq);
        }
    }

    private void removeTerm(CCTerm t) {
        assert (t.mRepStar == t);
        assert (this.mPendingCongruences.isEmpty());
        for (CCTermPairHash.Info.Entry e : t.mPairInfos) {
            this.mPairHash.removePairInfo(e.getInfo());
        }
        if (t.mSharedTerm != null) {
            t.mSharedTerm = null;
        }
        if (t instanceof CCAppTerm) {
            CCAppTerm at = (CCAppTerm)t;
            at.unlinkParentInfos();
        }
    }

    public void pop(Object object, int targetlevel) {
        StackData sd = (StackData)object;
        for (int i = this.mAllTerms.size() - 1; i >= sd.mAllTermsSize; --i) {
            CCTerm t = this.mAllTerms.get(i);
            this.removeTerm(t);
            this.mAllTerms.remove(i);
        }
        this.mNumFunctionPositions = sd.mNumFuncPositions;
        this.mSymbolicTerms.endScope();
    }

    public Object push() {
        this.mSymbolicTerms.beginScope();
        return new StackData(this);
    }

    public Object[] getStatistics() {
        return new Object[]{":CC", new Object[][]{{"Merges", this.mMergeCount}, {"Closure", this.mCcCount}, {"Times", new Object[][]{{"Invert", this.mInvertEdgeTime}, {"Eq", this.mEqTime}, {"Closure", this.mCcTime}, {"SetRep", this.mSetRepTime}}}}};
    }

    public void fillInModel(Model model, Theory t, SharedTermEvaluator ste) {
        CCTerm trueNode = null;
        CCTerm falseNode = null;
        if (!this.mAllTerms.isEmpty()) {
            CCTerm t0 = this.mAllTerms.get(0);
            SharedTerm shared0 = t0.getFlatTerm();
            if (shared0.getTerm() == t.mTrue) {
                trueNode = t0;
                falseNode = this.mAllTerms.get(1);
            } else if (shared0.getTerm() == t.mFalse) {
                falseNode = t0;
                trueNode = this.mAllTerms.get(1);
            }
        }
        trueNode.mModelVal = model.getBoolSortInterpretation().getTrueIdx();
        falseNode.mModelVal = model.getBoolSortInterpretation().getFalseIdx();
        new ModelBuilder(this, this.mAllTerms, model, t, ste, trueNode, falseNode);
    }

    void addInvertEdgeTime(long time) {
        this.mInvertEdgeTime += time;
    }

    void addEqTime(long time) {
        this.mEqTime += time;
    }

    void addCcTime(long time) {
        this.mCcTime += time;
    }

    void addSetRepTime(long time) {
        this.mSetRepTime += time;
    }

    void incCcCount() {
        ++this.mCcCount;
    }

    void incMergeCount() {
        ++this.mMergeCount;
    }

    void initArrays() {
        assert (this.mNumFunctionPositions == 0) : "Solver already in use before initArrays";
        CCBaseTerm store = new CCBaseTerm(true, this.mNumFunctionPositions, "store", null);
        this.mStoreNum = this.mNumFunctionPositions;
        this.mNumFunctionPositions += 3;
        this.mSymbolicTerms.put("store", store);
        CCBaseTerm select = new CCBaseTerm(true, this.mNumFunctionPositions, "select", null);
        this.mSelectNum = this.mNumFunctionPositions;
        this.mNumFunctionPositions += 2;
        this.mSymbolicTerms.put("select", select);
        CCBaseTerm diff = new CCBaseTerm(true, this.mNumFunctionPositions, "@diff", null);
        this.mDiffNum = this.mNumFunctionPositions;
        this.mNumFunctionPositions += 2;
        this.mSymbolicTerms.put("@diff", diff);
    }

    boolean isArrayTheory() {
        return this.mStoreNum != this.mSelectNum;
    }

    int getStoreNum() {
        return this.mStoreNum;
    }

    int getSelectNum() {
        return this.mSelectNum;
    }

    int getDiffNum() {
        return this.mDiffNum;
    }
}

