/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SharedTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.SimpleListable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCBaseTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCParentInfo;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CClosure;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.Coercion;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CCAppTerm
extends CCTerm {
    final CCTerm mFunc;
    final CCTerm mArg;
    final Parent mLeftParInfo;
    final Parent mRightParInfo;
    Term mSmtTerm;

    public CCAppTerm(boolean isFunc, int parentPos, CCTerm func, CCTerm arg, SharedTerm term, CClosure engine) {
        super(isFunc, parentPos, term, HashUtils.hashJenkins(func.hashCode(), (Object)arg));
        this.mFunc = func;
        this.mArg = arg;
        this.mLeftParInfo = new Parent();
        this.mRightParInfo = new Parent();
    }

    public CCTerm getFunc() {
        return this.mFunc;
    }

    public CCTerm getArg() {
        return this.mArg;
    }

    private CCAppTerm findCongruentAppTerm(CCTerm func, CCTerm arg) {
        CCParentInfo argInfo = arg.mCCPars.getInfo(func.mParentPosition);
        CCParentInfo funcInfo = func.mCCPars.getInfo(0);
        if (argInfo != null && funcInfo != null) {
            for (Parent p : argInfo.mCCParents) {
                if (p.getData() == this) continue;
                for (Parent q : funcInfo.mCCParents) {
                    if (p.getData() != q.getData()) continue;
                    return p.getData();
                }
            }
        }
        return null;
    }

    public CCAppTerm addParentInfo(CClosure engine) {
        CCTerm func = this.mFunc;
        CCTerm arg = this.mArg;
        CCAppTerm congruentAppTerm = null;
        while (func.mRep != func || arg.mRep != arg) {
            if (congruentAppTerm == null) {
                congruentAppTerm = this.findCongruentAppTerm(func, arg);
            }
            if (func.mRep == func || arg.mRep != arg && arg.mMergeTime > func.mMergeTime) {
                arg.mCCPars.addParentInfo(func.mParentPosition, this.mRightParInfo, false, null);
                arg = arg.mRep;
                continue;
            }
            func.mCCPars.addParentInfo(0, this.mLeftParInfo, false, null);
            func = func.mRep;
        }
        if (congruentAppTerm == null) {
            congruentAppTerm = this.findCongruentAppTerm(func, arg);
        }
        func.mCCPars.addParentInfo(0, this.mLeftParInfo, true, engine);
        arg.mCCPars.addParentInfo(func.mParentPosition, this.mRightParInfo, true, engine);
        return congruentAppTerm;
    }

    public void unlinkParentInfos() {
        this.mLeftParInfo.removeFromList();
        this.mRightParInfo.removeFromList();
    }

    public void markParentInfos() {
        this.mLeftParInfo.mMark = (this.mRightParInfo.mMark = true);
    }

    public void unmarkParentInfos() {
        this.mLeftParInfo.mMark = (this.mRightParInfo.mMark = false);
    }

    public void toStringHelper(StringBuilder sb, HashSet<CCAppTerm> visited) {
        if (this.mFunc instanceof CCAppTerm) {
            ((CCAppTerm)this.mFunc).toStringHelper(sb, visited);
            sb.append(' ');
        } else {
            sb.append('(').append(this.mFunc).append(' ');
        }
        if (this.mArg instanceof CCAppTerm) {
            CCAppTerm arg2 = (CCAppTerm)this.mArg;
            if (!visited.contains(arg2)) {
                arg2.toStringHelper(sb, visited);
                sb.append(')');
                visited.add(arg2);
            }
        } else {
            sb.append(this.mArg);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toStringHelper(sb, new HashSet<CCAppTerm>());
        sb.append(')');
        return sb.toString();
    }

    @Override
    public Term toSMTTerm(Theory theory, boolean useAuxVars) {
        FunctionSymbol sym;
        if (this.mSmtTerm != null) {
            return this.mSmtTerm;
        }
        assert (!this.mIsFunc);
        CCTerm t = this;
        int dest = 0;
        while (t instanceof CCAppTerm) {
            t = t.mFunc;
            ++dest;
        }
        CCBaseTerm basefunc = (CCBaseTerm)t;
        Term[] args = new Term[dest];
        t = this;
        while (t instanceof CCAppTerm) {
            args[--dest] = t.mArg.toSMTTerm(theory, useAuxVars);
            t = t.mFunc;
        }
        if (basefunc.mSymbol instanceof FunctionSymbol) {
            sym = (FunctionSymbol)basefunc.mSymbol;
        } else if (basefunc.mSymbol instanceof String) {
            ApplicationTerm tmp = theory.term((String)basefunc.mSymbol, args);
            sym = tmp.getFunction();
        } else {
            throw new InternalError("Unknown symbol in CCBaseTerm: " + basefunc.mSymbol);
        }
        this.mSmtTerm = Coercion.buildApp(sym, args);
        return this.mSmtTerm;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Parent
    extends SimpleListable<Parent> {
        private boolean mMark = false;

        Parent() {
        }

        CCAppTerm getData() {
            return CCAppTerm.this;
        }

        public final boolean isMarked() {
            assert (!this.mMark || CCAppTerm.this.mRepStar.mNumMembers > 1);
            return this.mMark;
        }

        public String toString() {
            return CCAppTerm.this.toString();
        }
    }
}

