/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure;

import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Clausifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.EqualityProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.ITheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.ArraySortInterpretation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.ArrayValue;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.Model;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.SharedTermEvaluator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAppTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCBaseTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCParentInfo;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CClosure;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.WeakCongruencePath;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.SymmetricPair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedArrayList;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashSet;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayTheory
implements ITheory {
    private final Clausifier mClausifier;
    private final CClosure mCClosure;
    private final int mSelectFunNum;
    private final ScopedArrayList<CCTerm> mArrays = new ScopedArrayList();
    private final ScopedHashSet<CCAppTerm> mStores = new ScopedHashSet();
    private final ScopedHashSet<CCAppTerm> mDiffs = new ScopedHashSet();
    private final ArrayDeque<ArrayLemma> mPropClauses = new ArrayDeque();
    private final LogProxy mLogger;
    Map<CCTerm, ArrayNode> mCongRoots = null;
    Map<ArrayNode, Map<CCTerm, Object>> mArrayModels = null;
    private int mNumInstsSelect = 0;
    private int mNumInstsEq = 0;
    private int mNumBuildWeakEQ = 0;
    private int mNumAddStores = 0;
    private int mNumMerges = 0;
    private int mNumModuloEdges = 0;
    private long mTimeBuildWeakEq = 0L;
    private long mTimeBuildWeakEqi = 0L;
    private long mTimePropagation = 0L;
    private long mTimeExplanations = 0L;
    private int mNumArrays = 0;

    public ArrayTheory(Clausifier clausifier, CClosure cclosure) {
        this.mClausifier = clausifier;
        this.mCClosure = cclosure;
        this.mCClosure.initArrays();
        this.mSelectFunNum = this.mCClosure.getSelectNum();
        this.mLogger = this.mCClosure.mEngine.getLogger();
    }

    @Override
    public Clause startCheck() {
        this.cleanCaches();
        return null;
    }

    @Override
    public void endCheck() {
    }

    @Override
    public Clause setLiteral(Literal literal) {
        if (literal instanceof CCEquality) {
            this.cleanCaches();
        } else {
            for (ArrayLemma lemma : this.mPropClauses) {
                if (!lemma.mUndecidedLits.remove(literal.negate()) || !lemma.mUndecidedLits.isEmpty()) continue;
                return this.explainPropagation(lemma.mPropagatedEq);
            }
        }
        return null;
    }

    @Override
    public void backtrackLiteral(Literal literal) {
        this.cleanCaches();
    }

    @Override
    public Clause checkpoint() {
        if (this.mCongRoots == null && this.buildWeakEq()) {
            for (ArrayLemma lemma : this.mPropClauses) {
                if (!lemma.mUndecidedLits.isEmpty()) continue;
                return this.explainPropagation(lemma.mPropagatedEq);
            }
        }
        return null;
    }

    @Override
    public Clause computeConflictClause() {
        Clause conflict = this.checkpoint();
        if (conflict != null) {
            return conflict;
        }
        if (this.mPropClauses.isEmpty()) {
            boolean foundLemma = this.computeWeakeqExt();
            if (foundLemma) {
                this.mArrayModels = null;
            } else {
                this.mCongRoots = null;
            }
        }
        return null;
    }

    @Override
    public Literal getPropagatedLiteral() {
        long start = System.nanoTime();
        for (ArrayLemma lemma : this.mPropClauses) {
            if (lemma.mUndecidedLits.size() != 1) continue;
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug("AL prop: " + lemma);
            }
            Literal lit = lemma.mUndecidedLits.iterator().next();
            this.mTimePropagation += System.nanoTime() - start;
            lit.getAtom().mExplanation = this.explainPropagation(lemma.mPropagatedEq);
            return lit;
        }
        return null;
    }

    @Override
    public Clause getUnitClause(Literal literal) {
        assert (literal instanceof CCEquality);
        if (this.mCongRoots == null) {
            this.buildWeakEq();
        }
        for (ArrayLemma lemma : this.mPropClauses) {
            Set<CCEquality> lits = lemma.mUndecidedLits;
            if (!lits.isEmpty() && (lits.size() != 1 || !lits.contains(literal))) continue;
            return this.explainPropagation(lemma.mPropagatedEq);
        }
        throw new AssertionError((Object)"Cannot explain unit literal!");
    }

    private Clause explainPropagation(SymmetricPair<CCAppTerm> equality) {
        long start = System.nanoTime();
        ++this.mNumInstsSelect;
        WeakCongruencePath path = new WeakCongruencePath(this);
        Clause lemma = path.computeSelectOverWeakEQ(equality.getFirst(), equality.getSecond(), this.mCClosure.mEngine.isProofGenerationEnabled());
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug("AL sw: " + lemma);
        }
        this.mTimeExplanations += System.nanoTime() - start;
        return lemma;
    }

    @Override
    public Literal getSuggestion() {
        return null;
    }

    @Override
    public void printStatistics(LogProxy logger) {
        if (logger.isInfoEnabled()) {
            logger.info("Array: #Arrays: %d, #BuildWeakEQ: %d, #ModEdges: %d, #addStores: %d, #merges: %d", this.mNumArrays, this.mNumBuildWeakEQ, this.mNumModuloEdges, this.mNumAddStores, this.mNumMerges);
            logger.info("Insts: ReadOverWeakEQ: %d, WeakeqExt: %d", this.mNumInstsSelect, this.mNumInstsEq);
            logger.info("Time: BuildWeakEq: %.3f ms, BuildWeakEqi: %.3f ms", (double)this.mTimeBuildWeakEq / 1000000.0, (double)this.mTimeBuildWeakEqi / 1000000.0);
            logger.info("Time: Propagation %.3f ms, Explanations: %.3f ms", (double)this.mTimePropagation / 1000000.0, (double)this.mTimeExplanations / 1000000.0);
        }
    }

    @Override
    public void dumpModel(LogProxy logger) {
        if (!logger.isInfoEnabled()) {
            return;
        }
        for (Map.Entry<ArrayNode, Map<CCTerm, Object>> entry : this.mArrayModels.entrySet()) {
            StringBuilder sb = new StringBuilder();
            sb.append(entry.getKey().mTerm).append(" = store[");
            sb.append(((ArrayNode)entry.getValue().get(null)).mTerm);
            for (Map.Entry<CCTerm, Object> storeEntry : entry.getValue().entrySet()) {
                if (storeEntry.getKey() == null) continue;
                sb.append(",(").append(storeEntry.getKey()).append(":=").append(storeEntry.getValue()).append(')');
            }
            sb.append(']');
            logger.info(sb.toString());
        }
    }

    @Override
    public void increasedDecideLevel(int currentDecideLevel) {
    }

    @Override
    public void decreasedDecideLevel(int currentDecideLevel) {
    }

    @Override
    public Clause backtrackComplete() {
        this.mPropClauses.clear();
        return null;
    }

    @Override
    public void restart(int iteration) {
    }

    @Override
    public void removeAtom(DPLLAtom atom) {
    }

    @Override
    public Object push() {
        this.mArrays.beginScope();
        this.mStores.beginScope();
        this.mDiffs.beginScope();
        return this.mNumArrays;
    }

    @Override
    public void pop(Object object, int targetlevel) {
        this.mNumArrays = (Integer)object;
        this.mStores.endScope();
        this.mArrays.endScope();
        this.mDiffs.endScope();
    }

    @Override
    public Object[] getStatistics() {
        return new Object[]{":Array", new Object[][]{{"NumArrays", this.mNumArrays}, {"BuildWeakEQ", this.mNumBuildWeakEQ}, {"AddStores", this.mNumAddStores}, {"Merges", this.mNumMerges}, {"ModuloEdges", this.mNumModuloEdges}, {"ReadOverWeakeq", this.mNumInstsSelect}, {"WeakeqExt", this.mNumInstsEq}, {"Times", new Object[][]{{"BuildWeakEq", this.mTimeBuildWeakEq}, {"BuildWeakEqi", this.mTimeBuildWeakEqi}, {"Propagation", this.mTimePropagation}, {"Explanations", this.mTimeExplanations}}}}};
    }

    @Override
    public void fillInModel(Model model, Theory t, SharedTermEvaluator ste) {
        HashMap<ArrayNode, Integer> freshIndices = new HashMap<ArrayNode, Integer>();
        HashMap<ArrayNode, Integer> freshValues = new HashMap<ArrayNode, Integer>();
        HashMap storeIndices = new HashMap();
        for (Map.Entry<ArrayNode, Map<CCTerm, Object>> e : this.mArrayModels.entrySet()) {
            ArrayNode root = (ArrayNode)e.getValue().get(null);
            HashSet<CCTerm> stores = (HashSet<CCTerm>)storeIndices.get(root);
            if (stores == null) {
                stores = new HashSet<CCTerm>();
                storeIndices.put(root, stores);
            }
            for (Map.Entry<CCTerm, Object> mapping : e.getValue().entrySet()) {
                if (!(mapping.getValue() instanceof CCTerm)) continue;
                assert (((CCTerm)mapping.getValue()).isRepresentative());
                int val = ((CCTerm)mapping.getValue()).mModelVal;
                if (val != 0) continue;
                stores.add(mapping.getKey());
            }
        }
        for (Map.Entry<ArrayNode, Map<CCTerm, Object>> e : this.mArrayModels.entrySet()) {
            CCTerm ccterm = e.getKey().mTerm;
            assert (ccterm.isRepresentative());
            Sort arraySort = ccterm.toSMTTerm(this.mClausifier.getTheory()).getSort();
            ArraySortInterpretation interp = model.getArrayInterpretation(arraySort);
            ArrayValue aval = interp.getValue(ccterm.mModelVal);
            ArrayNode root = (ArrayNode)e.getValue().get(null);
            if (!freshIndices.containsKey(root)) {
                int idx = interp.getIndexInterpretation().extendFresh();
                freshIndices.put(root, idx);
            }
            interp.getValueInterpretation().ensureCapacity(2);
            aval.store((Integer)freshIndices.get(root), 1);
            Set storeIdxs = (Set)storeIndices.get(root);
            for (CCTerm cCTerm : storeIdxs) {
                if (e.getValue().containsKey(cCTerm)) continue;
                if (!freshValues.containsKey(root)) {
                    freshValues.put(root, interp.getValueInterpretation().extendFresh());
                }
                int val = (Integer)freshValues.get(root);
                aval.store(cCTerm.mModelVal, val);
            }
            for (Map.Entry entry : e.getValue().entrySet()) {
                int val;
                CCTerm index = (CCTerm)entry.getKey();
                if (index == null) continue;
                assert (index.isRepresentative());
                Object value = entry.getValue();
                if (value instanceof CCTerm) {
                    assert (((CCTerm)value).isRepresentative());
                    val = ((CCTerm)value).mModelVal;
                } else {
                    ArrayNode weaki = (ArrayNode)value;
                    if (!freshValues.containsKey(weaki)) {
                        freshValues.put(weaki, interp.getValueInterpretation().extendFresh());
                    }
                    val = (Integer)freshValues.get(weaki);
                }
                aval.store(index.mModelVal, val);
            }
        }
    }

    public void notifyArray(CCTerm array, boolean isStore) {
        if (isStore) {
            this.mStores.add((CCAppTerm)array);
            ++this.mNumAddStores;
        }
        this.mArrays.add(array);
        ++this.mNumArrays;
    }

    public void notifyDiff(CCAppTerm diff) {
        this.mDiffs.add(diff);
    }

    static CCTerm getArrayFromSelect(CCAppTerm select) {
        return ((CCAppTerm)select.getFunc()).getArg();
    }

    static CCTerm getIndexFromSelect(CCAppTerm select) {
        return select.getArg();
    }

    static CCTerm getArrayFromStore(CCAppTerm store) {
        return ((CCAppTerm)((CCAppTerm)store.getFunc()).getFunc()).getArg();
    }

    static CCTerm getIndexFromStore(CCAppTerm store) {
        return ((CCAppTerm)store.getFunc()).getArg();
    }

    static CCTerm getValueFromStore(CCAppTerm store) {
        return store.getArg();
    }

    static CCTerm getLeftFromDiff(CCAppTerm diff) {
        return ArrayTheory.getIndexFromStore(diff);
    }

    static CCTerm getRightFromDiff(CCAppTerm diff) {
        return diff.getArg();
    }

    static Sort getArraySortFromSelect(CCAppTerm select) {
        return ((CCBaseTerm)((CCAppTerm)select.getFunc()).getFunc()).getFunctionSymbol().getParameterSorts()[0];
    }

    static Sort getArraySortFromStore(CCAppTerm store) {
        return ArrayTheory.getArraySortFromSelect((CCAppTerm)store.getFunc());
    }

    private boolean merge(CCAppTerm store) {
        ArrayNode storeNode;
        CCTerm array = ArrayTheory.getArrayFromStore(store);
        ArrayNode arrayNode = this.mCongRoots.get(array.getRepresentative());
        if (arrayNode == (storeNode = this.mCongRoots.get(store.getRepresentative()))) {
            return false;
        }
        ++this.mNumMerges;
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug("Merge: [" + ArrayTheory.getIndexFromStore(store).getRepresentative() + "] " + arrayNode + " and " + storeNode);
        }
        arrayNode.makeWeakRepresentative();
        storeNode.makeWeakRepresentative();
        HashSet<SymmetricPair<CCAppTerm>> propEqualities = new HashSet<SymmetricPair<CCAppTerm>>();
        if (arrayNode.mStoreEdge == null) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug("  StoreEdge");
            }
            arrayNode.mergeWith(storeNode, store, propEqualities);
        } else {
            HashSet<CCTerm> seenIndices = new HashSet<CCTerm>();
            CCTerm cCTerm = ArrayTheory.getIndexFromStore(store).getRepresentative();
            seenIndices.add(cCTerm);
            ArrayNode node = arrayNode;
            while (node.mStoreEdge != null) {
                CCTerm index = ArrayTheory.getIndexFromStore(node.mStoreReason).getRepresentative();
                if (seenIndices.add(index) && node.getWeakIRepresentative(index) != storeNode) {
                    ++this.mNumModuloEdges;
                    if (this.mLogger.isDebugEnabled()) {
                        this.mLogger.debug("  SelectEdge: [" + index + "] " + node + " to " + storeNode);
                    }
                    node.mergeSelect(storeNode, store, propEqualities);
                }
                node = node.mStoreEdge;
            }
        }
        for (SymmetricPair symmetricPair : propEqualities) {
            CCAppTerm select1 = (CCAppTerm)symmetricPair.getFirst();
            CCAppTerm select2 = (CCAppTerm)symmetricPair.getSecond();
            if (select1.getRepresentative() == select2.getRepresentative()) continue;
            CCTerm index1 = ArrayTheory.getIndexFromSelect(select1);
            CCTerm array1 = ArrayTheory.getArrayFromSelect(select1);
            CCTerm array2 = ArrayTheory.getArrayFromSelect(select2);
            HashSet<CCTerm> storeIndices = new HashSet<CCTerm>();
            this.computeStoreIndices(index1.getRepresentative(), array1, array2, storeIndices);
            HashSet<CCEquality> propClause = new HashSet<CCEquality>();
            for (CCTerm idx : storeIndices) {
                assert (index1.getRepresentative() != idx.getRepresentative());
                CCEquality lit = ArrayTheory.createEquality(index1, idx);
                if (lit == null) continue;
                assert (lit.getDecideStatus() != lit);
                if (lit.getDecideStatus() != null) continue;
                propClause.add(lit);
            }
            CCEquality lit = ArrayTheory.createEquality(select1, select2);
            if (lit != null) {
                assert (lit.getDecideStatus() != lit);
                if (lit.getDecideStatus() == null) {
                    propClause.add(lit);
                }
            }
            ArrayLemma lemma = new ArrayLemma();
            lemma.mUndecidedLits = propClause;
            lemma.mPropagatedEq = symmetricPair;
            this.mPropClauses.add(lemma);
        }
        return !propEqualities.isEmpty();
    }

    static CCEquality createEquality(CCTerm t1, CCTerm t2) {
        CCEquality eq;
        EqualityProxy ep = t1.getFlatTerm().createEquality(t2.getFlatTerm());
        if (ep == EqualityProxy.getFalseProxy()) {
            return null;
        }
        DPLLAtom res = ep.getLiteral();
        if (res instanceof CCEquality && ((eq = (CCEquality)res).getLhs() == t1 && eq.getRhs() == t2 || eq.getLhs() == t2 && eq.getRhs() == t1)) {
            return eq;
        }
        return ep.createCCEquality(t1.getFlatTerm(), t2.getFlatTerm());
    }

    private void computeStoreIndices(CCTerm index, CCTerm array1, CCTerm array2, Set<CCTerm> storeIndices) {
        ArrayNode node1 = this.mCongRoots.get(array1.getRepresentative());
        ArrayNode node2 = this.mCongRoots.get(array2.getRepresentative());
        Cursor cursor1 = new Cursor(array1, node1);
        Cursor cursor2 = new Cursor(array2, node2);
        assert (index == index.getRepresentative());
        cursor1.collect(index, cursor2, storeIndices);
    }

    private boolean buildWeakEq() {
        ++this.mNumBuildWeakEQ;
        long startTime = System.nanoTime();
        this.mCongRoots = new HashMap<CCTerm, ArrayNode>();
        for (CCTerm array : this.mArrays) {
            CCTerm rep = array.getRepresentative();
            if (this.mCongRoots.containsKey(rep)) continue;
            ArrayNode node = new ArrayNode(rep);
            node.computeSelects(this.mSelectFunNum);
            this.mCongRoots.put(rep, node);
        }
        boolean res = false;
        for (CCAppTerm store : this.mStores) {
            res |= this.merge(store);
        }
        this.mTimeBuildWeakEq += System.nanoTime() - startTime;
        return res;
    }

    private boolean computeWeakeqExt() {
        long startTime = System.nanoTime();
        this.mArrayModels = new HashMap<ArrayNode, Map<CCTerm, Object>>();
        HashMap inverse = new HashMap();
        HashSet<SymmetricPair<ArrayNode>> propEqualities = new HashSet<SymmetricPair<ArrayNode>>();
        ArrayDeque<ArrayNode> todoQueue = new ArrayDeque<ArrayNode>(this.mCongRoots.values());
        while (!todoQueue.isEmpty()) {
            ArrayNode node = todoQueue.getFirst();
            if (this.mArrayModels.containsKey(node)) {
                todoQueue.removeFirst();
                continue;
            }
            if (node.mStoreEdge != null && !this.mArrayModels.containsKey(node.mStoreEdge)) {
                todoQueue.addFirst(node.mStoreEdge);
                continue;
            }
            todoQueue.removeFirst();
            HashMap<CCTerm, Object> hashMap = new HashMap<CCTerm, Object>();
            if (node.mStoreEdge == null) {
                hashMap.put(null, node);
                for (Map.Entry<CCTerm, CCAppTerm> e : node.mSelects.entrySet()) {
                    hashMap.put(e.getKey(), e.getValue().getRepresentative());
                }
            } else {
                CCTerm storeIndex = ArrayTheory.getIndexFromStore(node.mStoreReason).getRepresentative();
                hashMap.putAll(this.mArrayModels.get(node.mStoreEdge));
                hashMap.remove(storeIndex);
                ArrayNode weakiRep = node.getWeakIRepresentative(storeIndex);
                CCAppTerm value = weakiRep.mSelects.get(storeIndex);
                if (value != null) {
                    hashMap.put(storeIndex, value.getRepresentative());
                } else if (weakiRep.mStoreEdge != null) {
                    hashMap.put(storeIndex, weakiRep);
                }
            }
            this.mArrayModels.put(node, hashMap);
            ArrayNode prev = inverse.put(hashMap, node);
            if (prev == null) continue;
            propEqualities.add(new SymmetricPair<ArrayNode>(prev, node));
        }
        for (SymmetricPair symmetricPair : propEqualities) {
            ++this.mNumInstsEq;
            WeakCongruencePath path = new WeakCongruencePath(this);
            Clause lemma = path.computeWeakeqExt(((ArrayNode)symmetricPair.getFirst()).mTerm, ((ArrayNode)symmetricPair.getSecond()).mTerm, this.mCClosure.mEngine.isProofGenerationEnabled());
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug("AL sw: " + lemma);
            }
            this.mCClosure.mEngine.learnClause(lemma);
        }
        this.mTimeBuildWeakEqi += System.nanoTime() - startTime;
        return !propEqualities.isEmpty();
    }

    CClosure getCClosure() {
        return this.mCClosure;
    }

    Clausifier getClausifier() {
        return this.mClausifier;
    }

    boolean isStore(CCTerm term) {
        return this.mStores.contains(term);
    }

    private void cleanCaches() {
        this.mCongRoots = null;
        this.mPropClauses.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Cursor {
        ArrayNode mNode;

        public Cursor(CCTerm term, ArrayNode node) {
            this.mNode = node;
        }

        public void collectOverStores(ArrayNode destNode, Set<CCTerm> storeIndices) {
            int steps1;
            int steps2 = destNode.countStoreEdges();
            for (steps1 = this.mNode.countStoreEdges(); steps1 > steps2; --steps1) {
                storeIndices.add(ArrayTheory.getIndexFromStore(this.mNode.mStoreReason));
                this.mNode = this.mNode.mStoreEdge;
            }
            while (steps2 > steps1) {
                storeIndices.add(ArrayTheory.getIndexFromStore(destNode.mStoreReason));
                destNode = destNode.mStoreEdge;
                --steps2;
            }
            while (this.mNode != destNode) {
                storeIndices.add(ArrayTheory.getIndexFromStore(this.mNode.mStoreReason));
                storeIndices.add(ArrayTheory.getIndexFromStore(destNode.mStoreReason));
                this.mNode = this.mNode.mStoreEdge;
                destNode = destNode.mStoreEdge;
            }
        }

        public void collectOneSelect(CCTerm index, Set<CCTerm> storeIndices) {
            ArrayNode selectNode = this.mNode.findSelectNode(index);
            CCAppTerm store = selectNode.mSelectReason;
            CCTerm array = ArrayTheory.getArrayFromStore(store);
            ArrayNode arrayNode = ArrayTheory.this.mCongRoots.get(array.getRepresentative());
            ArrayNode storeNode = ArrayTheory.this.mCongRoots.get(store.getRepresentative());
            if (arrayNode.findSelectNode(index) == selectNode) {
                this.collectOverStores(arrayNode, storeIndices);
                this.mNode = storeNode;
            } else {
                assert (storeNode.findSelectNode(index) == selectNode);
                this.collectOverStores(storeNode, storeIndices);
                this.mNode = arrayNode;
            }
            storeIndices.add(ArrayTheory.getIndexFromStore(store));
        }

        public void collect(CCTerm index, Cursor dest, Set<CCTerm> storeIndices) {
            int steps1;
            int steps2 = dest.mNode.countSelectEdges(index);
            for (steps1 = this.mNode.countSelectEdges(index); steps1 > steps2; --steps1) {
                this.collectOneSelect(index, storeIndices);
            }
            while (steps2 > steps1) {
                dest.collectOneSelect(index, storeIndices);
                --steps2;
            }
            while (this.mNode.findSelectNode(index) != dest.mNode.findSelectNode(index)) {
                this.collectOneSelect(index, storeIndices);
                dest.collectOneSelect(index, storeIndices);
            }
            this.collectOverStores(dest.mNode, storeIndices);
        }
    }

    private static class ArrayLemma {
        Set<CCEquality> mUndecidedLits;
        SymmetricPair<CCAppTerm> mPropagatedEq;

        private ArrayLemma() {
        }

        public String toString() {
            return "ArrayLemma[" + this.mPropagatedEq + " ; " + this.mUndecidedLits + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ArrayNode {
        CCTerm mTerm;
        ArrayNode mStoreEdge;
        CCAppTerm mStoreReason;
        ArrayNode mSelectEdge;
        CCAppTerm mSelectReason;
        ArrayNode mNext;
        Map<CCTerm, CCAppTerm> mSelects;

        public ArrayNode(CCTerm ccterm) {
            assert (ccterm.isRepresentative());
            this.mTerm = ccterm;
            this.mNext = this;
            this.mSelectEdge = null;
            this.mStoreEdge = null;
            this.mStoreReason = null;
        }

        public ArrayNode getWeakRepresentative() {
            ArrayNode node = this;
            while (node.mStoreEdge != null) {
                node = node.mStoreEdge;
            }
            return node;
        }

        public ArrayNode getWeakIRepresentative(CCTerm index) {
            index = index.getRepresentative();
            ArrayNode node = this;
            while (node.mStoreEdge != null) {
                if (ArrayTheory.getIndexFromStore(node.mStoreReason).getRepresentative() == index) {
                    if (node.mSelectEdge == null) break;
                    node = node.mSelectEdge;
                    continue;
                }
                node = node.mStoreEdge;
            }
            return node;
        }

        public void invertSelectEdges() {
            assert (this.mStoreEdge != null);
            assert (this.mSelectEdge != null);
            CCTerm index = ArrayTheory.getIndexFromStore(this.mStoreReason).getRepresentative();
            assert (this.getWeakIRepresentative(index) != this.getWeakRepresentative());
            ArrayNode prev = this;
            ArrayNode next = prev.mSelectEdge;
            CCAppTerm prevReason = prev.mSelectReason;
            while (next != null) {
                next = next.findSelectNode(index);
                ArrayNode nextEdge = next.mSelectEdge;
                CCAppTerm nextReason = next.mSelectReason;
                next.mSelectEdge = prev;
                next.mSelectReason = prevReason;
                prev = next;
                prevReason = nextReason;
                next = nextEdge;
            }
            this.mSelectEdge = null;
            this.mSelectReason = null;
            this.mSelects = prev.mSelects;
            prev.mSelects = Collections.emptyMap();
        }

        public void makeWeakRepresentative() {
            CCTerm index;
            if (this.mStoreEdge == null) {
                return;
            }
            HashMap<CCTerm, ArrayNode> seenStores = new HashMap<CCTerm, ArrayNode>();
            HashMap<CCTerm, ArrayNode> todoSelects = new HashMap<CCTerm, ArrayNode>();
            HashMap<CCTerm, CCAppTerm> todoReasons = new HashMap<CCTerm, CCAppTerm>();
            HashMap<CCTerm, CCAppTerm> newSelectMap = new HashMap<CCTerm, CCAppTerm>();
            ArrayNode node = this;
            ArrayNode prev = null;
            CCAppTerm prevStore = null;
            while (node.mStoreEdge != null) {
                ArrayNode next = node.mStoreEdge;
                CCAppTerm nextStore = node.mStoreReason;
                node.mStoreEdge = prev;
                node.mStoreReason = prevStore;
                CCTerm index2 = ArrayTheory.getIndexFromStore(nextStore).getRepresentative();
                ArrayNode old = seenStores.put(index2, next);
                if (old != node) {
                    if (node.mSelectEdge != null) {
                        if (old == null) {
                            todoSelects.put(index2, node.mSelectEdge);
                            todoReasons.put(index2, node.mSelectReason);
                        } else {
                            assert (ArrayTheory.getIndexFromStore(old.mStoreReason).getRepresentative() == index2);
                            assert (old.mSelectEdge == null);
                            old.mSelectEdge = node.mSelectEdge;
                            old.mSelectReason = node.mSelectReason;
                        }
                        node.mSelectEdge = null;
                        node.mSelectReason = null;
                    } else if (!node.mSelects.isEmpty()) {
                        if (old == null) {
                            assert (node.mSelects.get(index2) != null);
                            newSelectMap.put(index2, node.mSelects.get(index2));
                        } else {
                            old.mSelects = node.mSelects;
                        }
                        node.mSelects = Collections.emptyMap();
                    }
                }
                prev = node;
                node = next;
                prevStore = nextStore;
            }
            node.mStoreEdge = prev;
            node.mStoreReason = prevStore;
            Map<CCTerm, CCAppTerm> rootSelects = node.mSelects;
            node.mSelects = Collections.emptyMap();
            for (Map.Entry entry : seenStores.entrySet()) {
                index = (CCTerm)entry.getKey();
                CCAppTerm select = rootSelects.remove(index);
                if (select == null) continue;
                ((ArrayNode)entry.getValue()).mSelects = Collections.singletonMap(index, select);
            }
            for (Map.Entry entry : todoSelects.entrySet()) {
                index = (CCTerm)entry.getKey();
                ArrayNode dest = (ArrayNode)entry.getValue();
                dest = dest.findSelectNode(index);
                if (dest.mSelectEdge != null) {
                    dest.invertSelectEdges();
                }
                dest.mSelectEdge = this;
                dest.mSelectReason = (CCAppTerm)todoReasons.get(index);
                newSelectMap.putAll(dest.mSelects);
                dest.mSelects = Collections.emptyMap();
            }
            newSelectMap.putAll(rootSelects);
            this.mSelects = newSelectMap;
        }

        public void mergeWith(ArrayNode storeNode, CCAppTerm store, Set<SymmetricPair<CCAppTerm>> propEqualities) {
            assert (this.getWeakRepresentative() != storeNode.getWeakRepresentative());
            this.mStoreEdge = storeNode;
            this.mStoreReason = store;
            ArrayNode next = this.mNext;
            this.mNext = storeNode.mNext;
            storeNode.mNext = next;
            Map<Object, Object> newSelects = Collections.emptyMap();
            for (Map.Entry<CCTerm, CCAppTerm> entry : this.mSelects.entrySet()) {
                CCTerm index = entry.getKey();
                CCAppTerm select = entry.getValue();
                assert (select != null);
                if (index == ArrayTheory.getIndexFromStore(store).getRepresentative()) {
                    newSelects = Collections.singletonMap(index, select);
                    continue;
                }
                CCAppTerm otherSelect = storeNode.mSelects.get(index);
                if (otherSelect == null) {
                    storeNode.mSelects.put(index, select);
                    continue;
                }
                if (select.getRepresentative() == otherSelect.getRepresentative()) continue;
                propEqualities.add(new SymmetricPair<CCAppTerm>(select, otherSelect));
            }
            this.mSelects = newSelects;
        }

        public void computeSelects(int mSelectFunNum) {
            this.mSelects = new HashMap<CCTerm, CCAppTerm>();
            CCParentInfo info = this.mTerm.mCCPars.getExistingParentInfo(mSelectFunNum);
            if (info != null) {
                for (CCAppTerm.Parent pa : info.mCCParents) {
                    CCParentInfo selectas = pa.getData().getRepresentative().mCCPars.getExistingParentInfo(0);
                    for (CCAppTerm.Parent spa : selectas.mCCParents) {
                        CCAppTerm select = spa.getData();
                        assert (ArrayTheory.getArrayFromSelect(select).getRepresentative() == this.mTerm);
                        assert (select != null);
                        this.mSelects.put(select.mArg.getRepresentative(), select);
                    }
                }
            }
        }

        public void mergeSelect(ArrayNode storeNode, CCAppTerm store, Set<SymmetricPair<CCAppTerm>> propEqualities) {
            assert (storeNode.mStoreEdge == null);
            assert (this.mStoreEdge != null);
            assert (ArrayTheory.getIndexFromStore(this.mStoreReason).getRepresentative() != ArrayTheory.getIndexFromStore(store).getRepresentative());
            if (this.mSelectEdge != null) {
                this.invertSelectEdges();
            }
            this.mSelectEdge = storeNode;
            this.mSelectReason = store;
            if (!this.mSelects.isEmpty()) {
                CCTerm storeIndex = ArrayTheory.getIndexFromStore(this.mStoreReason).getRepresentative();
                CCAppTerm select = this.mSelects.get(storeIndex);
                assert (select != null);
                CCAppTerm otherSelect = storeNode.mSelects.get(storeIndex);
                if (otherSelect == null) {
                    storeNode.mSelects.put(storeIndex, select);
                } else if (select.getRepresentative() != otherSelect.getRepresentative()) {
                    propEqualities.add(new SymmetricPair<CCAppTerm>(select, otherSelect));
                }
                this.mSelects = Collections.emptyMap();
            }
        }

        public int countSelectEdges(CCTerm index) {
            assert (index.isRepresentative());
            int count = 0;
            ArrayNode node = this;
            while (node.mStoreEdge != null) {
                if (ArrayTheory.getIndexFromStore(node.mStoreReason).getRepresentative() == index) {
                    if (node.mSelectEdge == null) break;
                    node = node.mSelectEdge;
                    ++count;
                    continue;
                }
                node = node.mStoreEdge;
            }
            return count;
        }

        public ArrayNode findSelectNode(CCTerm index) {
            assert (index.isRepresentative());
            ArrayNode node = this;
            while (node.mStoreEdge != null && ArrayTheory.getIndexFromStore(node.mStoreReason).getRepresentative() != index) {
                node = node.mStoreEdge;
            }
            return node;
        }

        public int countStoreEdges() {
            int count = 0;
            ArrayNode node = this;
            while (node.mStoreEdge != null) {
                node = node.mStoreEdge;
                ++count;
            }
            return count;
        }

        public int hashCode() {
            return this.mTerm.hashCode();
        }

        public String toString() {
            return "ArrayNode[" + this.mTerm + "]";
        }
    }
}

