/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure;

import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.ArrayTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAppTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CongruencePath;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.WeakCongruencePath;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.Coercion;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.SymmetricPair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayAnnotation
extends CCAnnotation {
    final CCTerm[] mWeakIndices;
    final RuleKind mRule;
    final IndexedPath[] mIndexedPaths;
    private HashMap<SymmetricPair<CCTerm>, Literal> mEqualityLiterals;
    private HashMap<SymmetricPair<CCTerm>, IndexedPath> mSubPathMap;
    private HashMap<IndexedPath, ProofInfo> mPathProofMap;

    public ArrayAnnotation(CCEquality diseq, Collection<CongruencePath.SubPath> paths, RuleKind rule) {
        super(diseq, paths);
        this.mWeakIndices = new CCTerm[this.mPaths.length];
        this.mIndexedPaths = new IndexedPath[this.mPaths.length];
        int i = 0;
        for (CongruencePath.SubPath p : paths) {
            this.mWeakIndices[i] = p instanceof WeakCongruencePath.WeakSubPath ? ((WeakCongruencePath.WeakSubPath)p).getIndex() : null;
            this.mIndexedPaths[i] = new IndexedPath(this.mWeakIndices[i], this.mPaths[i]);
            ++i;
        }
        this.mRule = rule;
    }

    public CCTerm[] getWeakIndices() {
        return this.mWeakIndices;
    }

    @Override
    public Term toTerm(Clause clause, Theory theory) {
        this.mEqualityLiterals = this.collectClauseLiterals(clause);
        this.mSubPathMap = this.makeSubPathMap();
        this.mPathProofMap = this.makePathProofMap();
        SymmetricPair<CCTerm> mainDiseq = new SymmetricPair<CCTerm>(this.mDiseq.getLhs(), this.mDiseq.getRhs());
        LinkedHashSet<IndexedPath> mainPaths = this.findMainPaths();
        HashMap<SymmetricPair<CCTerm>, ProofInfo> proofGraph = this.buildProofGraph(mainDiseq, mainPaths);
        ArrayList<SymmetricPair<CCTerm>> proofOrder = this.determineProofOrder(mainDiseq, proofGraph);
        return this.buildProofTerm(clause, theory, proofOrder, proofGraph);
    }

    private HashMap<SymmetricPair<CCTerm>, Literal> collectClauseLiterals(Clause clause) {
        HashMap<SymmetricPair<CCTerm>, Literal> clauseLiterals = new HashMap<SymmetricPair<CCTerm>, Literal>();
        for (int i = 0; i < clause.getSize(); ++i) {
            Literal literal = clause.getLiteral(i);
            CCEquality atom = (CCEquality)literal.getAtom();
            CCTerm lhs = atom.getLhs();
            CCTerm rhs = atom.getRhs();
            clauseLiterals.put(new SymmetricPair<CCTerm>(lhs, rhs), literal);
        }
        return clauseLiterals;
    }

    private HashMap<SymmetricPair<CCTerm>, IndexedPath> makeSubPathMap() {
        HashMap<SymmetricPair<CCTerm>, IndexedPath> pathMap = new HashMap<SymmetricPair<CCTerm>, IndexedPath>();
        for (int i = 0; i < this.mIndexedPaths.length; ++i) {
            IndexedPath indexedPath = this.mIndexedPaths[i];
            if (indexedPath.getIndex() != null) continue;
            CCTerm[] path = indexedPath.getPath();
            SymmetricPair<CCTerm> pathEnds = new SymmetricPair<CCTerm>(path[0], path[path.length - 1]);
            pathMap.put(pathEnds, indexedPath);
        }
        return pathMap;
    }

    private HashMap<IndexedPath, ProofInfo> makePathProofMap() {
        HashMap<IndexedPath, ProofInfo> proofMap = new HashMap<IndexedPath, ProofInfo>();
        for (int p = 0; p < this.mIndexedPaths.length; ++p) {
            IndexedPath indexedPath = this.mIndexedPaths[p];
            ProofInfo pathInfo = new ProofInfo();
            pathInfo.collectProofInfoOnePath(indexedPath);
            proofMap.put(indexedPath, pathInfo);
        }
        return proofMap;
    }

    private LinkedHashSet<IndexedPath> findMainPaths() {
        IndexedPath firstSubPath;
        LinkedHashSet<IndexedPath> mainPaths = new LinkedHashSet<IndexedPath>();
        IndexedPath indexedPath = firstSubPath = this.mIndexedPaths[0].getIndex() == null ? this.mIndexedPaths[0] : null;
        if (firstSubPath != null) {
            mainPaths.add(firstSubPath);
        }
        for (int i = 0; i < this.mIndexedPaths.length; ++i) {
            if (this.mIndexedPaths[i].getIndex() == null) continue;
            mainPaths.add(this.mIndexedPaths[i]);
        }
        return mainPaths;
    }

    private HashMap<SymmetricPair<CCTerm>, ProofInfo> buildProofGraph(SymmetricPair<CCTerm> mainDiseq, LinkedHashSet<IndexedPath> mainPaths) {
        HashMap<SymmetricPair<CCTerm>, ProofInfo> proofGraph = new HashMap<SymmetricPair<CCTerm>, ProofInfo>();
        ArrayDeque<Map.Entry<SymmetricPair<CCTerm>, LinkedHashSet<SymmetricPair<CCTerm>>>> todoBuild = new ArrayDeque<Map.Entry<SymmetricPair<CCTerm>, LinkedHashSet<SymmetricPair<CCTerm>>>>();
        ProofInfo mainInfo = new ProofInfo();
        mainInfo.collectProofInfoDiseq(mainDiseq, mainPaths);
        proofGraph.put(mainDiseq, mainInfo);
        if (!mainInfo.getSubProofs().isEmpty()) {
            todoBuild.addAll(mainInfo.getSubProofs().entrySet());
        }
        while (!todoBuild.isEmpty()) {
            Map.Entry auxLemma = (Map.Entry)todoBuild.removeLast();
            SymmetricPair auxDiseq = (SymmetricPair)auxLemma.getKey();
            if (this.isEqualityLiteral(auxDiseq) || proofGraph.containsKey(auxDiseq)) continue;
            LinkedHashSet<IndexedPath> paths = new LinkedHashSet<IndexedPath>();
            for (SymmetricPair auxLemmaPath : (LinkedHashSet)auxLemma.getValue()) {
                if (this.mSubPathMap.containsKey(auxLemmaPath)) {
                    paths.add(this.mSubPathMap.get(auxLemmaPath));
                    continue;
                }
                CCTerm[] auxLemmaPathArray = new CCTerm[]{(CCTerm)auxLemmaPath.getFirst(), (CCTerm)auxLemmaPath.getSecond()};
                paths.add(new IndexedPath(null, auxLemmaPathArray));
            }
            ProofInfo proofInfo = new ProofInfo();
            proofInfo.collectProofInfoDiseq(auxDiseq, paths);
            proofGraph.put(auxDiseq, proofInfo);
            if (proofInfo.getSubProofs().isEmpty()) continue;
            todoBuild.addAll(proofInfo.getSubProofs().entrySet());
        }
        this.determineAllNumParents(proofGraph);
        this.mergeSingleDependencies(proofGraph, mainDiseq);
        this.determineAllNumParents(proofGraph);
        return proofGraph;
    }

    private void determineAllNumParents(HashMap<SymmetricPair<CCTerm>, ProofInfo> proofGraph) {
        for (Map.Entry<SymmetricPair<CCTerm>, ProofInfo> proofNode : proofGraph.entrySet()) {
            proofNode.getValue().resetNumParents();
        }
        for (Map.Entry<SymmetricPair<CCTerm>, ProofInfo> proofNode : proofGraph.entrySet()) {
            ProofInfo proofInfo = proofNode.getValue();
            for (SymmetricPair child : proofInfo.mSubProofs.keySet()) {
                proofGraph.get(child).increaseNumParents();
            }
        }
    }

    private void mergeSingleDependencies(HashMap<SymmetricPair<CCTerm>, ProofInfo> proofGraph, SymmetricPair<CCTerm> mainDiseq) {
        ArrayDeque<SymmetricPair<CCTerm>> todoMerge = new ArrayDeque<SymmetricPair<CCTerm>>();
        if (!proofGraph.get(mainDiseq).getSubProofs().isEmpty()) {
            todoMerge.addAll(proofGraph.get(mainDiseq).getSubProofs().keySet());
        }
        while (!todoMerge.isEmpty()) {
            boolean merge = false;
            SymmetricPair parentNode = (SymmetricPair)todoMerge.removeFirst();
            if (proofGraph.get(parentNode).getSubProofs().isEmpty()) continue;
            HashSet<SymmetricPair<CCTerm>> children = new HashSet<SymmetricPair<CCTerm>>();
            children.addAll(proofGraph.get(parentNode).getSubProofs().keySet());
            for (SymmetricPair symmetricPair : children) {
                if (proofGraph.get(symmetricPair).getNumParents() != 1 || parentNode.equals(mainDiseq)) continue;
                if (!proofGraph.get(symmetricPair).getSubProofs().isEmpty()) {
                    merge = true;
                }
                proofGraph.get(parentNode).mergeProofInfo(proofGraph.get(symmetricPair));
                proofGraph.remove(symmetricPair);
            }
            if (merge) {
                todoMerge.add(parentNode);
                this.determineAllNumParents(proofGraph);
                continue;
            }
            todoMerge.addAll(proofGraph.get(parentNode).getSubProofs().keySet());
        }
    }

    private ArrayList<SymmetricPair<CCTerm>> determineProofOrder(SymmetricPair<CCTerm> mainDiseq, HashMap<SymmetricPair<CCTerm>, ProofInfo> proofGraph) {
        ArrayList<SymmetricPair<CCTerm>> proofOrder = new ArrayList<SymmetricPair<CCTerm>>();
        ArrayDeque<SymmetricPair<CCTerm>> todo = new ArrayDeque<SymmetricPair<CCTerm>>();
        todo.add(mainDiseq);
        while (!todo.isEmpty()) {
            SymmetricPair node = (SymmetricPair)todo.removeFirst();
            ProofInfo nodeInfo = proofGraph.get(node);
            proofOrder.add(node);
            if (nodeInfo.getSubProofs().isEmpty()) continue;
            for (SymmetricPair<CCTerm> child : nodeInfo.getSubProofs().keySet()) {
                proofGraph.get(child).increaseVisitedParentsCounter();
                if (!proofGraph.get(child).haveVisitedAllParents() || todo.contains(child)) continue;
                todo.add(child);
            }
        }
        return proofOrder;
    }

    private Term buildProofTerm(Clause clause, Theory theory, ArrayList<SymmetricPair<CCTerm>> proofOrder, HashMap<SymmetricPair<CCTerm>, ProofInfo> proofGraph) {
        HashMap<SymmetricPair<CCTerm>, Term> auxLiterals = new HashMap<SymmetricPair<CCTerm>, Term>();
        Term[] allLemmas = new Term[proofOrder.size()];
        for (int lemmaNo = 0; lemmaNo < proofOrder.size(); ++lemmaNo) {
            Term diseq;
            ProofInfo info = proofGraph.get(proofOrder.get(lemmaNo));
            if (lemmaNo == 0) {
                diseq = this.mDiseq.getSMTFormula(theory);
            } else if (auxLiterals.containsKey(info.getDiseq())) {
                diseq = (Term)auxLiterals.get(info.getDiseq());
            } else {
                SymmetricPair<CCTerm> diseqPair = info.getDiseq();
                diseq = Coercion.buildEq(diseqPair.getFirst().toSMTTerm(theory), diseqPair.getSecond().toSMTTerm(theory));
                auxLiterals.put(diseqPair, diseq);
            }
            Term[] args = new Term[info.getLiterals().size() + 1];
            Annotation[] quote = new Annotation[]{new Annotation(":quoted", null)};
            int i = 0;
            args[i++] = theory.annotatedTerm(quote, diseq);
            for (Map.Entry<SymmetricPair<CCTerm>, Literal> entry : info.getLiterals().entrySet()) {
                Term arg = null;
                if (entry.getValue() != null) {
                    arg = entry.getValue().getAtom().getSMTFormula(theory);
                    arg = theory.annotatedTerm(quote, arg);
                    if (entry.getValue().getSign() < 0) {
                        arg = theory.not(arg);
                    }
                } else if (auxLiterals.containsKey(entry.getKey())) {
                    arg = theory.annotatedTerm(quote, (Term)auxLiterals.get(entry.getKey()));
                    arg = theory.not(arg);
                } else {
                    Term lhs = entry.getKey().getFirst().toSMTTerm(theory);
                    Term rhs = entry.getKey().getSecond().toSMTTerm(theory);
                    arg = Coercion.buildEq(lhs, rhs);
                    auxLiterals.put(entry.getKey(), arg);
                    arg = theory.annotatedTerm(quote, arg);
                    arg = theory.not(arg);
                }
                args[i++] = arg;
            }
            Term base = theory.or(args);
            String rule = lemmaNo == 0 ? this.mRule.getKind() : ":CC";
            LinkedHashSet<IndexedPath> paths = info.getPaths();
            Object[] subannots = new Object[2 * paths.size() + 1];
            int k = 0;
            subannots[k++] = diseq;
            for (IndexedPath p : paths) {
                CCTerm index = p.getIndex();
                CCTerm[] path = p.getPath();
                Term[] subs = new Term[path.length];
                for (int j = 0; j < path.length; ++j) {
                    subs[j] = path[j].toSMTTerm(theory);
                }
                if (index == null) {
                    subannots[k++] = ":subpath";
                    subannots[k++] = subs;
                    continue;
                }
                subannots[k++] = ":weakpath";
                subannots[k++] = new Object[]{index.toSMTTerm(theory), subs};
            }
            Annotation[] annots = new Annotation[]{new Annotation(rule, subannots)};
            Term lemma = theory.term("@lemma", theory.annotatedTerm(annots, base));
            if (lemmaNo != 0) {
                Term pivot = theory.annotatedTerm(quote, diseq);
                lemma = theory.annotatedTerm(new Annotation[]{new Annotation(":pivot", pivot)}, lemma);
            }
            allLemmas[lemmaNo] = lemma;
        }
        if (allLemmas.length > 1) {
            return theory.term("@res", allLemmas);
        }
        return allLemmas[0];
    }

    private boolean isEqualityLiteral(SymmetricPair<CCTerm> termPair) {
        return this.mEqualityLiterals.containsKey(termPair) && this.mEqualityLiterals.get(termPair).getSign() < 0;
    }

    private boolean isDisequalityLiteral(SymmetricPair<CCTerm> termPair) {
        return this.mEqualityLiterals.containsKey(termPair) && this.mEqualityLiterals.get(termPair).getSign() > 0;
    }

    private boolean isStoreTerm(CCTerm term) {
        return term instanceof CCAppTerm && ((CCAppTerm)term).getFunc() instanceof CCAppTerm && ((CCAppTerm)((CCAppTerm)term).getFunc()).getFunc() instanceof CCAppTerm && ((CCAppTerm)((CCAppTerm)((CCAppTerm)term).getFunc()).getFunc()).getFunc().toString().contains("store");
    }

    private boolean isSelectTerm(CCTerm term) {
        return term instanceof CCAppTerm && ((CCAppTerm)term).getFunc() instanceof CCAppTerm && ((CCAppTerm)((CCAppTerm)term).getFunc()).getFunc().toString().contains("select");
    }

    private LinkedHashSet<SymmetricPair<CCTerm>> findCongruencePaths(CCTerm firstTerm, CCTerm secondTerm) {
        LinkedHashSet<SymmetricPair<CCTerm>> ccPaths = new LinkedHashSet<SymmetricPair<CCTerm>>();
        if (!(firstTerm instanceof CCAppTerm) || !(secondTerm instanceof CCAppTerm)) {
            return null;
        }
        CCTerm first = firstTerm;
        CCTerm second = secondTerm;
        while (first instanceof CCAppTerm && second instanceof CCAppTerm) {
            CCTerm firstArg = ((CCAppTerm)first).getArg();
            CCTerm secondArg = ((CCAppTerm)second).getArg();
            SymmetricPair<CCTerm> argPair = new SymmetricPair<CCTerm>(firstArg, secondArg);
            boolean existsArgPath = false;
            if (firstArg == secondArg) {
                existsArgPath = true;
            } else if (this.isEqualityLiteral(argPair)) {
                existsArgPath = true;
                ccPaths.add(argPair);
            } else if (this.mSubPathMap.containsKey(argPair)) {
                existsArgPath = true;
                ccPaths.add(argPair);
            }
            if (!existsArgPath) {
                return null;
            }
            first = ((CCAppTerm)first).getFunc();
            second = ((CCAppTerm)second).getFunc();
        }
        return ccPaths;
    }

    private ArrayList<SymmetricPair<CCTerm>> findSelectPath(SymmetricPair<CCTerm> termPair, CCTerm weakpathindex) {
        ArrayList<SymmetricPair<CCTerm>> selectAndIndexPaths = new ArrayList<SymmetricPair<CCTerm>>();
        for (SymmetricPair<CCTerm> tryPath : this.mSubPathMap.keySet()) {
            CCTerm endArray;
            CCTerm startArray;
            SymmetricPair<CCTerm> arrayPair;
            boolean needFirstIndexPath = true;
            boolean needSecondIndexPath = true;
            SymmetricPair<CCTerm> firstIndexPath = null;
            SymmetricPair<CCTerm> secondIndexPath = null;
            CCTerm start = tryPath.getFirst();
            CCTerm end = tryPath.getSecond();
            if (!this.isSelectTerm(start) || !this.isSelectTerm(end) || !termPair.equals(arrayPair = new SymmetricPair<CCTerm>(startArray = ArrayTheory.getArrayFromSelect((CCAppTerm)start), endArray = ArrayTheory.getArrayFromSelect((CCAppTerm)end)))) continue;
            CCTerm startIndex = ArrayTheory.getIndexFromSelect((CCAppTerm)start);
            CCTerm endIndex = ArrayTheory.getIndexFromSelect((CCAppTerm)end);
            if (startIndex == weakpathindex) {
                needFirstIndexPath = false;
            }
            if (endIndex == weakpathindex) {
                needSecondIndexPath = false;
            }
            SymmetricPair<CCTerm> firstIndexPair = new SymmetricPair<CCTerm>(weakpathindex, startIndex);
            SymmetricPair<CCTerm> secondIndexPair = new SymmetricPair<CCTerm>(weakpathindex, endIndex);
            if (needFirstIndexPath) {
                if (this.isEqualityLiteral(firstIndexPair)) {
                    firstIndexPath = firstIndexPair;
                    needFirstIndexPath = false;
                } else if (this.mSubPathMap.containsKey(firstIndexPair)) {
                    firstIndexPath = firstIndexPair;
                    needFirstIndexPath = false;
                }
            }
            if (needSecondIndexPath) {
                if (this.isEqualityLiteral(secondIndexPair)) {
                    secondIndexPath = secondIndexPair;
                    needSecondIndexPath = false;
                } else if (this.mSubPathMap.containsKey(secondIndexPair)) {
                    secondIndexPath = secondIndexPair;
                    needSecondIndexPath = false;
                }
            }
            if (needFirstIndexPath || needSecondIndexPath) continue;
            selectAndIndexPaths.add(tryPath);
            if (firstIndexPath != null) {
                selectAndIndexPaths.add(firstIndexPath);
            }
            if (secondIndexPath != null) {
                selectAndIndexPaths.add(secondIndexPath);
            }
            return selectAndIndexPaths;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProofInfo {
        private SymmetricPair<CCTerm> mLemmaDiseq = null;
        private final HashMap<SymmetricPair<CCTerm>, Literal> mProofLiterals = new HashMap();
        private LinkedHashSet<IndexedPath> mProofPaths = new LinkedHashSet();
        private final HashMap<SymmetricPair<CCTerm>, LinkedHashSet<SymmetricPair<CCTerm>>> mSubProofs = new HashMap();
        private int mNumParents = 0;
        private int mNumVisitedParents = 0;

        public SymmetricPair<CCTerm> getDiseq() {
            return this.mLemmaDiseq;
        }

        public HashMap<SymmetricPair<CCTerm>, Literal> getLiterals() {
            return this.mProofLiterals;
        }

        public LinkedHashSet<IndexedPath> getPaths() {
            return this.mProofPaths;
        }

        public HashMap<SymmetricPair<CCTerm>, LinkedHashSet<SymmetricPair<CCTerm>>> getSubProofs() {
            return this.mSubProofs;
        }

        public int getNumParents() {
            return this.mNumParents;
        }

        public void resetNumParents() {
            this.mNumParents = 0;
        }

        public void increaseNumParents() {
            ++this.mNumParents;
        }

        public void increaseVisitedParentsCounter() {
            ++this.mNumVisitedParents;
        }

        public boolean haveVisitedAllParents() {
            return this.mNumParents == this.mNumVisitedParents;
        }

        private void collectProofInfoDiseq(SymmetricPair<CCTerm> diseq, LinkedHashSet<IndexedPath> paths) {
            this.mLemmaDiseq = diseq;
            this.mProofPaths = paths;
            for (IndexedPath indexedPath : paths) {
                ProofInfo pathInfo = (ProofInfo)ArrayAnnotation.this.mPathProofMap.get(indexedPath);
                if (pathInfo == null) continue;
                this.mProofLiterals.putAll(pathInfo.getLiterals());
                this.mSubProofs.putAll(pathInfo.getSubProofs());
            }
            this.mProofLiterals.remove(diseq);
            this.mSubProofs.remove(diseq);
        }

        private void collectProofInfoOnePath(IndexedPath indexedPath) {
            CCTerm pathIndex = indexedPath.getIndex();
            CCTerm[] path = indexedPath.getPath();
            for (int i = 0; i < path.length - 1; ++i) {
                LinkedHashSet ccArgPaths;
                CCTerm firstTerm = path[i];
                CCTerm secondTerm = path[i + 1];
                SymmetricPair<CCTerm> termPair = new SymmetricPair<CCTerm>(firstTerm, secondTerm);
                if (ArrayAnnotation.this.isEqualityLiteral(termPair)) {
                    this.mProofLiterals.put(termPair, (Literal)ArrayAnnotation.this.mEqualityLiterals.get(termPair));
                    continue;
                }
                CCTerm storeTerm = null;
                if (ArrayAnnotation.this.isStoreTerm(firstTerm) && ArrayTheory.getArrayFromStore((CCAppTerm)firstTerm) == secondTerm) {
                    storeTerm = firstTerm;
                } else if (ArrayAnnotation.this.isStoreTerm(secondTerm) && ArrayTheory.getArrayFromStore((CCAppTerm)secondTerm) == firstTerm) {
                    storeTerm = secondTerm;
                }
                if (storeTerm != null) {
                    if (pathIndex == null) continue;
                    CCTerm storeIndex = ArrayTheory.getIndexFromStore((CCAppTerm)storeTerm);
                    SymmetricPair<CCTerm> indexPair = new SymmetricPair<CCTerm>(pathIndex, storeIndex);
                    if (ArrayAnnotation.this.isDisequalityLiteral(indexPair)) {
                        this.mProofLiterals.put(indexPair, (Literal)ArrayAnnotation.this.mEqualityLiterals.get(indexPair));
                        continue;
                    }
                }
                if ((ccArgPaths = ArrayAnnotation.this.findCongruencePaths(firstTerm, secondTerm)) != null) {
                    LinkedHashSet<SymmetricPair<CCTerm>> ccPaths = new LinkedHashSet<SymmetricPair<CCTerm>>();
                    ccPaths.add(termPair);
                    ccPaths.addAll(ccArgPaths);
                    this.mProofLiterals.put(termPair, (Literal)ArrayAnnotation.this.mEqualityLiterals.get(termPair));
                    this.mSubProofs.put(termPair, ccPaths);
                    continue;
                }
                ArrayList selectAndIndexPaths = ArrayAnnotation.this.findSelectPath(termPair, pathIndex);
                if (selectAndIndexPaths != null) {
                    LinkedHashSet proofPaths = new LinkedHashSet();
                    proofPaths.addAll(selectAndIndexPaths);
                    SymmetricPair selectPath = (SymmetricPair)selectAndIndexPaths.get(0);
                    if (!ArrayAnnotation.this.isEqualityLiteral(selectPath)) {
                        this.mSubProofs.put(selectPath, proofPaths);
                    }
                    if (proofPaths.size() > 1) {
                        for (int j = 1; j < proofPaths.size(); ++j) {
                            SymmetricPair indexPair = (SymmetricPair)selectAndIndexPaths.get(j);
                            LinkedHashSet argPaths = ArrayAnnotation.this.findCongruencePaths((CCTerm)indexPair.getFirst(), (CCTerm)indexPair.getSecond());
                            if (argPaths == null) continue;
                            LinkedHashSet<SymmetricPair> ccPaths = new LinkedHashSet<SymmetricPair>();
                            ccPaths.add(indexPair);
                            ccPaths.addAll(argPaths);
                            this.mSubProofs.put(indexPair, ccPaths);
                        }
                    }
                    for (SymmetricPair proofPath : proofPaths) {
                        this.mProofLiterals.put(proofPath, (Literal)ArrayAnnotation.this.mEqualityLiterals.get(proofPath));
                    }
                    continue;
                }
                throw new IllegalArgumentException("Cannot explain term pair " + termPair.toString());
            }
        }

        private void mergeProofInfo(ProofInfo otherProof) {
            SymmetricPair<CCTerm> otherDiseq = otherProof.getDiseq();
            if (!ArrayAnnotation.this.mEqualityLiterals.containsKey(otherDiseq)) {
                this.mProofLiterals.remove(otherDiseq);
            }
            this.mProofLiterals.putAll(otherProof.getLiterals());
            this.mProofPaths.removeAll(otherProof.getPaths());
            for (IndexedPath otherProofPath : otherProof.getPaths()) {
                if (!ArrayAnnotation.this.mSubPathMap.containsValue(otherProofPath)) continue;
                this.mProofPaths.add(otherProofPath);
            }
            this.mSubProofs.putAll(otherProof.getSubProofs());
            this.mSubProofs.remove(otherDiseq);
        }
    }

    public class IndexedPath {
        private final CCTerm mIndex;
        private final CCTerm[] mPath;

        public IndexedPath(CCTerm index, CCTerm[] path) {
            this.mIndex = index;
            this.mPath = path;
        }

        public CCTerm getIndex() {
            return this.mIndex;
        }

        public CCTerm[] getPath() {
            return this.mPath;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RuleKind {
        READ_OVER_WEAKEQ(":read-over-weakeq"),
        WEAKEQ_EXT(":weakeq-ext");

        String mKind;

        private RuleKind(String kind) {
            this.mKind = kind;
        }

        public String getKind() {
            return this.mKind;
        }
    }
}

