/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Assignments;
import de.uni_freiburg.informatik.ultimate.logic.CheckClosedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbolFactory;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.NoopScript;
import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.ReasonUnknown;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.logic.simplification.SimplifyDDA;
import de.uni_freiburg.informatik.ultimate.smtinterpol.DefaultLogger;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.Main;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Clausifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLEngine;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.Interpolator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.SymbolChecker;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.SymbolCollector;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.Model;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.OptionMap;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.SolverOptions;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofChecker;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofTermGenerator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.UnsatCoreCollector;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.Div0Remover;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.TerminationRequest;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedArrayList;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMTInterpol
extends NoopScript {
    private final OptionMap mOptions;
    private final SolverOptions mSolverOptions;
    private DPLLEngine mEngine;
    private Clausifier mClausifier;
    private ScopedArrayList<Term> mAssertions;
    private final TimeoutHandler mCancel;
    private final LogProxy mLogger;
    Model mModel = null;
    private static final Object NAME = new QuotedObject("SMTInterpol");
    private static final Object AUTHORS = new QuotedObject("Juergen Christ, Jochen Hoenicke, Alexander Nutz, and Tanja Schindler");
    private static final Object INTERPOLATION_METHOD = new QuotedObject("tree");
    private Script.LBool mStatus = Script.LBool.SAT;
    private String mStatusSet = null;
    private ReasonUnknown mReasonUnknown = null;
    private boolean mAssertionStackModified = true;
    private int mBy0Seen = -1;
    private long mNextQuickCheck = 1L;
    private long mNumAsserts = 0L;
    private final boolean mDDFriendly = System.getProperty("smtinterpol.ddfriendly") != null;

    public SMTInterpol() {
        this((LogProxy)new DefaultLogger(), null);
    }

    public SMTInterpol(LogProxy logger) {
        this(logger, null);
    }

    @Deprecated
    public SMTInterpol(LogProxy logger, boolean ignored) {
        this(logger, null);
    }

    public SMTInterpol(TerminationRequest cancel) {
        this((LogProxy)new DefaultLogger(), cancel);
    }

    public SMTInterpol(LogProxy logger, TerminationRequest cancel) {
        this(cancel, new OptionMap(logger));
    }

    public SMTInterpol(OptionMap options) {
        this(null, options);
    }

    public SMTInterpol(TerminationRequest cancel, OptionMap options) {
        this.mLogger = options.getLogProxy();
        this.mOptions = options;
        this.mSolverOptions = options.getSolverOptions();
        this.mCancel = new TimeoutHandler(cancel);
        this.reset();
    }

    @Deprecated
    public SMTInterpol(LogProxy logger, boolean ignored, TerminationRequest cancel) {
        this(logger, cancel);
    }

    public SMTInterpol(SMTInterpol other, Map<String, Object> options, OptionMap.CopyMode mode) {
        super(other.getTheory());
        this.mLogger = other.mLogger;
        this.mOptions = other.mOptions.copy(mode);
        this.mSolverOptions = this.mOptions.getSolverOptions();
        if (options != null) {
            for (Map.Entry<String, Object> me : options.entrySet()) {
                this.setOption(me.getKey(), me.getValue());
            }
        }
        this.mCancel = other.mCancel;
        this.setupClausifier(this.getTheory().getLogic());
    }

    @Override
    public final void reset() {
        super.reset();
        this.mEngine = null;
        this.mModel = null;
        this.mAssertionStackModified = true;
        if (this.mAssertions != null) {
            this.mAssertions.clear();
        }
        this.mOptions.reset();
    }

    @Override
    public final void resetAssertions() {
        super.resetAssertions();
        this.mAssertionStackModified = true;
        if (this.mAssertions != null) {
            this.mAssertions.clear();
        }
        this.setupClausifier(this.mEngine.getSMTTheory().getLogic());
    }

    @Override
    public void push(int n) throws SMTLIBException {
        super.push(n);
        this.modifyAssertionStack();
        while (n-- > 0) {
            if (this.mAssertions != null) {
                this.mAssertions.beginScope();
            }
            this.mClausifier.push();
        }
    }

    @Override
    public void pop(int n) throws SMTLIBException {
        try {
            super.pop(n);
        }
        catch (SMTLIBException eBug) {
            if (this.mDDFriendly) {
                System.exit(123);
            }
            throw eBug;
        }
        this.modifyAssertionStack();
        int i = n;
        while (i-- > 0) {
            if (this.mAssertions == null) continue;
            this.mAssertions.endScope();
        }
        this.mClausifier.pop(n);
        if (this.mStackLevel < this.mBy0Seen) {
            this.mBy0Seen = -1;
        }
    }

    @Override
    public Script.LBool checkSat() throws SMTLIBException {
        return this.checkSatAssuming(new Term[0]);
    }

    @Override
    public Script.LBool checkSatAssuming(Term ... assumptions) throws SMTLIBException {
        long timeout;
        if (this.mEngine == null) {
            throw new SMTLIBException("No logic set!");
        }
        this.mModel = null;
        this.mAssertionStackModified = false;
        this.mEngine.clearAssumptions();
        if (assumptions != null && assumptions.length != 0) {
            for (Term ass : assumptions) {
                if (!(ass instanceof ApplicationTerm)) {
                    throw new SMTLIBException("Assumption is not a boolean constant");
                }
                ApplicationTerm at = (ApplicationTerm)ass;
                if (at.getSort() != this.getTheory().getBooleanSort()) {
                    throw new SMTLIBException("Assumption is not a boolean constant");
                }
                if (at.getParameters().length <= 1 && (at.getParameters().length != 1 || at.getFunction().getName().equals("not"))) continue;
                throw new SMTLIBException("Assumption is not a boolean constant");
            }
            if (!this.mEngine.quickCheck()) {
                return Script.LBool.UNSAT;
            }
            Literal[] assumptionlits = new Literal[assumptions.length];
            for (int i = 0; i < assumptions.length; ++i) {
                assumptionlits[i] = this.mClausifier.getCreateLiteral(assumptions[i]);
            }
            this.mEngine.assume(assumptionlits);
        }
        if ((timeout = this.mSolverOptions.getTimeout()) > 0L) {
            this.mCancel.setTimeout(timeout);
        }
        Script.LBool result = Script.LBool.UNKNOWN;
        this.mReasonUnknown = ReasonUnknown.INCOMPLETE;
        this.mEngine.setRandomSeed(this.mSolverOptions.getRandomSeed());
        if (this.mSolverOptions.getCheckType().check(this.mEngine)) {
            if (this.mEngine.hasModel()) {
                result = Script.LBool.SAT;
                if (this.mSolverOptions.isModelCheckModeActive()) {
                    this.mModel = new Model(this.mClausifier, this.getTheory(), this.mSolverOptions.isModelsPartial());
                    if (this.mDDFriendly && !this.mModel.checkTypeValues(this.mLogger)) {
                        System.exit(1);
                    }
                    for (Term asserted : this.mAssertions) {
                        Term checkedResult = this.mModel.evaluate(asserted);
                        if (checkedResult == this.getTheory().mTrue) continue;
                        if (this.mDDFriendly) {
                            System.exit(1);
                        }
                        this.mLogger.fatal("Model does not satisfy " + asserted.toStringDirect());
                    }
                }
            } else {
                result = Script.LBool.UNKNOWN;
                switch (this.mEngine.getCompleteness()) {
                    case 0: {
                        if (this.mSolverOptions.getCheckType() == CheckType.FULL) {
                            throw new InternalError("Complete but no model?");
                        }
                        this.mReasonUnknown = ReasonUnknown.INCOMPLETE;
                        break;
                    }
                    case 3: {
                        this.mReasonUnknown = ReasonUnknown.MEMOUT;
                        break;
                    }
                    case 5: {
                        this.mReasonUnknown = ReasonUnknown.TIMEOUT;
                        break;
                    }
                    case 1: 
                    case 2: {
                        this.mReasonUnknown = ReasonUnknown.INCOMPLETE;
                        break;
                    }
                    case 4: {
                        this.mReasonUnknown = ReasonUnknown.CRASHED;
                        break;
                    }
                    case 6: {
                        this.mReasonUnknown = ReasonUnknown.INCOMPLETE;
                        break;
                    }
                    case 7: {
                        this.mReasonUnknown = ReasonUnknown.CANCELLED;
                        break;
                    }
                    default: {
                        throw new InternalError("Unknown incompleteness reason");
                    }
                }
                this.mLogger.info("Got %s as reason to return unknown", this.mEngine.getCompletenessReason());
            }
        } else {
            ProofChecker proofchecker;
            result = Script.LBool.UNSAT;
            if (this.mSolverOptions.isProofCheckModeActive() && !(proofchecker = new ProofChecker(this, this.getLogger())).check(this.getProof())) {
                if (this.mDDFriendly) {
                    System.exit(2);
                }
                this.mLogger.fatal("Proof-checker did not verify");
            }
        }
        this.mStatus = result;
        if (this.isStatusSet() && this.mReasonUnknown != ReasonUnknown.MEMOUT && !this.mStatus.toString().equals(this.mStatusSet)) {
            this.mLogger.warn("Status differs: User said %s but we got %s", new Object[]{this.mStatusSet, this.mStatus});
            if (this.mDDFriendly) {
                System.exit(13);
            }
        }
        this.mStatusSet = null;
        this.mCancel.clearTimeout();
        return result;
    }

    private final boolean isStatusSet() {
        return this.mStatusSet != null && !this.mStatusSet.equals("unknown");
    }

    @Override
    public void setLogic(String logic) throws UnsupportedOperationException, SMTLIBException {
        try {
            this.setLogic(Logics.valueOf(logic));
        }
        catch (IllegalArgumentException ex) {
            throw new UnsupportedOperationException("Logic " + logic + " not supported");
        }
    }

    @Override
    public void setLogic(Logics logic) throws UnsupportedOperationException, SMTLIBException {
        this.mSolverSetup = new SMTInterpolSetup(this.getProofMode());
        super.setLogic(logic);
        this.setupClausifier(logic);
    }

    private void setupClausifier(Logics logic) {
        try {
            int proofMode = this.getProofMode();
            this.mEngine = new DPLLEngine(this.getTheory(), this.mLogger, this.mCancel);
            this.mClausifier = new Clausifier(this.mEngine, proofMode);
            this.mEngine.setProofGeneration(proofMode > 0);
            this.mClausifier.setLogic(logic);
            boolean produceAssignment = this.getBooleanOption(":produce-assignments");
            this.mClausifier.setAssignmentProduction(produceAssignment);
            this.mEngine.setProduceAssignments(produceAssignment);
            this.mEngine.setRandomSeed(this.mSolverOptions.getRandomSeed());
            if (this.getBooleanOption(":interactive-mode") || this.mSolverOptions.isInterpolantCheckModeActive() || this.mSolverOptions.isModelCheckModeActive() || this.getBooleanOption(":unsat-core-check-mode") || this.getBooleanOption(":unsat-assumptions-check-mode")) {
                this.mAssertions = new ScopedArrayList();
            }
            this.mOptions.setOnline();
            this.mEngine.getSMTTheory().setGlobalSymbols((Boolean)this.mOptions.get(":global-declarations"));
        }
        catch (UnsupportedOperationException eLogicUnsupported) {
            super.reset();
            this.mEngine = null;
            this.mClausifier = null;
            throw eLogicUnsupported;
        }
    }

    @Override
    public Script.LBool assertTerm(Term term) throws SMTLIBException {
        if (this.mEngine == null) {
            throw new SMTLIBException("No logic set!");
        }
        super.assertTerm(term);
        if (!term.getSort().equals(this.getTheory().getBooleanSort())) {
            if (term.getSort().getTheory() == this.getTheory()) {
                throw new SMTLIBException("Asserted terms must have sort Bool");
            }
            throw new SMTLIBException("Asserted terms created with incompatible theory");
        }
        if (!new CheckClosedTerm().isClosed(term)) {
            throw new SMTLIBException("Asserted terms must be closed");
        }
        if (this.mAssertions != null) {
            this.mAssertions.add(term);
        }
        if (this.mEngine.inconsistent()) {
            this.mLogger.info("Asserting into inconsistent context");
            return Script.LBool.UNSAT;
        }
        try {
            this.modifyAssertionStack();
            this.mClausifier.addFormula(term);
            if (this.mClausifier.resetBy0Seen() && this.mBy0Seen == -1) {
                this.mBy0Seen = this.mStackLevel;
            }
            if (this.mNumAsserts++ >= this.mNextQuickCheck) {
                this.mNextQuickCheck *= 2L;
                if (!this.mEngine.quickCheck()) {
                    this.mLogger.info("Assertion made context inconsistent");
                    return Script.LBool.UNSAT;
                }
            }
        }
        catch (UnsupportedOperationException ex) {
            throw new SMTLIBException(ex.getMessage());
        }
        catch (RuntimeException exc) {
            if (this.mDDFriendly) {
                System.exit(7);
            }
            throw exc;
        }
        catch (AssertionError exc) {
            if (this.mDDFriendly) {
                System.exit(7);
            }
            throw exc;
        }
        return Script.LBool.UNKNOWN;
    }

    @Override
    public Term[] getAssertions() throws SMTLIBException {
        if (this.mEngine == null) {
            throw new SMTLIBException("No logic set!");
        }
        if (this.mAssertions != null) {
            return this.mAssertions.toArray(new Term[this.mAssertions.size()]);
        }
        throw new SMTLIBException("Set option :interactive-mode to true to get assertions!");
    }

    @Override
    public Assignments getAssignment() throws SMTLIBException {
        if (this.mEngine == null) {
            throw new SMTLIBException("No logic set!");
        }
        if (!this.mEngine.isProduceAssignments()) {
            throw new SMTLIBException("Set option :produce-assignments to true to generate assignments!");
        }
        this.checkAssertionStackModified();
        return this.mEngine.getAssignments();
    }

    @Override
    public Object getInfo(String info) throws UnsupportedOperationException {
        if (":status".equals(info)) {
            return this.mStatus;
        }
        if (":name".equals(info)) {
            return NAME;
        }
        if (":version".equals(info)) {
            return new QuotedObject(Main.getVersion());
        }
        if (":authors".equals(info)) {
            return AUTHORS;
        }
        if (":all-statistics".equals(info)) {
            return this.mEngine == null ? new Object[]{} : this.mEngine.getStatistics();
        }
        if (":status-set".equals(info)) {
            return this.mStatusSet;
        }
        if (":options".equals(info)) {
            return this.mOptions.getInfo();
        }
        if (":reason-unknown".equals(info)) {
            if (this.mStatus != Script.LBool.UNKNOWN) {
                throw new SMTLIBException("Status not unknown");
            }
            return this.mReasonUnknown;
        }
        if (":assertion-stack-levels".equals(info)) {
            return this.mStackLevel;
        }
        if (":interpolation-method".equals(info)) {
            return INTERPOLATION_METHOD;
        }
        return this.mOptions.getInfo(info);
    }

    @Override
    public Object getOption(String opt) throws UnsupportedOperationException {
        return this.mOptions.get(opt);
    }

    private int getProofMode() {
        if (this.mSolverOptions.isProofCheckModeActive() || this.mSolverOptions.isProduceProofs()) {
            return 2;
        }
        if (this.mSolverOptions.isProduceInterpolants() || this.getBooleanOption(":produce-unsat-cores")) {
            return 1;
        }
        return 0;
    }

    @Override
    public Term getProof() throws SMTLIBException, UnsupportedOperationException {
        if (this.mEngine == null) {
            throw new SMTLIBException("No logic set!");
        }
        int proofMode = this.getProofMode();
        if (proofMode == 0) {
            throw new SMTLIBException("Option :produce-proofs not set to true");
        }
        if (proofMode == 1) {
            this.mLogger.warn("Using partial proofs (cut at CNF-level).  Set option :produce-proofs to true to get complete proofs.");
        }
        this.checkAssertionStackModified();
        Clause unsat = this.retrieveProof();
        try {
            ProofTermGenerator generator = new ProofTermGenerator(this.getTheory());
            Term res = generator.convert(unsat);
            if (this.mBy0Seen != -1) {
                res = new Div0Remover().transform(res);
            }
            return res;
        }
        catch (Exception exc) {
            throw new SMTLIBException(exc.getMessage() == null ? exc.toString() : exc.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Term[] getInterpolants(Term[] partition, int[] startOfSubtree) {
        if (this.mEngine == null) {
            throw new SMTLIBException("No logic set!");
        }
        if (!this.mSolverOptions.isProduceProofs() && !this.mSolverOptions.isProduceInterpolants()) {
            throw new SMTLIBException("Interpolant production not enabled.  Set either :produce-interpolants or :produce-proofs to true");
        }
        long timeout = this.mSolverOptions.getTimeout();
        if (timeout > 0L) {
            this.mCancel.setTimeout(timeout);
        }
        try {
            this.checkAssertionStackModified();
            if (partition.length != startOfSubtree.length) {
                throw new SMTLIBException("Partition table and subtree array need to have equal length");
            }
            for (int i = 0; i < partition.length; ++i) {
                if (startOfSubtree[i] < 0) {
                    throw new SMTLIBException("subtree array must not contain negative element");
                }
                int j = i;
                while (startOfSubtree[i] < j) {
                    j = startOfSubtree[j - 1];
                }
                if (startOfSubtree[i] == j) continue;
                throw new SMTLIBException("malformed subtree array.");
            }
            if (startOfSubtree[partition.length - 1] != 0) {
                throw new SMTLIBException("malformed subtree array.");
            }
            Set[] parts = new Set[partition.length];
            String errormsg = "arguments must be named terms or conjunctions of named terms";
            for (int i = 0; i < partition.length; ++i) {
                Term[] terms;
                if (!(partition[i] instanceof ApplicationTerm)) {
                    throw new SMTLIBException("arguments must be named terms or conjunctions of named terms");
                }
                FunctionSymbol fsym = ((ApplicationTerm)partition[i]).getFunction();
                if (fsym.isIntern()) {
                    if (!fsym.getName().equals("and")) {
                        throw new SMTLIBException("arguments must be named terms or conjunctions of named terms");
                    }
                    terms = ((ApplicationTerm)partition[i]).getParameters();
                } else {
                    terms = new Term[]{partition[i]};
                }
                parts[i] = new HashSet();
                for (int j = 0; j < terms.length; ++j) {
                    if (!(terms[j] instanceof ApplicationTerm)) {
                        throw new SMTLIBException("arguments must be named terms or conjunctions of named terms");
                    }
                    ApplicationTerm appTerm = (ApplicationTerm)terms[j];
                    if (appTerm.getParameters().length != 0) {
                        throw new SMTLIBException("arguments must be named terms or conjunctions of named terms");
                    }
                    if (appTerm.getFunction().isIntern()) {
                        throw new SMTLIBException("arguments must be named terms or conjunctions of named terms");
                    }
                    parts[i].add(appTerm.getFunction().getName().intern());
                }
            }
            SMTInterpol tmpBench = null;
            SymbolCollector collector = null;
            Set<FunctionSymbol> globals = null;
            if (this.mSolverOptions.isInterpolantCheckModeActive()) {
                HashSet usedParts = new HashSet();
                for (Set part : parts) {
                    usedParts.addAll(part);
                }
                tmpBench = new SMTInterpol(this, Collections.singletonMap(":interactive-mode", Boolean.TRUE), OptionMap.CopyMode.CURRENT_VALUE);
                int old = tmpBench.mLogger.getLoglevel();
                try {
                    tmpBench.mLogger.setLoglevel(2);
                    collector = new SymbolCollector();
                    collector.startCollectTheory();
                    block16: for (Term asserted : this.mAssertions) {
                        if (asserted instanceof AnnotatedTerm) {
                            AnnotatedTerm annot = (AnnotatedTerm)asserted;
                            for (Annotation an : annot.getAnnotations()) {
                                if (":named".equals(an.getKey()) && usedParts.contains(an.getValue())) continue block16;
                            }
                        }
                        tmpBench.assertTerm(asserted);
                        collector.addGlobalSymbols(asserted);
                    }
                    globals = collector.getTheorySymbols();
                }
                finally {
                    tmpBench.mLogger.setLoglevel(old);
                }
                usedParts = null;
            }
            Interpolator interpolator = new Interpolator(this.mLogger, this, tmpBench, this.getTheory(), parts, startOfSubtree);
            Clause refutation = this.retrieveProof();
            Term[] ipls = interpolator.getInterpolants(refutation);
            if (this.mBy0Seen != -1) {
                Div0Remover rem = new Div0Remover();
                for (int i = 0; i < ipls.length; ++i) {
                    ipls[i] = rem.transform(ipls[i]);
                }
            }
            if (this.mSolverOptions.isInterpolantCheckModeActive()) {
                boolean error = false;
                int old = tmpBench.mLogger.getLoglevel();
                try {
                    int i;
                    tmpBench.mLogger.setLoglevel(2);
                    Map[] occs = new Map[partition.length];
                    for (i = 0; i < partition.length; ++i) {
                        occs[i] = collector.collect(partition[i]);
                    }
                    for (i = 0; i < startOfSubtree.length; ++i) {
                        int child = i - 1;
                        while (child >= startOfSubtree[i]) {
                            for (Map.Entry entry : occs[child].entrySet()) {
                                Integer ival = (Integer)occs[i].get(entry.getKey());
                                ival = ival == null ? (Integer)entry.getValue() : ival + (Integer)entry.getValue();
                                occs[i].put(entry.getKey(), ival);
                            }
                            child = startOfSubtree[child] - 1;
                        }
                    }
                    SymbolChecker checker = new SymbolChecker(globals);
                    for (int i2 = 0; i2 < startOfSubtree.length; ++i2) {
                        tmpBench.push(1);
                        int child = i2 - 1;
                        while (child >= startOfSubtree[i2]) {
                            tmpBench.assertTerm(ipls[child]);
                            child = startOfSubtree[child] - 1;
                        }
                        tmpBench.assertTerm(partition[i2]);
                        try {
                            if (i2 != ipls.length) {
                                tmpBench.assertTerm(tmpBench.term("not", ipls[i2]));
                            }
                        }
                        catch (SMTLIBException sMTLIBException) {
                            this.mLogger.error("Could not assert interpolant", sMTLIBException);
                            error = true;
                        }
                        Script.LBool lBool = tmpBench.checkSat();
                        if (lBool == Script.LBool.SAT) {
                            if (this.mDDFriendly) {
                                System.exit(2);
                            }
                            this.mLogger.error("Interpolant %d not inductive:  (Check returned %s)", new Object[]{i2, lBool});
                            error = true;
                        } else if (lBool == Script.LBool.UNKNOWN) {
                            ReasonUnknown ru = tmpBench.mReasonUnknown;
                            this.mLogger.warn("Unable to check validity of interpolant: " + (Object)((Object)ru));
                        }
                        tmpBench.pop(1);
                        if (i2 == ipls.length || !checker.check(ipls[i2], occs[i2], occs[ipls.length])) continue;
                        this.mLogger.error("Symbol error in Interpolant %d.  Subtree only symbols: %s.  Non-subtree only symbols: %s.", i2, checker.getLeftErrors(), checker.getRightErrors());
                        error = true;
                    }
                }
                finally {
                    tmpBench.mLogger.setLoglevel(old);
                    tmpBench.exit();
                }
                if (error) {
                    throw new SMTLIBException("generated interpolants did not pass sanity check");
                }
            }
            if (this.mSolverOptions.isSimplifyInterpolants()) {
                SimplifyDDA simplifier = new SimplifyDDA(new SMTInterpol(this, Collections.singletonMap(":check-type", this.mSolverOptions.getSimplifierCheckType()), OptionMap.CopyMode.CURRENT_VALUE), this.getBooleanOption(":simplify-repeatedly"));
                for (int i = 0; i < ipls.length; ++i) {
                    ipls[i] = simplifier.getSimplifiedTerm(ipls[i]);
                }
            }
            Term[] termArray = ipls;
            return termArray;
        }
        finally {
            this.mCancel.clearTimeout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Term[] getUnsatCore() throws SMTLIBException, UnsupportedOperationException {
        if (this.mEngine == null) {
            throw new SMTLIBException("No logic set!");
        }
        if (!this.getBooleanOption(":produce-unsat-cores")) {
            throw new SMTLIBException("Set option :produce-unsat-cores to true before using get-unsat-cores");
        }
        this.checkAssertionStackModified();
        Clause unsat = this.mEngine.getProof();
        if (unsat == null) {
            throw new SMTLIBException("Logical context not inconsistent!");
        }
        Term[] core = new UnsatCoreCollector(this).getUnsatCore(unsat);
        if (this.getBooleanOption(":unsat-core-check-mode")) {
            HashSet<String> usedParts = new HashSet<String>();
            for (Term t : core) {
                usedParts.add(((ApplicationTerm)t).getFunction().getName());
            }
            SMTInterpol tmpBench = new SMTInterpol(this, null, OptionMap.CopyMode.CURRENT_VALUE);
            int old = tmpBench.mLogger.getLoglevel();
            try {
                tmpBench.mLogger.setLoglevel(2);
                block4: for (Term asserted : this.mAssertions) {
                    if (asserted instanceof AnnotatedTerm) {
                        AnnotatedTerm annot = (AnnotatedTerm)asserted;
                        for (Annotation an : annot.getAnnotations()) {
                            if (":named".equals(an.getKey()) && usedParts.contains(an.getValue())) continue block4;
                        }
                    }
                    tmpBench.assertTerm(asserted);
                }
                for (Term t : core) {
                    tmpBench.assertTerm(t);
                }
                Script.LBool isUnsat = tmpBench.checkSat();
                if (isUnsat != Script.LBool.UNSAT) {
                    this.mLogger.error("Unsat core could not be proven unsat (Result is %s)", new Object[]{isUnsat});
                }
            }
            finally {
                tmpBench.mLogger.setLoglevel(old);
                tmpBench.exit();
            }
        }
        return core;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Term[] getUnsatAssumptions() throws SMTLIBException, UnsupportedOperationException {
        if (this.mEngine == null) {
            throw new SMTLIBException("No logic set!");
        }
        if (!this.getBooleanOption(":produce-unsat-assumptions")) {
            throw new SMTLIBException("Set option :produce-unsat-assumptions to true before using get-unsat-assumptions");
        }
        this.checkAssertionStackModified();
        if (!this.mEngine.inconsistent()) {
            throw new SMTLIBException("Logical context not inconsistent!");
        }
        Literal[] unsatAssumptionLits = this.mEngine.getUnsatAssumptions();
        Term[] unsatAssumptions = new Term[unsatAssumptionLits.length];
        Theory t = this.getTheory();
        for (int i = 0; i < unsatAssumptionLits.length; ++i) {
            unsatAssumptions[i] = unsatAssumptionLits[i].negate().getSMTFormula(t);
        }
        if (this.getBooleanOption(":unsat-assumptions-check-mode")) {
            SMTInterpol tmpBench = new SMTInterpol(this, null, OptionMap.CopyMode.CURRENT_VALUE);
            int old = tmpBench.mLogger.getLoglevel();
            try {
                tmpBench.mLogger.setLoglevel(2);
                for (Term asserted : this.mAssertions) {
                    tmpBench.assertTerm(asserted);
                }
                for (Term ass : unsatAssumptions) {
                    tmpBench.assertTerm(ass);
                }
                Script.LBool isUnsat = tmpBench.checkSat();
                if (isUnsat != Script.LBool.UNSAT) {
                    this.mLogger.error("Unsat assumptions could not be proven unsat (Result is %s)", new Object[]{isUnsat});
                }
            }
            finally {
                tmpBench.mLogger.setLoglevel(old);
                tmpBench.exit();
            }
        }
        return unsatAssumptions;
    }

    @Override
    public Map<Term, Term> getValue(Term[] terms) throws SMTLIBException, UnsupportedOperationException {
        if (this.mEngine == null) {
            throw new SMTLIBException("No logic set!");
        }
        this.buildModel();
        return this.mModel.evaluate(terms);
    }

    @Override
    public de.uni_freiburg.informatik.ultimate.logic.Model getModel() throws SMTLIBException, UnsupportedOperationException {
        if (this.mEngine == null) {
            throw new SMTLIBException("No logic set!");
        }
        this.buildModel();
        return this.mModel;
    }

    @Override
    public void setInfo(String info, Object value) {
        if (info.equals(":status") && value instanceof String) {
            if (value.equals("sat")) {
                this.mStatus = Script.LBool.SAT;
                this.mStatusSet = "sat";
            } else if (value.equals("unsat")) {
                this.mStatus = Script.LBool.UNSAT;
                this.mStatusSet = "unsat";
            } else if (value.equals("unknown")) {
                this.mStatus = Script.LBool.UNKNOWN;
                this.mStatusSet = "unknown";
            }
        }
    }

    @Override
    public void setOption(String opt, Object value) throws UnsupportedOperationException, SMTLIBException {
        this.mOptions.set(opt, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Term simplify(Term term) throws SMTLIBException {
        CheckType old = this.mSolverOptions.getCheckType();
        int oldNumScopes = this.mStackLevel;
        try {
            this.mSolverOptions.setCheckType(this.mSolverOptions.getSimplifierCheckType());
            Term term2 = new SimplifyDDA(this, this.getBooleanOption(":simplify-repeatedly")).getSimplifiedTerm(term);
            return term2;
        }
        finally {
            this.mSolverOptions.setCheckType(old);
            assert (this.mStackLevel == oldNumScopes);
        }
    }

    public void flipDecisions() {
        this.mEngine.flipDecisions();
    }

    public void flipNamedLiteral(String name) throws SMTLIBException {
        this.mEngine.flipNamedLiteral(name);
    }

    public Clausifier getClausifier() {
        return this.mClausifier;
    }

    public DPLLEngine getEngine() {
        return this.mEngine;
    }

    public LogProxy getLogger() {
        return this.mLogger;
    }

    protected void setEngine(DPLLEngine engine) {
        this.mEngine = engine;
    }

    protected void setClausifier(Clausifier clausifier) {
        this.mClausifier = clausifier;
    }

    private void checkAssertionStackModified() throws SMTLIBException {
        if (this.mAssertionStackModified) {
            throw new SMTLIBException("Assertion stack has been modified since last check-sat!");
        }
    }

    private void modifyAssertionStack() {
        this.mAssertionStackModified = true;
        this.mModel = null;
        this.mEngine.clearAssumptions();
    }

    private void buildModel() throws SMTLIBException {
        this.checkAssertionStackModified();
        if (this.mEngine.inconsistent()) {
            if (this.mDDFriendly) {
                System.exit(4);
            }
            throw new SMTLIBException("Context is inconsistent");
        }
        if (this.mStatus != Script.LBool.SAT) {
            if (this.mDDFriendly) {
                System.exit(9);
            }
            throw new SMTLIBException("Cannot construct model since solving did not complete");
        }
        if (this.mModel == null) {
            this.mModel = new Model(this.mClausifier, this.getTheory(), this.mSolverOptions.isModelsPartial());
        }
    }

    public Clause retrieveProof() throws SMTLIBException {
        Clause unsat = this.mEngine.getProof();
        if (unsat == null) {
            if (this.mDDFriendly) {
                System.exit(5);
            }
            throw new SMTLIBException("Logical context not inconsistent!");
        }
        Clause proof = this.mSolverOptions.getProofTransformation().transform(unsat);
        return proof;
    }

    public Term[] getSatisfiedLiterals() throws SMTLIBException {
        this.checkAssertionStackModified();
        return this.mEngine.getSatisfiedLiterals();
    }

    private boolean dumpInterpolationBug(int[] startOfSubtree, Term[] partition, Term[] ipls, int num) {
        try {
            FileWriter fw = new FileWriter("iplBug.txt");
            FormulaUnLet unlet = new FormulaUnLet();
            PrintTerm outputter = new PrintTerm();
            int child = num - 1;
            while (child >= startOfSubtree[num]) {
                outputter.append((Appendable)fw, unlet.unlet(ipls[child]));
                child = startOfSubtree[child] - 1;
                fw.append("\nand\n");
            }
            outputter.append((Appendable)fw, ((ApplicationTerm)partition[num]).getFunction().getDefinition());
            fw.append('\n');
            if (num != ipls.length) {
                fw.append("==>\n");
                outputter.append((Appendable)fw, unlet.unlet(ipls[num]));
                fw.append('\n');
            }
            fw.flush();
            fw.close();
            return true;
        }
        catch (IOException eioe) {
            eioe.printStackTrace();
            return false;
        }
    }

    @Override
    public Iterable<Term[]> checkAllsat(final Term[] input) {
        final Literal[] lits = new Literal[input.length];
        for (int i = 0; i < input.length; ++i) {
            if (input[i].getSort() != this.getTheory().getBooleanSort()) {
                throw new SMTLIBException("AllSAT over non-Boolean");
            }
            lits[i] = this.mClausifier.getCreateLiteral(input[i]);
        }
        return new Iterable<Term[]>(){

            @Override
            public Iterator<Term[]> iterator() {
                DPLLEngine dPLLEngine = SMTInterpol.this.mEngine;
                dPLLEngine.getClass();
                return dPLLEngine.new DPLLEngine.AllSatIterator(lits, input);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Term[] findImpliedEquality(Term[] x, Term[] y) throws SMTLIBException, UnsupportedOperationException {
        Term ct;
        Term bt;
        Term at;
        block21: {
            Rational xdiff;
            if (x.length != y.length) {
                throw new SMTLIBException("Different number of x's and y's");
            }
            if (x.length < 2) {
                throw new SMTLIBException("Need at least two elements to find equality");
            }
            for (int i = 0; i < x.length; ++i) {
                if (x[i].getSort().isNumericSort() && y[i].getSort().isNumericSort()) continue;
                throw new SMTLIBException("Only numeric types supported");
            }
            Script.LBool isSat = this.checkSat();
            if (isSat == Script.LBool.UNSAT) {
                throw new SMTLIBException("Context is inconsistent!");
            }
            Term[] terms = new Term[x.length + y.length];
            System.arraycopy(x, 0, terms, 0, x.length);
            System.arraycopy(y, 0, terms, x.length, y.length);
            Map<Term, Term> vals = this.getValue(terms);
            Rational x0 = (Rational)((ConstantTerm)vals.get(x[0])).getValue();
            Rational y0 = (Rational)((ConstantTerm)vals.get(y[0])).getValue();
            Rational x1 = null;
            Rational y1 = null;
            for (int i = 1; i < x.length; ++i) {
                x1 = (Rational)((ConstantTerm)vals.get(x[i])).getValue();
                y1 = (Rational)((ConstantTerm)vals.get(y[i])).getValue();
                if (!x1.equals(x0)) break;
                if (y1.equals(y0)) continue;
                return new Term[0];
            }
            if ((xdiff = x0.sub(x1)).equals(Rational.ZERO)) {
                return new Term[0];
            }
            Rational a = y0.subdiv(y1, xdiff);
            Rational b = Rational.ONE;
            Rational c = y0.mul(x1).subdiv(x0.mul(y1), xdiff);
            Sort s = x[0].getSort();
            if (x[0].getSort().getName().equals("Int") && y[0].getSort().getName().equals("Int")) {
                BigInteger denom;
                if (!a.isIntegral()) {
                    denom = a.denominator();
                    a = a.mul(denom);
                    b = b.mul(denom);
                    c = c.mul(denom);
                }
                if (!c.isIntegral()) {
                    denom = c.denominator();
                    a = a.mul(denom);
                    b = b.mul(denom);
                    c = c.mul(denom);
                }
            } else if (s.getName().equals("Int")) {
                s = this.sort("Real", new Sort[0]);
            }
            at = a.toTerm(s);
            bt = b.toTerm(s);
            ct = c.toTerm(s);
            if (this.mSolverOptions.getCheckType() == CheckType.FULL) {
                Term[] disj = new Term[x.length];
                for (int i = 0; i < x.length; ++i) {
                    disj[i] = this.term("not", this.term("=", this.term("*", at, x[i]), this.term("+", this.term("*", bt, y[i]), ct)));
                }
                try {
                    this.push(1);
                    this.assertTerm(this.term("or", disj));
                    Script.LBool isImplied = this.checkSat();
                    if (isImplied != Script.LBool.UNSAT) {
                        Term[] termArray = new Term[]{};
                        return termArray;
                    }
                    break block21;
                }
                finally {
                    this.pop(1);
                }
            }
            for (int i = 0; i < x.length; ++i) {
                Term neq = this.term("not", this.term("=", this.term("*", at, x[i]), this.term("+", this.term("*", bt, y[i]), ct)));
                try {
                    this.push(1);
                    this.assertTerm(neq);
                    Script.LBool isImplied = this.checkSat();
                    if (isImplied == Script.LBool.UNSAT) continue;
                    Term[] termArray = new Term[]{};
                    return termArray;
                }
                finally {
                    this.pop(1);
                }
            }
        }
        return new Term[]{at, bt, ct};
    }

    @Override
    public void declareFun(String fun, Sort[] paramSorts, Sort resultSort) throws SMTLIBException {
        Sort realSort = resultSort.getRealSort();
        if (realSort.isArraySort() && realSort.getArguments()[0] == this.getTheory().getBooleanSort()) {
            throw new UnsupportedOperationException("SMTInterpol does not support Arrays with Boolean indices");
        }
        super.declareFun(fun, paramSorts, resultSort);
    }

    private final boolean getBooleanOption(String option) {
        return (Boolean)this.mOptions.get(option);
    }

    public boolean isTerminationRequested() {
        return this.mCancel.isTerminationRequested();
    }

    private static class SMTInterpolSetup
    extends Theory.SolverSetup {
        private final int mProofMode;

        public SMTInterpolSetup(int proofMode) {
            this.mProofMode = proofMode;
        }

        public void setLogic(Theory theory, Logics logic) {
            int leftassoc = 2;
            Sort proof = null;
            Sort[] proof2 = null;
            Sort bool = theory.getSort("Bool", new Sort[0]);
            Sort[] bool1 = new Sort[]{bool};
            if (this.mProofMode > 0) {
                this.declareInternalSort(theory, "@Proof", 0, 0);
                proof = theory.getSort("@Proof", new Sort[0]);
                proof2 = new Sort[]{proof, proof};
                this.declareInternalFunction(theory, "@res", proof2, proof, 2);
                this.declareInternalFunction(theory, "@tautology", bool1, proof, 0);
                this.declareInternalFunction(theory, "@lemma", bool1, proof, 0);
                this.declareInternalFunction(theory, "@asserted", bool1, proof, 0);
                this.declareInternalFunction(theory, "@assumption", bool1, proof, 0);
            }
            if (this.mProofMode > 1) {
                this.declareInternalFunction(theory, "@intern", bool1, proof, 0);
                this.declareInternalFunction(theory, "@split", new Sort[]{proof, bool}, proof, 0);
                this.defineFunction(theory, new RewriteProofFactory("@eq", proof));
                this.declareInternalFunction(theory, "@rewrite", bool1, proof, 0);
                this.declareInternalFunction(theory, "@clause", new Sort[]{proof, bool}, proof, 0);
            }
            this.defineFunction(theory, new FunctionSymbolFactory("@undefined"){

                public int getFlags(BigInteger[] indices, Sort[] paramSorts, Sort resultSort) {
                    return 17;
                }

                public Sort getResultSort(BigInteger[] indices, Sort[] paramSorts, Sort resultSort) {
                    if (indices != null || paramSorts.length != 0) {
                        return null;
                    }
                    return resultSort;
                }
            });
            if (logic.isArray()) {
                this.declareArraySymbols(theory);
            }
            if (logic.hasIntegers()) {
                this.declareIntSymbols(theory);
            }
            if (logic.hasReals()) {
                this.declareRealSymbols(theory);
            }
        }

        private final void declareIntSymbols(Theory theory) {
            Sort intSort = theory.getSort("Int", new Sort[0]);
            Sort[] sort1 = new Sort[]{intSort};
            this.declareInternalFunction(theory, "@mod0", sort1, intSort, 0);
            this.declareInternalFunction(theory, "@div0", sort1, intSort, 0);
        }

        private final void declareRealSymbols(Theory theory) {
            Sort realSort = theory.getSort("Real", new Sort[0]);
            Sort[] sort1 = new Sort[]{realSort};
            this.declareInternalFunction(theory, "@/0", sort1, realSort, 0);
        }

        private final void declareArraySymbols(Theory theory) {
            Sort[] vars = theory.createSortVariables("Index", "Elem");
            Sort array = theory.getSort("Array", vars);
            this.declareInternalPolymorphicFunction(theory, "@diff", vars, new Sort[]{array, array}, vars[0], 0);
        }

        private static class RewriteProofFactory
        extends FunctionSymbolFactory {
            Sort mProofSort;

            public RewriteProofFactory(String name, Sort proofSort) {
                super(name);
                this.mProofSort = proofSort;
            }

            public int getFlags(BigInteger[] indices, Sort[] paramSorts, Sort resultSort) {
                return paramSorts.length == 1 ? 1 : 3;
            }

            public Sort getResultSort(BigInteger[] indices, Sort[] paramSorts, Sort resultSort) {
                if (indices != null || paramSorts.length == 0 || paramSorts.length > 2 || resultSort != null || paramSorts[0] != this.mProofSort) {
                    return null;
                }
                if (paramSorts.length == 2 && paramSorts[0] != paramSorts[1]) {
                    return null;
                }
                return paramSorts[0];
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CheckType {
        FULL{

            boolean check(DPLLEngine engine) {
                engine.provideCompleteness(0);
                return engine.solve();
            }
        }
        ,
        PROPAGATION{

            boolean check(DPLLEngine engine) {
                engine.provideCompleteness(6);
                return engine.propagate();
            }
        }
        ,
        QUICK{

            boolean check(DPLLEngine engine) {
                engine.provideCompleteness(6);
                return engine.quickCheck();
            }
        };


        abstract boolean check(DPLLEngine var1);
    }

    private static class TimeoutHandler
    implements TerminationRequest {
        TerminationRequest mStackedCancellation;
        long mTimeout;

        public TimeoutHandler(TerminationRequest stacked) {
            this.mStackedCancellation = stacked;
            this.clearTimeout();
        }

        public void clearTimeout() {
            this.mTimeout = Long.MAX_VALUE;
        }

        public void setTimeout(long millis) {
            this.mTimeout = System.currentTimeMillis() + millis;
        }

        public boolean isTerminationRequested() {
            if (this.mStackedCancellation != null && this.mStackedCancellation.isTerminationRequested()) {
                return true;
            }
            return System.currentTimeMillis() >= this.mTimeout;
        }
    }
}

