/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2;

import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.FrontEndOptions;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.OptionMap;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.ExitHook;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.Lexer;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.Parser;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.MySymbolFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseEnvironment {
    final Script mScript;
    private File mCwd = null;
    private ExitHook mExitHook;
    private Deque<Long> mTiming;
    private final FrontEndOptions mOptions;
    private Lexer mLexer = null;
    private boolean mVersion25 = true;

    public ParseEnvironment(Script script, OptionMap options) {
        this(script, null, options);
    }

    public ParseEnvironment(Script script, ExitHook exit, OptionMap options) {
        this.mScript = script;
        this.mExitHook = exit;
        this.mOptions = options.getFrontEndOptions();
        if (!this.mOptions.isFrontEndActive()) {
            throw new IllegalArgumentException("Front End not active!");
        }
    }

    public Script getScript() {
        return this.mScript;
    }

    static boolean convertSexp(StringBuilder sb, Object o, int level) {
        if (o instanceof Object[]) {
            if (level > 0) {
                sb.append(System.getProperty("line.separator"));
                for (int i = 0; i < level; ++i) {
                    sb.append(' ');
                }
            }
            sb.append('(');
            Object[] array = (Object[])o;
            boolean subarray = false;
            String sep = "";
            for (Object el : array) {
                sb.append(sep);
                subarray |= ParseEnvironment.convertSexp(sb, el, level + 2);
                sep = " ";
            }
            if (subarray) {
                sb.append(System.getProperty("line.separator"));
                for (int i = 0; i < level; ++i) {
                    sb.append(' ');
                }
            }
            sb.append(')');
            return true;
        }
        sb.append(o);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseScript(String filename) throws SMTLIBException {
        File oldcwd = this.mCwd;
        InputStreamReader reader = null;
        boolean closeReader = false;
        try {
            if (filename.equals("<stdin>")) {
                reader = new InputStreamReader(System.in);
            } else {
                File script = new File(filename);
                if (!script.isAbsolute()) {
                    script = new File(this.mCwd, filename);
                }
                this.mCwd = script.getParentFile();
                try {
                    reader = new FileReader(script);
                    closeReader = true;
                }
                catch (FileNotFoundException ex) {
                    throw new SMTLIBException("File not found: " + filename);
                }
            }
            this.parseStream(reader, filename);
        }
        finally {
            this.mCwd = oldcwd;
            if (closeReader) {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void parseStream(Reader reader, String streamname) throws SMTLIBException {
        MySymbolFactory symfactory = new MySymbolFactory();
        Lexer last = this.mLexer;
        this.mLexer = new Lexer(reader);
        this.mLexer.setSymbolFactory(symfactory);
        Parser parser = new Parser(this.mLexer, symfactory);
        parser.setFileName(streamname);
        parser.setParseEnvironment(this);
        try {
            parser.parse();
        }
        catch (Exception ex) {
            System.err.println("Unexpected Exception: " + ex);
            throw new SMTLIBException(ex);
        }
        finally {
            this.mLexer = last;
        }
    }

    public void include(String filename) throws SMTLIBException {
        ExitHook oldexit = this.mExitHook;
        this.mExitHook = new ExitHook(){

            public void exitHook() {
            }
        };
        File oldcwd = this.mCwd;
        this.parseScript(filename);
        this.mCwd = oldcwd;
        this.mExitHook = oldexit;
    }

    public void printSuccess() {
        if (this.mOptions.isPrintSuccess()) {
            PrintWriter out = this.mOptions.getOutChannel();
            out.println("success");
            out.flush();
        }
    }

    public void printError(String message) {
        PrintWriter out = this.mOptions.getOutChannel();
        out.print("(error \"");
        out.print(message);
        out.println("\")");
        out.flush();
        if (!this.mOptions.continueOnError()) {
            System.exit(1);
        }
    }

    public void printValues(Map<Term, Term> values) {
        PrintTerm pt = new PrintTerm();
        PrintWriter out = this.mOptions.getOutChannel();
        out.print('(');
        String sep = "";
        String itemSep = System.getProperty("line.separator") + " ";
        for (Map.Entry<Term, Term> me : values.entrySet()) {
            out.print(sep);
            out.print('(');
            pt.append((Appendable)out, me.getKey());
            out.print(' ');
            pt.append((Appendable)out, me.getValue());
            out.print(')');
            sep = itemSep;
        }
        out.println(')');
        out.flush();
    }

    public void printResponse(Object response) {
        PrintWriter out = this.mOptions.getOutChannel();
        if (!this.mOptions.isPrintTermsCSE()) {
            if (response instanceof Term) {
                new PrintTerm().append((Appendable)out, (Term)response);
                out.println();
                out.flush();
                return;
            }
            if (response instanceof Term[]) {
                this.printTermResponse((Term[])response);
                out.flush();
                return;
            }
        }
        if (response instanceof Object[]) {
            StringBuilder sb = new StringBuilder();
            ParseEnvironment.convertSexp(sb, response, 0);
            out.println(sb.toString());
        } else if (response instanceof Iterable) {
            Iterable it = (Iterable)response;
            out.print("(");
            for (Object o : it) {
                this.printResponse(o);
            }
            out.println(")");
        } else if (response instanceof QuotedObject) {
            out.println(((QuotedObject)response).toString(this.mVersion25));
        } else {
            out.println(response);
        }
        out.flush();
    }

    public void printInfoResponse(String info, Object response) {
        PrintWriter out = this.mOptions.getOutChannel();
        StringBuilder sb = new StringBuilder();
        sb.append('(').append(info).append(' ');
        ParseEnvironment.convertSexp(sb, response, 0);
        out.println(sb.append(')').toString());
        out.flush();
    }

    public void printTermResponse(Term[] response) {
        StringBuilder sb = new StringBuilder();
        PrintTerm pt = new PrintTerm();
        sb.append('(');
        String sep = "";
        String itemSep = System.getProperty("line.separator") + " ";
        for (Term t : response) {
            sb.append(sep);
            pt.append((Appendable)sb, t);
            sep = itemSep;
        }
        sb.append(')');
        this.mOptions.getOutChannel().println(sb.toString());
        this.mOptions.getOutChannel().flush();
    }

    public void exit() {
        if (this.mExitHook == null) {
            this.mScript.exit();
            Runtime.getRuntime().exit(0);
        } else {
            this.mExitHook.exitHook();
        }
    }

    public void setInfo(String info, Object value) {
        if (info.equals(":smt-lib-version")) {
            String svalue = String.valueOf(value);
            if ("2.5".equals(svalue)) {
                this.mVersion25 = true;
                this.mLexer.setVersion25(true);
            } else if ("2.0".equals(svalue)) {
                this.mVersion25 = false;
                this.mLexer.setVersion25(false);
            } else {
                this.printError("Unknown SMTLIB version");
            }
        } else if (info.equals(":error-behavior")) {
            if ("immediate-exit".equals(value)) {
                this.mScript.setOption(":continue-on-error", false);
            } else if ("continued-execution".equals(value)) {
                this.mScript.setOption(":continue-on-error", true);
            }
        }
        this.mScript.setInfo(info, value);
    }

    public Object getInfo(String info) {
        if (info.equals(":error-behavior")) {
            return this.mOptions.continueOnError() ? "continued-execution" : "immediate-exit";
        }
        return this.mScript.getInfo(info);
    }

    public void startTiming() {
        if (this.mTiming == null) {
            this.mTiming = new ArrayDeque<Long>();
        }
        this.mOptions.getOutChannel().print('(');
        this.mTiming.push(System.nanoTime());
    }

    public void endTiming() {
        long old = this.mTiming.pop();
        long duration = System.nanoTime() - old;
        double secs = (double)duration / 1.0E9;
        this.mOptions.getOutChannel().printf((Locale)null, " :time %.3f)", secs);
        this.mOptions.getOutChannel().println();
        this.mOptions.getOutChannel().flush();
    }

    public boolean isContinueOnError() {
        return this.mOptions.continueOnError();
    }
}

