/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.proof;

import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.LeafNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ResolutionNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.SourceAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.IdentityHashSet;
import java.util.ArrayDeque;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnsatCoreCollector {
    private final Script mScript;

    public UnsatCoreCollector(Script script) {
        this.mScript = script;
    }

    public Term[] getUnsatCore(Clause unsat) {
        try {
            HashSet<String> unsatCoreIds = this.run(unsat);
            Term[] res = new Term[unsatCoreIds.size()];
            int i = -1;
            for (String s : unsatCoreIds) {
                res[++i] = this.mScript.term(s, new Term[0]);
            }
            return res;
        }
        catch (SMTLIBException ese) {
            throw new InternalError(ese.getMessage());
        }
    }

    private HashSet<String> run(Clause unsat) {
        HashSet<String> res = new HashSet<String>();
        ArrayDeque<Clause> todo = new ArrayDeque<Clause>();
        todo.push(unsat);
        IdentityHashSet<Clause> visited = new IdentityHashSet<Clause>();
        while (!todo.isEmpty()) {
            ResolutionNode.Antecedent[] ants;
            Clause c = (Clause)todo.pop();
            if (!visited.add(c)) continue;
            if (c.getProof().isLeaf()) {
                String name;
                LeafNode l = (LeafNode)c.getProof();
                if (l.getLeafKind() != -1 || !(l.getTheoryAnnotation() instanceof SourceAnnotation) || (name = ((SourceAnnotation)l.getTheoryAnnotation()).getAnnotation()).isEmpty()) continue;
                res.add(name);
                continue;
            }
            ResolutionNode n = (ResolutionNode)c.getProof();
            todo.push(n.getPrimary());
            for (ResolutionNode.Antecedent a : ants = n.getAntecedents()) {
                todo.push(a.mAntecedent);
            }
        }
        return res;
    }
}

