/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.proof;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Clausifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Utils;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.IProofTracker;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofConstants;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;

public class ProofTracker
implements IProofTracker {
    private final Rewrite mFirst;
    private Rewrite mLast = this.mMarkPos = new Rewrite();
    private Rewrite mMarkPos;
    private Rewrite mSave;
    private int mNumRewrites = 0;
    private int mSaveNumRewrites;
    private Map<Term, Term> mLits;

    private boolean addToLits(Term orig, Term lit) {
        if (this.mLits == null) {
            this.mLits = new HashMap<Term, Term>();
        }
        return this.mLits.put(orig, lit) == null;
    }

    private void prepend(Rewrite rw) {
        assert (this.invNumRewrites());
        rw.mNext = this.mFirst.mNext;
        this.mFirst.mNext = rw;
        if (rw.mNext == null) {
            this.mLast = rw;
        }
        ++this.mNumRewrites;
        assert (this.invNumRewrites());
    }

    private void append(Rewrite rw) {
        assert (this.invNumRewrites());
        this.mLast.mNext = rw;
        this.mLast = rw;
        ++this.mNumRewrites;
        assert (this.invNumRewrites());
    }

    private void insertAtMarkedPos(Rewrite rw) {
        assert (this.invNumRewrites());
        rw.mNext = this.mMarkPos.mNext;
        this.mMarkPos.mNext = rw;
        ++this.mNumRewrites;
        if (this.mMarkPos == this.mLast) {
            this.mLast = rw;
        }
        assert (this.invNumRewrites());
    }

    private boolean invNumRewrites() {
        int i = 0;
        Rewrite rw = this.mFirst.mNext;
        while (rw != null) {
            ++i;
            rw = rw.mNext;
        }
        assert (i == this.mNumRewrites);
        return i == this.mNumRewrites;
    }

    public ProofTracker() {
        this.mFirst = this.mMarkPos;
    }

    public void reset() {
        this.mFirst.mNext = null;
        this.mLast = this.mMarkPos = this.mFirst;
        this.mNumRewrites = 0;
        assert (this.invNumRewrites());
    }

    public void expand(ApplicationTerm orig) {
        this.prepend(new ExpandRewrite(orig));
    }

    public void expandDef(Term orig, Term res) {
        this.prepend(new ResultRewrite(orig, res, 1));
    }

    public void equality(Term[] args, Object res, int rule) {
        Term tres = null;
        if (res instanceof Term) {
            tres = (Term)res;
        } else {
            Theory t = args[0].getTheory();
            assert (res instanceof Term[]);
            Term[] resArgs = (Term[])res;
            if (resArgs.length == 0) {
                tres = t.mTrue;
            } else if (resArgs.length == 1) {
                tres = rule == 5 ? t.term(t.mNot, resArgs[0]) : resArgs[0];
            } else if (rule == 4) {
                tres = t.term(t.mAnd, (Term[])resArgs.clone());
            } else if (rule == 5) {
                tres = t.term(t.mNot, t.term(t.mOr, resArgs));
            } else if (rule == 6) {
                tres = t.term("=", resArgs);
            } else {
                throw new InternalError("Strange result in equality rewrite");
            }
        }
        this.append(new ResultRewrite(tres.getTheory().term("=", args), tres, rule));
    }

    public void distinct(Term[] args, Term res, int rule) {
        if (res == null) {
            Theory t = args[0].getTheory();
            if (rule == 11) {
                res = args[0] == t.mTrue ? t.term(t.mNot, args[1]) : t.term(t.mNot, args[0]);
            } else {
                throw new InternalError("Result should be given");
            }
        }
        this.append(new ResultRewrite(res.getTheory().term("distinct", args), res, rule));
    }

    public void negation(Term pos, Term res, int rule) {
        Theory t = res.getTheory();
        this.append(new ResultRewrite(t.term(t.mNot, pos), res, rule));
    }

    public void or(Term[] args, Term res, int rule) {
        this.append(new ResultRewrite(res.getTheory().term("or", args), res, rule));
    }

    public void ite(Term cond, Term thenTerm, Term elseTerm, Term res, int rule) {
        Theory t = cond.getTheory();
        if (res == null) {
            switch (rule) {
                case 21: {
                    res = t.term(t.mNot, cond);
                    break;
                }
                case 23: {
                    res = t.term(t.mNot, t.term(t.mOr, cond, t.term(t.mNot, elseTerm)));
                    break;
                }
                case 24: {
                    res = t.term(t.mOr, t.term(t.mNot, cond), thenTerm);
                    break;
                }
                case 25: {
                    res = t.term(t.mNot, t.term(t.mOr, t.term(t.mNot, cond), t.term(t.mNot, thenTerm)));
                    break;
                }
                default: {
                    throw new InternalError("BUG in ProofTracker: ITE");
                }
            }
        }
        this.append(new ResultRewrite(t.term("ite", cond, thenTerm, elseTerm), res, rule));
    }

    public void strip(AnnotatedTerm orig) {
        this.prepend(new ResultRewrite(orig, orig.getSubterm(), 29));
    }

    public void sum(FunctionSymbol fsym, Term[] args, Term res) {
        Term right;
        Theory t = fsym.getTheory();
        Term left = SMTAffineTerm.cleanup(t.term(fsym, args));
        if (left != (right = SMTAffineTerm.cleanup(res))) {
            this.append(new ResultRewrite(left, right, 30));
        }
    }

    public void leqSimp(SMTAffineTerm leq, Term res, int rule) {
        Theory t = res.getTheory();
        ApplicationTerm left = t.term("<=", SMTAffineTerm.cleanup(leq), leq.getSort().getName().equals("Int") ? t.numeral(BigInteger.ZERO) : t.decimal(BigDecimal.ZERO));
        this.append(new ResultRewrite(left, res, rule));
    }

    public void desugar(ApplicationTerm orig, Term[] origArgs, Term[] newArgs) {
        Theory t = orig.getTheory();
        this.append(new ResultRewrite(t.term(orig.getFunction(), origArgs), t.term(orig.getFunction(), newArgs), 37));
    }

    public void divisible(FunctionSymbol divn, Term div, Term res) {
        ApplicationTerm divisible = res.getTheory().term(divn, SMTAffineTerm.cleanup(div));
        this.append(new ResultRewrite(divisible, res, 38));
    }

    public Term getRewriteProof(Term asserted) {
        assert (this.invNumRewrites());
        Theory t = asserted.getTheory();
        return this.getEqProof(t.term("@asserted", asserted));
    }

    private Term getEqProof(Term proofPart) {
        if (this.mNumRewrites == 0) {
            return proofPart;
        }
        Term[] args = new Term[this.mNumRewrites + 1];
        args[0] = proofPart;
        int i = 1;
        Rewrite rw = this.mFirst.mNext;
        while (rw != null) {
            args[i++] = rw.toTerm();
            rw = rw.mNext;
        }
        ApplicationTerm eq = proofPart.getTheory().term("@eq", args);
        return eq;
    }

    public void distinctBoolEq(Term lhs, Term rhs, boolean firstNegated) {
        Theory t = lhs.getTheory();
        ApplicationTerm distinct = t.term("distinct", lhs, rhs);
        ApplicationTerm res = firstNegated ? t.term("=", t.term(t.mNot, lhs), rhs) : t.term("=", lhs, t.term(t.mNot, rhs));
        this.append(new ResultRewrite(distinct, res, 53));
    }

    public void removeConnective(Term[] origArgs, Term result, int rule) {
        if (rule == 31) {
            Term tmp2;
            Term tmp;
            assert (origArgs.length == 2);
            SMTAffineTerm constant = SMTAffineTerm.create(origArgs[1]);
            if (constant.isConstant() && constant.getConstant().equals(Rational.ZERO) && (tmp = SMTAffineTerm.cleanup(result)) == (tmp2 = SMTAffineTerm.cleanup(origArgs[0]))) {
                return;
            }
        }
        this.append(new RemoveConnective(rule, origArgs, result));
    }

    public void quoted(Term orig, Literal quote) {
        Term t = quote.getSMTFormula(orig.getTheory(), true);
        this.append(new InternRewrite(orig, t));
    }

    public void eq(Term lhs, Term rhs, Term res) {
        ApplicationTerm orig = res.getTheory().term("=", lhs, rhs);
        if (orig != res) {
            this.append(new InternRewrite(orig, res));
        }
    }

    public void eq(Term lhs, Term rhs, DPLLAtom eqAtom) {
        Theory t = lhs.getTheory();
        Term res = SMTAffineTerm.cleanup(eqAtom.getSMTFormula(t, true));
        Term orig = SMTAffineTerm.cleanup(t.term("=", lhs, rhs));
        if (orig != res) {
            this.append(new InternRewrite(orig, res));
        }
    }

    public void leq0(SMTAffineTerm sum, Literal lit) {
        Term res;
        Theory t = sum.getTheory();
        ApplicationTerm orig = t.term("<=", SMTAffineTerm.cleanup(sum), sum.getSort().getName().equals("Int") ? t.numeral(BigInteger.ZERO) : t.decimal(BigDecimal.ZERO));
        if (orig != (res = lit.getSMTFormula(t, true))) {
            this.append(new InternRewrite(orig, res));
        }
    }

    public void intern(Term term, Literal lit) {
        Term res;
        Theory t = term.getTheory();
        Term orig = SMTAffineTerm.cleanup(term);
        if (orig != (res = lit.getSMTFormula(t, true))) {
            this.append(new InternRewrite(orig, res));
        }
    }

    public Term split(Term data, Term proof, int splitKind) {
        ApplicationTerm res;
        Theory t = proof.getTheory();
        switch (splitKind) {
            case 0: {
                ApplicationTerm res2 = t.term(t.mNot, data);
                ApplicationTerm base = t.term("@split", t.annotatedTerm(new Annotation[]{ProofConstants.SPLITANNOTS[splitKind]}, proof), res2);
                Term posRes = res2;
                if (Utils.isNegation(data)) {
                    posRes = ((ApplicationTerm)data).getParameters()[0];
                    ApplicationTerm rewrite = t.term("@rewrite", t.annotatedTerm(new Annotation[]{ProofConstants.REWRITEANNOTS[14]}, t.term("=", res2, posRes)));
                    base = t.term("@eq", base, rewrite);
                }
                return base;
            }
            case 1: {
                Term[] params = ((ApplicationTerm)data).getParameters();
                assert (params.length == 2);
                res = t.term(t.mOr, params[0], t.term(t.mNot, params[1]));
                break;
            }
            case 2: {
                Term[] params = ((ApplicationTerm)data).getParameters();
                assert (params.length == 2);
                res = t.term(t.mOr, t.term(t.mNot, params[0]), params[1]);
                break;
            }
            case 3: {
                Term[] params = ((ApplicationTerm)data).getParameters();
                assert (params.length == 2);
                res = t.term(t.mOr, params);
                break;
            }
            case 4: {
                Term[] params = ((ApplicationTerm)data).getParameters();
                assert (params.length == 2);
                res = t.term(t.mOr, t.term(t.mNot, params[0]), t.term(t.mNot, params[1]));
                break;
            }
            case 5: {
                Term[] params = ((ApplicationTerm)data).getParameters();
                assert (params.length == 3);
                res = t.term(t.mOr, t.term(t.mNot, params[0]), params[1]);
                break;
            }
            case 6: {
                Term[] params = ((ApplicationTerm)data).getParameters();
                assert (params.length == 3);
                res = t.term(t.mOr, params[0], params[2]);
                break;
            }
            case 7: {
                Term[] params = ((ApplicationTerm)data).getParameters();
                assert (params.length == 3);
                res = t.term(t.mOr, t.term(t.mNot, params[0]), t.term(t.mNot, params[1]));
                break;
            }
            case 8: {
                Term[] params = ((ApplicationTerm)data).getParameters();
                assert (params.length == 3);
                res = t.term(t.mOr, params[0], t.term(t.mNot, params[2]));
                break;
            }
            default: {
                throw new InternalError("BUG in ProofTracker: Split");
            }
        }
        return this.getEqProof(t.term("@split", t.annotatedTerm(new Annotation[]{ProofConstants.SPLITANNOTS[splitKind]}, proof), res));
    }

    public Term clause(Term proof) {
        assert (this.invNumRewrites());
        return this.getEqProof(proof);
    }

    public Term auxAxiom(int auxKind, Literal auxLit, Term data, Term base, Object auxData) {
        Term axiom;
        Theory t = data.getTheory();
        switch (auxKind) {
            case 0: {
                axiom = auxLit.getSMTFormula(t, true);
                break;
            }
            case 1: {
                Term[] args = ((ApplicationTerm)data).getParameters();
                Term[] nargs = new Term[args.length + 1];
                nargs[0] = t.term(t.mNot, auxLit.getSMTFormula(t, true));
                System.arraycopy(args, 0, nargs, 1, args.length);
                axiom = t.term(t.mOr, nargs);
                break;
            }
            case 2: {
                axiom = t.term(t.mOr, auxLit.getSMTFormula(t, true), t.term(t.mNot, data));
                break;
            }
            case 3: {
                Term[] params = ((ApplicationTerm)data).getParameters();
                axiom = t.term(t.mOr, t.term(t.mNot, auxLit.getSMTFormula(t, true)), t.term(t.mNot, params[0]), params[1]);
                break;
            }
            case 4: {
                Term[] params = ((ApplicationTerm)data).getParameters();
                axiom = t.term(t.mOr, t.term(t.mNot, auxLit.getSMTFormula(t, true)), params[0], params[2]);
                break;
            }
            case 5: {
                Term[] params = ((ApplicationTerm)data).getParameters();
                axiom = t.term(t.mOr, t.term(t.mNot, auxLit.getSMTFormula(t, true)), params[1], params[2]);
                break;
            }
            case 6: {
                Term[] params = ((ApplicationTerm)data).getParameters();
                axiom = t.term(t.mOr, auxLit.getSMTFormula(t, true), t.term(t.mNot, params[0]), t.term(t.mNot, params[1]));
                break;
            }
            case 7: {
                Term[] params = ((ApplicationTerm)data).getParameters();
                axiom = t.term(t.mOr, auxLit.getSMTFormula(t, true), params[0], t.term(t.mNot, params[2]));
                break;
            }
            case 8: {
                Term[] params = ((ApplicationTerm)data).getParameters();
                axiom = t.term(t.mOr, auxLit.getSMTFormula(t, true), t.term(t.mNot, params[1]), t.term(t.mNot, params[2]));
                break;
            }
            case 9: {
                Term[] params = ((ApplicationTerm)data).getParameters();
                axiom = t.term(t.mOr, t.term(t.mNot, auxLit.getSMTFormula(t, true)), params[0], t.term(t.mNot, params[1]));
                break;
            }
            case 10: {
                Term[] params = ((ApplicationTerm)data).getParameters();
                axiom = t.term(t.mOr, t.term(t.mNot, auxLit.getSMTFormula(t, true)), t.term(t.mNot, params[0]), params[1]);
                break;
            }
            case 11: {
                Term[] params = ((ApplicationTerm)data).getParameters();
                axiom = t.term(t.mOr, auxLit.getSMTFormula(t, true), params[0], params[1]);
                break;
            }
            case 12: {
                Term[] params = ((ApplicationTerm)data).getParameters();
                axiom = t.term(t.mOr, auxLit.getSMTFormula(t, true), t.term(t.mNot, params[0]), t.term(t.mNot, params[1]));
                break;
            }
            case 13: {
                axiom = t.term(t.mOr, t.term(t.mNot, data), auxLit.getSMTFormula(t, true));
                break;
            }
            case 14: {
                axiom = t.term(t.mOr, data, auxLit.getSMTFormula(t, true));
                break;
            }
            case 15: {
                Clausifier.ConditionChain tmp;
                Clausifier.ConditionChain walk = tmp = (Clausifier.ConditionChain)auxData;
                int size = 1;
                while (walk != null) {
                    walk = walk.getPrevious();
                    ++size;
                }
                Term[] nparams = new Term[size];
                walk = tmp;
                for (int i = size - 2; i >= 0; --i) {
                    nparams[i] = t.term(t.mNot, walk.getTerm());
                    if (Utils.isNegation(walk.getTerm())) {
                        this.negation(walk.getTerm(), Utils.createNotUntracked(walk.getTerm()), 14);
                    }
                    walk = walk.getPrevious();
                }
                nparams[size - 1] = t.term("=", base, data);
                axiom = t.term(t.mOr, nparams);
                break;
            }
            case 16: {
                axiom = t.term("<=", SMTAffineTerm.cleanup(data), t.numeral(BigInteger.ZERO));
                break;
            }
            case 18: {
                axiom = t.term("<=", SMTAffineTerm.cleanup(data), t.rational(BigInteger.ZERO, BigInteger.ONE));
                break;
            }
            case 17: {
                axiom = t.term(t.mNot, t.term("<=", SMTAffineTerm.cleanup(data), t.numeral(BigInteger.ZERO)));
                break;
            }
            case 19: {
                axiom = t.term(t.mNot, t.term("<=", SMTAffineTerm.cleanup(data), t.rational(BigInteger.ZERO, BigInteger.ONE)));
                break;
            }
            case 20: {
                Term[] params = ((ApplicationTerm)data).getParameters();
                axiom = t.term("=", t.term("select", data, params[1]), params[2]);
                break;
            }
            case 21: {
                Term[] params = ((ApplicationTerm)data).getParameters();
                axiom = t.term("or", t.term("=", params), t.term("not", t.term("=", t.term("select", params[0], data), t.term("select", params[1], data))));
                break;
            }
            default: {
                throw new InternalError("BUG in ProofTracker: AUX");
            }
        }
        return t.term("@tautology", t.annotatedTerm(new Annotation[]{ProofConstants.AUXANNOTS[auxKind]}, axiom));
    }

    public IProofTracker getDescendent() {
        return new ProofTracker();
    }

    public void modulo(ApplicationTerm appTerm, Term res) {
        this.append(new ResultRewrite(appTerm, res, 39));
    }

    public void mod(Term x, Term y, Term res, int rule) {
        Theory t = x.getTheory();
        ApplicationTerm mod = t.term("mod", SMTAffineTerm.cleanup(x), SMTAffineTerm.cleanup(y));
        this.append(new ResultRewrite(mod, SMTAffineTerm.cleanup(res), rule));
    }

    public void div(Term x, Term y, Term res, int rule) {
        Theory t = x.getTheory();
        ApplicationTerm mod = t.term("div", SMTAffineTerm.cleanup(x), SMTAffineTerm.cleanup(y));
        this.append(new ResultRewrite(mod, SMTAffineTerm.cleanup(res), rule));
    }

    public void toInt(Term arg, Term res) {
        Theory t = arg.getTheory();
        ApplicationTerm toint = t.term("to_int", SMTAffineTerm.cleanup(arg));
        this.append(new ResultRewrite(toint, SMTAffineTerm.cleanup(res), 46));
    }

    public Term[] prepareIRAHack(Term[] args) {
        return (Term[])args.clone();
    }

    public void negateLit(Literal lit, Theory theory) {
        assert (lit.getSign() == -1) : "Literal not negated!";
        ApplicationTerm lhs = theory.term(theory.mNot, SMTAffineTerm.cleanup(lit.getSMTFormula(theory, true)));
        Term rhs = SMTAffineTerm.cleanup(lit.getAtom().getSMTFormula(theory, true));
        this.append(new ResultRewrite(lhs, rhs, 14));
    }

    public void arrayRewrite(Term[] args, Term result, int rule) {
        Theory t = result.getTheory();
        ApplicationTerm input = rule == 48 ? t.term("store", args) : t.term("select", args);
        this.append(new ResultRewrite(input, result, rule));
    }

    public void flatten(Term[] args, boolean simpOr) {
        Theory t = args[0].getTheory();
        ArrayDeque<FlattenHelper> toFlatten = new ArrayDeque<FlattenHelper>();
        toFlatten.add(new FlattenHelper(args, 0));
        ArrayList<Term> newArgs = new ArrayList<Term>();
        while (!toFlatten.isEmpty()) {
            FlattenHelper fh = (FlattenHelper)toFlatten.poll();
            fh.flatten(toFlatten, newArgs);
        }
        ApplicationTerm res = t.term(t.mOr, newArgs.toArray(new Term[newArgs.size()]));
        if (simpOr) {
            this.orSimpClause(res.getParameters());
        }
        this.insertAtMarkedPos(new ResultRewrite(t.term(t.mOr, args), res, 50));
    }

    public void orSimpClause(Term[] args) {
        Theory t = args[0].getTheory();
        Term[] newArgs = (Term[])args.clone();
        LinkedHashSet<Term> clause = new LinkedHashSet<Term>();
        for (int i = 0; i < newArgs.length; ++i) {
            Term tmp = SMTAffineTerm.cleanup(newArgs[i]);
            Term newDisj = this.mLits.get(tmp);
            if (newDisj == null) {
                newDisj = tmp;
            }
            newArgs[i] = newDisj;
            if (newDisj == t.mFalse) continue;
            clause.add(newDisj);
        }
        Term res = clause.isEmpty() ? t.mFalse : (clause.size() == 1 ? (Term)clause.iterator().next() : t.term(t.mOr, clause.toArray(new Term[clause.size()])));
        ResultRewrite rw = new ResultRewrite(t.term(t.mOr, newArgs), res, 15);
        this.append(rw);
    }

    public void markPosition() {
        this.mMarkPos = this.mLast;
    }

    public Term[] produceAuxAxiom(Literal auxlit, Term ... args) {
        Theory t = args[0].getTheory();
        Term[] res = new Term[1 + args.length];
        res[0] = auxlit.getSMTFormula(t, true);
        System.arraycopy(args, 0, res, 1, args.length);
        return res;
    }

    public void save() {
        this.mSave = this.mLast;
        this.mSaveNumRewrites = this.mNumRewrites;
    }

    public void restore() {
        if (this.mSave != null) {
            this.mLast = this.mSave;
            this.mLast.mNext = null;
            this.mNumRewrites = this.mSaveNumRewrites;
            this.mSave = null;
        }
        assert (this.invNumRewrites());
    }

    public void cleanSave() {
        this.mSave = null;
    }

    public void normalized(ConstantTerm term, SMTAffineTerm res) {
        Term rhs = SMTAffineTerm.cleanup(res);
        if (term != rhs) {
            this.append(new ResultRewrite(term, rhs, 30));
        }
    }

    public boolean notifyLiteral(Literal lit, Term t) {
        return this.addToLits(SMTAffineTerm.cleanup(t), SMTAffineTerm.cleanup(lit.getSMTFormula(t.getTheory(), true)));
    }

    public void notifyFalseLiteral(Term t) {
        this.addToLits(SMTAffineTerm.cleanup(t), t.getTheory().mFalse);
    }

    public void storeRewrite(ApplicationTerm store, Term result, boolean arrayFirst) {
        Term array = store.getParameters()[0];
        ApplicationTerm orig = arrayFirst ? store.getTheory().term("=", array, store) : store.getTheory().term("=", store, array);
        this.append(new ResultRewrite(orig, result, 51));
    }

    public void toReal(Term arg, Term res) {
        ApplicationTerm orig = arg.getTheory().term("to_real", SMTAffineTerm.cleanup(arg));
        this.append(new ResultRewrite(orig, SMTAffineTerm.cleanup(res), 52));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FlattenHelper {
        private final Term[] mArgs;
        private int mOffset;

        public FlattenHelper(Term[] args, int offset) {
            this.mArgs = args;
            this.mOffset = offset;
        }

        public void flatten(ArrayDeque<FlattenHelper> todo, ArrayList<Term> args) {
            for (int i = this.mOffset; i < this.mArgs.length; ++i) {
                ApplicationTerm tst;
                if (this.mArgs[i] instanceof ApplicationTerm && Clausifier.shouldFlatten(tst = (ApplicationTerm)this.mArgs[i])) {
                    this.mOffset = i + 1;
                    if (this.mOffset < this.mArgs.length) {
                        todo.addFirst(this);
                    }
                    todo.addFirst(new FlattenHelper(tst.getParameters(), 0));
                    return;
                }
                args.add(this.mArgs[i]);
            }
        }
    }

    private static class InternRewrite
    extends Rewrite {
        private final Term mTerm;
        private final Term mLitTerm;

        public InternRewrite(Term term, Term litTerm) {
            assert (term != litTerm) : "Intern should track changes!!!";
            this.mTerm = term;
            this.mLitTerm = litTerm;
        }

        public Term toTerm() {
            Theory t = this.mTerm.getTheory();
            ApplicationTerm res = t.term("=", this.mTerm, this.mLitTerm);
            return t.term("@intern", res);
        }
    }

    private static class RemoveConnective
    extends Rewrite {
        private final int mRule;
        private final Term[] mArgs;
        private final Term mRes;

        public RemoveConnective(int rule, Term[] args, Term res) {
            this.mRule = rule;
            this.mArgs = rule == 26 ? (Term[])args.clone() : args;
            this.mRes = res;
        }

        public Term toTerm() {
            Term res;
            ApplicationTerm orig;
            Theory t = this.mArgs[0].getTheory();
            Term[] resArgs = this.mArgs;
            switch (this.mRule) {
                case 26: {
                    resArgs = new Term[this.mArgs.length];
                    orig = t.term(t.mAnd, this.mArgs);
                    for (int i = 0; i < resArgs.length; ++i) {
                        resArgs[i] = t.term(t.mNot, this.mArgs[i]);
                    }
                    res = t.term(t.mNot, t.term(t.mOr, resArgs));
                    break;
                }
                case 27: {
                    orig = t.term(t.mXor, this.mArgs);
                    res = t.term("distinct", resArgs);
                    break;
                }
                case 28: {
                    resArgs = new Term[resArgs.length];
                    orig = t.term(t.mImplies, this.mArgs);
                    for (int i = 1; i < resArgs.length; ++i) {
                        resArgs[i] = t.term(t.mNot, this.mArgs[i - 1]);
                    }
                    resArgs[0] = this.mArgs[this.mArgs.length - 1];
                    res = t.term(t.mOr, resArgs);
                    break;
                }
                case 31: {
                    orig = t.term("<=", this.mArgs);
                    resArgs = new Term[]{SMTAffineTerm.cleanup(this.mRes), resArgs[0].getSort().getName().equals("Int") ? t.numeral(BigInteger.ZERO) : t.decimal(BigDecimal.ZERO)};
                    res = t.term("<=", resArgs);
                    break;
                }
                case 33: {
                    orig = t.term(">=", this.mArgs);
                    resArgs = new Term[]{SMTAffineTerm.cleanup(this.mRes), resArgs[0].getSort().getName().equals("Int") ? t.numeral(BigInteger.ZERO) : t.decimal(BigDecimal.ZERO)};
                    res = t.term("<=", resArgs);
                    break;
                }
                case 34: {
                    orig = t.term(">", this.mArgs);
                    resArgs = new Term[]{SMTAffineTerm.cleanup(this.mRes), resArgs[0].getSort().getName().equals("Int") ? t.numeral(BigInteger.ZERO) : t.decimal(BigDecimal.ZERO)};
                    res = t.term(t.mNot, t.term("<=", resArgs));
                    break;
                }
                case 32: {
                    orig = t.term("<", this.mArgs);
                    resArgs = new Term[]{SMTAffineTerm.cleanup(this.mRes), resArgs[0].getSort().getName().equals("Int") ? t.numeral(BigInteger.ZERO) : t.decimal(BigDecimal.ZERO)};
                    res = t.term(t.mNot, t.term("<=", resArgs));
                    break;
                }
                default: {
                    throw new InternalError("BUG in ProofTracker: RemoveConnective");
                }
            }
            res = t.annotatedTerm(new Annotation[]{ProofConstants.REWRITEANNOTS[this.mRule]}, t.term("=", orig, res));
            return t.term("@rewrite", res);
        }
    }

    private static class ResultRewrite
    extends Rewrite {
        Term mOld;
        Term mNew;
        int mNum;

        public ResultRewrite(Term oldTerm, Term newTerm, int rewriteNum) {
            this.mOld = SMTAffineTerm.cleanup(oldTerm);
            this.mNew = SMTAffineTerm.cleanup(newTerm);
            this.mNum = rewriteNum;
            assert (oldTerm != newTerm) : "ResultRewrite should track changes";
        }

        public Term toTerm() {
            Theory t = this.mOld.getTheory();
            Term base = t.term("=", this.mOld, this.mNew);
            base = t.annotatedTerm(new Annotation[]{ProofConstants.REWRITEANNOTS[this.mNum]}, base);
            return t.term("@rewrite", base);
        }
    }

    private static class ExpandRewrite
    extends Rewrite {
        ApplicationTerm mOld;

        public ExpandRewrite(Term old) {
            this.mOld = (ApplicationTerm)old;
        }

        public Term toTerm() {
            Term res;
            FunctionSymbol fsym = this.mOld.getFunction();
            Term[] params = this.mOld.getParameters();
            Theory t = this.mOld.getTheory();
            if (fsym.isLeftAssoc()) {
                res = t.term(fsym, params[0], params[1]);
                for (int i = 2; i < params.length; ++i) {
                    res = t.term(fsym, res, params[i]);
                }
            } else if (fsym.isRightAssoc()) {
                res = t.term(fsym, params[params.length - 2], params[params.length - 1]);
                for (int i = params.length - 3; i >= 0; --i) {
                    res = t.term(fsym, params[i], res);
                }
            } else if (fsym.isChainable()) {
                res = t.term(fsym, params[0], params[1]);
                for (int i = 1; i < params.length - 1; ++i) {
                    res = t.term(t.mAnd, res, t.term(fsym, params[i], params[i + 1]));
                }
            } else {
                throw new InternalError("Cannot expand " + fsym);
            }
            res = t.annotatedTerm(new Annotation[]{ProofConstants.REWRITEANNOTS[0]}, t.term("=", this.mOld, res));
            return t.term("@rewrite", res);
        }
    }

    private static class Rewrite {
        Rewrite mNext;

        private Rewrite() {
        }

        public Term toTerm() {
            throw new InternalError("toTerm called on sentinel");
        }
    }
}

