/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.option;

import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.BooleanOption;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.EnumOption;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.LongOption;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.OptionMap;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.VerbosityOption;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.Transformations;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.SMTInterpol;

public class SolverOptions {
    private final LongOption mTimeout;
    private final BooleanOption mProduceProofs;
    private final LongOption mRandomSeed;
    private final BooleanOption mInterpolantCheckMode;
    private final BooleanOption mProduceInterpolants;
    private final BooleanOption mModelCheckMode;
    private final EnumOption<Transformations.AvailableTransformations> mProofTrans;
    private final BooleanOption mModelsPartial;
    private final EnumOption<SMTInterpol.CheckType> mCheckType;
    private final BooleanOption mSimpIps;
    private final BooleanOption mProofCheckMode;
    private final EnumOption<SMTInterpol.CheckType> mSimpCheckType;
    public static final String TIMEOUT = ":timeout";
    public static final String RANDOM_SEED = ":random-seed";
    public static final String MODELS_PARTIAL = ":models-partial";
    public static final String MODEL_CHECK_MODE = ":model-check-mode";
    public static final String PRODUCE_PROOFS = ":produce-proofs";
    public static final String PROOF_TRANSFORMATION = ":proof-transformation";
    public static final String PROOF_CHECK_MODE = ":proof-check-mode";
    public static final String PRODUCE_INTERPOLANTS = ":produce-interpolants";
    public static final String INTERPOLANT_CHECK_MODE = ":interpolant-check-mode";
    public static final String SIMPLIFY_INTERPOLANTS = ":simplify-interpolants";
    public static final String CHECK_TYPE = ":check-type";
    public static final String SIMPLIFY_CHECK_TYPE = ":simplify-check-type";

    SolverOptions(OptionMap options, LogProxy logger) {
        this.mTimeout = new LongOption(0L, true, "Soft timeout in milliseconds for individual check-sat calls.  Values <= 0 deactivate the timeout.");
        this.mProduceProofs = new BooleanOption(false, false, "Produce proofs for unsatisfiable formulas.");
        this.mRandomSeed = new LongOption(11350294L, true, "Seed for the internal pseudo-random number generator.");
        this.mInterpolantCheckMode = new BooleanOption(false, false, "Check generated interpolants.");
        this.mProduceInterpolants = new BooleanOption(false, false, "Enable interpolant production.");
        this.mModelCheckMode = new BooleanOption(false, true, "Check satisfiable formulas against the produced model.");
        this.mProofTrans = new EnumOption<Transformations.AvailableTransformations>(Transformations.AvailableTransformations.NONE, true, Transformations.AvailableTransformations.class, "Algorithm used to transform the resolution proof tree.");
        this.mModelsPartial = new BooleanOption(false, true, "Don't totalize models.");
        this.mCheckType = new EnumOption<SMTInterpol.CheckType>(SMTInterpol.CheckType.FULL, true, SMTInterpol.CheckType.class, "Strength of check used in check-sat command.");
        this.mSimpIps = new BooleanOption(false, true, "Apply strong context simplification to generated interpolants.");
        this.mProofCheckMode = new BooleanOption(false, false, "Check the produced proof for unsatisfiable formulas.");
        this.mSimpCheckType = new EnumOption<SMTInterpol.CheckType>(SMTInterpol.CheckType.QUICK, true, SMTInterpol.CheckType.class, "Strength of checks used by the strong context simplifier used in the simplify command");
        options.addOption(":verbosity", new VerbosityOption(logger));
        options.addOption(TIMEOUT, this.mTimeout);
        options.addOption(RANDOM_SEED, this.mRandomSeed);
        options.addOption(":produce-assertions", new BooleanOption(false, false, "Store asserted formulas for later retrieval."));
        options.addAlias(":interactive-mode", ":produce-assertions");
        options.addOption(":produce-models", new BooleanOption(false, true, "Produce models for satisfiable formulas"));
        options.addOption(MODELS_PARTIAL, this.mModelsPartial);
        options.addOption(MODEL_CHECK_MODE, this.mModelCheckMode);
        options.addOption(":produce-assignments", new BooleanOption(false, false, "Produce assignments of named Boolean terms for satisfiable formulas"));
        options.addOption(PRODUCE_PROOFS, this.mProduceProofs);
        options.addOption(PROOF_TRANSFORMATION, this.mProofTrans);
        options.addOption(PROOF_CHECK_MODE, this.mProofCheckMode);
        options.addOption(PRODUCE_INTERPOLANTS, this.mProduceInterpolants);
        options.addOption(INTERPOLANT_CHECK_MODE, this.mInterpolantCheckMode);
        options.addOption(SIMPLIFY_INTERPOLANTS, this.mSimpIps);
        options.addOption(":produce-unsat-cores", new BooleanOption(false, false, "Enable production of unsatisfiable cores."));
        options.addOption(":unsat-core-check-mode", new BooleanOption(false, false, "Check generated unsat cores"));
        options.addOption(":produce-unsat-assumptions", new BooleanOption(false, false, "Enable production of unsatisfiable assumptions."));
        options.addOption(":unsat-assumptions-check-mode", new BooleanOption(false, false, "Check generated unsat assumptions"));
        options.addOption(CHECK_TYPE, this.mCheckType);
        options.addOption(SIMPLIFY_CHECK_TYPE, this.mSimpCheckType);
        options.addOption(":simplify-repeatedly", new BooleanOption(true, true, "Simplify until the fixpoint is reached."));
        options.addOption(":global-declarations", new BooleanOption(false, false, "Make all declared and defined symbols global.  Global symbols survive pop operations."));
    }

    SolverOptions(OptionMap options) {
        this.mTimeout = (LongOption)options.getOption(TIMEOUT);
        this.mProduceProofs = (BooleanOption)options.getOption(PRODUCE_PROOFS);
        this.mRandomSeed = (LongOption)options.getOption(RANDOM_SEED);
        this.mInterpolantCheckMode = (BooleanOption)options.getOption(INTERPOLANT_CHECK_MODE);
        this.mProduceInterpolants = (BooleanOption)options.getOption(PRODUCE_INTERPOLANTS);
        this.mModelCheckMode = (BooleanOption)options.getOption(MODEL_CHECK_MODE);
        this.mProofTrans = (EnumOption)options.getOption(PROOF_TRANSFORMATION);
        this.mModelsPartial = (BooleanOption)options.getOption(MODELS_PARTIAL);
        this.mCheckType = (EnumOption)options.getOption(CHECK_TYPE);
        this.mSimpIps = (BooleanOption)options.getOption(SIMPLIFY_INTERPOLANTS);
        this.mProofCheckMode = (BooleanOption)options.getOption(PROOF_CHECK_MODE);
        this.mSimpCheckType = (EnumOption)options.getOption(SIMPLIFY_CHECK_TYPE);
    }

    public final SMTInterpol.CheckType getCheckType() {
        return this.mCheckType.getValue();
    }

    public final void setCheckType(SMTInterpol.CheckType newCheckType) {
        this.mCheckType.set((Object)newCheckType);
    }

    public final boolean isInterpolantCheckModeActive() {
        return this.mInterpolantCheckMode.getValue();
    }

    public final boolean isModelCheckModeActive() {
        return this.mModelCheckMode.getValue();
    }

    public final boolean isModelsPartial() {
        return this.mModelsPartial.getValue();
    }

    public final boolean isProduceInterpolants() {
        return this.mProduceInterpolants.getValue();
    }

    public final boolean isProduceProofs() {
        return this.mProduceProofs.getValue();
    }

    public final boolean isProofCheckModeActive() {
        return this.mProofCheckMode.getValue();
    }

    public final Transformations.AvailableTransformations getProofTransformation() {
        return this.mProofTrans.getValue();
    }

    public final long getRandomSeed() {
        return this.mRandomSeed.getValue();
    }

    public final boolean isSimplifyInterpolants() {
        return this.mSimpIps.getValue();
    }

    public final long getTimeout() {
        return this.mTimeout.getValue();
    }

    public SMTInterpol.CheckType getSimplifierCheckType() {
        return this.mSimpCheckType.getValue();
    }
}

