/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.option;

import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.Option;
import java.io.IOException;

public class LoggerOption
extends Option {
    private String mDefaultDest;
    private final LogProxy mLogger;

    public LoggerOption(String description, LogProxy logger) {
        super(true, description);
        this.mDefaultDest = logger.getDestination();
        this.mLogger = logger;
    }

    private final void changeLoggerDest(String newdest) {
        try {
            this.mLogger.changeDestination(String.valueOf(newdest));
        }
        catch (IOException eio) {
            throw new SMTLIBException("Could not change logging destination", eio);
        }
    }

    public void set(Object value) {
        if (value instanceof QuotedObject) {
            value = ((QuotedObject)value).getValue();
        }
        if (this.mLogger.canChangeDestination()) {
            this.changeLoggerDest(String.valueOf(value));
        } else {
            this.mLogger.warn("Attempt to change the destionation of the logger which cannot change its destination!");
        }
    }

    public Object get() {
        return new QuotedObject(this.mLogger.getDestination());
    }

    public void reset() {
        if (this.mLogger.canChangeDestination()) {
            this.changeLoggerDest(this.mDefaultDest);
        }
    }

    public Object defaultValue() {
        return this.mDefaultDest;
    }

    public Option copy() {
        return this;
    }

    public void started() {
        this.mDefaultDest = this.mLogger.getDestination();
    }
}

