/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.option;

import de.uni_freiburg.informatik.ultimate.smtinterpol.option.BooleanOption;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.ChannelOption;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.Option;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.OptionMap;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.StringOptionWithWarning;
import java.io.PrintWriter;

public class FrontEndOptions {
    private final BooleanOption mPrintSuccess;
    private final ChannelOption mOut;
    private final BooleanOption mPrintTermsCSE;
    private final BooleanOption mContinueOnError;
    private static final String REG_OUT_CHANNEL_NAME = ":regular-output-channel";
    private static final String REG_OUT_CHANNEL_DEF = "stdout";
    private static final String REG_OUT_CHANNEL_DESC = "Where to print command responses to.  Use \"stdout\" for standard output and \"stderr\" for standard error.";

    FrontEndOptions(OptionMap options) {
        this.mPrintSuccess = (BooleanOption)options.getOption(":print-success");
        Option outChannel = options.getOption(REG_OUT_CHANNEL_NAME);
        this.mOut = outChannel instanceof ChannelOption ? (ChannelOption)outChannel : null;
        this.mPrintTermsCSE = (BooleanOption)options.getOption(":print-terms-cse");
        this.mContinueOnError = (BooleanOption)options.getOption(":continue-on-error");
    }

    FrontEndOptions(OptionMap options, boolean active) {
        this.mPrintSuccess = new BooleanOption(true, true, "Print \"success\" after successful command executions that would otherwise not produce feedback.");
        this.mPrintTermsCSE = new BooleanOption(true, true, "Eliminate common subexpressions before printing terms.");
        this.mContinueOnError = new BooleanOption(true, true, "Continue on errors.  Corresponds to (set-info :error-behavior continued-execution).");
        options.addOption(":print-success", this.mPrintSuccess);
        if (active) {
            this.mOut = new ChannelOption(REG_OUT_CHANNEL_DEF, true, REG_OUT_CHANNEL_DESC);
            options.addOption(REG_OUT_CHANNEL_NAME, this.mOut);
        } else {
            options.addOption(REG_OUT_CHANNEL_NAME, new StringOptionWithWarning(REG_OUT_CHANNEL_DEF, true, REG_OUT_CHANNEL_DESC, "Front End not active.  Option change will not have an effect!", options.getLogProxy()));
            this.mOut = null;
        }
        options.addOption(":print-terms-cse", this.mPrintTermsCSE);
        options.addOption(":continue-on-error", this.mContinueOnError);
    }

    public final boolean isFrontEndActive() {
        return this.mOut != null;
    }

    public final boolean isPrintSuccess() {
        return this.mPrintSuccess.getValue();
    }

    public PrintWriter getOutChannel() {
        return this.mOut.getChannel();
    }

    public final boolean isPrintTermsCSE() {
        return this.mPrintTermsCSE.getValue();
    }

    public final boolean continueOnError() {
        return this.mContinueOnError.getValue();
    }
}

