/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.option;

import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.smtinterpol.ChannelUtil;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.Option;
import java.io.IOException;
import java.io.PrintWriter;

public class ChannelOption
extends Option {
    private String mName;
    private String mDefaultName;
    private PrintWriter mWriter;

    public ChannelOption(String defaultChannel, boolean onlineModifiable, String description) {
        super(onlineModifiable, description);
        this.createChannel(defaultChannel);
        this.mName = this.mDefaultName = defaultChannel;
    }

    public Option copy() {
        return this;
    }

    public void set(Object value) {
        if (value instanceof QuotedObject) {
            value = ((QuotedObject)value).getValue();
        }
        String val = value.toString();
        this.createChannel(val);
        this.mName = val;
    }

    public Object get() {
        return new QuotedObject(this.mName);
    }

    public void reset() {
        this.createChannel(this.mName);
        this.mName = this.mDefaultName;
    }

    public Object defaultValue() {
        return new QuotedObject(this.mDefaultName);
    }

    private void createChannel(String file) {
        try {
            this.mWriter = ChannelUtil.createChannel(file);
        }
        catch (IOException eIO) {
            throw new SMTLIBException(eIO);
        }
    }

    public void started() {
        this.mDefaultName = this.mName;
    }

    public PrintWriter getChannel() {
        return this.mWriter;
    }
}

