/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.model;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Clausifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.BooleanVarAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.ITheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.ArraySortInterpretation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.BoolSortInterpretation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.FiniteSortInterpretation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.FunctionValue;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.ModelEvaluator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.ModelFormatter;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.NumericSortInterpretation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.SharedTermEvaluator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.SortInterpretation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.ArrayTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CClosure;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinArSolve;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Model
implements de.uni_freiburg.informatik.ultimate.logic.Model {
    private final HashMap<Sort, SortInterpretation> mSorts = new HashMap();
    private final HashMap<Sort, ArraySortInterpretation> mArraySorts = new HashMap();
    private final BoolSortInterpretation mBoolSort;
    private final NumericSortInterpretation mNumSorts;
    private final HashMap<FunctionSymbol, FunctionValue> mFuncVals = new HashMap();
    private final Theory mTheory;
    private final ModelEvaluator mEval;
    private final FormulaUnLet mUnlet = new FormulaUnLet(FormulaUnLet.UnletType.EXPAND_DEFINITIONS);
    private final boolean mPartialModel;

    /*
     * WARNING - void declaration
     */
    public Model(Clausifier clausifier, Theory t, boolean partial) {
        this.mTheory = t;
        this.mPartialModel = partial;
        this.mBoolSort = new BoolSortInterpretation();
        this.mNumSorts = new NumericSortInterpretation();
        FunctionValue trueValue = new FunctionValue(this.mBoolSort.getTrueIdx());
        FunctionValue falseValue = new FunctionValue(this.mBoolSort.getFalseIdx());
        for (BooleanVarAtom atom : clausifier.getBooleanVars()) {
            void var9_9;
            ApplicationTerm at = (ApplicationTerm)atom.getSMTFormula(t);
            if (atom.getDecideStatus() == null) {
                FunctionValue functionValue = atom.getPreferredStatus() == atom ? trueValue : falseValue;
            } else {
                FunctionValue functionValue = atom.getDecideStatus() == atom ? trueValue : falseValue;
            }
            this.mFuncVals.put(at.getFunction(), (FunctionValue)var9_9);
        }
        CClosure cc = clausifier.getCClosure();
        LinArSolve la = null;
        ArrayTheory array = null;
        for (ITheory theory : clausifier.getEngine().getAttachedTheories()) {
            if (theory instanceof LinArSolve) {
                la = (LinArSolve)theory;
                continue;
            }
            if (theory instanceof ArrayTheory) {
                array = (ArrayTheory)theory;
                continue;
            }
            if (theory == cc) continue;
            throw new InternalError("Modelproduction for theory not implemented: " + theory);
        }
        SharedTermEvaluator sharedTermEvaluator = new SharedTermEvaluator(la);
        if (la != null) {
            la.fillInModel(this, t, sharedTermEvaluator);
        }
        if (cc != null) {
            cc.fillInModel(this, t, sharedTermEvaluator);
        }
        if (array != null) {
            array.fillInModel(this, t, sharedTermEvaluator);
        }
        if (!partial) {
            for (FunctionSymbol fs : t.getDeclaredFunctions().values()) {
                if (fs.isIntern() || this.mFuncVals.containsKey(fs)) continue;
                SortInterpretation si = this.provideSortInterpretation(fs.getReturnSort());
                si.ensureCapacity(1);
                this.map(fs, 0);
            }
        }
        this.mEval = new ModelEvaluator(this);
    }

    public boolean checkTypeValues(LogProxy logger) {
        boolean correct = true;
        for (Map.Entry<FunctionSymbol, FunctionValue> me : this.mFuncVals.entrySet()) {
            FunctionSymbol fs = me.getKey();
            if (!fs.getReturnSort().getName().equals("Int")) continue;
            if (!this.mNumSorts.get(me.getValue().getDefault()).isIntegral()) {
                correct = false;
                if (fs.getParameterSorts().length == 0) {
                    logger.fatal("Non-integral value for integer variable " + fs);
                } else {
                    logger.fatal("Non-integral default value for function " + fs);
                }
            }
            for (Map.Entry<FunctionValue.Index, Integer> val : me.getValue().values().entrySet()) {
                if (this.mNumSorts.get(val.getValue()).isIntegral()) continue;
                correct = false;
                logger.fatal("Non-integral value for function " + fs + " at index " + me.getKey());
            }
        }
        return correct;
    }

    public int getFalseIdx() {
        return this.mBoolSort.getFalseIdx();
    }

    public int getTrueIdx() {
        return this.mBoolSort.getTrueIdx();
    }

    public int extendNumeric(FunctionSymbol fsym, Rational rat) {
        assert (fsym.getReturnSort().isNumericSort());
        assert (!fsym.getReturnSort().getName().equals("Int") || rat.isIntegral());
        int idx = this.mNumSorts.extend(rat);
        this.mFuncVals.put(fsym, new FunctionValue(idx));
        return idx;
    }

    public int putNumeric(Rational rat) {
        return this.mNumSorts.extend(rat);
    }

    public int extendFresh(Sort s) {
        if (s.isArraySort()) {
            ArraySortInterpretation si = this.mArraySorts.get(s);
            if (si == null) {
                si = new ArraySortInterpretation(this.provideSortInterpretation(s.getArguments()[0]), this.provideSortInterpretation(s.getArguments()[1]));
                this.mArraySorts.put(s, si);
            }
            return si.extendFresh();
        }
        SortInterpretation si = this.mSorts.get(s);
        if (si == null) {
            si = new FiniteSortInterpretation();
            this.mSorts.put(s, si);
        }
        return si.extendFresh();
    }

    @Override
    public Set<FunctionSymbol> getDefinedFunctions() {
        return Collections.unmodifiableSet(this.mFuncVals.keySet());
    }

    Term index2Term(FunctionValue.Index index, TermVariable[] vars) {
        int[] idx = index.getArray();
        assert (vars.length == idx.length);
        Term[] conj = new Term[vars.length];
        for (int i = 0; i < vars.length; ++i) {
            conj[i] = this.mTheory.equals(vars[i], this.toModelTerm(idx[i], vars[i].getSort()));
        }
        return this.mTheory.and(conj);
    }

    public Term getFunctionDefinition(FunctionSymbol fs, TermVariable[] vars) {
        FunctionValue value = this.mFuncVals.get(fs);
        if (value == null) {
            throw new IllegalArgumentException("No model for " + fs);
        }
        if (fs.getParameterSorts().length != vars.length) {
            throw new IllegalArgumentException("Wrong number of variables");
        }
        int defaultVal = value.getDefault();
        Sort resultSort = fs.getReturnSort();
        Term definition = this.toModelTerm(defaultVal, resultSort);
        for (Map.Entry<FunctionValue.Index, Integer> me : value.values().entrySet()) {
            if (me.getValue() == defaultVal) continue;
            Term cond = this.index2Term(me.getKey(), vars);
            Term val = this.toModelTerm(me.getValue(), resultSort);
            definition = this.mTheory.ifthenelse(cond, val, definition);
        }
        return definition;
    }

    @Override
    public Term getFunctionDefinition(String func, TermVariable[] args) {
        Sort[] argTypes = new Sort[args.length];
        for (int i = 0; i < args.length; ++i) {
            argTypes[i] = args[i].getSort();
        }
        FunctionSymbol fs = this.mTheory.getFunction(func, argTypes);
        if (fs == null) {
            throw new IllegalArgumentException("Function " + func + " not defined.");
        }
        return this.getFunctionDefinition(fs, args);
    }

    public FunctionValue map(FunctionSymbol fs, int value) {
        FunctionValue res = this.mFuncVals.get(fs);
        if (res == null) {
            res = new FunctionValue(value);
            this.mFuncVals.put(fs, res);
        }
        assert (res.getDefault() == value);
        return res;
    }

    public FunctionValue map(FunctionSymbol fs, int[] args, int value) {
        assert (fs.getParameterSorts().length == args.length);
        FunctionValue val = this.mFuncVals.get(fs);
        if (val == null) {
            val = new FunctionValue();
            this.mFuncVals.put(fs, val);
        }
        val.put(value, args);
        return val;
    }

    Term getUndefined(Sort s) {
        FunctionSymbol fsym = this.mTheory.getFunctionWithResult("@undefined", null, s, new Sort[0]);
        return this.mTheory.term(fsym, new Term[0]);
    }

    @Override
    public Term evaluate(Term input) {
        Term unletted = this.mUnlet.unlet(input);
        return this.mEval.evaluate(unletted);
    }

    @Override
    public Map<Term, Term> evaluate(Term[] input) {
        LinkedHashMap<Term, Term> values = new LinkedHashMap<Term, Term>();
        for (Term t : input) {
            values.put(t, this.evaluate(t));
        }
        return values;
    }

    public String toString() {
        ModelFormatter mf = new ModelFormatter(this.mTheory, this);
        for (Map.Entry<FunctionSymbol, FunctionValue> me : this.mFuncVals.entrySet()) {
            if (me.getKey().isIntern()) continue;
            mf.appendValue(me.getKey(), me.getValue(), this.mTheory);
        }
        return mf.finish();
    }

    Theory getTheory() {
        return this.mTheory;
    }

    public boolean isPartialModel() {
        return this.mPartialModel;
    }

    public BoolSortInterpretation getBoolSortInterpretation() {
        return this.mBoolSort;
    }

    public NumericSortInterpretation getNumericSortInterpretation() {
        return this.mNumSorts;
    }

    public SortInterpretation provideSortInterpretation(Sort sort) {
        if (sort.isNumericSort()) {
            return this.mNumSorts;
        }
        if (sort == this.mTheory.getBooleanSort()) {
            return this.mBoolSort;
        }
        if (sort.isArraySort()) {
            ArraySortInterpretation array = this.mArraySorts.get(sort);
            if (array == null) {
                array = new ArraySortInterpretation(this.provideSortInterpretation(sort.getArguments()[0]), this.provideSortInterpretation(sort.getArguments()[1]));
                this.mArraySorts.put(sort, array);
            }
            return array;
        }
        SortInterpretation res = this.mSorts.get(sort);
        if (res == null) {
            res = new FiniteSortInterpretation();
            this.mSorts.put(sort, res);
        }
        return res;
    }

    public FunctionValue getFunctionValue(FunctionSymbol fs) {
        return this.mFuncVals.get(fs);
    }

    public Term toModelTerm(int idx, Sort resultSort) {
        if (idx == -1) {
            return this.getUndefined(resultSort);
        }
        if (resultSort == this.mTheory.getBooleanSort()) {
            return this.mBoolSort.get(idx, resultSort, this.mTheory);
        }
        if (resultSort.isNumericSort()) {
            Rational val = this.mNumSorts.get(idx);
            return val.toTerm(resultSort);
        }
        if (resultSort.isArraySort()) {
            ArraySortInterpretation array = this.mArraySorts.get(resultSort);
            if (array == null) {
                if (this.mPartialModel) {
                    return this.getUndefined(resultSort);
                }
                array = new ArraySortInterpretation(this.provideSortInterpretation(resultSort.getArguments()[0]), this.provideSortInterpretation(resultSort.getArguments()[1]));
                this.mArraySorts.put(resultSort, array);
            }
            return array.get(idx, resultSort, this.mTheory);
        }
        SortInterpretation si = this.mSorts.get(resultSort);
        if (si == null) {
            if (this.mPartialModel) {
                return this.getUndefined(resultSort);
            }
            si = new FiniteSortInterpretation();
            si.ensureCapacity(idx + 1);
        }
        return si.get(idx, resultSort, this.mTheory);
    }

    public ArraySortInterpretation getArrayInterpretation(Sort arraySort) {
        return this.mArraySorts.get(arraySort);
    }
}

