/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FunctionValue {
    private Map<Index, Integer> mValues;
    private int mDefault;

    public FunctionValue() {
        this(0);
    }

    public FunctionValue(int idx) {
        this.mDefault = idx;
    }

    public void put(int value, int ... idx) {
        if (idx.length == 0) {
            assert (this.mDefault == 0);
            this.mDefault = value;
        } else {
            if (this.mValues == null) {
                this.mValues = new HashMap<Index, Integer>();
            }
            this.mValues.put(new Index(idx), value);
        }
    }

    public int get(int[] idx, boolean partial) {
        if (idx == null || idx.length == 0) {
            return this.mDefault;
        }
        if (this.mValues == null) {
            return partial ? -1 : this.mDefault;
        }
        Integer res = this.mValues.get(new Index(idx));
        return res == null ? (partial ? -1 : this.mDefault) : res;
    }

    public int getDefault() {
        return this.mDefault;
    }

    public Map<Index, Integer> values() {
        Map empty = Collections.emptyMap();
        return this.mValues == null ? empty : this.mValues;
    }

    static class Index {
        private final int[] mIdx;
        private final int mHash;

        public Index(int[] idx) {
            this.mIdx = idx;
            this.mHash = Arrays.hashCode(this.mIdx);
        }

        public int hashCode() {
            return this.mHash;
        }

        public boolean equals(Object o) {
            if (o instanceof Index) {
                return Arrays.equals(this.mIdx, ((Index)o).mIdx);
            }
            return false;
        }

        public int[] getArray() {
            return this.mIdx;
        }

        public String toString() {
            return Arrays.toString(this.mIdx);
        }
    }
}

