/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.model;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.SortInterpretation;
import java.util.Iterator;

public class ArrayValue {
    public static final ArrayValue DEFAULT_ARRAY = new ArrayValue(null);
    private final IntIntMap mValues;
    private IntIntMap mDiffMap;

    public ArrayValue() {
        this(new IntIntMap());
    }

    private ArrayValue(IntIntMap map) {
        this.mValues = map;
        this.mDiffMap = null;
    }

    public int store(int idx, int val) {
        if (val == 0) {
            return this.mValues.remove(idx);
        }
        return this.mValues.add(idx, val);
    }

    public int select(int idx, boolean partial) {
        return this.mValues == null ? 0 : this.mValues.get(idx, partial);
    }

    public int hashCode() {
        return this.mValues == null ? 0 : this.mValues.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof ArrayValue)) {
            return false;
        }
        if (this == DEFAULT_ARRAY) {
            return other == DEFAULT_ARRAY;
        }
        if (this.mValues.getSize() == 0) {
            return other == DEFAULT_ARRAY;
        }
        return this.mValues.equals(((ArrayValue)other).mValues);
    }

    ArrayValue copy() {
        IntIntMap copy = this.mValues == null ? new IntIntMap() : new IntIntMap(this.mValues);
        return new ArrayValue(copy);
    }

    public Term toSMTLIB(Sort s, Theory t, SortInterpretation index, SortInterpretation value) {
        ApplicationTerm res = t.term(t.getFunctionWithResult("@0", null, s, new Sort[0]), new Term[0]);
        if (this.mValues.getSize() != 0) {
            Sort indexSort = s.getArguments()[0];
            Sort valueSort = s.getArguments()[1];
            FunctionSymbol store = t.getFunction("store", s, indexSort, valueSort);
            for (Entry e : this.mValues.backwardInsertionOrder()) {
                res = t.term(store, res, index.get(e.getKey(), indexSort, t), value.get(e.getValue(), valueSort, t));
            }
        }
        return res;
    }

    public boolean containsMapping(int val) {
        return this.mValues == null ? false : this.mValues.containsKey(val);
    }

    public void addDiff(int snd, int val) {
        if (this.mDiffMap == null) {
            this.mDiffMap = new IntIntMap();
        }
        this.mDiffMap.add(snd, val);
    }

    public int computeDiff(int idx, ArrayValue other) {
        if (this.mValues == null) {
            return other == this ? 0 : other.computeDiff(0, this);
        }
        if (this.mDiffMap != null && this.mDiffMap.containsKey(idx)) {
            return this.mDiffMap.get(idx, false);
        }
        for (Entry e : this.mValues.forwardInsertionOrder()) {
            if (other.select(e.getKey(), false) == e.getValue()) continue;
            return e.getKey();
        }
        assert (this == other);
        return 0;
    }

    public String toString() {
        return this.mValues == null ? "@0" : this.mValues.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntIntMap {
        Entry[] mTable;
        int mSize;
        int mThreshold;
        final Entry mList;
        private static final float LOAD_FACTOR = 0.75f;

        public IntIntMap() {
            this(8);
        }

        public IntIntMap(int capacity) {
            this.mTable = new Entry[capacity];
            this.mSize = 0;
            this.mThreshold = (int)((float)capacity * 0.75f);
            this.mList = new Entry();
        }

        public IntIntMap(IntIntMap other) {
            this.mTable = new Entry[other.mTable.length];
            this.mSize = 0;
            this.mThreshold = other.mThreshold;
            this.mList = new Entry();
            for (Entry e : other.forwardInsertionOrder()) {
                this.add(e.getKey(), e.getValue());
            }
        }

        private int idx2bucket(int idx) {
            return idx & this.mTable.length - 1;
        }

        private void grow() {
            Entry[] old = this.mTable;
            this.mTable = new Entry[this.mTable.length << 1];
            this.mThreshold = (int)((float)this.mTable.length * 0.75f);
            Entry[] entryArray = old;
            int n = entryArray.length;
            for (int i = 0; i < n; ++i) {
                Entry e;
                Entry bucket = e = entryArray[i];
                while (bucket != null) {
                    int idx = this.idx2bucket(bucket.mKey);
                    Entry reinsert = bucket;
                    bucket = bucket.mNext;
                    reinsert.mNext = this.mTable[idx];
                    this.mTable[idx] = reinsert;
                }
            }
        }

        public int add(int key, int value) {
            int hash;
            Entry e;
            if (this.mSize >= this.mThreshold) {
                this.grow();
            }
            if ((e = this.findEntry(hash = this.idx2bucket(key), key)) == null) {
                ++this.mSize;
                this.mTable[hash] = e = new Entry(key, value, this.mTable[hash], this.mList);
                return value;
            }
            return e.setValue(value);
        }

        public int remove(int key) {
            int hash = this.idx2bucket(key);
            Entry prev = null;
            Entry bucket = this.mTable[hash];
            while (bucket != null) {
                if (bucket.getKey() == key) {
                    bucket.unlink();
                    if (prev == null) {
                        this.mTable[hash] = bucket.mNext;
                    } else {
                        prev.mNext = bucket.mNext;
                    }
                    --this.mSize;
                    return bucket.getValue();
                }
                prev = bucket;
                bucket = bucket.mNext;
            }
            return 0;
        }

        public int get(int key, boolean partial) {
            int hash = this.idx2bucket(key);
            Entry e = this.findEntry(hash, key);
            if (e == null) {
                return partial ? -1 : 0;
            }
            return e.getValue();
        }

        private Entry findEntry(int hash, int key) {
            Entry bucket = this.mTable[hash];
            while (bucket != null) {
                if (bucket.getKey() == key) {
                    return bucket;
                }
                bucket = bucket.mNext;
            }
            return null;
        }

        public boolean containsKey(int key) {
            int hash = this.idx2bucket(key);
            return this.findEntry(hash, key) != null;
        }

        public int getSize() {
            return this.mSize;
        }

        public int hashCode() {
            int hash = 0;
            for (Entry e : this.forwardInsertionOrder()) {
                hash += e.hashCode();
            }
            return hash;
        }

        public boolean equals(Object other) {
            if (!(other instanceof IntIntMap)) {
                return false;
            }
            IntIntMap o = (IntIntMap)other;
            if (o.getSize() != this.mSize) {
                return false;
            }
            for (Entry e : o.forwardInsertionOrder()) {
                int hash = this.idx2bucket(e.getKey());
                Entry my = this.findEntry(hash, e.getKey());
                if (my != null && my.getValue() == e.getValue()) continue;
                return false;
            }
            return true;
        }

        public Iterable<Entry> forwardInsertionOrder() {
            return new Iterable<Entry>(){

                @Override
                public Iterator<Entry> iterator() {
                    return new Iterator<Entry>(){
                        private Entry mCur;
                        {
                            this.mCur = IntIntMap.this.mList.mListNext;
                        }

                        @Override
                        public boolean hasNext() {
                            return this.mCur != IntIntMap.this.mList;
                        }

                        @Override
                        public Entry next() {
                            Entry cur = this.mCur;
                            this.mCur = this.mCur.mListNext;
                            return cur;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }

        public Iterable<Entry> backwardInsertionOrder() {
            return new Iterable<Entry>(){

                @Override
                public Iterator<Entry> iterator() {
                    return new Iterator<Entry>(){
                        private Entry mCur;
                        {
                            this.mCur = IntIntMap.this.mList.mListPrev;
                        }

                        @Override
                        public boolean hasNext() {
                            return this.mCur != IntIntMap.this.mList;
                        }

                        @Override
                        public Entry next() {
                            Entry cur = this.mCur;
                            this.mCur = this.mCur.mListPrev;
                            return cur;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            for (Entry e : this.forwardInsertionOrder()) {
                sb.append(e);
            }
            sb.append('}');
            return sb.toString();
        }
    }

    private static class Entry {
        private final int mKey;
        private int mValue;
        private Entry mNext;
        private Entry mListNext;
        private Entry mListPrev;

        Entry() {
            this.mKey = -2;
            this.mValue = -2;
            this.mNext = null;
            this.mListNext = this.mListPrev = this;
        }

        public Entry(int key, int value, Entry next, Entry sentinel) {
            this.mKey = key;
            this.mValue = value;
            this.mNext = next;
            this.mListNext = sentinel;
            this.mListPrev = sentinel.mListPrev;
            sentinel.mListPrev.mListNext = this;
            sentinel.mListPrev = this;
        }

        public void unlink() {
            this.mListNext.mListPrev = this.mListPrev;
            this.mListPrev.mListNext = this.mListNext;
        }

        public int getKey() {
            return this.mKey;
        }

        public int getValue() {
            return this.mValue;
        }

        public int setValue(int value) {
            int res = this.mValue;
            this.mValue = value;
            return res;
        }

        public int hashCode() {
            return this.mKey + 3643 * this.mValue;
        }

        public String toString() {
            return "[" + this.mKey + "," + this.mValue + "]";
        }
    }
}

