/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate;

import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.Interpolant;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.Interpolator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.InterpolatorAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.LATerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.BoundConstraint;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitNumber;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinVar;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MutableAffinTerm;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;

public class LAInterpolator {
    Interpolator mInterpolator;
    LAAnnotation mAnnotation;
    HashMap<LAAnnotation, AnnotInfo> mAuxInfos = new HashMap();

    public LAInterpolator(Interpolator interpolator, LAAnnotation theoryAnnotation) {
        this.mInterpolator = interpolator;
        this.mAnnotation = theoryAnnotation;
    }

    private AnnotInfo computeAuxAnnotations(LAAnnotation auxAnnot) {
        AnnotInfo result = this.mAuxInfos.get(auxAnnot);
        if (result != null) {
            return result;
        }
        result = new AnnotInfo(auxAnnot);
        result.mInterpolants = new Interpolant[this.mInterpolator.mNumInterpolants];
        for (int i = 0; i < this.mInterpolator.mNumInterpolants; ++i) {
            result.mInterpolants[i] = new Interpolant();
        }
        for (LAAnnotation annot : auxAnnot.getAuxAnnotations().keySet()) {
            this.computeAuxAnnotations(annot);
        }
        this.interpolateLeaf(auxAnnot, result);
        this.interpolateInnerNode(auxAnnot, result);
        this.mAuxInfos.put(auxAnnot, result);
        return result;
    }

    private void interpolateLeaf(LAAnnotation auxAnnot, AnnotInfo result) {
        InterpolatorAffineTerm[] ipl = new InterpolatorAffineTerm[this.mInterpolator.mNumInterpolants + 1];
        for (int part = 0; part < ipl.length; ++part) {
            ipl[part] = new InterpolatorAffineTerm();
        }
        ArrayList[] auxVars = new ArrayList[this.mInterpolator.mNumInterpolants];
        Literal equality = null;
        Interpolator.Occurrence equalityInfo = null;
        Interpolator.Occurrence inequalityInfo = null;
        if (auxAnnot != this.mAnnotation) {
            for (int part = result.mInB.nextClearBit(0); part < ipl.length; ++part) {
                Rational rational;
                Rational rational2 = rational = auxAnnot.isUpper() ? Rational.MONE : Rational.ONE;
                if (result.isMixed(part)) {
                    ipl[part].add(rational, result.getMixedSum(part));
                    if (auxVars[part] == null) {
                        auxVars[part] = new ArrayList();
                    }
                    auxVars[part].add(result.mAuxVar);
                }
                if (!result.isALocal(part)) continue;
                ipl[part].add(rational, result.getSum());
                ipl[part].add(result.getEpsilon());
            }
        }
        for (Map.Entry<LAAnnotation, Rational> entry : auxAnnot.getAuxAnnotations().entrySet()) {
            AnnotInfo info = this.mAuxInfos.get(entry.getKey());
            Rational coeff = entry.getValue();
            for (int part = info.mInB.nextClearBit(0); part < ipl.length; ++part) {
                if (info.isMixed(part)) {
                    ipl[part].add(coeff, info.getMixedSum(part));
                    if (auxVars[part] == null) {
                        auxVars[part] = new ArrayList();
                    }
                    auxVars[part].add(info.mAuxVar);
                }
                if (!info.isALocal(part)) continue;
                ipl[part].add(coeff, info.getSum());
            }
            inequalityInfo = info;
        }
        for (Map.Entry<Object, Rational> entry : auxAnnot.getCoefficients().entrySet()) {
            Literal lit = ((Literal)entry.getKey()).negate();
            Rational factor = entry.getValue();
            if (lit.getAtom() instanceof BoundConstraint || lit instanceof LAEquality) {
                LinVar lv;
                InfinitNumber bound;
                if (lit.getAtom() instanceof BoundConstraint) {
                    assert (factor.signum() == lit.getSign());
                    BoundConstraint bc = (BoundConstraint)lit.getAtom();
                    bound = lit.getSign() > 0 ? bc.getBound() : bc.getInverseBound();
                    lv = bc.getVar();
                } else {
                    assert (lit instanceof LAEquality);
                    LAEquality eq = (LAEquality)lit;
                    lv = eq.getVar();
                    bound = new InfinitNumber(eq.getBound(), 0);
                }
                Interpolator.LitInfo info = this.mInterpolator.getLiteralInfo(lit.getAtom());
                inequalityInfo = info;
                for (int part = info.mInB.nextClearBit(0); part < ipl.length; ++part) {
                    if (info.isMixed(part)) {
                        assert (info.mMixedVar != null);
                        ipl[part].add(factor, info.getAPart(part));
                        ipl[part].add(factor.negate(), info.mMixedVar);
                        if (auxVars[part] == null) {
                            auxVars[part] = new ArrayList();
                        }
                        auxVars[part].add(info.mMixedVar);
                    }
                    if (!info.isALocal(part)) continue;
                    ipl[part].add(factor, lv);
                    ipl[part].add(bound.negate().mul(factor));
                }
                continue;
            }
            if (!(lit.negate() instanceof LAEquality)) continue;
            equality = lit.negate();
            LAEquality eq = (LAEquality)equality;
            assert (auxAnnot.getAuxAnnotations().size() + auxAnnot.getCoefficients().size() + (auxAnnot == this.mAnnotation ? 0 : 1) == 3);
            assert (equalityInfo == null);
            equalityInfo = this.mInterpolator.getLiteralInfo(eq);
            assert (factor.abs() == Rational.ONE);
            for (int part = ((Interpolator.LitInfo)equalityInfo).mInB.nextClearBit(0); part < ipl.length; ++part) {
                if (!equalityInfo.isALocal(part)) continue;
                ipl[part].add(eq.getVar().getEpsilon());
            }
        }
        assert (ipl[ipl.length - 1].isConstant() && InfinitNumber.ZERO.less(ipl[ipl.length - 1].getConstant()));
        for (int part = 0; part < auxVars.length; ++part) {
            Rational rational = ipl[part].isConstant() ? Rational.ONE : ipl[part].getGCD().inverse().abs();
            ipl[part].mul(rational);
            if (ipl[part].isInt()) {
                ipl[part].mConstant = ipl[part].getConstant().ceil();
            }
            if (auxVars[part] != null) {
                Term F;
                InfinitNumber k;
                if (equalityInfo != null) {
                    assert (equalityInfo.isMixed(part));
                    assert (auxVars[part].size() == 2);
                    assert (rational == Rational.ONE);
                    InterpolatorAffineTerm less = new InterpolatorAffineTerm(ipl[part]).add(InfinitNumber.EPSILON);
                    k = InfinitNumber.ZERO;
                    F = this.mInterpolator.mTheory.and(ipl[part].toLeq0(this.mInterpolator.mTheory), this.mInterpolator.mTheory.or(less.toLeq0(this.mInterpolator.mTheory), this.mInterpolator.mTheory.equals(((Interpolator.LitInfo)equalityInfo).getMixedVar(), (Term)auxVars[part].iterator().next())));
                } else {
                    k = ipl[part].isInt() ? InfinitNumber.ONE.negate() : InfinitNumber.EPSILON.negate();
                    F = ipl[part].toLeq0(this.mInterpolator.mTheory);
                }
                LATerm laTerm = new LATerm(ipl[part], k, F);
                result.mInterpolants[part].mTerm = laTerm;
                continue;
            }
            assert (equalityInfo == null || !equalityInfo.isMixed(part));
            if (equalityInfo != null && ipl[part].isConstant() && equalityInfo.isALocal(part) != inequalityInfo.isALocal(part)) {
                Literal thisIpl = equalityInfo.isALocal(part) ? equality.negate() : equality;
                result.mInterpolants[part].mTerm = thisIpl.getSMTFormula(this.mInterpolator.mTheory);
                continue;
            }
            result.mInterpolants[part].mTerm = ipl[part].toLeq0(this.mInterpolator.mTheory);
        }
    }

    private void interpolateInnerNode(LAAnnotation auxAnnot, AnnotInfo result) {
        for (Map.Entry<LAAnnotation, Rational> auxAnn : auxAnnot.getAuxAnnotations().entrySet()) {
            LAAnnotation annot = auxAnn.getKey();
            AnnotInfo subInfo = this.computeAuxAnnotations(annot);
            for (int part = 0; part < this.mInterpolator.mNumInterpolants; ++part) {
                if (subInfo.isBLocal(part)) {
                    result.mInterpolants[part].mTerm = this.mInterpolator.mTheory.and(result.mInterpolants[part].mTerm, subInfo.mInterpolants[part].mTerm);
                    continue;
                }
                if (subInfo.isMixed(part)) {
                    TermVariable mixedVar = subInfo.mAuxVar;
                    result.mInterpolants[part] = this.mInterpolator.mixedPivotLA(result.mInterpolants[part], subInfo.mInterpolants[part], mixedVar);
                    continue;
                }
                if (subInfo.isAB(part)) {
                    MutableAffinTerm mat = new MutableAffinTerm();
                    Rational coeff = annot.isUpper() ? Rational.ONE : Rational.MONE;
                    mat.add(coeff, subInfo.getSum());
                    result.mInterpolants[part].mTerm = this.mInterpolator.mTheory.ifthenelse(mat.toSMTLibLeq0(this.mInterpolator.mTheory, false), result.mInterpolants[part].mTerm, subInfo.mInterpolants[part].mTerm);
                    continue;
                }
                result.mInterpolants[part].mTerm = this.mInterpolator.mTheory.or(result.mInterpolants[part].mTerm, subInfo.mInterpolants[part].mTerm);
            }
        }
    }

    public Interpolant[] computeInterpolants() {
        AnnotInfo annotInfo = this.computeAuxAnnotations(this.mAnnotation);
        return annotInfo.mInterpolants;
    }

    class AnnotInfo
    extends Interpolator.Occurrence {
        LAAnnotation mMyAnnotation;
        private MutableAffinTerm mSum;
        Interpolant[] mInterpolants;
        InterpolatorAffineTerm[] mMixedSums;
        TermVariable mAuxVar;
        InfinitNumber mEpsilon;

        public AnnotInfo(LAAnnotation auxAnnot) {
            this.mMyAnnotation = auxAnnot;
            if (!auxAnnot.equals(LAInterpolator.this.mAnnotation)) {
                this.computeSum();
                this.color();
                this.computeMixedSums();
            }
        }

        private void computeSum() {
            this.mSum = new MutableAffinTerm();
            this.mSum.add(Rational.ONE, this.mMyAnnotation.getLinVar());
            this.mSum.add(this.mMyAnnotation.getBound().negate());
            this.mEpsilon = this.mMyAnnotation.getLinVar().getEpsilon();
        }

        private void color() {
            boolean isFirst = true;
            for (LinVar lv : this.mSum.getSummands().keySet()) {
                Interpolator.Occurrence occ = LAInterpolator.this.mInterpolator.getOccurrence(lv.getSharedTerm());
                assert (occ != null);
                if (isFirst) {
                    this.mInA.or(occ.mInA);
                    this.mInB.or(occ.mInB);
                    isFirst = false;
                    continue;
                }
                this.mInA.and(occ.mInA);
                this.mInB.and(occ.mInB);
            }
        }

        private void computeMixedSums() {
            BitSet shared = new BitSet();
            shared.or(this.mInA);
            shared.or(this.mInB);
            if (shared.nextClearBit(0) == LAInterpolator.this.mInterpolator.mNumInterpolants) {
                return;
            }
            Sort sort = LAInterpolator.this.mInterpolator.mTheory.getSort(this.mMyAnnotation.getLinVar().isInt() ? "Int" : "Real", new Sort[0]);
            this.mMixedSums = new InterpolatorAffineTerm[LAInterpolator.this.mInterpolator.mNumInterpolants];
            this.mAuxVar = LAInterpolator.this.mInterpolator.mTheory.createFreshTermVariable("msaux", sort);
            for (int part = 0; part < LAInterpolator.this.mInterpolator.mNumInterpolants; ++part) {
                if (!this.isMixed(part)) continue;
                InterpolatorAffineTerm sumApart = new InterpolatorAffineTerm();
                LinVar lv = this.mMyAnnotation.getLinVar();
                for (Map.Entry<LinVar, BigInteger> en : lv.getLinTerm().entrySet()) {
                    Interpolator.Occurrence occ = LAInterpolator.this.mInterpolator.getOccurrence(en.getKey().getSharedTerm());
                    if (!occ.isALocal(part)) continue;
                    Rational coeff = Rational.valueOf(en.getValue(), BigInteger.ONE);
                    sumApart.add(coeff, en.getKey());
                }
                sumApart.add(Rational.MONE, this.mAuxVar);
                this.mMixedSums[part] = sumApart;
            }
        }

        private MutableAffinTerm getSum() {
            return this.mSum;
        }

        InterpolatorAffineTerm getMixedSum(int part) {
            return this.mMixedSums[part];
        }

        public InfinitNumber getEpsilon() {
            return this.mEpsilon;
        }
    }
}

