/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate;

import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SharedTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitNumber;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinVar;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MutableAffinTerm;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterpolatorAffineTerm {
    Map<Term, Rational> mSummands = new HashMap<Term, Rational>();
    InfinitNumber mConstant;

    public InterpolatorAffineTerm() {
        this.mConstant = InfinitNumber.ZERO;
    }

    public InterpolatorAffineTerm(InterpolatorAffineTerm iat) {
        this.mConstant = iat.getConstant();
        this.mSummands.putAll(iat.getSummands());
    }

    public InterpolatorAffineTerm(Map<LinVar, Rational> sum, InfinitNumber c) {
        this.mConstant = c;
        for (Map.Entry<LinVar, Rational> entry : sum.entrySet()) {
            this.mSummands.put(entry.getKey().getSharedTerm().getTerm(), entry.getValue());
        }
    }

    public InterpolatorAffineTerm(MutableAffinTerm mat) {
        this(mat.getSummands(), mat.getConstant());
    }

    public InterpolatorAffineTerm add(Rational c) {
        this.mConstant = this.mConstant.add(new InfinitNumber(c, 0));
        return this;
    }

    public InterpolatorAffineTerm add(InfinitNumber c) {
        this.mConstant = this.mConstant.add(c);
        return this;
    }

    public InterpolatorAffineTerm add(Rational c, MutableAffinTerm a) {
        if (c != Rational.ZERO) {
            this.addLinVarMap(c, a.getSummands());
            this.mConstant = this.mConstant.add(a.getConstant().mul(c));
        }
        return this;
    }

    public InterpolatorAffineTerm add(Rational c, Term term) {
        if (!c.equals(Rational.ZERO)) {
            this.addSimple(c, term);
        }
        return this;
    }

    public InterpolatorAffineTerm add(Rational c, SharedTerm term) {
        if (c.equals(Rational.ZERO)) {
            return this;
        }
        if (term.getTerm() instanceof SMTAffineTerm) {
            this.add(c, term.getClausifier().createMutableAffinTerm(term));
        } else {
            this.addSimple(c, term.getLinVar());
        }
        return this;
    }

    public InterpolatorAffineTerm add(Rational c, LinVar var) {
        if (c.equals(Rational.ZERO)) {
            return this;
        }
        if (var.isInitiallyBasic()) {
            for (Map.Entry<LinVar, BigInteger> me : var.getLinTerm().entrySet()) {
                this.add(c.mul(me.getValue()), me.getKey());
            }
        } else {
            this.addSimple(c, var);
        }
        return this;
    }

    private void addLinVarMap(Rational c, Map<LinVar, Rational> linterm) {
        for (Map.Entry<LinVar, Rational> summand : linterm.entrySet()) {
            this.addSimple(c.mul(summand.getValue()), summand.getKey());
        }
    }

    private void addMap(Rational c, Map<Term, Rational> linterm) {
        for (Map.Entry<Term, Rational> summand : linterm.entrySet()) {
            this.addSimple(c.mul(summand.getValue()), summand.getKey());
        }
    }

    private void addSimple(Rational c, LinVar term) {
        this.addSimple(c, term.getSharedTerm().getRealTerm());
    }

    private void addSimple(Rational c, Term term) {
        assert (!c.equals(Rational.ZERO));
        Rational oldc = this.mSummands.remove(term);
        if (oldc != null && (c = oldc.add(c)).equals(Rational.ZERO)) {
            return;
        }
        this.mSummands.put(term, c);
    }

    public InterpolatorAffineTerm add(Rational c, InterpolatorAffineTerm a) {
        if (c != Rational.ZERO) {
            this.addMap(c, a.mSummands);
            this.mConstant = this.mConstant.add(a.mConstant.mul(c));
        }
        return this;
    }

    public InterpolatorAffineTerm mul(Rational c) {
        if (c.equals(Rational.ZERO)) {
            this.mSummands.clear();
        } else if (!c.equals(Rational.ONE)) {
            for (Map.Entry<Term, Rational> summand : this.mSummands.entrySet()) {
                summand.setValue(c.mul(summand.getValue()));
            }
            this.mConstant = this.mConstant.mul(c);
        }
        return this;
    }

    public InterpolatorAffineTerm div(Rational c) {
        return this.mul(c.inverse());
    }

    public InterpolatorAffineTerm negate() {
        return this.mul(Rational.MONE);
    }

    public boolean isConstant() {
        return this.mSummands.isEmpty();
    }

    public InfinitNumber getConstant() {
        return this.mConstant;
    }

    public Map<Term, Rational> getSummands() {
        return this.mSummands;
    }

    public Rational getGCD() {
        assert (!this.mSummands.isEmpty());
        Iterator<Rational> it = this.mSummands.values().iterator();
        Rational gcd = it.next();
        boolean firstSign = gcd.isNegative();
        gcd = gcd.abs();
        while (it.hasNext()) {
            gcd = gcd.gcd(it.next().abs());
        }
        if (firstSign) {
            gcd = gcd.negate();
        }
        return gcd;
    }

    void normalize() {
        this.mul(this.getGCD().inverse());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry<Term, Rational> entry : this.mSummands.entrySet()) {
            Term var = entry.getKey();
            Rational fact = entry.getValue();
            if (fact.isNegative()) {
                sb.append(isFirst ? "-" : " - ");
            } else {
                sb.append(isFirst ? "" : " + ");
            }
            fact = fact.abs();
            if (!fact.equals(Rational.ONE)) {
                sb.append(fact).append('*');
            }
            sb.append(var);
            isFirst = false;
        }
        if (isFirst) {
            sb.append(this.mConstant);
        } else {
            int signum = this.mConstant.compareTo(InfinitNumber.ZERO);
            if (signum < 0) {
                sb.append(" - ");
                sb.append(this.mConstant.mul(Rational.MONE));
            } else if (signum > 0) {
                sb.append(" + ");
                sb.append(this.mConstant);
            }
        }
        return sb.toString();
    }

    public Term toSMTLib(Theory t, boolean isInt) {
        Sort numSort;
        assert (this.mConstant.mEps == 0);
        Sort sort = numSort = isInt ? t.getSort("Int", new Sort[0]) : t.getSort("Real", new Sort[0]);
        assert (numSort != null);
        Sort[] binfunc = new Sort[]{numSort, numSort};
        FunctionSymbol times = t.getFunction("*", binfunc);
        FunctionSymbol plus = t.getFunction("+", binfunc);
        FunctionSymbol negate = t.getFunction("-", numSort);
        if (negate == null) {
            negate = t.getFunction("-", numSort);
        }
        assert (!isInt || this.mConstant.mA.isIntegral());
        Term comb = this.mConstant.mA.equals(Rational.ZERO) ? null : (isInt ? t.numeral(this.mConstant.mA.numerator()) : t.rational(this.mConstant.mA.numerator(), this.mConstant.mA.denominator()));
        for (Map.Entry<Term, Rational> me : this.mSummands.entrySet()) {
            Term convme = me.getKey();
            assert (!isInt || convme.getSort().getName().equals("Int"));
            assert (!isInt || me.getValue().isIntegral());
            if (!isInt && convme.getSort().getName().equals("Int")) {
                Sort intSort = t.getSort("Int", new Sort[0]);
                FunctionSymbol toReal = t.getFunction("to_real", intSort);
                convme = t.term(toReal, convme);
            }
            if (me.getValue().equals(Rational.MONE)) {
                convme = t.term(negate, convme);
            } else if (!me.getValue().equals(Rational.ONE)) {
                Term convfac = isInt ? t.numeral(me.getValue().numerator()) : t.rational(me.getValue().numerator(), me.getValue().denominator());
                convme = t.term(times, convfac, convme);
            }
            if (comb == null) {
                comb = convme;
                continue;
            }
            comb = t.term(plus, convme, comb);
        }
        if (comb == null) {
            return isInt ? t.numeral(BigInteger.ZERO) : t.rational(BigInteger.ZERO, BigInteger.ONE);
        }
        return comb;
    }

    public boolean isInt() {
        for (Term v : this.mSummands.keySet()) {
            if (v.getSort().getName().equals("Int")) continue;
            return false;
        }
        return true;
    }

    public Term toLeq0(Theory t) {
        Term trcomb;
        Term tlcomb;
        InfinitNumber constant;
        Sort numSort;
        assert (this.mConstant.mEps >= 0);
        if (this.isConstant()) {
            return this.mConstant.compareTo(InfinitNumber.ZERO) <= 0 ? t.mTrue : t.mFalse;
        }
        boolean isInt = this.isInt();
        Sort sort = numSort = isInt ? t.getSort("Int", new Sort[0]) : t.getSort("Real", new Sort[0]);
        assert (numSort != null);
        Sort[] binfunc = new Sort[]{numSort, numSort};
        FunctionSymbol times = t.getFunction("*", binfunc);
        ArrayList<Term> lcomb = new ArrayList<Term>();
        ArrayList<Term> rcomb = new ArrayList<Term>();
        for (Map.Entry<Term, Rational> me : this.mSummands.entrySet()) {
            Term convfac;
            Rational cf;
            Term convme = me.getKey();
            assert (!isInt || convme.getSort().getName().equals("Int"));
            assert (!isInt || me.getValue().isIntegral());
            if (!isInt && convme.getSort().getName().equals("Int")) {
                Sort intSort = t.getSort("Int", new Sort[0]);
                FunctionSymbol toReal = t.getFunction("to_real", intSort);
                convme = t.term(toReal, convme);
            }
            if (me.getValue().equals(Rational.MONE)) {
                rcomb.add(convme);
                continue;
            }
            if (me.getValue().signum() < 0) {
                cf = me.getValue().abs();
                convfac = isInt ? t.numeral(cf.numerator()) : t.rational(cf.numerator(), cf.denominator());
                rcomb.add(t.term(times, convfac, convme));
                continue;
            }
            if (me.getValue().equals(Rational.ONE)) {
                lcomb.add(convme);
                continue;
            }
            if (me.getValue().signum() <= 0) continue;
            cf = me.getValue();
            convfac = isInt ? t.numeral(cf.numerator()) : t.rational(cf.numerator(), cf.denominator());
            lcomb.add(t.term(times, convfac, convme));
        }
        InfinitNumber infinitNumber = constant = isInt ? this.mConstant.ceil() : this.mConstant;
        if (!constant.mA.equals(Rational.ZERO)) {
            rcomb.add(isInt ? t.numeral(constant.mA.numerator().negate()) : t.rational(constant.mA.numerator().negate(), constant.mA.denominator()));
        }
        if (lcomb.isEmpty() && rcomb.isEmpty()) {
            return constant.mEps == 0 ? t.mTrue : t.mFalse;
        }
        FunctionSymbol plus = t.getFunction("+", binfunc);
        switch (lcomb.size()) {
            case 0: {
                tlcomb = isInt ? t.numeral(BigInteger.ZERO) : t.decimal(BigDecimal.ZERO);
                break;
            }
            case 1: {
                tlcomb = (Term)lcomb.get(0);
                break;
            }
            default: {
                tlcomb = t.term(plus, lcomb.toArray(new Term[lcomb.size()]));
            }
        }
        switch (rcomb.size()) {
            case 0: {
                trcomb = isInt ? t.numeral(BigInteger.ZERO) : t.decimal(BigDecimal.ZERO);
                break;
            }
            case 1: {
                trcomb = (Term)rcomb.get(0);
                break;
            }
            default: {
                trcomb = t.term(plus, rcomb.toArray(new Term[rcomb.size()]));
            }
        }
        return t.term(constant.mEps == 0 ? "<=" : "<", tlcomb, trcomb);
    }

    public int hashCode() {
        return this.mConstant.hashCode() + 1021 * this.mSummands.hashCode();
    }
}

