/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Clausifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SharedTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.IAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.CCInterpolator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.Interpolant;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.InterpolatorAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.LAInterpolator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.LATerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.LeafNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ResolutionNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.SourceAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.SMTInterpol;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.BoundConstraint;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitNumber;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinVar;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MutableAffinTerm;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Interpolator
extends NonRecursive {
    SMTInterpol mSmtSolver;
    Script mCheckingSolver;
    LogProxy mLogger;
    Theory mTheory;
    int mNumInterpolants;
    int[] mStartOfSubtrees;
    HashMap<SharedTerm, Occurrence> mSymbolPartition;
    HashMap<DPLLAtom, LitInfo> mLiteralInfos;
    HashMap<String, Integer> mPartitions;
    HashMap<Clause, Interpolant[]> mInterpolants;
    private final ArrayDeque<Interpolant[]> mInterpolated = new ArrayDeque();

    public Interpolator(LogProxy logger, SMTInterpol smtSolver, Script checkingSolver, Theory theory, Set<String>[] partitions, int[] startOfSubTrees) {
        this.mPartitions = new HashMap();
        for (int i = 0; i < partitions.length; ++i) {
            Integer part = i;
            for (String name : partitions[i]) {
                this.mPartitions.put(name, part);
            }
        }
        this.mLogger = logger;
        this.mSmtSolver = smtSolver;
        this.mCheckingSolver = checkingSolver;
        this.mTheory = theory;
        this.mNumInterpolants = partitions.length - 1;
        this.mStartOfSubtrees = startOfSubTrees;
        this.mSymbolPartition = new HashMap();
        this.mLiteralInfos = new HashMap();
        this.mInterpolants = new HashMap();
    }

    public Term[] getInterpolants(Clause refutation) {
        this.colorLiterals(refutation, new HashSet<Clause>());
        Interpolant[] eqitps = this.interpolate(refutation);
        Term[] itpTerms = new Term[eqitps.length];
        for (int i = 0; i < eqitps.length; ++i) {
            itpTerms[i] = this.unfoldLAs(eqitps[i]);
        }
        return itpTerms;
    }

    public Interpolant[] interpolate(Clause clause) {
        if (this.mInterpolants.containsKey(clause)) {
            this.mLogger.debug("Clause {0} has been interpolated before.", clause);
            return this.mInterpolants.get(clause);
        }
        if (this.mSmtSolver.isTerminationRequested()) {
            throw new SMTLIBException("Timeout exceeded");
        }
        Interpolant[] interpolants = null;
        this.run(new ProofTreeWalker(clause));
        interpolants = this.collectInterpolated();
        return interpolants;
    }

    private void walkResolutionNode(Clause clause) {
        if (this.mSmtSolver.isTerminationRequested()) {
            throw new SMTLIBException("Timeout exceeded");
        }
        ResolutionNode resNode = (ResolutionNode)clause.getProof();
        Clause prim = resNode.getPrimary();
        ResolutionNode.Antecedent[] assump = resNode.getAntecedents();
        int antNumber = assump.length;
        this.enqueueWalker(new SummarizeResolution(clause));
        for (int i = antNumber - 1; i >= 0; --i) {
            this.enqueueWalker(new CombineInterpolants(assump[i].mPivot));
            this.enqueueWalker(new ProofTreeWalker(assump[i].mAntecedent));
        }
        this.enqueueWalker(new ProofTreeWalker(prim));
    }

    private void walkLeafNode(Clause clause) {
        Object ipolator;
        if (this.mSmtSolver.isTerminationRequested()) {
            throw new SMTLIBException("Timeout exceeded");
        }
        LeafNode leaf = (LeafNode)clause.getProof();
        Interpolant[] interpolants = new Interpolant[this.mNumInterpolants];
        if (leaf.getLeafKind() == -6) {
            assert (clause.getSize() == 2);
            Literal l1 = clause.getLiteral(0);
            Literal l2 = clause.getLiteral(1);
            assert (l1.getSign() != l2.getSign());
            if (l1.getAtom() instanceof LAEquality) {
                l1 = clause.getLiteral(1);
                l2 = clause.getLiteral(0);
            }
            interpolants = this.computeEQInterpolant((CCEquality)l1.getAtom(), (LAEquality)l2.getAtom(), l1.getSign());
        } else if (leaf.hasSourceAnnotation()) {
            SourceAnnotation annot = (SourceAnnotation)leaf.getTheoryAnnotation();
            int partition = this.mPartitions.containsKey(annot.getAnnotation()) ? this.mPartitions.get(annot.getAnnotation()) : 0;
            interpolants = new Interpolant[this.mNumInterpolants];
            for (int i = 0; i < this.mNumInterpolants; ++i) {
                interpolants[i] = new Interpolant(this.mStartOfSubtrees[i] <= partition && partition <= i ? this.mTheory.mFalse : this.mTheory.mTrue);
            }
        } else if (leaf.getLeafKind() == -3) {
            ipolator = new CCInterpolator(this);
            Term[] interpolantTerms = ((CCInterpolator)ipolator).computeInterpolants(clause, (CCAnnotation)leaf.getTheoryAnnotation());
            interpolants = new Interpolant[this.mNumInterpolants];
            for (int j = 0; j < this.mNumInterpolants; ++j) {
                interpolants[j] = new Interpolant(interpolantTerms[j]);
            }
        } else if (leaf.getLeafKind() == -4) {
            ipolator = new LAInterpolator(this, (LAAnnotation)leaf.getTheoryAnnotation());
            interpolants = ((LAInterpolator)ipolator).computeInterpolants();
        } else {
            throw new UnsupportedOperationException("Cannot interpolate " + leaf);
        }
        Object lits = null;
        this.mInterpolated.add(interpolants);
        this.mInterpolants.put(clause, interpolants);
        this.mLogger.debug("Interpolating leaf {0} yields ...", clause);
        for (int i = 0; i <= this.mNumInterpolants - 1; ++i) {
            this.mLogger.debug(interpolants[i]);
        }
    }

    private void combine(Literal pivot) {
        LitInfo pivInfo = this.mLiteralInfos.get(pivot.getAtom());
        Interpolant[] assInterp = this.collectInterpolated();
        Interpolant[] primInterp = this.collectInterpolated();
        Interpolant[] interp = new Interpolant[this.mNumInterpolants];
        for (int i = 0; i < this.mNumInterpolants; ++i) {
            this.mLogger.debug("Pivot {2}{3} on interpolants {0} and {1} gives...", primInterp[i], assInterp[i], pivot.getSMTFormula(this.mTheory), pivInfo);
            if (pivInfo.isALocal(i)) {
                interp[i] = new Interpolant(this.mTheory.or(primInterp[i].mTerm, assInterp[i].mTerm));
            } else if (pivInfo.isBLocal(i)) {
                interp[i] = new Interpolant(this.mTheory.and(primInterp[i].mTerm, assInterp[i].mTerm));
            } else if (pivInfo.isAB(i)) {
                interp[i] = new Interpolant(this.mTheory.ifthenelse(pivot.getSMTFormula(this.mTheory), primInterp[i].mTerm, assInterp[i].mTerm));
            } else if (pivot.getAtom() instanceof CCEquality || pivot.getAtom() instanceof LAEquality) {
                Interpolant neqIpol;
                Interpolant eqIpol;
                if (pivot.getSign() > 0) {
                    eqIpol = assInterp[i];
                    neqIpol = primInterp[i];
                } else {
                    eqIpol = primInterp[i];
                    neqIpol = assInterp[i];
                }
                interp[i] = this.mixedEqInterpolate(eqIpol, neqIpol, pivInfo.mMixedVar);
            } else if (pivot.getAtom() instanceof BoundConstraint) {
                interp[i] = this.mixedPivotLA(assInterp[i], primInterp[i], pivInfo.mMixedVar);
            } else {
                throw new UnsupportedOperationException("Cannot handle mixed literal " + pivot);
            }
            this.mLogger.debug(interp[i]);
        }
        this.mInterpolated.add(interp);
    }

    private void summarize(Clause clause) {
        Interpolant[] interpolants = null;
        interpolants = this.mInterpolated.getLast();
        Object lits = null;
        this.mInterpolants.put(clause, interpolants);
        this.mLogger.debug("...which is the resulting interpolant for clause {0} ", clause);
    }

    protected final Interpolant[] collectInterpolated() {
        return this.mInterpolated.removeLast();
    }

    public boolean checkCacheForInterpolants(Clause clause) {
        Interpolant[] interpolants = new Interpolant[this.mNumInterpolants];
        if (this.mInterpolants.containsKey(clause)) {
            interpolants = this.mInterpolants.get(clause);
            this.mInterpolated.add(interpolants);
            return true;
        }
        return false;
    }

    private Term unfoldLAs(Interpolant interpolant) {
        TermTransformer substitutor = new TermTransformer(){

            public void convert(Term term) {
                if (term instanceof LATerm) {
                    term = ((LATerm)term).mF;
                }
                super.convert(term);
            }
        };
        return substitutor.transform(interpolant.mTerm);
    }

    private void checkInductivity(Collection<Literal> clause, Interpolant[] ipls) {
        int part;
        int old = this.mLogger.getLoglevel();
        this.mLogger.setLoglevel(2);
        this.mCheckingSolver.push(1);
        HashMap[] auxMaps = new HashMap[ipls.length];
        for (Literal lit : clause) {
            LitInfo info = this.getLiteralInfo(lit.getAtom());
            for (int part2 = 0; part2 < ipls.length; ++part2) {
                if (!info.isMixed(part2)) continue;
                TermVariable tv = info.mMixedVar;
                String name = ".check" + part2 + "." + tv.getName();
                this.mCheckingSolver.declareFun(name, new Sort[0], tv.getSort());
                Term term = this.mCheckingSolver.term(name, new Term[0]);
                if (auxMaps[part2] == null) {
                    auxMaps[part2] = new HashMap();
                }
                auxMaps[part2].put(tv, term);
            }
        }
        Term[] interpolants = new Term[ipls.length];
        for (part = 0; part < ipls.length; ++part) {
            Term ipl = this.unfoldLAs(ipls[part]);
            if (auxMaps[part] == null) {
                interpolants[part] = ipl;
                continue;
            }
            TermVariable[] tvs = new TermVariable[auxMaps[part].size()];
            Term[] values = new Term[auxMaps[part].size()];
            int i = 0;
            for (Map.Entry entry : auxMaps[part].entrySet()) {
                tvs[i] = (TermVariable)entry.getKey();
                values[i] = (Term)entry.getValue();
                ++i;
            }
            interpolants[part] = this.mTheory.let(tvs, values, ipl);
        }
        for (part = 0; part < ipls.length; ++part) {
            this.mCheckingSolver.push(1);
            for (Map.Entry<String, Integer> entry : this.mPartitions.entrySet()) {
                if (entry.getValue() != part) continue;
                this.mCheckingSolver.assertTerm(this.mTheory.term(entry.getKey(), new Term[0]));
            }
            for (Literal lit : clause) {
                LinVar lv;
                InfinitNumber bound;
                int child;
                LitInfo info = this.mLiteralInfos.get((lit = lit.negate()).getAtom());
                if (info.contains(part)) {
                    this.mCheckingSolver.assertTerm(lit.getSMTFormula(this.mTheory));
                    continue;
                }
                if (info.isBLocal(part) || info.isALocalInSomeChild(part)) continue;
                if (lit.getAtom() instanceof CCEquality) {
                    CCEquality cceq = (CCEquality)lit.getAtom();
                    Term lhs = cceq.getLhs().toSMTTerm(this.mTheory);
                    Term rhs = cceq.getRhs().toSMTTerm(this.mTheory);
                    child = part - 1;
                    while (child >= this.mStartOfSubtrees[part]) {
                        if (info.isMixed(child)) {
                            if (info.getLhsOccur().isALocal(child)) {
                                lhs = (Term)auxMaps[child].get(info.mMixedVar);
                            } else {
                                assert (info.getLhsOccur().isBLocal(child));
                                rhs = (Term)auxMaps[child].get(info.mMixedVar);
                            }
                        }
                        child = this.mStartOfSubtrees[child] - 1;
                    }
                    if (info.isMixed(part)) {
                        if (info.getLhsOccur().isALocal(part)) {
                            rhs = (Term)auxMaps[part].get(info.mMixedVar);
                        } else {
                            assert (info.getLhsOccur().isBLocal(part));
                            lhs = (Term)auxMaps[part].get(info.mMixedVar);
                        }
                        this.mCheckingSolver.assertTerm(this.mTheory.term("=", lhs, rhs));
                        continue;
                    }
                    this.mCheckingSolver.assertTerm(this.mTheory.term(lit.getSign() < 0 ? "distinct" : "=", lhs, rhs));
                    continue;
                }
                if (lit.negate() instanceof LAEquality) {
                    Term zero;
                    Term t;
                    InterpolatorAffineTerm at = new InterpolatorAffineTerm();
                    LAEquality eq = (LAEquality)lit.negate();
                    int child2 = part - 1;
                    while (child2 >= this.mStartOfSubtrees[part]) {
                        if (info.isMixed(child2)) {
                            at.add(Rational.MONE, info.getAPart(child2));
                            at.add(Rational.ONE, (Term)auxMaps[child2].get(info.mMixedVar));
                        }
                        child2 = this.mStartOfSubtrees[child2] - 1;
                    }
                    if (info.isMixed(part)) {
                        assert (info.mMixedVar != null);
                        at.add(Rational.ONE, info.getAPart(part));
                        at.add(Rational.MONE, (Term)auxMaps[part].get(info.mMixedVar));
                        t = at.toSMTLib(this.mTheory, eq.getVar().isInt());
                        zero = eq.getVar().isInt() ? this.mTheory.numeral(BigInteger.ZERO) : this.mTheory.decimal(BigDecimal.ZERO);
                        this.mCheckingSolver.assertTerm(this.mTheory.term("=", t, zero));
                        continue;
                    }
                    assert (!at.isConstant());
                    at.add(Rational.ONE, eq.getVar());
                    at.add(eq.getBound().negate());
                    t = at.toSMTLib(this.mTheory, eq.getVar().isInt());
                    zero = eq.getVar().isInt() ? this.mTheory.numeral(BigInteger.ZERO) : this.mTheory.decimal(BigDecimal.ZERO);
                    this.mCheckingSolver.assertTerm(this.mTheory.term("distinct", t, zero));
                    continue;
                }
                if (lit.getAtom() instanceof BoundConstraint) {
                    BoundConstraint bc = (BoundConstraint)lit.getAtom();
                    bound = lit.getSign() > 0 ? bc.getBound() : bc.getInverseBound();
                    lv = bc.getVar();
                } else {
                    assert (lit.getAtom() instanceof LAEquality);
                    LAEquality eq = (LAEquality)lit;
                    lv = eq.getVar();
                    bound = new InfinitNumber(eq.getBound(), 0);
                }
                InterpolatorAffineTerm at = new InterpolatorAffineTerm();
                child = part - 1;
                while (child >= this.mStartOfSubtrees[part]) {
                    if (info.isMixed(child)) {
                        at.add(Rational.MONE, info.getAPart(child));
                        at.add(Rational.ONE, (Term)auxMaps[child].get(info.mMixedVar));
                    }
                    child = this.mStartOfSubtrees[child] - 1;
                }
                if (info.isMixed(part)) {
                    assert (info.mMixedVar != null);
                    at.add(Rational.ONE, info.getAPart(part));
                    at.add(Rational.MONE, (Term)auxMaps[part].get(info.mMixedVar));
                } else {
                    assert (!at.isConstant());
                    at.add(Rational.ONE, lv);
                    at.add(bound.negate());
                }
                if (lit.getAtom() instanceof BoundConstraint) {
                    if (lit.getSign() < 0) {
                        at.negate();
                    }
                    this.mCheckingSolver.assertTerm(at.toLeq0(this.mTheory));
                    continue;
                }
                boolean isInt = at.isInt();
                Term t = at.toSMTLib(this.mTheory, isInt);
                Term zero = isInt ? this.mTheory.numeral(BigInteger.ZERO) : this.mTheory.decimal(BigDecimal.ZERO);
                ApplicationTerm eqTerm = this.mTheory.term("=", t, zero);
                if (!info.isMixed(part) && lit.getSign() < 0) {
                    eqTerm = this.mTheory.term("not", eqTerm);
                }
                this.mCheckingSolver.assertTerm(eqTerm);
            }
            int child = part - 1;
            while (child >= this.mStartOfSubtrees[part]) {
                this.mCheckingSolver.assertTerm(interpolants[child]);
                child = this.mStartOfSubtrees[child] - 1;
            }
            this.mCheckingSolver.assertTerm(this.mTheory.term("not", interpolants[part]));
            if (this.mCheckingSolver.checkSat() != Script.LBool.UNSAT) {
                throw new AssertionError();
            }
            this.mCheckingSolver.pop(1);
        }
        this.mCheckingSolver.pop(1);
        this.mLogger.setLoglevel(old);
    }

    private Interpolant[] computeEQInterpolant(CCEquality ccEq, LAEquality laEq, int sign) {
        Interpolant[] interpolants = null;
        LitInfo ccInfo = this.getLiteralInfo(ccEq);
        LitInfo laInfo = this.getLiteralInfo(laEq);
        interpolants = new Interpolant[this.mNumInterpolants];
        for (int p = 0; p < this.mNumInterpolants; ++p) {
            Term interpolant;
            if (ccInfo.isAorShared(p) && laInfo.isAorShared(p)) {
                interpolant = this.mTheory.mFalse;
            } else if (ccInfo.isBorShared(p) && laInfo.isBorShared(p)) {
                interpolant = this.mTheory.mTrue;
            } else {
                InterpolatorAffineTerm iat = new InterpolatorAffineTerm();
                Rational factor = ccEq.getLAFactor();
                TermVariable mixed = null;
                boolean negate = false;
                if (ccInfo.isALocal(p)) {
                    iat.add(factor, ccEq.getLhs().getFlatTerm());
                    iat.add(factor.negate(), ccEq.getRhs().getSharedTerm());
                    if (sign == 1) {
                        negate = true;
                    }
                } else if (ccInfo.isMixed(p)) {
                    if (sign == 1) {
                        mixed = ccInfo.getMixedVar();
                    }
                    if (ccInfo.mLhsOccur.isALocal(p)) {
                        iat.add(factor, ccEq.getLhs().getFlatTerm());
                        iat.add(factor.negate(), ccInfo.getMixedVar());
                    } else {
                        iat.add(factor, ccInfo.getMixedVar());
                        iat.add(factor.negate(), ccEq.getRhs().getFlatTerm());
                    }
                }
                if (laInfo.isALocal(p)) {
                    iat.add(Rational.MONE, laEq.getVar());
                    iat.add(laEq.getBound());
                    if (sign == -1) {
                        negate = true;
                    }
                } else if (laInfo.isMixed(p)) {
                    if (sign == -1) {
                        mixed = laInfo.getMixedVar();
                    }
                    iat.add(Rational.MONE, laInfo.getAPart(p));
                    iat.add(Rational.ONE, laInfo.getMixedVar());
                }
                iat.mul(iat.getGCD().inverse());
                if (mixed != null) {
                    Term sharedTerm;
                    Rational mixedFactor = iat.getSummands().remove(mixed);
                    assert (mixedFactor.isIntegral());
                    boolean isInt = mixed.getSort().getName().equals("Int");
                    if (isInt && mixedFactor.abs() != Rational.ONE) {
                        if (mixedFactor.signum() > 0) {
                            iat.negate();
                        }
                        sharedTerm = iat.toSMTLib(this.mTheory, isInt);
                        interpolant = this.mTheory.equals(mixed, this.mTheory.term("div", sharedTerm, this.mTheory.numeral(mixedFactor.numerator())));
                        FunctionSymbol divisible = this.mTheory.getFunctionWithResult("divisible", new BigInteger[]{mixedFactor.numerator().abs()}, null, this.mTheory.getSort("Int", new Sort[0]));
                        interpolant = this.mTheory.and(interpolant, this.mTheory.term(divisible, sharedTerm));
                    } else {
                        iat.mul(mixedFactor.negate().inverse());
                        sharedTerm = iat.toSMTLib(this.mTheory, isInt);
                        interpolant = this.mTheory.equals(mixed, sharedTerm);
                    }
                } else if (iat.isConstant()) {
                    if (iat.getConstant() != InfinitNumber.ZERO) {
                        negate ^= true;
                    }
                    interpolant = negate ? this.mTheory.mFalse : this.mTheory.mTrue;
                } else {
                    boolean isInt = iat.isInt();
                    Term term = iat.toSMTLib(this.mTheory, isInt);
                    Term zero = iat.isInt() ? this.mTheory.numeral(BigInteger.ZERO) : this.mTheory.decimal(BigDecimal.ZERO);
                    interpolant = negate ? this.mTheory.distinct(term, zero) : this.mTheory.equals(term, zero);
                }
            }
            interpolants[p] = new Interpolant(interpolant);
        }
        return interpolants;
    }

    public void colorLiterals(Clause root, HashSet<Clause> visited) {
        if (visited.contains(root)) {
            return;
        }
        ProofNode pn = root.getProof();
        if (pn.isLeaf()) {
            LeafNode ln = (LeafNode)pn;
            if (ln.hasSourceAnnotation()) {
                SourceAnnotation annot = (SourceAnnotation)ln.getTheoryAnnotation();
                int partition = this.mPartitions.containsKey(annot.getAnnotation()) ? this.mPartitions.get(annot.getAnnotation()) : 0;
                for (int i = 0; i < root.getSize(); ++i) {
                    LinVar lv;
                    Literal lit = root.getLiteral(i);
                    DPLLAtom atom = lit.getAtom();
                    LitInfo info = this.mLiteralInfos.get(atom);
                    if (info == null) {
                        info = new LitInfo();
                        this.mLiteralInfos.put(atom, info);
                    }
                    if (info.contains(partition)) continue;
                    info.occursIn(partition);
                    if (atom instanceof CCEquality) {
                        CCEquality eq = (CCEquality)atom;
                        this.addOccurrence(eq.getLhs().getFlatTerm(), partition);
                        this.addOccurrence(eq.getRhs().getFlatTerm(), partition);
                        continue;
                    }
                    if (atom instanceof BoundConstraint) {
                        lv = ((BoundConstraint)atom).getVar();
                        this.addOccurrence(lv, partition);
                        continue;
                    }
                    if (!(atom instanceof LAEquality)) continue;
                    lv = ((LAEquality)atom).getVar();
                    this.addOccurrence(lv, partition);
                }
            }
        } else {
            ResolutionNode rn = (ResolutionNode)pn;
            this.colorLiterals(rn.getPrimary(), visited);
            for (ResolutionNode.Antecedent a : rn.getAntecedents()) {
                this.colorLiterals(a.mAntecedent, visited);
            }
        }
        visited.add(root);
    }

    Occurrence getOccurrence(SharedTerm shared) {
        Occurrence result = this.mSymbolPartition.get(shared);
        if (result == null) {
            result = new Occurrence();
            IAnnotation annot = shared.getAnnotation();
            if (annot instanceof SourceAnnotation) {
                Integer partition = this.mPartitions.get(((SourceAnnotation)annot).getAnnotation());
                if (partition == null) {
                    for (int p = 0; p < this.mNumInterpolants; ++p) {
                        result.occursIn(p);
                    }
                } else {
                    result.occursIn(partition);
                }
            }
            this.mSymbolPartition.put(shared, result);
        }
        return result;
    }

    void addOccurrence(SharedTerm term, int part) {
        ApplicationTerm at;
        this.getOccurrence(term).occursIn(part);
        if (term.getTerm() instanceof SMTAffineTerm && term.getLinVar() != null) {
            this.addOccurrence(term.getLinVar(), part);
        } else if (term.getTerm() instanceof ApplicationTerm && !(at = (ApplicationTerm)term.getTerm()).getFunction().isInterpreted()) {
            Clausifier c = term.getClausifier();
            for (Term p : at.getParameters()) {
                this.addOccurrence(c.getSharedTerm(p), part);
            }
        }
    }

    void addOccurrence(LinVar var, int part) {
        if (var.isInitiallyBasic()) {
            for (LinVar c : var.getLinTerm().keySet()) {
                this.addOccurrence(c.getSharedTerm(), part);
            }
        } else {
            this.addOccurrence(var.getSharedTerm(), part);
        }
    }

    LitInfo getLiteralInfo(DPLLAtom lit) {
        LitInfo result = this.mLiteralInfos.get(lit);
        if (result == null) {
            result = this.colorMixedLiteral(lit);
        }
        return result;
    }

    public LitInfo colorMixedLiteral(DPLLAtom atom) {
        Sort auxSort;
        LitInfo info = this.mLiteralInfos.get(atom);
        assert (info == null);
        ArrayList<SharedTerm> subterms = new ArrayList<SharedTerm>();
        if (atom instanceof CCEquality) {
            CCEquality eq = (CCEquality)atom;
            SharedTerm l = eq.getLhs().getFlatTerm();
            SharedTerm r = eq.getRhs().getFlatTerm();
            subterms.add(l);
            subterms.add(r);
            if (l.getSort() == r.getSort()) {
                auxSort = l.getSort();
            } else {
                assert (this.mTheory.getLogic().isIRA());
                auxSort = this.mTheory.getRealSort();
            }
        } else {
            LinVar lv = null;
            if (atom instanceof BoundConstraint) {
                lv = ((BoundConstraint)atom).getVar();
            } else if (atom instanceof LAEquality) {
                lv = ((LAEquality)atom).getVar();
            }
            Set<LinVar> components = lv.isInitiallyBasic() ? lv.getLinTerm().keySet() : Collections.singleton(lv);
            boolean allInt = true;
            for (LinVar c : components) {
                allInt &= c.isInt();
                subterms.add(c.getSharedTerm());
            }
            auxSort = allInt ? this.mTheory.getNumericSort() : this.mTheory.getRealSort();
        }
        info = this.computeMixedOccurrence(subterms);
        this.mLiteralInfos.put(atom, info);
        BitSet shared = new BitSet();
        shared.or(info.mInA);
        shared.or(info.mInB);
        if (shared.nextClearBit(0) >= this.mNumInterpolants) {
            return info;
        }
        info.mMixedVar = this.mTheory.createFreshTermVariable("litaux", auxSort);
        if (atom instanceof CCEquality) {
            CCEquality eq = (CCEquality)atom;
            info.mLhsOccur = this.getOccurrence(eq.getLhs().getFlatTerm());
        } else if (atom instanceof BoundConstraint || atom instanceof LAEquality) {
            LinVar lv = null;
            lv = atom instanceof BoundConstraint ? ((BoundConstraint)atom).getVar() : ((LAEquality)atom).getVar();
            assert (lv.isInitiallyBasic()) : "Not initially basic: " + lv + " atom: " + atom;
            info.mAPart = new MutableAffinTerm[this.mNumInterpolants];
            for (int part = 0; part < this.mNumInterpolants; ++part) {
                if (!info.isMixed(part)) continue;
                MutableAffinTerm sumApart = new MutableAffinTerm();
                for (Map.Entry<LinVar, BigInteger> en : lv.getLinTerm().entrySet()) {
                    LinVar var = en.getKey();
                    Occurrence occ = this.getOccurrence(en.getKey().getSharedTerm());
                    if (!occ.isALocal(part)) continue;
                    Rational coeff = Rational.valueOf(en.getValue(), BigInteger.ONE);
                    sumApart.add(coeff, var);
                }
                info.mAPart[part] = sumApart;
            }
        }
        return info;
    }

    private LitInfo computeMixedOccurrence(ArrayList<SharedTerm> subterms) {
        BitSet inA = null;
        BitSet inB = null;
        for (SharedTerm st : subterms) {
            Occurrence occInfo = this.getOccurrence(st);
            if (inA == null) {
                inA = (BitSet)occInfo.mInA.clone();
                inB = (BitSet)occInfo.mInB.clone();
                continue;
            }
            inA.and(occInfo.mInA);
            inB.and(occInfo.mInB);
        }
        LitInfo info = new LitInfo(inA, inB);
        return info;
    }

    Term substitute(Term mainTerm, TermVariable termVar, Term replacement) {
        return new Substitutor(termVar, replacement).transform(mainTerm);
    }

    private Interpolant mixedEqInterpolate(Interpolant eqIpol, Interpolant neqIpol, TermVariable mixedVar) {
        EQInterpolator ipolator = new EQInterpolator(neqIpol, mixedVar);
        return new Interpolant(ipolator.transform(eqIpol.mTerm));
    }

    public Interpolant mixedPivotLA(Interpolant leqItp, Interpolant sgItp, TermVariable mixedVar) {
        MixedLAInterpolator ipolator = mixedVar.getSort().getName().equals("Real") ? new RealInterpolator(sgItp.mTerm, mixedVar) : new IntegerInterpolator(sgItp.mTerm, mixedVar);
        Interpolant newI = new Interpolant(ipolator.transform(leqItp.mTerm));
        return newI;
    }

    class IntegerInterpolator
    extends MixedLAInterpolator {
        public IntegerInterpolator(Term i2, TermVariable mixedVar) {
            super(i2, mixedVar);
        }

        public Term interpolate(LATerm la1, LATerm la2) {
            Rational kc;
            InterpolatorAffineTerm theS;
            Rational theC;
            Rational k2c2;
            InterpolatorAffineTerm s1 = new InterpolatorAffineTerm(la1.mS);
            Rational c1 = s1.getSummands().remove(this.mMixedVar);
            InterpolatorAffineTerm s2 = new InterpolatorAffineTerm(la2.mS);
            Rational c2 = s2.getSummands().remove(this.mMixedVar);
            assert (c1.isIntegral() && c2.isIntegral());
            assert (c1.signum() * c2.signum() == -1);
            Rational absc1 = c1.abs();
            Rational absc2 = c2.abs();
            InterpolatorAffineTerm c1s2c2s1 = new InterpolatorAffineTerm();
            c1s2c2s1.add(absc1, s2);
            c1s2c2s1.add(absc2, s1);
            Rational c1c2 = absc1.mul(absc2);
            InfinitNumber newK = la1.mK.mul(absc2).add(la2.mK.mul(absc1)).add(new InfinitNumber(c1c2, 0));
            assert (newK.isIntegral());
            Rational k1c1 = la1.mK.mA.add(Rational.ONE).div(absc1).ceil();
            if (k1c1.compareTo(k2c2 = la2.mK.mA.add(Rational.ONE).div(absc2).ceil()) < 0) {
                theC = c1;
                theS = s1;
                kc = k1c1;
            } else {
                theC = c2;
                theS = s2;
                kc = k2c2;
            }
            BigInteger cNum = theC.numerator().abs();
            Term newF = Interpolator.this.mTheory.mFalse;
            InterpolatorAffineTerm sPlusOffset = new InterpolatorAffineTerm();
            sPlusOffset.add(theC.signum() > 0 ? Rational.MONE : Rational.ONE, theS);
            Rational offset = Rational.ZERO;
            if (theC.signum() < 0) {
                sPlusOffset.add(theC.abs().add(Rational.MONE));
            }
            while (offset.compareTo(kc) <= 0) {
                if (Interpolator.this.mSmtSolver.isTerminationRequested()) {
                    throw new SMTLIBException("Timeout exceeded");
                }
                Term x = sPlusOffset.toSMTLib(Interpolator.this.mTheory, true);
                if (!cNum.equals(BigInteger.ONE)) {
                    x = Interpolator.this.mTheory.term("div", x, Interpolator.this.mTheory.numeral(cNum));
                }
                Term F1 = Interpolator.this.substitute(la1.mF, this.mMixedVar, x);
                Term F2 = Interpolator.this.substitute(la2.mF, this.mMixedVar, x);
                if (offset.compareTo(kc) == 0) {
                    if (theS == s1) {
                        F1 = Interpolator.this.mTheory.mTrue;
                    } else {
                        F2 = Interpolator.this.mTheory.mTrue;
                    }
                }
                newF = Interpolator.this.mTheory.or(newF, Interpolator.this.mTheory.and(F1, F2));
                sPlusOffset = sPlusOffset.add(theC.negate());
                offset = offset.add(c1c2);
            }
            LATerm la3 = new LATerm(c1s2c2s1, newK, newF);
            return la3;
        }
    }

    class RealInterpolator
    extends MixedLAInterpolator {
        public RealInterpolator(Term i2, TermVariable mixedVar) {
            super(i2, mixedVar);
        }

        public Term interpolate(LATerm la1, LATerm la2) {
            InterpolatorAffineTerm s1divc1;
            Term newF;
            InterpolatorAffineTerm s1 = new InterpolatorAffineTerm(la1.mS);
            Rational c1 = s1.getSummands().remove(this.mMixedVar);
            InterpolatorAffineTerm s2 = new InterpolatorAffineTerm(la2.mS);
            Rational c2 = s2.getSummands().remove(this.mMixedVar);
            assert (c1.signum() * c2.signum() == -1);
            InfinitNumber newK = la1.mK.mul(c2.abs()).add(la2.mK.mul(c1.abs()));
            InterpolatorAffineTerm c1s2c2s1 = new InterpolatorAffineTerm();
            c1s2c2s1.add(c1.abs(), s2);
            c1s2c2s1.add(c2.abs(), s1);
            if (s1.getConstant().mEps > 0 || s2.getConstant().mEps > 0) {
                newF = c1s2c2s1.toLeq0(Interpolator.this.mTheory);
                newK = InfinitNumber.EPSILON.negate();
            } else if (la1.mK.less(InfinitNumber.ZERO)) {
                s1divc1 = new InterpolatorAffineTerm(s1);
                s1divc1.mul(c1.inverse().negate());
                Term s1DivByc1 = s1divc1.toSMTLib(Interpolator.this.mTheory, false);
                newF = Interpolator.this.substitute(la2.mF, this.mMixedVar, s1DivByc1);
                newK = la2.mK;
            } else if (la2.mK.less(InfinitNumber.ZERO)) {
                InterpolatorAffineTerm s2divc2 = new InterpolatorAffineTerm(s2);
                s2divc2.mul(c2.inverse().negate());
                Term s2DivByc2 = s2divc2.toSMTLib(Interpolator.this.mTheory, false);
                newF = Interpolator.this.substitute(la1.mF, this.mMixedVar, s2DivByc2);
                newK = la1.mK;
            } else {
                s1divc1 = new InterpolatorAffineTerm(s1);
                s1divc1.mul(c1.inverse().negate());
                Term s1DivByc1 = s1divc1.toSMTLib(Interpolator.this.mTheory, false);
                Term f1 = Interpolator.this.substitute(la1.mF, this.mMixedVar, s1DivByc1);
                Term f2 = Interpolator.this.substitute(la2.mF, this.mMixedVar, s1DivByc1);
                newF = Interpolator.this.mTheory.and(f1, f2);
                if (c1s2c2s1.isConstant()) {
                    if (c1s2c2s1.getConstant().less(InfinitNumber.ZERO)) {
                        newF = Interpolator.this.mTheory.mTrue;
                    }
                } else {
                    InterpolatorAffineTerm s3 = new InterpolatorAffineTerm(c1s2c2s1);
                    s3.add(InfinitNumber.EPSILON);
                    newF = Interpolator.this.mTheory.or(s3.toLeq0(Interpolator.this.mTheory), newF);
                }
                newK = InfinitNumber.ZERO;
            }
            LATerm la3 = new LATerm(c1s2c2s1, newK, newF);
            return la3;
        }
    }

    static abstract class MixedLAInterpolator
    extends TermTransformer {
        TermVariable mMixedVar;
        Term mI2;
        LATerm mLA1;

        public MixedLAInterpolator(Term i2, TermVariable mixed) {
            this.mMixedVar = mixed;
            this.mLA1 = null;
            this.mI2 = i2;
        }

        abstract Term interpolate(LATerm var1, LATerm var2);

        public void convert(Term term) {
            assert (term != this.mMixedVar);
            if (term instanceof LATerm) {
                final LATerm laTerm = (LATerm)term;
                if (laTerm.mS.getSummands().get(this.mMixedVar) != null) {
                    if (this.mLA1 == null) {
                        this.beginScope();
                        this.mLA1 = laTerm;
                        this.enqueueWalker(new NonRecursive.Walker(){

                            public void walk(NonRecursive engine) {
                                ((MixedLAInterpolator)engine).mLA1 = null;
                                ((MixedLAInterpolator)engine).endScope();
                            }
                        });
                        this.pushTerm(this.mI2);
                        return;
                    }
                    this.setResult(this.interpolate(this.mLA1, (LATerm)term));
                    return;
                }
                this.enqueueWalker(new NonRecursive.Walker(){

                    public void walk(NonRecursive engine) {
                        MixedLAInterpolator me = (MixedLAInterpolator)engine;
                        Term result = me.getConverted();
                        if (result == laTerm.mF) {
                            me.setResult(laTerm);
                        } else {
                            me.setResult(new LATerm(laTerm.mS, laTerm.mK, result));
                        }
                    }
                });
                this.pushTerm(laTerm.mF);
                return;
            }
            super.convert(term);
        }
    }

    class EQInterpolator
    extends TermTransformer {
        Interpolant mI2;
        TermVariable mAuxVar;

        EQInterpolator(Interpolant i2, TermVariable auxVar) {
            this.mI2 = i2;
            this.mAuxVar = auxVar;
        }

        public void convert(Term term) {
            ApplicationTerm appTerm;
            assert (term != this.mAuxVar);
            if (term instanceof LATerm) {
                final LATerm laTerm = (LATerm)term;
                this.enqueueWalker(new NonRecursive.Walker(){

                    public void walk(NonRecursive engine) {
                        EQInterpolator me = (EQInterpolator)engine;
                        Term result = me.getConverted();
                        if (result == laTerm.mF) {
                            me.setResult(laTerm);
                        } else {
                            me.setResult(new LATerm(laTerm.mS, laTerm.mK, result));
                        }
                    }
                });
                this.pushTerm(laTerm.mF);
                return;
            }
            if (term instanceof ApplicationTerm && (appTerm = (ApplicationTerm)term).getParameters().length == 2 && (appTerm.getParameters()[0] == this.mAuxVar || appTerm.getParameters()[1] == this.mAuxVar)) {
                assert (appTerm.getFunction().isIntern() && appTerm.getFunction().getName().equals("=") && appTerm.getParameters().length == 2);
                Term s = appTerm.getParameters()[1];
                if (s == this.mAuxVar) {
                    s = appTerm.getParameters()[0];
                }
                this.setResult(Interpolator.this.substitute(this.mI2.mTerm, this.mAuxVar, s));
                return;
            }
            super.convert(term);
        }
    }

    public static class Substitutor
    extends TermTransformer {
        TermVariable mTermVar;
        Term mReplacement;

        public Substitutor(TermVariable termVar, Term replacement) {
            this.mTermVar = termVar;
            this.mReplacement = replacement;
        }

        public void convert(Term term) {
            if (term instanceof LATerm) {
                final LATerm laTerm = (LATerm)term;
                final Term[] oldTerms = laTerm.mS.getSummands().keySet().toArray(new Term[laTerm.mS.getSummands().size()]);
                this.enqueueWalker(new NonRecursive.Walker(){

                    public void walk(NonRecursive engine) {
                        Substitutor me = (Substitutor)engine;
                        Term result = me.getConverted();
                        Term[] newTerms = me.getConverted(oldTerms);
                        if (result == laTerm.mF && newTerms == oldTerms) {
                            me.setResult(laTerm);
                            return;
                        }
                        InterpolatorAffineTerm newS = new InterpolatorAffineTerm();
                        for (int i = 0; i < oldTerms.length; ++i) {
                            newS.add(laTerm.mS.getSummands().get(oldTerms[i]), newTerms[i]);
                        }
                        newS.add(laTerm.mS.getConstant());
                        me.setResult(new LATerm(newS, laTerm.mK, result));
                    }
                });
                this.pushTerm(laTerm.mF);
                this.pushTerms(oldTerms);
                return;
            }
            if (term.equals(this.mTermVar)) {
                this.setResult(this.mReplacement);
            } else {
                super.convert(term);
            }
        }
    }

    class LitInfo
    extends Occurrence {
        TermVariable mMixedVar;
        Occurrence mLhsOccur;
        MutableAffinTerm[] mAPart;

        public LitInfo() {
        }

        public LitInfo(BitSet inA, BitSet inB) {
            super(inA, inB);
        }

        public TermVariable getMixedVar() {
            return this.mMixedVar;
        }

        public Occurrence getLhsOccur() {
            return this.mLhsOccur;
        }

        public MutableAffinTerm getAPart(int p) {
            return this.mAPart[p];
        }
    }

    class Occurrence {
        BitSet mInA;
        BitSet mInB;

        public Occurrence() {
            this.mInA = new BitSet(Interpolator.this.mNumInterpolants + 1);
            this.mInB = new BitSet(Interpolator.this.mNumInterpolants + 1);
        }

        public Occurrence(BitSet inA, BitSet inB) {
            this.mInA = inA;
            this.mInB = inB;
        }

        public void occursIn(int partition) {
            for (int i = 0; i <= Interpolator.this.mNumInterpolants; ++i) {
                if (i < partition || Interpolator.this.mStartOfSubtrees[i] > partition) {
                    this.mInB.set(i);
                    continue;
                }
                this.mInA.set(i);
            }
        }

        public boolean isALocalInSomeChild(int partition) {
            int i = partition - 1;
            while (i >= Interpolator.this.mStartOfSubtrees[partition]) {
                if (this.mInA.get(i)) {
                    return true;
                }
                i = Interpolator.this.mStartOfSubtrees[i] - 1;
            }
            return false;
        }

        public boolean contains(int partition) {
            if (!this.mInA.get(partition)) {
                return false;
            }
            if (this.mInB.get(partition)) {
                return true;
            }
            int i = partition - 1;
            while (i >= Interpolator.this.mStartOfSubtrees[partition]) {
                if (!this.mInB.get(i)) {
                    return false;
                }
                i = Interpolator.this.mStartOfSubtrees[i] - 1;
            }
            return true;
        }

        public boolean isAorShared(int partition) {
            return this.mInA.get(partition);
        }

        public boolean isBorShared(int partition) {
            return this.mInB.get(partition);
        }

        public boolean isALocal(int partition) {
            return this.mInA.get(partition) && !this.mInB.get(partition);
        }

        public boolean isBLocal(int partition) {
            return this.mInB.get(partition) && !this.mInA.get(partition);
        }

        public boolean isAB(int partition) {
            return this.mInA.get(partition) && this.mInB.get(partition);
        }

        public boolean isMixed(int partition) {
            return !this.mInA.get(partition) && !this.mInB.get(partition);
        }

        public String toString() {
            return "[" + this.mInA + "|" + this.mInB + "]";
        }

        public int getALocalColor() {
            int color = this.mInA.nextSetBit(0);
            if (this.mInB.get(color)) {
                color = this.mInB.nextClearBit(color);
            }
            return color;
        }
    }

    public static class SummarizeResolution
    implements NonRecursive.Walker {
        private final Clause mClause;

        public SummarizeResolution(Clause clause) {
            this.mClause = clause;
        }

        public void walk(NonRecursive engine) {
            ((Interpolator)engine).summarize(this.mClause);
        }
    }

    public static class CombineInterpolants
    implements NonRecursive.Walker {
        private final Literal mPivot;

        public CombineInterpolants(Literal pivot) {
            this.mPivot = pivot;
        }

        public void walk(NonRecursive engine) {
            ((Interpolator)engine).combine(this.mPivot);
        }
    }

    public static class ProofTreeWalker
    implements NonRecursive.Walker {
        private final Clause mClause;

        public ProofTreeWalker(Clause clause) {
            this.mClause = clause;
        }

        public void walk(NonRecursive engine) {
            Interpolator proofTreeWalker = (Interpolator)engine;
            if (proofTreeWalker.checkCacheForInterpolants(this.mClause)) {
                return;
            }
            if (!this.mClause.getProof().isLeaf()) {
                ((Interpolator)engine).walkResolutionNode(this.mClause);
            } else {
                ((Interpolator)engine).walkLeafNode(this.mClause);
            }
        }
    }
}

