/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.Interpolator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAppTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCBaseTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.Coercion;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.SymmetricPair;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class CCInterpolator {
    Interpolator mInterpolator;
    HashMap<SymmetricPair<CCTerm>, CCEquality> mEqualities;
    HashMap<SymmetricPair<CCTerm>, PathInfo> mPaths;
    Theory mTheory;
    int mNumInterpolants;
    Set<Term>[] mInterpolants;

    private int getParent(int color) {
        int parent = color + 1;
        while (this.mInterpolator.mStartOfSubtrees[parent] > color) {
            ++parent;
        }
        return parent;
    }

    private int getChild(int color, Interpolator.Occurrence occur) {
        int child = color - 1;
        while (child >= this.mInterpolator.mStartOfSubtrees[color]) {
            if (occur.isALocal(child)) {
                return child;
            }
            child = this.mInterpolator.mStartOfSubtrees[child] - 1;
        }
        return -1;
    }

    public CCInterpolator(Interpolator ipolator) {
        this.mInterpolator = ipolator;
        this.mNumInterpolants = ipolator.mNumInterpolants;
        this.mTheory = ipolator.mTheory;
        this.mPaths = new HashMap();
        this.mInterpolants = new Set[this.mNumInterpolants];
        for (int i = 0; i < this.mNumInterpolants; ++i) {
            this.mInterpolants[i] = new HashSet<Term>();
        }
    }

    public Term[] computeInterpolants(Clause cl, CCAnnotation annot) {
        this.mEqualities = new HashMap();
        for (int i = 0; i < cl.getSize(); ++i) {
            Literal lit = cl.getLiteral(i);
            if (!(lit.negate() instanceof CCEquality)) continue;
            CCEquality eq = (CCEquality)lit.negate();
            this.mEqualities.put(new SymmetricPair<CCTerm>(eq.getLhs(), eq.getRhs()), eq);
        }
        PathInfo mainPath = null;
        CCTerm[][] paths = annot.getPaths();
        for (int i = 0; i < paths.length; ++i) {
            CCTerm first = paths[i][0];
            CCTerm last = paths[i][paths[i].length - 1];
            PathInfo pathInfo = new PathInfo(paths[i]);
            this.mPaths.put(new SymmetricPair<CCTerm>(first, last), pathInfo);
            if (i != 0) continue;
            mainPath = pathInfo;
        }
        mainPath.interpolatePathInfo();
        CCEquality diseq = annot.getDiseq();
        if (diseq != null) {
            mainPath.addDiseq(diseq);
        }
        mainPath.close();
        Term[] interpolants = new Term[this.mNumInterpolants];
        for (int i = 0; i < this.mNumInterpolants; ++i) {
            interpolants[i] = this.mTheory.and(this.mInterpolants[i].toArray(new Term[this.mInterpolants[i].size()]));
        }
        return interpolants;
    }

    public String toString() {
        return Arrays.toString(this.mInterpolants);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PathInfo {
        CCTerm[] mPath;
        BitSet mHasABPath;
        int mMaxColor;
        PathEnd mHead;
        PathEnd mTail;
        boolean mComputed;

        public PathInfo(CCTerm[] path) {
            this.mPath = path;
            this.mHasABPath = new BitSet(CCInterpolator.this.mNumInterpolants);
            this.mHasABPath.set(0, CCInterpolator.this.mNumInterpolants);
            this.mMaxColor = CCInterpolator.this.mNumInterpolants;
        }

        public PathInfo(CCTerm arg) {
            this(new CCTerm[]{arg});
        }

        public void interpolatePathInfo() {
            if (this.mComputed) {
                return;
            }
            Interpolator.Occurrence headOccur = CCInterpolator.this.mInterpolator.getOccurrence(this.mPath[0].getFlatTerm());
            this.mHead = new PathEnd();
            this.mTail = new PathEnd();
            this.mTail.closeAPath(this.mHead, null, headOccur);
            this.mTail.openAPath(this.mHead, null, headOccur);
            for (int i = 0; i < this.mPath.length - 1; ++i) {
                CCTerm left = this.mPath[i];
                CCTerm right = this.mPath[i + 1];
                CCEquality lit = CCInterpolator.this.mEqualities.get(new SymmetricPair<CCTerm>(left, right));
                if (lit == null) {
                    this.mTail.mergeCongPath(this.mHead, (CCAppTerm)left, (CCAppTerm)right);
                    continue;
                }
                Interpolator.LitInfo info = CCInterpolator.this.mInterpolator.getLiteralInfo(lit);
                Term boundaryTerm = this.mPath[i].toSMTTerm(CCInterpolator.this.mTheory);
                if (info.getMixedVar() == null) {
                    this.mTail.closeAPath(this.mHead, boundaryTerm, info);
                    this.mTail.openAPath(this.mHead, boundaryTerm, info);
                    continue;
                }
                this.mTail.closeAPath(this.mHead, boundaryTerm, info);
                this.mTail.openAPath(this.mHead, boundaryTerm, info);
                Interpolator.Occurrence occ = CCInterpolator.this.mInterpolator.getOccurrence(this.mPath[i + 1].getFlatTerm());
                boundaryTerm = info.getMixedVar();
                this.mTail.closeAPath(this.mHead, boundaryTerm, occ);
                this.mTail.openAPath(this.mHead, boundaryTerm, occ);
            }
            this.mComputed = true;
        }

        private void addInterpolantClause(int color, Set<Term> pre) {
            ApplicationTerm clause = pre == null ? CCInterpolator.this.mTheory.mFalse : CCInterpolator.this.mTheory.or(pre.toArray(new Term[pre.size()]));
            CCInterpolator.this.mInterpolants[color].add(clause);
        }

        public String toString() {
            return "PathInfo[" + Arrays.toString(this.mPath) + "," + this.mHead + ',' + this.mTail + "," + this.mMaxColor + "]";
        }

        public void addDiseq(CCEquality diseq) {
            Interpolator.LitInfo info = CCInterpolator.this.mInterpolator.getLiteralInfo(diseq);
            Term boundaryHeadTerm = this.mPath[0].toSMTTerm(CCInterpolator.this.mTheory);
            Term boundaryTailTerm = this.mPath[this.mPath.length - 1].toSMTTerm(CCInterpolator.this.mTheory);
            if (info.getMixedVar() == null) {
                this.mTail.closeAPath(this.mHead, boundaryTailTerm, info);
                this.mTail.openAPath(this.mHead, boundaryTailTerm, info);
                this.mHead.closeAPath(this.mTail, boundaryHeadTerm, info);
                this.mHead.openAPath(this.mTail, boundaryHeadTerm, info);
            } else {
                Interpolator.Occurrence occHead = CCInterpolator.this.mInterpolator.getOccurrence(this.mPath[0].getFlatTerm());
                this.mHead.closeAPath(this.mTail, boundaryHeadTerm, info);
                this.mHead.openAPath(this.mTail, boundaryHeadTerm, info);
                Interpolator.Occurrence occTail = CCInterpolator.this.mInterpolator.getOccurrence(this.mPath[this.mPath.length - 1].getFlatTerm());
                this.mTail.closeAPath(this.mHead, boundaryTailTerm, info);
                this.mTail.openAPath(this.mHead, boundaryTailTerm, info);
                this.mHead.closeAPath(this.mTail, info.getMixedVar(), occTail);
                this.mTail.closeAPath(this.mHead, info.getMixedVar(), occHead);
            }
        }

        public void close() {
            while (this.mHead.mColor < CCInterpolator.this.mNumInterpolants || this.mTail.mColor < CCInterpolator.this.mNumInterpolants) {
                int parent;
                if (this.mHead.mColor < this.mTail.mColor) {
                    this.mHead.addPre(this.mHead.mColor, Coercion.buildEq(this.mHead.getBoundTerm(this.mHead.mColor), this.mTail.getBoundTerm(this.mMaxColor)));
                    this.addInterpolantClause(this.mHead.mColor, this.mHead.mPre[this.mHead.mColor]);
                    parent = this.mHead.mColor + 1;
                    while (CCInterpolator.this.mInterpolator.mStartOfSubtrees[parent] > this.mHead.mColor) {
                        ++parent;
                    }
                    this.mHead.mColor = parent;
                    continue;
                }
                if (this.mHead.mColor == this.mTail.mColor) {
                    this.mHead.addAllPre(this.mHead.mColor, this.mTail);
                    this.mTail.mPre[this.mTail.mColor] = null;
                    if (this.mHead.mColor < this.mMaxColor) {
                        this.mHead.addPre(this.mHead.mColor, Coercion.buildDistinct(this.mHead.getBoundTerm(this.mHead.mColor), this.mTail.getBoundTerm(this.mHead.mColor)));
                    }
                    this.addInterpolantClause(this.mHead.mColor, this.mHead.mPre[this.mHead.mColor]);
                    parent = this.mHead.mColor + 1;
                    while (CCInterpolator.this.mInterpolator.mStartOfSubtrees[parent] > this.mHead.mColor) {
                        ++parent;
                    }
                    this.mHead.mColor = parent;
                    this.mTail.mColor = parent;
                    continue;
                }
                this.mTail.addPre(this.mTail.mColor, Coercion.buildEq(this.mHead.getBoundTerm(this.mMaxColor), this.mTail.getBoundTerm(this.mTail.mColor)));
                this.addInterpolantClause(this.mTail.mColor, this.mTail.mPre[this.mTail.mColor]);
                parent = this.mTail.mColor + 1;
                while (CCInterpolator.this.mInterpolator.mStartOfSubtrees[parent] > this.mTail.mColor) {
                    ++parent;
                }
                this.mTail.mColor = parent;
            }
        }

        class PathEnd {
            int mColor;
            Term[] mTerm;
            Set<Term>[] mPre;

            public PathEnd() {
                this.mColor = CCInterpolator.this.mNumInterpolants;
                this.mTerm = new Term[CCInterpolator.this.mNumInterpolants];
                this.mPre = new Set[CCInterpolator.this.mNumInterpolants];
            }

            public void closeSingleAPath(PathEnd other, Term boundaryTerm) {
                assert (PathInfo.this.mHasABPath.isEmpty());
                int color = this.mColor;
                this.mColor = CCInterpolator.this.getParent(color);
                if (color < PathInfo.this.mMaxColor) {
                    this.addPre(color, Coercion.buildEq(boundaryTerm, this.mTerm[color]));
                    PathInfo.this.addInterpolantClause(color, this.mPre[color]);
                    this.mPre[color] = null;
                    this.mTerm[color] = null;
                } else {
                    assert (PathInfo.this.mMaxColor == color);
                    other.mTerm[color] = boundaryTerm;
                    if (this.mPre[color] != null) {
                        other.mPre[color] = this.mPre[color];
                        this.mPre[color] = null;
                    }
                    PathInfo.this.mMaxColor = CCInterpolator.this.getParent(color);
                }
            }

            public void openSingleAPath(PathEnd other, Term boundaryTerm, int child) {
                if (PathInfo.this.mHasABPath.get(child)) {
                    other.mColor = this.mColor = child;
                    PathInfo.this.mMaxColor = this.mColor;
                    BitSet subtree = new BitSet();
                    subtree.set(CCInterpolator.this.mInterpolator.mStartOfSubtrees[child], child);
                    PathInfo.this.mHasABPath.and(subtree);
                } else {
                    this.mTerm[child] = boundaryTerm;
                    this.mColor = child;
                }
            }

            public void closeAPath(PathEnd other, Term boundaryTerm, Interpolator.Occurrence occur) {
                assert (other.mColor <= PathInfo.this.mMaxColor);
                PathInfo.this.mHasABPath.and(occur.mInA);
                while (this.mColor < CCInterpolator.this.mNumInterpolants && occur.isBLocal(this.mColor)) {
                    this.closeSingleAPath(other, boundaryTerm);
                }
            }

            public void openAPath(PathEnd other, Term boundaryTerm, Interpolator.Occurrence occur) {
                int child;
                while ((child = CCInterpolator.this.getChild(this.mColor, occur)) >= 0) {
                    assert (occur.isALocal(child));
                    this.openSingleAPath(other, boundaryTerm, child);
                }
            }

            public Term getBoundTerm(int color) {
                if (color < this.mColor) {
                    CCTerm first = this == PathInfo.this.mHead ? PathInfo.this.mPath[0] : PathInfo.this.mPath[PathInfo.this.mPath.length - 1];
                    return first.toSMTTerm(CCInterpolator.this.mTheory);
                }
                if (color < PathInfo.this.mMaxColor) {
                    return this.mTerm[color];
                }
                CCTerm last = this == PathInfo.this.mTail ? PathInfo.this.mPath[0] : PathInfo.this.mPath[PathInfo.this.mPath.length - 1];
                return last.toSMTTerm(CCInterpolator.this.mTheory);
            }

            public void addPre(int color, Term pre) {
                if (this.mPre[color] == null) {
                    this.mPre[color] = new HashSet<Term>();
                }
                this.mPre[color].add(pre);
            }

            public void addAllPre(int color, PathEnd src) {
                Set<Term> pre = src.mPre[color];
                if (pre == null) {
                    return;
                }
                if (this.mPre[color] == null) {
                    this.mPre[color] = new HashSet<Term>();
                }
                this.mPre[color].addAll(pre);
            }

            private void mergeCongPath(PathEnd other, CCAppTerm start, CCAppTerm end) {
                int child;
                CCTerm term = start.getFunc();
                while (term instanceof CCAppTerm) {
                    term = ((CCAppTerm)term).getFunc();
                }
                int rightColor = CCInterpolator.this.mInterpolator.getOccurrence(end.getFlatTerm()).getALocalColor();
                Interpolator.Occurrence rightOccur = new Interpolator.Occurrence(CCInterpolator.this.mInterpolator);
                rightOccur.occursIn(rightColor);
                Interpolator.Occurrence leftOccur = new Interpolator.Occurrence(CCInterpolator.this.mInterpolator);
                leftOccur.occursIn(this.mColor);
                FunctionSymbol func = ((CCBaseTerm)term).getFunctionSymbol();
                int numArgs = func.getParameterSorts().length;
                PathInfo[] argPaths = new PathInfo[numArgs];
                PathEnd[] head = new PathEnd[numArgs];
                PathEnd[] tail = new PathEnd[numArgs];
                boolean[] isReverse = new boolean[numArgs];
                int arg = numArgs;
                while (true) {
                    argPaths[--arg] = start.getArg() == end.getArg() ? new PathInfo(start.getArg()) : CCInterpolator.this.mPaths.get(new SymmetricPair<CCTerm>(start.getArg(), end.getArg()));
                    argPaths[arg].interpolatePathInfo();
                    isReverse[arg] = start.getArg() != argPaths[arg].mPath[0];
                    head[arg] = isReverse[arg] ? argPaths[arg].mTail : argPaths[arg].mHead;
                    tail[arg] = isReverse[arg] ? argPaths[arg].mHead : argPaths[arg].mTail;
                    Term startTerm = start.getArg().toSMTTerm(CCInterpolator.this.mTheory);
                    head[arg].closeAPath(tail[arg], startTerm, leftOccur);
                    head[arg].openAPath(tail[arg], startTerm, leftOccur);
                    Term endTerm = end.getArg().toSMTTerm(CCInterpolator.this.mTheory);
                    tail[arg].closeAPath(head[arg], endTerm, rightOccur);
                    tail[arg].openAPath(head[arg], endTerm, rightOccur);
                    if (arg == 0) break;
                    start = (CCAppTerm)start.getFunc();
                    end = (CCAppTerm)end.getFunc();
                }
                PathInfo.this.mHasABPath.and(rightOccur.mInA);
                while (rightOccur.isBLocal(this.mColor)) {
                    Term[] boundaryParams = new Term[numArgs];
                    for (int i = 0; i < numArgs; ++i) {
                        boundaryParams[i] = head[i].getBoundTerm(this.mColor);
                        this.addAllPre(this.mColor, tail[i]);
                    }
                    Term boundaryTerm = Coercion.buildApp(func, boundaryParams);
                    this.closeSingleAPath(other, boundaryTerm);
                }
                int highColor = this.mColor;
                while ((child = CCInterpolator.this.getChild(this.mColor, rightOccur)) >= 0) {
                    Term[] boundaryParams = new Term[numArgs];
                    for (int i = 0; i < numArgs; ++i) {
                        boundaryParams[i] = tail[i].getBoundTerm(child);
                        this.addAllPre(child, tail[i]);
                    }
                    Term boundaryTerm = Coercion.buildApp(func, boundaryParams);
                    this.openSingleAPath(other, boundaryTerm, child);
                }
                assert (this.mColor == rightColor);
                int color = highColor;
                while (color < CCInterpolator.this.mNumInterpolants) {
                    for (int i = 0; i < numArgs; ++i) {
                        if (color < argPaths[i].mMaxColor) {
                            this.addPre(color, Coercion.buildDistinct(head[i].getBoundTerm(color), tail[i].getBoundTerm(color)));
                        }
                        this.addAllPre(color, head[i]);
                        this.addAllPre(color, tail[i]);
                    }
                    color = CCInterpolator.this.getParent(color);
                }
            }

            public String toString() {
                int i;
                StringBuilder sb = new StringBuilder();
                String comma = "";
                sb.append(this.mColor).append(":[");
                for (i = this.mColor; i < PathInfo.this.mMaxColor; ++i) {
                    sb.append(comma);
                    if (this.mPre[i] != null) {
                        sb.append(this.mPre[i]).append(" or ");
                    }
                    sb.append(this.mTerm[i]);
                    comma = ",";
                }
                comma = "|";
                for (i = PathInfo.this.mMaxColor; i < CCInterpolator.this.mNumInterpolants; ++i) {
                    if (this.mPre[i] == null) continue;
                    sb.append(comma).append("pre").append(i).append(':');
                    sb.append(this.mPre[i]);
                    comma = ",";
                }
                sb.append(']');
                return sb.toString();
            }
        }
    }
}

