/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.convert;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Clausifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TermDAG {
    private final LinkedHashSet<TermNode> mRoots = new LinkedHashSet();
    private final ArrayList<ConstTermNode> mConsts = new ArrayList();
    private final ArrayList<VarNode> mVars = new ArrayList();
    private final HashMap<Term, TermNode> mNodes = new HashMap();

    public TermNode[] buildDAG(Term[] triggers) {
        this.mRoots.clear();
        this.mConsts.clear();
        this.mVars.clear();
        this.mNodes.clear();
        for (Term trig : triggers) {
            this.mRoots.add(this.insert(trig));
        }
        return this.mRoots.toArray(new TermNode[this.mRoots.size()]);
    }

    public CCTerm[] getConstants(Clausifier converter) {
        CCTerm[] res = new CCTerm[this.mConsts.size()];
        int i = -1;
        for (ConstTermNode ctn : this.mConsts) {
            res[++i] = converter.getSharedTerm(ctn.getConstant()).getCCTerm();
            ctn.setRegPos(i);
        }
        return res;
    }

    public Iterable<ConstTermNode> getConstants() {
        return this.mConsts;
    }

    public Iterable<VarNode> getVars() {
        return this.mVars;
    }

    private TermNode insert(Term trig) {
        TermNode cached = this.mNodes.get(trig);
        if (cached != null) {
            return cached;
        }
        if (trig.getFreeVars().length == 0) {
            ConstTermNode ctn = new ConstTermNode(trig);
            this.mConsts.add(ctn);
            this.mNodes.put(trig, ctn);
            return ctn;
        }
        if (trig instanceof TermVariable) {
            VarNode vn = new VarNode((TermVariable)trig);
            this.mNodes.put(trig, vn);
            this.mVars.add(vn);
            return vn;
        }
        assert (trig instanceof ApplicationTerm);
        ApplicationTerm at = (ApplicationTerm)trig;
        AppTermNode atn = new AppTermNode(at.getFunction());
        Term[] params = at.getParameters();
        for (int i = 0; i < params.length; ++i) {
            atn.addChild(this.insert(params[i]), i);
        }
        this.mNodes.put(trig, atn);
        return atn;
    }

    public static class VarNode
    extends TermNode {
        final TermVariable mVar;

        public VarNode(TermVariable var) {
            this.mVar = var;
        }

        public TermVariable getVariable() {
            return this.mVar;
        }

        public String toString() {
            return this.mVar.toString();
        }
    }

    public static class ConstTermNode
    extends TermNode {
        final Term mConst;

        public ConstTermNode(Term constant) {
            assert (constant.getFreeVars().length == 0);
            this.mConst = constant;
        }

        public Term getConstant() {
            return this.mConst;
        }

        public String toString() {
            return this.mConst.toString();
        }
    }

    public static class AppTermNode
    extends TermNode {
        final FunctionSymbol mSymbol;

        public AppTermNode(FunctionSymbol symbol) {
            this.mSymbol = symbol;
        }

        public FunctionSymbol getSymbol() {
            return this.mSymbol;
        }

        public int getChildCount() {
            assert (this.mOutgoing.size() == this.mSymbol.getParameterSorts().length);
            return this.mSymbol.getParameterSorts().length;
        }

        public void addChild(TermNode child, int pos) {
            new Edge(this, child, pos);
        }

        public Edge getChild(int pos) {
            Edge res = (Edge)this.mOutgoing.get(pos);
            if (res.getNumber() != pos) {
                for (Edge e : this.mOutgoing) {
                    if (e.getNumber() != pos) continue;
                    return e;
                }
            }
            return res;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('(').append(this.mSymbol.getName());
            for (Edge e : this.mOutgoing) {
                sb.append(' ').append(e.mTo);
            }
            sb.append(')');
            return sb.toString();
        }
    }

    public static final class Edge {
        boolean mMarked = false;
        final TermNode mFrom;
        final TermNode mTo;
        final int mNum;

        public Edge(TermNode from, TermNode to, int num) {
            this.mFrom = from;
            this.mTo = to;
            this.mNum = num;
            from.addOutgoing(this);
            to.addIncomming(this);
        }

        public void mark() {
            this.mMarked = true;
        }

        public boolean isMarked() {
            return this.mMarked;
        }

        public int getNumber() {
            return this.mNum;
        }

        public TermNode getFrom() {
            return this.mFrom;
        }

        public TermNode getTo() {
            return this.mTo;
        }

        public String toString() {
            return this.mFrom + " --> " + this.mTo;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TermNode {
        protected final List<Edge> mIncomming = new ArrayList<Edge>();
        protected final List<Edge> mOutgoing = new ArrayList<Edge>();
        int mRegPos = -1;

        public void addIncomming(Edge in) {
            this.mIncomming.add(in);
        }

        public void addOutgoing(Edge out) {
            this.mOutgoing.add(out);
        }

        public Iterable<Edge> getIncomming() {
            return this.mIncomming;
        }

        public Iterable<Edge> getOutgoing() {
            return this.mOutgoing;
        }

        public void setRegPos(int regPos) {
            this.mRegPos = regPos;
        }

        public int getRegPos() {
            return this.mRegPos;
        }

        public boolean isInRegister() {
            return this.mRegPos != -1;
        }

        public void removeFromRegister() {
            this.mRegPos = -1;
        }
    }
}

