/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.convert;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Utils;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.IProofTracker;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnifyHash;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TermCompiler
extends TermTransformer {
    private boolean mBy0Seen = false;
    private Map<Term, Set<String>> mNames;
    private IProofTracker mTracker;
    private Utils mUtils;
    private final FormulaUnLet mUnletter = new FormulaUnLet();
    private final UnifyHash<SMTAffineTerm> mAffineUnifier = new UnifyHash();

    public void setProofTracker(IProofTracker tracker) {
        this.mTracker = tracker;
        this.mUtils = new Utils(tracker);
    }

    public void setAssignmentProduction(boolean on) {
        this.mNames = on ? new HashMap<Term, Set<String>>() : null;
    }

    public Map<Term, Set<String>> getNames() {
        return this.mNames;
    }

    @Override
    public void convert(Term term) {
        if (term instanceof ApplicationTerm) {
            ApplicationTerm appTerm = (ApplicationTerm)term;
            FunctionSymbol fsym = appTerm.getFunction();
            if (fsym.isModelValue()) {
                throw new SMTLIBException("Model values not allowed in input");
            }
            Term[] params = appTerm.getParameters();
            if (fsym.isLeftAssoc() && params.length > 2) {
                Theory theory = appTerm.getTheory();
                if (fsym == theory.mAnd || fsym == theory.mOr) {
                    this.enqueueWalker(new TermTransformer.BuildApplicationTerm(appTerm));
                    this.pushTerms(params);
                    return;
                }
                this.enqueueWalker(new RewriteAdder(appTerm, null));
                TermTransformer.BuildApplicationTerm dummy = new TermTransformer.BuildApplicationTerm(theory.term(fsym, params[0], params[1]));
                for (int i = params.length - 1; i > 0; --i) {
                    this.enqueueWalker(dummy);
                    this.pushTerm(params[i]);
                }
                this.pushTerm(params[0]);
                return;
            }
            if (fsym.isRightAssoc() && params.length > 2) {
                Theory theory = appTerm.getTheory();
                if (fsym == theory.mImplies) {
                    this.enqueueWalker(new TermTransformer.BuildApplicationTerm(appTerm));
                    this.pushTerms(params);
                    return;
                }
                this.enqueueWalker(new RewriteAdder(appTerm, null));
                TermTransformer.BuildApplicationTerm dummy = new TermTransformer.BuildApplicationTerm(theory.term(fsym, params[params.length - 2], params[params.length - 1]));
                for (int i = params.length - 1; i > 0; --i) {
                    this.enqueueWalker(dummy);
                }
                this.pushTerms(params);
                return;
            }
            if (fsym.isChainable() && params.length > 2 && !fsym.getName().equals("=")) {
                this.enqueueWalker(new RewriteAdder(appTerm, null));
                Theory theory = appTerm.getTheory();
                TermTransformer.BuildApplicationTerm and = new TermTransformer.BuildApplicationTerm(theory.term("and", theory.mTrue, theory.mTrue));
                TermTransformer.BuildApplicationTerm dummy = new TermTransformer.BuildApplicationTerm(theory.term(fsym, params[0], params[1]));
                for (int i = params.length - 1; i > 1; --i) {
                    this.enqueueWalker(and);
                    this.enqueueWalker(dummy);
                    this.pushTerm(params[i]);
                    this.pushTerm(params[i - 1]);
                }
                this.enqueueWalker(dummy);
                this.pushTerm(params[1]);
                this.pushTerm(params[0]);
                return;
            }
        } else if (term instanceof ConstantTerm) {
            SMTAffineTerm res = SMTAffineTerm.create(term);
            this.mTracker.normalized((ConstantTerm)term, res);
            this.setResult(res);
            return;
        }
        super.convert(term);
    }

    @Override
    public void convertApplicationTerm(ApplicationTerm appTerm, Term[] args) {
        FunctionSymbol fsym = appTerm.getFunction();
        Theory theory = appTerm.getTheory();
        if (fsym.getDefinition() != null) {
            Term definition = fsym.getDefinitionVars().length == 0 ? fsym.getDefinition() : theory.let(fsym.getDefinitionVars(), appTerm.getParameters(), fsym.getDefinition());
            Term expanded = this.mUnletter.unlet(definition);
            this.enqueueWalker(new RewriteAdder(appTerm, expanded));
            this.pushTerm(expanded);
            return;
        }
        Sort[] paramSorts = fsym.getParameterSorts();
        Term[] origArgs = null;
        if (theory.getLogic().isIRA() && paramSorts.length == 2 && paramSorts[0].getName().equals("Real") && paramSorts[1] == paramSorts[0]) {
            if (args == appTerm.getParameters()) {
                args = (Term[])args.clone();
            }
            for (int i = 0; i < args.length; ++i) {
                if (!args[i].getSort().getName().equals("Int")) continue;
                if (origArgs == null) {
                    origArgs = this.mTracker.prepareIRAHack(args);
                }
                args[i] = SMTAffineTerm.create(args[i]).typecast(paramSorts[0]);
            }
        }
        if (origArgs != null) {
            this.mTracker.desugar(appTerm, origArgs, args);
        }
        if (fsym.isIntern()) {
            if (fsym == theory.mNot) {
                this.setResult(this.mUtils.createNot(args[0]));
                return;
            }
            if (fsym == theory.mAnd) {
                this.setResult(this.mUtils.createAnd(args));
                return;
            }
            if (fsym == theory.mOr) {
                this.setResult(this.mUtils.createOr(args));
                return;
            }
            if (fsym == theory.mXor) {
                this.mTracker.removeConnective(args, null, 27);
                this.setResult(this.mUtils.createDistinct(args));
                return;
            }
            if (fsym == theory.mImplies) {
                this.mTracker.removeConnective(args, null, 28);
                Term[] tmp = new Term[args.length];
                for (int i = 1; i < args.length; ++i) {
                    tmp[i] = this.mUtils.createNot(args[i - 1]);
                }
                tmp[0] = args[args.length - 1];
                this.setResult(this.mUtils.createOr(tmp));
                return;
            }
            if (fsym.getName().equals("ite")) {
                this.setResult(this.mUtils.createIte(args[0], args[1], args[2]));
                return;
            }
            if (fsym.getName().equals("=")) {
                this.setResult(this.mUtils.createEq(args));
                return;
            }
            if (fsym.getName().equals("distinct")) {
                this.setResult(this.mUtils.createDistinct(args));
                return;
            }
            if (fsym.getName().equals("<=")) {
                Term res = SMTAffineTerm.create(args[0]).add(SMTAffineTerm.create(Rational.MONE, args[1])).normalize(this);
                this.mTracker.removeConnective(args, res, 31);
                this.setResult(this.mUtils.createLeq0(res));
                return;
            }
            if (fsym.getName().equals(">=")) {
                Term res = SMTAffineTerm.create(args[1]).add(SMTAffineTerm.create(Rational.MONE, args[0])).normalize(this);
                this.mTracker.removeConnective(args, res, 33);
                this.setResult(this.mUtils.createLeq0(res));
                return;
            }
            if (fsym.getName().equals(">")) {
                Term res = SMTAffineTerm.create(args[0]).add(SMTAffineTerm.create(Rational.MONE, args[1])).normalize(this);
                this.mTracker.removeConnective(args, res, 34);
                this.setResult(this.mUtils.createNot(this.mUtils.createLeq0(res)));
                return;
            }
            if (fsym.getName().equals("<")) {
                Term res = SMTAffineTerm.create(args[1]).add(SMTAffineTerm.create(Rational.MONE, args[0])).normalize(this);
                this.mTracker.removeConnective(args, res, 32);
                this.setResult(this.mUtils.createNot(this.mUtils.createLeq0(res)));
                return;
            }
            if (fsym.getName().equals("+")) {
                Term res = SMTAffineTerm.create(args[0]).add(SMTAffineTerm.create(args[1])).normalize(this);
                this.mTracker.sum(fsym, args, res);
                this.setResult(res);
                return;
            }
            if (fsym.getName().equals("-") && paramSorts.length == 2) {
                Term res = SMTAffineTerm.create(args[0]).add(SMTAffineTerm.create(Rational.MONE, args[1])).normalize(this);
                this.mTracker.sum(fsym, args, res);
                this.setResult(res);
                return;
            }
            if (fsym.getName().equals("*")) {
                SMTAffineTerm res;
                SMTAffineTerm arg0 = SMTAffineTerm.create(args[0]);
                SMTAffineTerm arg1 = SMTAffineTerm.create(args[1]);
                if (arg0.isConstant()) {
                    res = arg1.mul(arg0.getConstant());
                } else if (arg1.isConstant()) {
                    res = arg0.mul(arg1.getConstant());
                } else {
                    throw new UnsupportedOperationException("Unsupported non-linear arithmetic");
                }
                Term result = res.normalize(this);
                this.mTracker.sum(fsym, args, result);
                this.setResult(result);
                return;
            }
            if (fsym.getName().equals("/")) {
                SMTAffineTerm arg0 = SMTAffineTerm.create(args[0]);
                SMTAffineTerm arg1 = SMTAffineTerm.create(args[1]);
                if (arg1.isConstant()) {
                    if (arg1.getConstant().equals(Rational.ZERO)) {
                        this.mBy0Seen = true;
                        this.setResult(theory.term("@/0", arg0));
                    } else {
                        Term res = arg0.mul(arg1.getConstant().inverse()).normalize(this);
                        this.mTracker.sum(fsym, args, res);
                        this.setResult(res);
                    }
                    return;
                }
                throw new UnsupportedOperationException("Unsupported non-linear arithmetic");
            }
            if (fsym.getName().equals("div")) {
                SMTAffineTerm arg0 = SMTAffineTerm.create(args[0]);
                SMTAffineTerm arg1 = SMTAffineTerm.create(args[1]);
                Term narg0 = arg0.normalize(this);
                Term narg1 = arg1.normalize(this);
                Rational divisor = arg1.getConstant();
                if (arg1.isConstant() && divisor.isIntegral()) {
                    if (divisor.equals(Rational.ZERO)) {
                        this.mBy0Seen = true;
                        this.setResult(theory.term("@div0", narg0));
                    } else if (divisor.equals(Rational.ONE)) {
                        this.mTracker.div(narg0, narg1, narg0, 43);
                        this.setResult(narg0);
                    } else if (divisor.equals(Rational.MONE)) {
                        Term res = arg0.negate().normalize(this);
                        this.mTracker.div(narg0, narg1, res, 44);
                        this.setResult(res);
                    } else if (arg0.isConstant()) {
                        Rational div = TermCompiler.constDiv(arg0.getConstant(), arg1.getConstant());
                        Term res = SMTAffineTerm.create(div.toTerm(arg0.getSort())).normalize(this);
                        this.mTracker.div(narg0, narg1, res, 45);
                        this.setResult(res);
                    } else {
                        this.setResult(theory.term(fsym, narg0, narg1));
                    }
                    return;
                }
                throw new UnsupportedOperationException("Unsupported non-linear arithmetic");
            }
            if (fsym.getName().equals("mod")) {
                SMTAffineTerm arg0 = SMTAffineTerm.create(args[0]);
                SMTAffineTerm arg1 = SMTAffineTerm.create(args[1]);
                Term narg0 = arg0.normalize(this);
                Term narg1 = arg1.normalize(this);
                Rational divisor = arg1.getConstant();
                if (arg1.isConstant() && divisor.isIntegral()) {
                    if (divisor.equals(Rational.ZERO)) {
                        this.mBy0Seen = true;
                        this.setResult(theory.term("@mod0", narg0));
                    } else if (divisor.equals(Rational.ONE)) {
                        Term res = SMTAffineTerm.create(Rational.ZERO.toTerm(arg0.getSort())).normalize(this);
                        this.mTracker.mod(narg0, narg1, res, 40);
                        this.setResult(res);
                    } else if (divisor.equals(Rational.MONE)) {
                        Term res = SMTAffineTerm.create(Rational.ZERO.toTerm(arg0.getSort())).normalize(this);
                        this.mTracker.mod(arg0, arg1, res, 41);
                        this.setResult(res);
                    } else if (arg0.isConstant()) {
                        Rational c0 = arg0.getConstant();
                        Rational c1 = arg1.getConstant();
                        Rational mod = c0.sub(TermCompiler.constDiv(c0, c1).mul(c1));
                        Term res = SMTAffineTerm.create(mod.toTerm(arg0.getSort())).normalize(this);
                        this.mTracker.mod(arg0, arg1, res, 42);
                        this.setResult(res);
                    } else {
                        SMTAffineTerm ydiv = SMTAffineTerm.create(theory.term("div", arg0, arg1)).mul(arg1.getConstant());
                        Term res = arg0.add(ydiv.negate()).normalize(this);
                        this.setResult(res);
                        this.mTracker.modulo(appTerm, res);
                    }
                    return;
                }
                throw new UnsupportedOperationException("Unsupported non-linear arithmetic");
            }
            if (fsym.getName().equals("-") && paramSorts.length == 1) {
                Term res = SMTAffineTerm.create(args[0]).negate().normalize(this);
                this.mTracker.sum(fsym, args, res);
                this.setResult(res);
                return;
            }
            if (fsym.getName().equals("to_real")) {
                SMTAffineTerm arg = SMTAffineTerm.create(args[0]);
                Term res = arg.typecast(fsym.getReturnSort()).normalize(this);
                this.setResult(res);
                if (arg.isConstant()) {
                    this.mTracker.toReal(arg, res);
                }
                return;
            }
            if (fsym.getName().equals("to_int")) {
                SMTAffineTerm arg0 = SMTAffineTerm.create(args[0]);
                if (arg0.isConstant()) {
                    Term res = SMTAffineTerm.create(arg0.getConstant().floor().toTerm(fsym.getReturnSort())).normalize(this);
                    this.mTracker.toInt(arg0, res);
                    this.setResult(res);
                    return;
                }
            } else {
                if (fsym.getName().equals("divisible")) {
                    Rational c1;
                    Rational c0;
                    Rational mod;
                    SMTAffineTerm arg0 = SMTAffineTerm.create(args[0]);
                    SMTAffineTerm arg1 = SMTAffineTerm.create(Rational.valueOf(fsym.getIndices()[0], BigInteger.ONE), arg0.getSort());
                    ApplicationTerm res = arg1.getConstant().equals(Rational.ONE) ? theory.mTrue : (arg0.isConstant() ? ((mod = (c0 = arg0.getConstant()).sub(TermCompiler.constDiv(c0, c1 = arg1.getConstant()).mul(c1))).equals(Rational.ZERO) ? theory.mTrue : theory.mFalse) : theory.term("=", arg0, SMTAffineTerm.create(theory.term("div", arg0, arg1)).mul(arg1.getConstant()).normalize(this)));
                    this.setResult(res);
                    this.mTracker.divisible(appTerm.getFunction(), arg0, res);
                    return;
                }
                if (fsym.getName().equals("store")) {
                    SMTAffineTerm diff;
                    Term array = args[0];
                    Term idx = args[1];
                    Term nestedIdx = TermCompiler.getArrayStoreIdx(array);
                    if (nestedIdx != null && (diff = SMTAffineTerm.create(idx).add(SMTAffineTerm.create(nestedIdx).negate())).isConstant() && diff.getConstant().equals(Rational.ZERO)) {
                        ApplicationTerm appArray = (ApplicationTerm)array;
                        ApplicationTerm result = theory.term(fsym, appArray.getParameters()[0], args[1], args[2]);
                        this.mTracker.arrayRewrite(args, result, 48);
                        this.setResult(result);
                        return;
                    }
                } else if (fsym.getName().equals("select")) {
                    SMTAffineTerm diff;
                    Term array = args[0];
                    Term idx = args[1];
                    Term nestedIdx = TermCompiler.getArrayStoreIdx(array);
                    if (nestedIdx != null && (diff = SMTAffineTerm.create(idx).add(SMTAffineTerm.create(nestedIdx).negate())).isConstant()) {
                        ApplicationTerm appArray = (ApplicationTerm)array;
                        if (diff.getConstant().equals(Rational.ZERO)) {
                            Term result = appArray.getParameters()[2];
                            this.mTracker.arrayRewrite(args, result, 49);
                            this.setResult(result);
                            return;
                        }
                        ApplicationTerm result = theory.term("select", appArray.getParameters()[0], idx);
                        this.mTracker.arrayRewrite(args, result, 49);
                        this.setResult(result);
                        return;
                    }
                } else if (fsym.getName().equals("@undefined")) {
                    throw new SMTLIBException("Undefined value in input");
                }
            }
        }
        super.convertApplicationTerm(appTerm, args);
    }

    public static final Rational constDiv(Rational c0, Rational c1) {
        Rational div = c0.div(c1);
        return c1.isNegative() ? div.ceil() : div.floor();
    }

    private static final Term getArrayStoreIdx(Term array) {
        ApplicationTerm appArray;
        FunctionSymbol arrayFunc;
        if (array instanceof ApplicationTerm && (arrayFunc = (appArray = (ApplicationTerm)array).getFunction()).isIntern() && arrayFunc.getName().equals("store")) {
            return appArray.getParameters()[1];
        }
        return null;
    }

    @Override
    public void postConvertQuantifier(QuantifiedFormula old, Term newBody) {
        if (old.getQuantifier() == 0) {
            super.postConvertQuantifier(old, newBody);
        } else {
            Term negNewBody = this.mUtils.createNot(newBody);
            Theory t = old.getTheory();
            ApplicationTerm res = t.term(t.mNot, t.exists(old.getVariables(), negNewBody));
            this.setResult(res);
        }
    }

    @Override
    public void postConvertAnnotation(AnnotatedTerm old, Annotation[] newAnnots, Term newBody) {
        if (this.mNames != null && newBody.getSort() == newBody.getTheory().getBooleanSort()) {
            Annotation[] oldAnnots;
            for (Annotation annot : oldAnnots = old.getAnnotations()) {
                if (!annot.getKey().equals(":named")) continue;
                Set<String> oldNames = this.mNames.get(newBody);
                if (oldNames == null) {
                    oldNames = new HashSet<String>();
                    this.mNames.put(newBody, oldNames);
                }
                oldNames.add(annot.getValue().toString());
            }
        }
        this.mTracker.strip(old);
        this.setResult(newBody);
    }

    public boolean resetBy0Seen() {
        boolean old = this.mBy0Seen;
        this.mBy0Seen = false;
        return old;
    }

    public SMTAffineTerm unify(SMTAffineTerm affine) {
        return this.mAffineUnifier.unify(affine);
    }

    private static class RewriteAdder
    implements NonRecursive.Walker {
        private final ApplicationTerm mAppTerm;
        private final Term mExpanded;

        public RewriteAdder(ApplicationTerm term, Term expanded) {
            this.mAppTerm = term;
            this.mExpanded = expanded;
        }

        public void walk(NonRecursive engine) {
            TermCompiler transformer = (TermCompiler)engine;
            if (this.mExpanded == null) {
                transformer.mTracker.expand(this.mAppTerm);
            } else {
                transformer.mTracker.expandDef(this.mAppTerm, this.mExpanded);
            }
        }

        public String toString() {
            return "addrewrite " + this.mAppTerm.getFunction().getApplicationString();
        }
    }
}

