/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.convert;

import java.util.AbstractSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleSet<E>
extends AbstractSet<E>
implements Cloneable {
    E[] mElementObjects;
    int mCount = 0;

    public SimpleSet() {
        this(2);
    }

    public SimpleSet(int initialSize) {
        this.mElementObjects = new Object[initialSize];
    }

    @Override
    public int size() {
        return this.mCount;
    }

    @Override
    public boolean add(E element) {
        if (element == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < this.mCount; ++i) {
            if (!element.equals(this.mElementObjects[i])) continue;
            return false;
        }
        if (this.mCount == this.mElementObjects.length) {
            Object[] newArray = new Object[(this.mCount + 1) * 2];
            System.arraycopy(this.mElementObjects, 0, newArray, 0, this.mCount);
            this.mElementObjects = newArray;
        }
        this.mElementObjects[this.mCount++] = element;
        return true;
    }

    public Object clone() {
        try {
            SimpleSet other = (SimpleSet)super.clone();
            other.mElementObjects = (Object[])this.mElementObjects.clone();
            return other;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError("Clone?");
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            int mPos = 0;

            @Override
            public boolean hasNext() {
                return this.mPos < SimpleSet.this.mCount;
            }

            @Override
            public E next() {
                return SimpleSet.this.mElementObjects[this.mPos++];
            }

            @Override
            public void remove() {
                if (this.mPos < SimpleSet.this.mCount) {
                    System.arraycopy(SimpleSet.this.mElementObjects, this.mPos, SimpleSet.this.mElementObjects, this.mPos - 1, SimpleSet.this.mCount - this.mPos);
                }
                --SimpleSet.this.mCount;
                --this.mPos;
            }
        };
    }
}

