/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.convert;

import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;

public class InternTermTransformer
extends TermTransformer {
    protected void convert(Term term) {
        if (term instanceof SMTAffineTerm) {
            SMTAffineTerm old = (SMTAffineTerm)term;
            this.enqueueWalker(new BuildSMTAffineTerm(old));
            this.pushTerms(old.getSummands().keySet().toArray(new Term[old.getSummands().size()]));
        } else {
            super.convert(term);
        }
    }

    protected void convertSMTAffineTerm(SMTAffineTerm old, Term[] newArgs, Term[] oldArgs) {
        SMTAffineTerm res = old;
        if (oldArgs != newArgs) {
            res = SMTAffineTerm.create(old.getConstant(), old.getSort());
            for (int i = 0; i < oldArgs.length; ++i) {
                Rational fac = old.getSummands().get(oldArgs[i]);
                res = res.add(SMTAffineTerm.create(fac, newArgs[i]));
            }
        }
        this.setResult(res);
    }

    private static class BuildSMTAffineTerm
    implements NonRecursive.Walker {
        private final SMTAffineTerm mOld;

        public BuildSMTAffineTerm(SMTAffineTerm old) {
            this.mOld = old;
        }

        public void walk(NonRecursive engine) {
            InternTermTransformer transformer = (InternTermTransformer)engine;
            Term[] oldArgs = this.mOld.getSummands().keySet().toArray(new Term[this.mOld.getSummands().size()]);
            Term[] newArgs = transformer.getConverted(oldArgs);
            transformer.convertSMTAffineTerm(this.mOld, newArgs, oldArgs);
        }
    }
}

