/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.convert;

import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Clausifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SharedTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MutableAffinTerm;

public class EqualityProxy {
    private static final TrueEqualityProxy TRUE = new TrueEqualityProxy();
    private static final FalseEqualityProxy FALSE = new FalseEqualityProxy();
    final Clausifier mClausifier;
    final SharedTerm mLhs;
    final SharedTerm mRhs;
    DPLLAtom mEqAtom;

    public static TrueEqualityProxy getTrueProxy() {
        return TRUE;
    }

    public static FalseEqualityProxy getFalseProxy() {
        return FALSE;
    }

    public EqualityProxy(Clausifier clausifier, SharedTerm lhs, SharedTerm rhs) {
        this.mClausifier = clausifier;
        this.mLhs = lhs;
        this.mRhs = rhs;
    }

    public LAEquality createLAEquality() {
        MutableAffinTerm at = this.mClausifier.createMutableAffinTerm(this.mLhs);
        at.add(Rational.MONE, this.mClausifier.createMutableAffinTerm(this.mRhs));
        return this.mClausifier.getLASolver().createEquality(this.mClausifier.getStackLevel(), at);
    }

    public CCEquality createCCEquality(SharedTerm lhs, SharedTerm rhs) {
        Rational normFactor;
        MutableAffinTerm at;
        Object eq;
        LAEquality laeq;
        assert (lhs.mCCterm != null && rhs.mCCterm != null);
        if (this.mEqAtom == null) {
            laeq = this.createLAEquality();
            this.mEqAtom = laeq;
            this.mClausifier.addToUndoTrail(new RemoveAtom());
        } else if (this.mEqAtom instanceof CCEquality) {
            eq = (CCEquality)this.mEqAtom;
            laeq = ((CCEquality)eq).getLASharedData();
            if (laeq == null) {
                at = this.mClausifier.createMutableAffinTerm(this.mLhs);
                at.add(Rational.MONE, this.mClausifier.createMutableAffinTerm(this.mRhs));
                normFactor = at.getGCD().inverse();
                laeq = this.createLAEquality();
                laeq.addDependentAtom((CCEquality)eq);
                ((CCEquality)eq).setLASharedData(laeq, normFactor);
            }
        } else {
            laeq = (LAEquality)this.mEqAtom;
        }
        for (CCEquality eq2 : laeq.getDependentEqualities()) {
            assert (eq2.getLASharedData() == laeq);
            if (eq2.getLhs() == lhs.mCCterm && eq2.getRhs() == rhs.mCCterm) {
                return eq2;
            }
            if (eq2.getRhs() != lhs.mCCterm || eq2.getLhs() != rhs.mCCterm) continue;
            return eq2;
        }
        eq = this.mClausifier.getCClosure().createCCEquality(this.mClausifier.getStackLevel(), lhs.mCCterm, rhs.mCCterm);
        at = this.mClausifier.createMutableAffinTerm(lhs);
        at.add(Rational.MONE, this.mClausifier.createMutableAffinTerm(rhs));
        normFactor = at.getGCD().inverse();
        laeq.addDependentAtom((CCEquality)eq);
        ((CCEquality)eq).setLASharedData(laeq, normFactor);
        return eq;
    }

    private DPLLAtom createAtom() {
        if (this.mLhs.mCCterm == null && this.mRhs.mCCterm == null) {
            if (this.mClausifier.getCClosure() == null || this.mLhs.mOffset != null && this.mRhs.mOffset == null) {
                this.mRhs.shareWithLinAr();
            }
            if (this.mClausifier.getCClosure() == null || this.mLhs.mOffset == null && this.mRhs.mOffset != null) {
                this.mLhs.shareWithLinAr();
            }
        }
        if (this.mLhs.getSort() != this.mRhs.getSort()) {
            return this.createLAEquality();
        }
        if (!(this.mLhs.mCCterm != null && this.mRhs.mCCterm != null || this.mLhs.mOffset != null && this.mRhs.mOffset != null)) {
            Clausifier.CCTermBuilder cc = this.mClausifier.new Clausifier.CCTermBuilder();
            cc.convert(this.mLhs.getTerm());
            cc.convert(this.mRhs.getTerm());
        }
        if (this.mLhs.mOffset != null && this.mRhs.mOffset != null) {
            return this.createLAEquality();
        }
        return this.mClausifier.getCClosure().createCCEquality(this.mClausifier.getStackLevel(), this.mLhs.mCCterm, this.mRhs.mCCterm);
    }

    public DPLLAtom getLiteral() {
        if (this.mEqAtom == null) {
            this.mEqAtom = this.createAtom();
            if (this.mClausifier.getLogger().isDebugEnabled()) {
                this.mClausifier.getLogger().debug("Created Equality: " + this.mEqAtom);
            }
        }
        return this.mEqAtom;
    }

    public String toString() {
        PrintTerm pt = new PrintTerm();
        StringBuilder sb = new StringBuilder();
        pt.append((Appendable)sb, this.mLhs.getRealTerm());
        sb.append(" == ");
        pt.append((Appendable)sb, this.mRhs.getRealTerm());
        return sb.toString();
    }

    private final class RemoveAtom
    extends Clausifier.TrailObject {
        private RemoveAtom() {
        }

        public void undo() {
            EqualityProxy.this.mEqAtom = null;
        }
    }

    public static final class FalseEqualityProxy
    extends EqualityProxy {
        private FalseEqualityProxy() {
            super(null, null, null);
        }

        public DPLLAtom getLiteral() {
            throw new InternalError("Should never be called");
        }
    }

    public static final class TrueEqualityProxy
    extends EqualityProxy {
        private TrueEqualityProxy() {
            super(null, null, null);
        }

        public DPLLAtom getLiteral() {
            throw new InternalError("Should never be called");
        }
    }
}

