/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.convert;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.EqualityProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.OccurrenceCounter;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SharedTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.TermCompiler;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Utils;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.BooleanVarAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.ClauseDeletionHook;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLEngine;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.IAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.NamedAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.IProofTracker;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.LeafNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.NoopProofTracker;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofTracker;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ResolutionNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.SourceAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.ArrayTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAppTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CClosure;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinArSolve;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MutableAffinTerm;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedArrayList;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Clausifier {
    private final FormulaUnLet mUnlet = new FormulaUnLet();
    private final TermCompiler mCompiler = new TermCompiler();
    private final OccurrenceCounter mOccCounter = new OccurrenceCounter();
    private final Deque<Operation> mTodoStack = new ArrayDeque<Operation>();
    private ProofNode mProof;
    private final Theory mTheory;
    private final DPLLEngine mEngine;
    private CClosure mCClosure;
    private LinArSolve mLASolver;
    private ArrayTheory mArrayTheory;
    private boolean mInstantiationMode;
    private final Map<Term, ClausifierInfo> mClauseData = new HashMap<Term, ClausifierInfo>();
    private final Map<Term, Literal> mLiteralData = new HashMap<Term, Literal>();
    SharedTerm mSharedTrue;
    SharedTerm mSharedFalse;
    private int mNumAtoms = 0;
    private TrailObject mUndoTrail = new TrailObject(){

        public void undo() {
        }
    };
    final ScopedArrayList<SharedTerm> mUnshareCC = new ScopedArrayList();
    final ScopedArrayList<SharedTerm> mUnshareLA = new ScopedArrayList();
    final ScopedHashMap<Term, SharedTerm> mSharedTerms = new ScopedHashMap();
    final ScopedHashMap<SMTAffineTerm, EqualityProxy> mEqualities = new ScopedHashMap();
    private int mStackLevel = 0;
    private int mNumFailedPushes = 0;
    private boolean mWarnedFailedPush = false;
    private final LogProxy mLogger;
    private final IProofTracker mTracker;

    public MutableAffinTerm createMutableAffinTerm(SharedTerm term) {
        SMTAffineTerm at = SMTAffineTerm.create(term.getTerm());
        return this.createMutableAffinTerm(at);
    }

    MutableAffinTerm createMutableAffinTerm(SMTAffineTerm at) {
        MutableAffinTerm res = new MutableAffinTerm();
        res.add(at.getConstant());
        for (Map.Entry<Term, Rational> summand : at.getSummands().entrySet()) {
            SharedTerm shared = this.getSharedTerm(summand.getKey());
            Rational coeff = summand.getValue();
            shared.shareWithLinAr();
            res.add(shared.mFactor.mul(coeff), shared);
            res.add(shared.mOffset.mul(coeff));
        }
        return res;
    }

    public SharedTerm getSharedTerm(Term t) {
        return this.getSharedTerm(t, false);
    }

    public SharedTerm getSharedTerm(Term t, boolean inCCTermBuilder) {
        SharedTerm res;
        if (t instanceof SMTAffineTerm) {
            t = ((SMTAffineTerm)t).internalize(this.mCompiler);
        }
        if ((res = this.mSharedTerms.get(t)) == null) {
            res = new SharedTerm(this, t);
            this.mSharedTerms.put(t, res);
            if (t instanceof ApplicationTerm) {
                ApplicationTerm at = (ApplicationTerm)t;
                if (t.getSort() == t.getTheory().getBooleanSort()) {
                    this.pushOperation(new AddExcludedMiddleAxiom(res));
                } else {
                    FunctionSymbol fs = at.getFunction();
                    if (fs.isInterpreted()) {
                        if (fs.getName().equals("div")) {
                            this.pushOperation(new AddDivideAxioms(t, at.getParameters()[0], SMTAffineTerm.create(at.getParameters()[1]).getConstant()));
                        } else if (fs.getName().equals("to_int")) {
                            this.pushOperation(new AddToIntAxioms(at));
                        } else if (fs.getName().equals("ite") && fs.getReturnSort() != this.mTheory.getBooleanSort()) {
                            this.pushOperation(new AddTermITEAxiom(res));
                        } else if (fs.getName().equals("store")) {
                            this.pushOperation(new AddStoreAxioms(at));
                        } else if (fs.getName().equals("@diff")) {
                            this.pushOperation(new AddDiffAxiom(at));
                        }
                    }
                    if (Clausifier.needCCTerm(fs) && !inCCTermBuilder && at.getParameters().length > 0) {
                        CCTermBuilder cc = new CCTermBuilder();
                        res.mCCterm = cc.convert(t);
                    }
                }
            }
            if (t instanceof SMTAffineTerm) {
                res.shareWithLinAr();
            }
        }
        return res;
    }

    private static boolean needCCTerm(FunctionSymbol fs) {
        return !fs.isInterpreted() || fs.getName() == "select" || fs.getName() == "store" || fs.getName() == "@diff";
    }

    public Clausifier(DPLLEngine engine, int proofLevel) {
        this.mTheory = engine.getSMTTheory();
        this.mEngine = engine;
        this.mLogger = engine.getLogger();
        this.mTracker = proofLevel == 2 ? new ProofTracker() : new NoopProofTracker();
        this.mCompiler.setProofTracker(this.mTracker);
    }

    public void setAssignmentProduction(boolean on) {
        this.mCompiler.setAssignmentProduction(on);
    }

    void pushOperation(Operation op) {
        this.mTodoStack.push(op);
    }

    private static Term toPositive(Term t) {
        assert (!(t instanceof AnnotatedTerm));
        if (t instanceof ApplicationTerm) {
            ApplicationTerm at = (ApplicationTerm)t;
            return at.getFunction() == at.getTheory().mNot ? at.getParameters()[0] : at;
        }
        throw new InternalError("Unclear how to compute positive for " + t);
    }

    NamedAtom createAnonAtom(Term smtFormula) {
        NamedAtom atom = new NamedAtom(smtFormula, this.mStackLevel);
        this.mEngine.addAtom(atom);
        this.mTracker.quoted(smtFormula, atom);
        ++this.mNumAtoms;
        return atom;
    }

    BooleanVarAtom createBooleanVar(Term smtFormula) {
        BooleanVarAtom atom = new BooleanVarAtom(smtFormula, this.mStackLevel);
        this.mUndoTrail = new RemoveAtom(this.mUndoTrail, smtFormula);
        this.mEngine.addAtom(atom);
        ++this.mNumAtoms;
        return atom;
    }

    public EqualityProxy createEqualityProxy(SharedTerm lhs, SharedTerm rhs) {
        SMTAffineTerm diff = SMTAffineTerm.create(lhs.getTerm()).addUnchecked(SMTAffineTerm.create(rhs.getTerm()).negate(), lhs.getSort() == rhs.getSort());
        if (diff.isConstant()) {
            if (diff.getConstant().equals(Rational.ZERO)) {
                return EqualityProxy.getTrueProxy();
            }
            return EqualityProxy.getFalseProxy();
        }
        diff = diff.div(diff.getGcd());
        if (this.mTheory.getLogic().isIRA() && !diff.isIntegral() && diff.isAllIntSummands()) {
            diff = diff.typecast(this.getTheory().getSort("Int", new Sort[0]));
        }
        if (diff.isIntegral() && !diff.getConstant().isIntegral()) {
            return EqualityProxy.getFalseProxy();
        }
        EqualityProxy eqForm = this.mEqualities.get(diff);
        if (eqForm != null) {
            return eqForm;
        }
        eqForm = this.mEqualities.get(diff.negate());
        if (eqForm != null) {
            return eqForm;
        }
        eqForm = new EqualityProxy(this, lhs, rhs);
        this.mEqualities.put(diff, eqForm);
        return eqForm;
    }

    Literal getLiteralForPolarity(Term t, boolean positive) {
        assert (t == Clausifier.toPositive(t));
        ClausifierInfo ci = this.mClauseData.get(t);
        if (ci != null && ci.getLiteral() != null) {
            if (positive) {
                if (!ci.testFlags(4)) {
                    this.pushOperation(new AddAuxAxioms(t, ci.getLiteral(), positive));
                }
                return ci.getLiteral();
            }
            if (!ci.testFlags(8)) {
                this.pushOperation(new AddAuxAxioms(t, ci.getLiteral(), positive));
            }
            return ci.getLiteral().negate();
        }
        return null;
    }

    Literal getLiteral(Term t) {
        Term idx = Clausifier.toPositive(t);
        boolean pos = t == idx;
        ClausifierInfo ci = this.mClauseData.get(idx);
        if (ci == null) {
            ci = new ClausifierInfo();
            this.mClauseData.put(idx, ci);
            this.mUndoTrail = new RemoveClausifierInfo(this.mUndoTrail, idx);
        }
        if (ci.getLiteral() == null) {
            NamedAtom lit = this.createAnonAtom(idx);
            ci.setLiteral(lit);
            this.mUndoTrail = new RemoveLiteral(this.mUndoTrail, ci);
            this.pushOperation(new AddAuxAxioms(idx, lit, pos));
            return pos ? lit : lit.negate();
        }
        if (pos) {
            if (!ci.testFlags(4)) {
                this.pushOperation(new AddAuxAxioms(idx, ci.getLiteral(), true));
            }
            return ci.getLiteral();
        }
        if (!ci.testFlags(8)) {
            this.pushOperation(new AddAuxAxioms(idx, ci.getLiteral(), false));
        }
        return ci.getLiteral().negate();
    }

    Literal getLiteralTseitin(Term t) {
        Term idx = Clausifier.toPositive(t);
        boolean pos = t == idx;
        ClausifierInfo ci = this.mClauseData.get(idx);
        if (ci == null) {
            ci = new ClausifierInfo();
            this.mClauseData.put(idx, ci);
            this.mUndoTrail = new RemoveClausifierInfo(this.mUndoTrail, idx);
        }
        if (ci.getLiteral() == null) {
            NamedAtom lit = this.createAnonAtom(idx);
            ci.setLiteral(lit);
            this.mUndoTrail = new RemoveLiteral(this.mUndoTrail, ci);
            this.pushOperation(new AddAuxAxioms(idx, lit, true));
            this.pushOperation(new AddAuxAxioms(idx, lit, false));
            return pos ? lit : lit.negate();
        }
        if (!ci.testFlags(4)) {
            this.pushOperation(new AddAuxAxioms(idx, ci.getLiteral(), true));
        }
        if (!ci.testFlags(8)) {
            this.pushOperation(new AddAuxAxioms(idx, ci.getLiteral(), false));
        }
        return pos ? ci.getLiteral() : ci.getLiteral().negate();
    }

    ClausifierInfo getInfo(Term idx) {
        assert (idx == Clausifier.toPositive(idx));
        ClausifierInfo res = this.mClauseData.get(idx);
        if (res == null) {
            res = new ClausifierInfo();
            this.mClauseData.put(idx, res);
            this.mUndoTrail = new RemoveClausifierInfo(this.mUndoTrail, idx);
        }
        return res;
    }

    void addClause(Literal[] lits, ClauseDeletionHook hook, ProofNode proof) {
        if (!this.mInstantiationMode) {
            this.mEngine.addFormulaClause(lits, proof, hook);
        }
    }

    void addToUndoTrail(TrailObject obj) {
        obj.setPrevious(this.mUndoTrail);
        this.mUndoTrail = obj;
    }

    private void pushUndoTrail() {
        this.mUndoTrail = new ScopeMarker(this.mUndoTrail);
    }

    private void popUndoTrail() {
        while (!this.mUndoTrail.isScopeMarker()) {
            this.mUndoTrail.undo();
            this.mUndoTrail = this.mUndoTrail.getPrevious();
        }
        this.mUndoTrail = this.mUndoTrail.getPrevious();
    }

    void addUnshareCC(SharedTerm shared) {
        this.mUnshareCC.add(shared);
    }

    void addUnshareLA(SharedTerm shared) {
        this.mUnshareLA.add(shared);
    }

    private void setupCClosure() {
        if (this.mCClosure == null) {
            this.mCClosure = new CClosure(this.mEngine);
            this.mEngine.addTheory(this.mCClosure);
            if (this.mStackLevel != 0) {
                this.mUndoTrail = new RemoveTheory(this.mUndoTrail);
            }
            this.mSharedTrue = new SharedTerm(this, this.mTheory.mTrue);
            this.mSharedTrue.mCCterm = this.mCClosure.createAnonTerm(this.mSharedTrue);
            this.mSharedTerms.put(this.mTheory.mTrue, this.mSharedTrue);
            this.mSharedFalse = new SharedTerm(this, this.mTheory.mFalse);
            this.mSharedFalse.mCCterm = this.mCClosure.createAnonTerm(this.mSharedFalse);
            this.mSharedTerms.put(this.mTheory.mFalse, this.mSharedFalse);
            Literal[] lits = new Literal[]{this.mCClosure.createCCEquality(this.mStackLevel, this.mSharedTrue.mCCterm, this.mSharedFalse.mCCterm).negate()};
            this.mEngine.addFormulaClause(lits, this.getProofNewSource(0, this.mTracker.auxAxiom(0, lits[0], this.mTheory.mTrue, null, null)));
        }
    }

    private void setupLinArithmetic() {
        if (this.mLASolver == null) {
            this.mLASolver = new LinArSolve(this.mEngine);
            this.mEngine.addTheory(this.mLASolver);
        }
    }

    private void setupArrayTheory() {
        if (this.mArrayTheory == null) {
            this.mArrayTheory = new ArrayTheory(this, this.mCClosure);
            this.mEngine.addTheory(this.mArrayTheory);
        }
    }

    public void setLogic(Logics logic) {
        if (this.mEngine.isProofGenerationEnabled()) {
            this.setSourceAnnotation(-1, SourceAnnotation.EMPTY_SOURCE_ANNOT);
        }
        if (logic.isBitVector() || logic.isQuantified() || logic.isNonLinearArithmetic()) {
            throw new UnsupportedOperationException("Logic " + logic.toString() + " unsupported");
        }
        if (logic.isUF() || logic.isArray()) {
            this.setupCClosure();
        }
        if (logic.isArithmetic()) {
            this.setupLinArithmetic();
        }
        if (logic.isArray()) {
            this.setupArrayTheory();
        }
    }

    public Iterable<BooleanVarAtom> getBooleanVars() {
        return new Iterable<BooleanVarAtom>(){

            @Override
            public Iterator<BooleanVarAtom> iterator() {
                return new BooleanVarIterator(Clausifier.this.mLiteralData.values().iterator());
            }
        };
    }

    private final void run() {
        while (!this.mTodoStack.isEmpty()) {
            if (this.mEngine.isTerminationRequested()) {
                this.mTodoStack.clear();
                return;
            }
            Operation op = this.mTodoStack.pop();
            op.perform();
        }
    }

    public DPLLEngine getEngine() {
        return this.mEngine;
    }

    public CClosure getCClosure() {
        return this.mCClosure;
    }

    public LinArSolve getLASolver() {
        return this.mLASolver;
    }

    public LogProxy getLogger() {
        return this.mLogger;
    }

    public int getStackLevel() {
        return this.mStackLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFormula(Term f) {
        Term tmp2;
        if (this.mEngine.inconsistent()) {
            this.mLogger.warn("Already inconsistent.");
            return;
        }
        if (this.mEngine.isProofGenerationEnabled()) {
            this.setSourceAnnotation(-1, SourceAnnotation.EMPTY_SOURCE_ANNOT);
            if (f instanceof AnnotatedTerm) {
                Annotation[] annots;
                AnnotatedTerm at = (AnnotatedTerm)f;
                for (Annotation a : annots = at.getAnnotations()) {
                    if (!a.getKey().equals(":named")) continue;
                    String name = ((String)a.getValue()).intern();
                    this.setSourceAnnotation(-1, new SourceAnnotation(name, null));
                    break;
                }
            }
        }
        Term tmp = this.mUnlet.unlet(f);
        try {
            tmp2 = this.mCompiler.transform(tmp);
        }
        finally {
            this.mCompiler.reset();
        }
        tmp = null;
        Term proof = this.mTracker.getRewriteProof(f);
        this.mTracker.reset();
        this.mOccCounter.count(tmp2);
        Map<Term, Set<String>> names = this.mCompiler.getNames();
        if (names != null) {
            for (Map.Entry<Term, Set<String>> me : names.entrySet()) {
                this.trackAssignment(me.getKey(), me.getValue());
            }
        }
        this.pushOperation(new AddAsAxiom(tmp2, proof));
        this.mInstantiationMode = false;
        this.run();
        this.mOccCounter.reset(tmp2);
        tmp2 = null;
        if (this.mEngine.isProofGenerationEnabled()) {
            this.setSourceAnnotation(-1, SourceAnnotation.EMPTY_SOURCE_ANNOT);
        }
    }

    public void push() {
        if (this.mEngine.inconsistent()) {
            if (!this.mWarnedFailedPush) {
                this.mLogger.warn("Already inconsistent.");
                this.mWarnedFailedPush = true;
            }
            ++this.mNumFailedPushes;
        } else {
            this.mEngine.push();
            ++this.mStackLevel;
            this.mEqualities.beginScope();
            this.mUnshareCC.beginScope();
            this.mUnshareLA.beginScope();
            this.mSharedTerms.beginScope();
            this.pushUndoTrail();
        }
    }

    public void pop(int numpops) {
        if (numpops <= this.mNumFailedPushes) {
            this.mNumFailedPushes -= numpops;
            return;
        }
        this.mWarnedFailedPush = false;
        this.mNumFailedPushes = 0;
        this.mEngine.pop(numpops -= this.mNumFailedPushes);
        for (int i = 0; i < numpops; ++i) {
            for (SharedTerm t : this.mUnshareCC.currentScope()) {
                t.unshareCC();
            }
            this.mUnshareCC.endScope();
            for (SharedTerm t : this.mUnshareLA.currentScope()) {
                t.unshareLA();
            }
            this.mUnshareLA.endScope();
            this.mEqualities.endScope();
            this.popUndoTrail();
            this.mSharedTerms.endScope();
        }
        this.mStackLevel -= numpops;
    }

    public void setSourceAnnotation(int leafKind, IAnnotation sourceAnnot) {
        this.mProof = new LeafNode(leafKind, sourceAnnot);
    }

    private ProofNode getProofNewSource(Term source) {
        return this.getProofNewSource(-1, source);
    }

    private ProofNode getProofNewSource(int leafKind, Term source) {
        if (source == null) {
            return this.mProof;
        }
        if (this.mProof instanceof LeafNode) {
            LeafNode ln = (LeafNode)this.mProof;
            SourceAnnotation annot = new SourceAnnotation((SourceAnnotation)ln.getTheoryAnnotation(), source);
            return new LeafNode(leafKind, annot);
        }
        return this.mProof;
    }

    private ProofNode getClauseProof(Term proofTerm) {
        proofTerm = this.mTracker.clause(proofTerm);
        return this.getProofNewSource(proofTerm);
    }

    public IAnnotation getAnnotation() {
        if (this.mProof instanceof LeafNode) {
            return ((LeafNode)this.mProof).getTheoryAnnotation();
        }
        return null;
    }

    public Theory getTheory() {
        return this.mTheory;
    }

    private void trackAssignment(Term term, Set<String> names) {
        SharedTerm rhs;
        SharedTerm lhs;
        EqualityProxy ep;
        ApplicationTerm at;
        FunctionSymbol fs;
        boolean pos;
        Term idx = Clausifier.toPositive(term);
        boolean bl = pos = idx == term;
        Literal lit = idx instanceof ApplicationTerm ? ((fs = (at = (ApplicationTerm)idx).getFunction()).getName().equals("<=") ? this.createLeq0(at) : (fs.getName().equals("=") && at.getParameters()[0].getSort() != this.mTheory.getBooleanSort() ? ((ep = this.createEqualityProxy(lhs = this.getSharedTerm(at.getParameters()[0]), rhs = this.getSharedTerm(at.getParameters()[1]))) == EqualityProxy.getTrueProxy() ? new DPLLAtom.TrueAtom() : (ep == EqualityProxy.getFalseProxy() ? new DPLLAtom.TrueAtom().negate() : ep.getLiteral())) : ((!fs.isIntern() || fs.getName().equals("select")) && fs.getReturnSort() == this.mTheory.getBooleanSort() ? this.createBooleanLit(at) : (at == this.mTheory.mTrue ? new DPLLAtom.TrueAtom() : (at == this.mTheory.mFalse ? new DPLLAtom.TrueAtom().negate() : this.getLiteralTseitin(idx)))))) : this.getLiteralTseitin(idx);
        if (!pos) {
            lit = lit.negate();
        }
        for (String name : names) {
            this.mEngine.trackAssignment(name, lit);
        }
    }

    private Literal createLeq0(ApplicationTerm leq0term) {
        Literal lit = this.mLiteralData.get(leq0term);
        if (lit == null) {
            SMTAffineTerm sum = SMTAffineTerm.create(leq0term.getParameters()[0]);
            MutableAffinTerm msum = this.createMutableAffinTerm(sum);
            lit = this.mLASolver.generateConstraint(msum, false, this.mStackLevel);
            this.mLiteralData.put(leq0term, lit);
            this.mUndoTrail = new RemoveAtom(this.mUndoTrail, leq0term);
        }
        return lit;
    }

    private Literal createBooleanLit(ApplicationTerm term) {
        Literal lit = this.mLiteralData.get(term);
        if (lit == null) {
            if (term.getParameters().length == 0) {
                lit = this.createBooleanVar(term);
            } else {
                SharedTerm st = this.getSharedTerm(term);
                EqualityProxy eq = this.createEqualityProxy(st, this.mSharedTrue);
                assert (eq != EqualityProxy.getTrueProxy());
                assert (eq != EqualityProxy.getFalseProxy());
                lit = eq.getLiteral();
            }
            this.mLiteralData.put(term, lit);
            this.mUndoTrail = new RemoveAtom(this.mUndoTrail, term);
        }
        return lit;
    }

    public boolean resetBy0Seen() {
        return this.mCompiler.resetBy0Seen();
    }

    public IProofTracker getTracker() {
        return this.mTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Literal getCreateLiteral(Term f) {
        EqualityProxy ep;
        Term tmp2;
        Term tmp = this.mUnlet.unlet(f);
        try {
            tmp2 = this.mCompiler.transform(tmp);
        }
        finally {
            this.mCompiler.reset();
        }
        tmp = null;
        this.mOccCounter.count(tmp2);
        ApplicationTerm at = (ApplicationTerm)tmp2;
        boolean negated = false;
        FunctionSymbol fs = at.getFunction();
        if (fs == this.mTheory.mNot) {
            at = (ApplicationTerm)at.getParameters()[0];
            fs = at.getFunction();
            negated = true;
        }
        Literal res = !fs.isIntern() || fs.getName().equals("select") ? this.createBooleanLit(at) : (at == this.mTheory.mTrue ? new DPLLAtom.TrueAtom() : (at == this.mTheory.mFalse ? new DPLLAtom.TrueAtom().negate() : (fs.getName().equals("=") ? (at.getParameters()[0].getSort() == this.mTheory.getBooleanSort() ? this.getLiteralTseitin(at) : ((ep = this.createEqualityProxy(this.getSharedTerm(at.getParameters()[0]), this.getSharedTerm(at.getParameters()[1]))) == EqualityProxy.getFalseProxy() ? new DPLLAtom.TrueAtom().negate() : (ep == EqualityProxy.getTrueProxy() ? new DPLLAtom.TrueAtom() : ep.getLiteral()))) : (fs.getName().equals("<=") ? this.createLeq0(at) : this.getLiteralTseitin(at)))));
        this.mInstantiationMode = false;
        this.run();
        this.mOccCounter.reset(tmp2);
        tmp2 = null;
        return negated ? res.negate() : res;
    }

    public static boolean shouldFlatten(ApplicationTerm term) {
        return term.getFunction() == term.getTheory().mOr && term.mTmpCtr <= 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BooleanVarIterator
    implements Iterator<BooleanVarAtom> {
        private final Iterator<Literal> mIt;
        private BooleanVarAtom mNext;

        public BooleanVarIterator(Iterator<Literal> it) {
            this.mIt = it;
            this.computeNext();
        }

        private final void computeNext() {
            while (this.mIt.hasNext()) {
                Literal lit = this.mIt.next();
                if (!(lit instanceof BooleanVarAtom)) continue;
                this.mNext = (BooleanVarAtom)lit;
                return;
            }
            this.mNext = null;
        }

        @Override
        public boolean hasNext() {
            return this.mNext != null;
        }

        @Override
        public BooleanVarAtom next() {
            BooleanVarAtom res = this.mNext;
            if (res == null) {
                throw new NoSuchElementException();
            }
            this.computeNext();
            return res;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class AddTermITEAxiom
    implements Operation {
        private final SharedTerm mTermITE;
        private ArrayDeque<Operation> mCollects;

        public AddTermITEAxiom(SharedTerm termITE) {
            this.mTermITE = termITE;
        }

        public void perform() {
            this.mCollects = new ArrayDeque();
            ApplicationTerm ite = (ApplicationTerm)this.mTermITE.getTerm();
            Term cond = ite.getParameters()[0];
            this.mCollects.push(new CollectConditions(new ConditionChain(null, cond), ite.getParameters()[1], this.mTermITE));
            this.mCollects.push(new CollectConditions(new ConditionChain(null, cond, true), ite.getParameters()[2], this.mTermITE));
            while (!this.mCollects.isEmpty()) {
                this.mCollects.pop().perform();
            }
        }

        private class CollectConditions
        implements Operation {
            private final ConditionChain mConds;
            private final Term mTerm;
            private final SharedTerm mIte;

            public CollectConditions(ConditionChain conds, Term term, SharedTerm ite) {
                this.mConds = conds;
                this.mTerm = term;
                this.mIte = ite;
            }

            public void perform() {
                ApplicationTerm at;
                if (this.mTerm instanceof ApplicationTerm && (at = (ApplicationTerm)this.mTerm).getFunction().getName().equals("ite") && at.mTmpCtr <= 1) {
                    Term c = at.getParameters()[0];
                    Term t = at.getParameters()[1];
                    Term e = at.getParameters()[2];
                    AddTermITEAxiom.this.mCollects.push(new CollectConditions(new ConditionChain(this.mConds, c), t, this.mIte));
                    AddTermITEAxiom.this.mCollects.push(new CollectConditions(new ConditionChain(this.mConds, c, true), e, this.mIte));
                    return;
                }
                BuildClause bc = new BuildClause(15);
                bc.auxAxiom(null, this.mTerm, this.mIte.getTerm(), this.mConds);
                Clausifier.this.pushOperation(bc);
                SharedTerm st = Clausifier.this.getSharedTerm(this.mTerm);
                EqualityProxy eqproxy = Clausifier.this.createEqualityProxy(this.mIte, st);
                assert (eqproxy != EqualityProxy.getFalseProxy());
                assert (eqproxy != EqualityProxy.getTrueProxy());
                DPLLAtom eq = eqproxy.getLiteral();
                bc.addLiteral(eq);
                bc.getTracker().eq(this.mIte.getTerm(), this.mTerm, eq);
                ConditionChain walk = this.mConds;
                Utils tmp = new Utils(bc.getTracker());
                while (walk != null) {
                    Clausifier.this.pushOperation(new CollectLiterals(walk.mNegated ? walk.mCond : tmp.createNot(walk.mCond), bc));
                    walk = walk.mPrev;
                }
            }
        }
    }

    public static class ConditionChain {
        final ConditionChain mPrev;
        final Term mCond;
        final boolean mNegated;

        public ConditionChain(ConditionChain prev, Term cond) {
            this(prev, cond, false);
        }

        public ConditionChain(ConditionChain prev, Term cond, boolean negated) {
            this.mPrev = prev;
            this.mCond = cond;
            this.mNegated = negated;
        }

        public Term getTerm() {
            return this.mNegated ? this.mCond.getTheory().term(this.mCond.getTheory().mNot, this.mCond) : this.mCond;
        }

        public ConditionChain getPrevious() {
            return this.mPrev;
        }
    }

    private class AddExcludedMiddleAxiom
    implements Operation {
        private final SharedTerm mSharedTerm;

        public AddExcludedMiddleAxiom(SharedTerm shared) {
            this.mSharedTerm = shared;
        }

        public void perform() {
            EqualityProxy thenProxy = Clausifier.this.createEqualityProxy(this.mSharedTerm, Clausifier.this.mSharedTrue);
            EqualityProxy elseProxy = Clausifier.this.createEqualityProxy(this.mSharedTerm, Clausifier.this.mSharedFalse);
            assert (thenProxy != EqualityProxy.getTrueProxy());
            assert (thenProxy != EqualityProxy.getFalseProxy());
            assert (elseProxy != EqualityProxy.getTrueProxy());
            assert (elseProxy != EqualityProxy.getFalseProxy());
            BuildClause bc1 = new BuildClause(13);
            DPLLAtom lit1 = thenProxy.getLiteral();
            bc1.auxAxiom(lit1, this.mSharedTerm.getTerm(), null, null);
            bc1.addLiteral(lit1);
            Clausifier.this.pushOperation(bc1);
            Clausifier.this.pushOperation(new CollectLiterals(new Utils(bc1.getTracker()).createNot(this.mSharedTerm.getTerm()), bc1));
            BuildClause bc2 = new BuildClause(14);
            DPLLAtom lit2 = elseProxy.getLiteral();
            bc2.auxAxiom(lit2, this.mSharedTerm.getTerm(), null, null);
            bc2.addLiteral(lit2);
            Clausifier.this.pushOperation(bc2);
            Clausifier.this.pushOperation(new CollectLiterals(this.mSharedTerm.getTerm(), bc2));
        }
    }

    private class AddToIntAxioms
    implements Operation {
        private final ApplicationTerm mToIntTerm;

        public AddToIntAxioms(ApplicationTerm toIntTerm) {
            this.mToIntTerm = toIntTerm;
        }

        public void perform() {
            IProofTracker sub = Clausifier.this.mTracker.getDescendent();
            Utils tmp = new Utils(sub);
            SMTAffineTerm realTerm = SMTAffineTerm.create(this.mToIntTerm.getParameters()[0]);
            SMTAffineTerm toInt = SMTAffineTerm.create(this.mToIntTerm).typecast(realTerm.getSort());
            SMTAffineTerm difflow = toInt.add(realTerm.negate());
            Literal lit1 = Clausifier.this.createLeq0((ApplicationTerm)tmp.createLeq0(difflow));
            Term prf = sub.auxAxiom(18, null, difflow, null, null);
            sub.leq0(difflow, lit1);
            Clausifier.this.addClause(new Literal[]{lit1}, null, Clausifier.this.getProofNewSource(18, sub.clause(prf)));
            sub = Clausifier.this.mTracker.getDescendent();
            tmp = new Utils(sub);
            SMTAffineTerm diffhigh = toInt.add(Rational.ONE).add(realTerm.negate());
            prf = sub.auxAxiom(19, null, diffhigh, null, null);
            Literal lit2 = Clausifier.this.createLeq0((ApplicationTerm)tmp.createLeq0(diffhigh));
            sub.leq0(diffhigh, lit2);
            if (lit2.getSign() == -1) {
                sub.negateLit(lit2, Clausifier.this.mTheory);
            }
            Clausifier.this.addClause(new Literal[]{lit2.negate()}, null, Clausifier.this.getProofNewSource(19, sub.clause(prf)));
        }
    }

    private class AddDivideAxioms
    implements Operation {
        private final Term mDivTerm;
        private final Term mDivider;
        private final Rational mDivident;

        public AddDivideAxioms(Term divTerm, Term divider, Rational divident) {
            this.mDivTerm = divTerm;
            this.mDivider = divider;
            this.mDivident = divident;
        }

        public void perform() {
            IProofTracker sub = Clausifier.this.mTracker.getDescendent();
            Utils tmp = new Utils(sub);
            SMTAffineTerm arg = SMTAffineTerm.create(this.mDivider);
            SMTAffineTerm div = SMTAffineTerm.create(this.mDivTerm);
            SMTAffineTerm difflow = div.mul(this.mDivident).add(arg.negate());
            Literal lit1 = Clausifier.this.createLeq0((ApplicationTerm)tmp.createLeq0(difflow));
            Term prf = sub.auxAxiom(16, null, difflow, null, null);
            sub.leq0(difflow, lit1);
            Clausifier.this.addClause(new Literal[]{lit1}, null, Clausifier.this.getProofNewSource(16, sub.clause(prf)));
            sub = Clausifier.this.mTracker.getDescendent();
            tmp = new Utils(sub);
            SMTAffineTerm diffhigh = arg.negate().add(div.mul(this.mDivident)).add(this.mDivident.abs());
            prf = sub.auxAxiom(17, null, diffhigh, null, null);
            Literal lit2 = Clausifier.this.createLeq0((ApplicationTerm)tmp.createLeq0(diffhigh));
            sub.leq0(diffhigh, lit2);
            if (lit2.getSign() == -1) {
                sub.negateLit(lit2, Clausifier.this.mTheory);
            }
            Clausifier.this.addClause(new Literal[]{lit2.negate()}, null, Clausifier.this.getProofNewSource(17, sub.clause(prf)));
        }
    }

    private class BuildClause
    implements Operation {
        private boolean mIsTrue = false;
        private final int mLeafKind;
        private final LinkedHashSet<Literal> mLits = new LinkedHashSet();
        private Term mProofTerm;
        private Term[] mOrigArgs;
        private final IProofTracker mSubTracker = Clausifier.access$000(Clausifier.this).getDescendent();
        private boolean mFlatten;
        private boolean mSimpOr;

        public BuildClause(int leafKind) {
            this.mLeafKind = leafKind;
            this.mProofTerm = null;
        }

        public BuildClause(Term proofTerm, Term original) {
            this(-1);
            this.mProofTerm = proofTerm;
        }

        public void auxAxiom(Literal lit, Term res, Term base, Object auxData) {
            this.mProofTerm = this.mSubTracker.auxAxiom(this.mLeafKind, lit, res, base, auxData);
        }

        public void setProofTerm(Term proof) {
            this.mProofTerm = proof;
        }

        public void setOrigArgs(Term ... args) {
            this.mOrigArgs = args;
        }

        public void addLiteral(Literal lit, Term t) {
            if (this.mSubTracker.notifyLiteral(lit, t)) {
                this.addLiteral(lit);
            } else {
                this.mSimpOr = true;
                this.mSubTracker.restore();
            }
        }

        public void addLiteral(Literal lit) {
            if (this.mLits.add(lit)) {
                this.mIsTrue |= this.mLits.contains(lit.negate());
            } else {
                this.mSimpOr = true;
            }
        }

        public void setTrue() {
            this.mIsTrue = true;
        }

        public void perform() {
            if (!this.mIsTrue) {
                Literal[] lits = this.mLits.toArray(new Literal[this.mLits.size()]);
                if (this.mFlatten) {
                    this.mSubTracker.flatten(this.mOrigArgs, this.mSimpOr);
                } else if (this.mSimpOr) {
                    this.mSubTracker.orSimpClause(this.mOrigArgs);
                }
                Clausifier.this.addClause(lits, null, Clausifier.this.getProofNewSource(this.mLeafKind, this.mSubTracker.clause(this.mProofTerm)));
            }
        }

        public IProofTracker getTracker() {
            return this.mSubTracker;
        }

        public void setFlatten(Term[] origArgs) {
            for (Term t : origArgs) {
                ApplicationTerm at;
                if (!(t instanceof ApplicationTerm) || !Clausifier.shouldFlatten(at = (ApplicationTerm)t)) continue;
                this.mOrigArgs = origArgs;
                this.mFlatten = true;
                return;
            }
        }

        public void setSimpOr() {
            this.mSimpOr = true;
        }
    }

    private class CollectLiterals
    implements Operation {
        private final Term mTerm;
        private final BuildClause mCollector;

        public CollectLiterals(Term term, BuildClause collector) {
            assert (term.getSort() == Clausifier.this.mTheory.getBooleanSort());
            this.mTerm = term;
            this.mCollector = collector;
        }

        public void perform() {
            boolean positive;
            Theory t = this.mTerm.getTheory();
            if (this.mTerm == t.mFalse) {
                return;
            }
            if (this.mTerm == t.mTrue) {
                this.mCollector.setTrue();
                return;
            }
            Term idx = Clausifier.toPositive(this.mTerm);
            boolean bl = positive = this.mTerm == idx;
            if (idx instanceof ApplicationTerm) {
                ApplicationTerm at = (ApplicationTerm)idx;
                if (positive && at.getFunction() == t.mOr) {
                    if (this.mTerm.mTmpCtr > 1) {
                        this.mCollector.getTracker().save();
                        Literal lit = Clausifier.this.getLiteral(idx);
                        this.mCollector.getTracker().quoted(idx, lit.getAtom());
                        this.mCollector.addLiteral(lit, this.mTerm);
                        this.mCollector.getTracker().cleanSave();
                    } else {
                        this.mCollector.setFlatten(at.getParameters());
                        for (Term p : at.getParameters()) {
                            Clausifier.this.pushOperation(new CollectLiterals(p, this.mCollector));
                        }
                    }
                } else if ((!at.getFunction().isIntern() || at.getFunction().getName().equals("select")) && at.getFunction().getReturnSort() == t.getBooleanSort()) {
                    this.mCollector.getTracker().save();
                    Literal lit = Clausifier.this.createBooleanLit(at);
                    this.mCollector.getTracker().intern(idx, lit);
                    this.mCollector.addLiteral(positive ? lit : lit.negate(), this.mTerm);
                    this.mCollector.getTracker().cleanSave();
                } else if (at.getFunction().getName().equals("=") && at.getParameters()[0].getSort() != Clausifier.this.mTheory.getBooleanSort()) {
                    SharedTerm srhs;
                    Term lhs = at.getParameters()[0];
                    Term rhs = at.getParameters()[1];
                    SharedTerm slhs = Clausifier.this.getSharedTerm(lhs);
                    EqualityProxy eq = Clausifier.this.createEqualityProxy(slhs, srhs = Clausifier.this.getSharedTerm(rhs));
                    if (eq == EqualityProxy.getTrueProxy()) {
                        if (positive) {
                            this.mCollector.setTrue();
                        } else {
                            this.mCollector.getTracker().eq(lhs, rhs, ((Clausifier)Clausifier.this).mTheory.mTrue);
                            this.mCollector.getTracker().negation(((Clausifier)Clausifier.this).mTheory.mTrue, ((Clausifier)Clausifier.this).mTheory.mFalse, 14);
                            this.mCollector.getTracker().notifyFalseLiteral(at);
                            this.mCollector.setSimpOr();
                        }
                        return;
                    }
                    if (eq == EqualityProxy.getFalseProxy()) {
                        if (positive) {
                            this.mCollector.getTracker().eq(lhs, rhs, ((Clausifier)Clausifier.this).mTheory.mFalse);
                            this.mCollector.getTracker().notifyFalseLiteral(at);
                            this.mCollector.setSimpOr();
                        } else {
                            this.mCollector.setTrue();
                        }
                        return;
                    }
                    this.mCollector.getTracker().save();
                    DPLLAtom eqAtom = eq.getLiteral();
                    this.mCollector.getTracker().eq(lhs, rhs, eqAtom);
                    this.mCollector.addLiteral(positive ? eqAtom : eqAtom.negate(), this.mTerm);
                    this.mCollector.getTracker().cleanSave();
                } else if (at.getFunction().getName().equals("<=")) {
                    this.mCollector.getTracker().save();
                    Literal lit = Clausifier.this.createLeq0(at);
                    this.mCollector.getTracker().intern(at, lit);
                    if (!positive && lit.getSign() == -1) {
                        this.mCollector.getTracker().negateLit(lit, Clausifier.this.mTheory);
                    }
                    this.mCollector.addLiteral(positive ? lit : lit.negate(), this.mTerm);
                    this.mCollector.getTracker().cleanSave();
                } else {
                    this.mCollector.getTracker().save();
                    Literal lit = Clausifier.this.getLiteral(this.mTerm);
                    this.mCollector.getTracker().quoted(this.mTerm, lit);
                    this.mCollector.addLiteral(lit, this.mTerm);
                    this.mCollector.getTracker().cleanSave();
                }
            } else if (positive) {
                assert (idx instanceof QuantifiedFormula);
                Literal lit = Clausifier.this.getLiteral(idx);
                this.mCollector.addLiteral(lit, this.mTerm);
            }
        }
    }

    private class CreateNegClauseAuxAxioms
    implements Operation {
        Set<Term> mDisjuncts = new LinkedHashSet<Term>();
        private final Literal mAuxLit;

        public CreateNegClauseAuxAxioms(Literal auxLit) {
            this.mAuxLit = auxLit;
        }

        public void init(Term term) {
            Clausifier.this.pushOperation(new CollectDisjuncts(term));
        }

        public void perform() {
            for (Term disj : this.mDisjuncts) {
                BuildClause bc = new BuildClause(2);
                bc.auxAxiom(this.mAuxLit, disj, null, null);
                bc.addLiteral(this.mAuxLit);
                Clausifier.this.pushOperation(bc);
                Term t = new Utils(bc.getTracker()).createNot(disj);
                Clausifier.this.pushOperation(new CollectLiterals(t, bc));
                bc.getTracker().markPosition();
                bc.setOrigArgs(Clausifier.this.mTracker.produceAuxAxiom(this.mAuxLit, t));
            }
        }

        private class CollectDisjuncts
        implements Operation {
            private final Term mTerm;

            public CollectDisjuncts(Term term) {
                this.mTerm = term;
            }

            public void perform() {
                ApplicationTerm at;
                if (this.mTerm instanceof ApplicationTerm && (at = (ApplicationTerm)this.mTerm).getFunction() == at.getTheory().mOr) {
                    for (Term disj : at.getParameters()) {
                        Clausifier.this.pushOperation(new CollectDisjuncts(disj));
                    }
                    return;
                }
                CreateNegClauseAuxAxioms.this.mDisjuncts.add(this.mTerm);
            }
        }
    }

    private class AddAuxAxioms
    implements Operation {
        private final Term mTerm;
        private final Literal mAuxLit;
        private final boolean mPositive;

        public AddAuxAxioms(Term term, Literal lit, boolean pos) {
            assert (term == Clausifier.toPositive(term));
            this.mTerm = term;
            this.mAuxLit = lit;
            this.mPositive = pos;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void perform() {
            int negflag;
            int flag;
            int auxflag;
            ClausifierInfo ci = Clausifier.this.getInfo(this.mTerm);
            if (this.mPositive) {
                auxflag = 4;
                flag = 1;
                negflag = 2;
            } else {
                auxflag = 8;
                flag = 2;
                negflag = 1;
            }
            if (ci.testFlags(auxflag)) {
                return;
            }
            if (ci.testFlags(flag)) {
                return;
            }
            ci.setFlag(auxflag);
            Clausifier.this.mUndoTrail = new RemoveFlag(Clausifier.this.mUndoTrail, ci, auxflag);
            if (ci.testFlags(negflag)) {
                Literal[] unit = new Literal[]{this.mPositive ? this.mAuxLit.negate() : this.mAuxLit};
                if (Clausifier.this.mEngine.isProofGenerationEnabled()) {
                    Clausifier.this.addClause(unit, null, ci.getAxiomProof(Clausifier.this.mTracker, this.mTerm, this.mAuxLit));
                    return;
                } else {
                    Clausifier.this.addClause(unit, null, Clausifier.this.mProof);
                }
                return;
            }
            Theory t = this.mTerm.getTheory();
            if (this.mTerm instanceof ApplicationTerm) {
                ApplicationTerm at = (ApplicationTerm)this.mTerm;
                if (at.getFunction() == t.mOr) {
                    if (this.mPositive) {
                        BuildClause bc = new BuildClause(1);
                        bc.auxAxiom(this.mAuxLit, at, null, null);
                        bc.addLiteral(this.mAuxLit.negate());
                        bc.setOrigArgs(Clausifier.this.mTracker.produceAuxAxiom(this.mAuxLit.negate(), at.getParameters()));
                        Clausifier.this.pushOperation(bc);
                        for (Term param : at.getParameters()) {
                            Clausifier.this.pushOperation(new CollectLiterals(param, bc));
                        }
                        return;
                    } else {
                        CreateNegClauseAuxAxioms helper = new CreateNegClauseAuxAxioms(this.mAuxLit);
                        Clausifier.this.pushOperation(helper);
                        helper.init(this.mTerm);
                    }
                    return;
                } else if (at.getFunction().getName().equals("ite")) {
                    Term cond = at.getParameters()[0];
                    Term thenTerm = at.getParameters()[1];
                    Term elseTerm = at.getParameters()[2];
                    if (this.mPositive) {
                        BuildClause bc1 = new BuildClause(3);
                        bc1.auxAxiom(this.mAuxLit, at, null, null);
                        bc1.addLiteral(this.mAuxLit.negate());
                        Clausifier.this.pushOperation(bc1);
                        Clausifier.this.pushOperation(new CollectLiterals(thenTerm, bc1));
                        Term t1 = new Utils(bc1.getTracker()).createNot(cond);
                        Clausifier.this.pushOperation(new CollectLiterals(t1, bc1));
                        bc1.setOrigArgs(Clausifier.this.mTracker.produceAuxAxiom(this.mAuxLit.negate(), t1, thenTerm));
                        bc1.getTracker().markPosition();
                        BuildClause bc2 = new BuildClause(4);
                        bc2.auxAxiom(this.mAuxLit, at, null, null);
                        bc2.addLiteral(this.mAuxLit.negate());
                        Clausifier.this.pushOperation(bc2);
                        Clausifier.this.pushOperation(new CollectLiterals(elseTerm, bc2));
                        Clausifier.this.pushOperation(new CollectLiterals(cond, bc2));
                        bc2.setOrigArgs(Clausifier.this.mTracker.produceAuxAxiom(this.mAuxLit.negate(), cond, elseTerm));
                        bc2.getTracker().markPosition();
                        BuildClause bc3 = new BuildClause(5);
                        bc3.auxAxiom(this.mAuxLit, at, null, null);
                        bc3.addLiteral(this.mAuxLit.negate());
                        Clausifier.this.pushOperation(bc3);
                        Clausifier.this.pushOperation(new CollectLiterals(elseTerm, bc3));
                        Clausifier.this.pushOperation(new CollectLiterals(thenTerm, bc3));
                        bc3.setOrigArgs(Clausifier.this.mTracker.produceAuxAxiom(this.mAuxLit.negate(), thenTerm, elseTerm));
                        bc3.getTracker().markPosition();
                        return;
                    } else {
                        BuildClause bc1 = new BuildClause(6);
                        Utils tmp1 = new Utils(bc1.getTracker());
                        bc1.auxAxiom(this.mAuxLit, at, null, null);
                        bc1.addLiteral(this.mAuxLit);
                        Clausifier.this.pushOperation(bc1);
                        Term t2 = tmp1.createNot(thenTerm);
                        Clausifier.this.pushOperation(new CollectLiterals(t2, bc1));
                        Term t1 = tmp1.createNot(cond);
                        Clausifier.this.pushOperation(new CollectLiterals(t1, bc1));
                        bc1.setOrigArgs(Clausifier.this.mTracker.produceAuxAxiom(this.mAuxLit, t1, t2));
                        bc1.getTracker().markPosition();
                        tmp1 = null;
                        BuildClause bc2 = new BuildClause(7);
                        bc2.auxAxiom(this.mAuxLit, at, null, null);
                        bc2.addLiteral(this.mAuxLit);
                        Clausifier.this.pushOperation(bc2);
                        t1 = new Utils(bc2.getTracker()).createNot(elseTerm);
                        Clausifier.this.pushOperation(new CollectLiterals(t1, bc2));
                        Clausifier.this.pushOperation(new CollectLiterals(cond, bc2));
                        bc2.setOrigArgs(Clausifier.this.mTracker.produceAuxAxiom(this.mAuxLit, cond, t1));
                        bc2.getTracker().markPosition();
                        BuildClause bc3 = new BuildClause(8);
                        Utils tmp3 = new Utils(bc3.getTracker());
                        bc3.auxAxiom(this.mAuxLit, at, null, null);
                        bc3.addLiteral(this.mAuxLit);
                        Clausifier.this.pushOperation(bc3);
                        t2 = tmp3.createNot(elseTerm);
                        Clausifier.this.pushOperation(new CollectLiterals(t2, bc3));
                        t1 = tmp3.createNot(thenTerm);
                        Clausifier.this.pushOperation(new CollectLiterals(t1, bc3));
                        bc3.setOrigArgs(Clausifier.this.mTracker.produceAuxAxiom(this.mAuxLit, t1, t2));
                        bc3.getTracker().markPosition();
                    }
                    return;
                } else {
                    if (!at.getFunction().getName().equals("=")) throw new InternalError("AuxAxiom not implemented: " + SMTAffineTerm.cleanup(this.mTerm));
                    assert (at.getParameters().length == 2);
                    Term lhs = at.getParameters()[0];
                    Term rhs = at.getParameters()[1];
                    assert (lhs.getSort() == t.getBooleanSort());
                    assert (rhs.getSort() == t.getBooleanSort());
                    if (this.mPositive) {
                        BuildClause bc1 = new BuildClause(9);
                        Utils tmp1 = new Utils(bc1.getTracker());
                        bc1.auxAxiom(this.mAuxLit, at, null, null);
                        bc1.addLiteral(this.mAuxLit.negate());
                        Clausifier.this.pushOperation(bc1);
                        Term t2 = tmp1.createNot(rhs);
                        Clausifier.this.pushOperation(new CollectLiterals(t2, bc1));
                        Clausifier.this.pushOperation(new CollectLiterals(lhs, bc1));
                        bc1.setOrigArgs(Clausifier.this.mTracker.produceAuxAxiom(this.mAuxLit.negate(), lhs, t2));
                        bc1.getTracker().markPosition();
                        tmp1 = null;
                        BuildClause bc2 = new BuildClause(10);
                        Utils tmp2 = new Utils(bc2.getTracker());
                        bc2.auxAxiom(this.mAuxLit, at, null, null);
                        bc2.addLiteral(this.mAuxLit.negate());
                        Clausifier.this.pushOperation(bc2);
                        Clausifier.this.pushOperation(new CollectLiterals(rhs, bc2));
                        Term t1 = tmp2.createNot(lhs);
                        Clausifier.this.pushOperation(new CollectLiterals(t1, bc2));
                        bc2.setOrigArgs(Clausifier.this.mTracker.produceAuxAxiom(this.mAuxLit.negate(), t1, rhs));
                        bc2.getTracker().markPosition();
                        return;
                    } else {
                        BuildClause bc1 = new BuildClause(11);
                        bc1.auxAxiom(this.mAuxLit, at, null, null);
                        bc1.addLiteral(this.mAuxLit);
                        Clausifier.this.pushOperation(bc1);
                        Clausifier.this.pushOperation(new CollectLiterals(rhs, bc1));
                        Clausifier.this.pushOperation(new CollectLiterals(lhs, bc1));
                        bc1.setOrigArgs(Clausifier.this.mTracker.produceAuxAxiom(this.mAuxLit, lhs, rhs));
                        bc1.getTracker().markPosition();
                        BuildClause bc2 = new BuildClause(12);
                        Utils tmp = new Utils(bc2.getTracker());
                        bc2.auxAxiom(this.mAuxLit, at, null, null);
                        bc2.addLiteral(this.mAuxLit);
                        Clausifier.this.pushOperation(bc2);
                        Term t2 = tmp.createNot(rhs);
                        Clausifier.this.pushOperation(new CollectLiterals(t2, bc2));
                        Term t1 = tmp.createNot(lhs);
                        Clausifier.this.pushOperation(new CollectLiterals(t1, bc2));
                        bc2.setOrigArgs(Clausifier.this.mTracker.produceAuxAxiom(this.mAuxLit, t1, t2));
                        bc2.getTracker().markPosition();
                    }
                }
                return;
            } else {
                if (!(this.mTerm instanceof QuantifiedFormula)) throw new InternalError("Don't know how to create aux axiom: " + SMTAffineTerm.cleanup(this.mTerm));
                throw new SMTLIBException("Cannot create quantifier in quantifier-free logic");
            }
        }
    }

    private class AddAsAxiom
    implements Operation {
        private final Term mProofTerm;
        private final Term mTerm;
        private final boolean mNegated;

        public AddAsAxiom(Term term, Term proofTerm) {
            this(term, false, proofTerm);
        }

        public AddAsAxiom(Term term, boolean negated, Term proofTerm) {
            this.mTerm = term;
            this.mNegated = negated;
            this.mProofTerm = proofTerm;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void perform() {
            int negflag;
            int auxflag;
            int flag;
            Term idx = Clausifier.toPositive(this.mTerm);
            ClausifierInfo ci = Clausifier.this.getInfo(idx);
            boolean positive = idx == this.mTerm ^ this.mNegated;
            if (positive) {
                flag = 1;
                auxflag = 4;
                negflag = 2;
            } else {
                flag = 2;
                auxflag = 8;
                negflag = 1;
            }
            if (ci.testFlags(flag)) {
                return;
            }
            if (ci.testFlags(negflag)) {
                if (Clausifier.this.mEngine.isProofGenerationEnabled()) {
                    ResolutionNode.Antecedent ante;
                    Clause primary;
                    NamedAtom idxAtom = new NamedAtom(idx, Clausifier.this.mStackLevel);
                    Clausifier.this.mTracker.quoted(idx, idxAtom);
                    if (positive) {
                        primary = new Clause(new Literal[]{idxAtom}, Clausifier.this.getClauseProof(this.mProofTerm));
                        ante = new ResolutionNode.Antecedent(idxAtom.negate(), new Clause(new Literal[]{idxAtom.negate()}, ci.getAxiomProof(Clausifier.this.mTracker, idx, idxAtom)));
                    } else {
                        primary = new Clause(new Literal[]{idxAtom}, ci.getAxiomProof(Clausifier.this.mTracker, idx, idxAtom));
                        ante = new ResolutionNode.Antecedent(idxAtom.negate(), new Clause(new Literal[]{idxAtom.negate()}, Clausifier.this.getClauseProof(this.mProofTerm)));
                    }
                    ResolutionNode rn = new ResolutionNode(primary, new ResolutionNode.Antecedent[]{ante});
                    Clausifier.this.addClause(new Literal[0], null, rn);
                    return;
                } else {
                    Clausifier.this.addClause(new Literal[0], null, Clausifier.this.mProof);
                }
                return;
            }
            assert (!ci.isAxiomProofAvailable());
            ci.setAxiomProof(this.mTerm, this.mProofTerm, Clausifier.this.getAnnotation(), !positive);
            Clausifier.this.mUndoTrail = new RemoveAxiomProof(Clausifier.this.mUndoTrail, ci);
            Literal auxlit = ci.getLiteral();
            if (auxlit != null) {
                if (!ci.testFlags(auxflag)) {
                    new AddAuxAxioms(idx, auxlit, positive).perform();
                }
                Clausifier.this.mTracker.quoted(idx, auxlit.getAtom());
                Clausifier.this.addClause(new Literal[]{positive ? auxlit : auxlit.negate()}, null, Clausifier.this.getClauseProof(this.mProofTerm));
                ci.setFlag(flag);
                Clausifier.this.mUndoTrail = new RemoveFlag(Clausifier.this.mUndoTrail, ci, flag);
                return;
            }
            ci.setFlag(flag);
            Clausifier.this.mUndoTrail = new RemoveFlag(Clausifier.this.mUndoTrail, ci, flag);
            Theory t = this.mTerm.getTheory();
            if (idx instanceof ApplicationTerm) {
                ApplicationTerm at = (ApplicationTerm)idx;
                if (at.getFunction() == t.mOr) {
                    if (positive) {
                        BuildClause bc = new BuildClause(this.mProofTerm, at);
                        bc.setOrigArgs(at.getParameters());
                        Clausifier.this.pushOperation(bc);
                        for (Term p : at.getParameters()) {
                            Clausifier.this.pushOperation(new CollectLiterals(p, bc));
                        }
                        return;
                    } else {
                        for (Term p : at.getParameters()) {
                            Clausifier.this.pushOperation(new AddAsAxiom(p, true, Clausifier.this.mTracker.split(p, this.mProofTerm, 0)));
                        }
                    }
                    return;
                } else if ((!at.getFunction().isIntern() || at.getFunction().getName().equals("select")) && at.getFunction().getReturnSort() == t.getBooleanSort()) {
                    Literal lit = Clausifier.this.createBooleanLit(at);
                    IProofTracker sub = Clausifier.this.mTracker.getDescendent();
                    sub.intern(at, lit);
                    Clausifier.this.addClause(new Literal[]{positive ? lit : lit.negate()}, null, Clausifier.this.getProofNewSource(sub.clause(this.mProofTerm)));
                    return;
                } else if (at.getFunction().getName().equals("=")) {
                    Term lhs = at.getParameters()[0];
                    Term rhs = at.getParameters()[1];
                    if (lhs.getSort() == t.getBooleanSort()) {
                        Term t2;
                        BuildClause bc1 = new BuildClause(-1);
                        Clausifier.this.pushOperation(bc1);
                        if (positive) {
                            bc1.setProofTerm(Clausifier.this.mTracker.split(at, this.mProofTerm, 1));
                            Clausifier.this.pushOperation(new CollectLiterals(lhs, bc1));
                            t2 = new Utils(bc1.getTracker()).createNot(rhs);
                            Clausifier.this.pushOperation(new CollectLiterals(t2, bc1));
                            bc1.setOrigArgs(lhs, t2);
                        } else {
                            bc1.setProofTerm(Clausifier.this.mTracker.split(at, this.mProofTerm, 3));
                            Clausifier.this.pushOperation(new CollectLiterals(lhs, bc1));
                            Clausifier.this.pushOperation(new CollectLiterals(rhs, bc1));
                            bc1.setOrigArgs(lhs, rhs);
                        }
                        bc1.getTracker().markPosition();
                        BuildClause bc2 = new BuildClause(-1);
                        Clausifier.this.pushOperation(bc2);
                        Utils tmp = new Utils(bc2.getTracker());
                        if (positive) {
                            bc2.setProofTerm(Clausifier.this.mTracker.split(at, this.mProofTerm, 2));
                            Term t1 = tmp.createNot(lhs);
                            Clausifier.this.pushOperation(new CollectLiterals(t1, bc2));
                            Clausifier.this.pushOperation(new CollectLiterals(rhs, bc2));
                            bc2.setOrigArgs(t1, rhs);
                        } else {
                            bc2.setProofTerm(Clausifier.this.mTracker.split(at, this.mProofTerm, 4));
                            Term t1 = tmp.createNot(lhs);
                            Clausifier.this.pushOperation(new CollectLiterals(t1, bc2));
                            t2 = tmp.createNot(rhs);
                            Clausifier.this.pushOperation(new CollectLiterals(t2, bc2));
                            bc2.setOrigArgs(t1, t2);
                        }
                        bc2.getTracker().markPosition();
                        return;
                    } else {
                        SharedTerm srhs;
                        SharedTerm slhs = Clausifier.this.getSharedTerm(lhs);
                        EqualityProxy eq = Clausifier.this.createEqualityProxy(slhs, srhs = Clausifier.this.getSharedTerm(rhs));
                        if (eq == EqualityProxy.getTrueProxy()) {
                            if (positive) return;
                            Clausifier.this.mTracker.eq(lhs, rhs, ((Clausifier)Clausifier.this).mTheory.mTrue);
                            Clausifier.this.mTracker.negation(((Clausifier)Clausifier.this).mTheory.mTrue, ((Clausifier)Clausifier.this).mTheory.mFalse, 14);
                            Clausifier.this.addClause(new Literal[0], null, Clausifier.this.getClauseProof(this.mProofTerm));
                            return;
                        }
                        if (eq == EqualityProxy.getFalseProxy()) {
                            if (!positive) return;
                            Clausifier.this.mTracker.eq(lhs, rhs, ((Clausifier)Clausifier.this).mTheory.mFalse);
                            Clausifier.this.addClause(new Literal[0], null, Clausifier.this.getClauseProof(this.mProofTerm));
                            return;
                        }
                        DPLLAtom lit = eq.getLiteral();
                        IProofTracker sub = Clausifier.this.mTracker.getDescendent();
                        sub.intern(at, lit);
                        Clausifier.this.addClause(new Literal[]{positive ? lit : lit.negate()}, null, Clausifier.this.getProofNewSource(sub.clause(this.mProofTerm)));
                    }
                    return;
                } else if (at.getFunction().getName().equals("ite")) {
                    assert (at.getFunction().getReturnSort() == t.getBooleanSort());
                    Term cond = at.getParameters()[0];
                    Term thenForm = at.getParameters()[1];
                    Term elseForm = at.getParameters()[2];
                    int kind1 = 5;
                    int kind2 = 6;
                    if (!positive) {
                        kind1 = 7;
                        kind2 = 8;
                    }
                    BuildClause bc1 = new BuildClause(-1);
                    bc1.setProofTerm(Clausifier.this.mTracker.split(at, this.mProofTerm, kind1));
                    Utils tmp1 = new Utils(bc1.getTracker());
                    Clausifier.this.pushOperation(bc1);
                    Term t1 = tmp1.createNot(cond);
                    Clausifier.this.pushOperation(new CollectLiterals(t1, bc1));
                    if (!positive) {
                        thenForm = tmp1.createNot(thenForm);
                    }
                    bc1.setOrigArgs(t1, thenForm);
                    tmp1 = null;
                    Clausifier.this.pushOperation(new CollectLiterals(thenForm, bc1));
                    bc1.getTracker().markPosition();
                    BuildClause bc2 = new BuildClause(-1);
                    bc2.setProofTerm(Clausifier.this.mTracker.split(at, this.mProofTerm, kind2));
                    Utils tmp2 = new Utils(bc2.getTracker());
                    Clausifier.this.pushOperation(bc2);
                    Clausifier.this.pushOperation(new CollectLiterals(cond, bc2));
                    if (!positive) {
                        elseForm = tmp2.createNot(elseForm);
                    }
                    bc2.setOrigArgs(cond, elseForm);
                    tmp2 = null;
                    Clausifier.this.pushOperation(new CollectLiterals(elseForm, bc2));
                    bc2.getTracker().markPosition();
                    return;
                } else if (at.getFunction().getName().equals("<=")) {
                    Literal lit = Clausifier.this.createLeq0(at);
                    IProofTracker sub = Clausifier.this.mTracker.getDescendent();
                    sub.intern(at, lit);
                    if (lit.getSign() == -1 && !positive) {
                        sub.negateLit(lit, Clausifier.this.mTheory);
                    }
                    Clausifier.this.addClause(new Literal[]{positive ? lit : lit.negate()}, null, Clausifier.this.getProofNewSource(sub.clause(this.mProofTerm)));
                    return;
                } else {
                    if (at == t.mTrue) return;
                    if (at != t.mFalse) throw new InternalError("Not implementd: " + SMTAffineTerm.cleanup(at));
                    Clausifier.this.addClause(new Literal[0], null, Clausifier.this.getClauseProof(this.mProofTerm));
                }
                return;
            } else {
                if (!(idx instanceof QuantifiedFormula)) throw new InternalError("Don't know how to convert into axiom: " + SMTAffineTerm.cleanup(this.mTerm));
                throw new SMTLIBException("Cannot create quantifier in quantifier-free logic");
            }
        }
    }

    private static interface Operation {
        public void perform();
    }

    private static class ClausifierInfo {
        static final int POS_AXIOMS_ADDED = 1;
        static final int NEG_AXIOMS_ADDED = 2;
        static final int POS_AUX_AXIOMS_ADDED = 4;
        static final int NEG_AUX_AXIOMS_ADDED = 8;
        private Literal mLit = null;
        private int mFlags = 0;
        private Object mProof;

        public void setFlag(int flag) {
            this.mFlags |= flag;
        }

        public void clearFlag(int flag) {
            this.mFlags &= ~flag;
        }

        public boolean testFlags(int flag) {
            return (this.mFlags & flag) != 0;
        }

        public Literal getLiteral() {
            return this.mLit;
        }

        public void setLiteral(Literal lit) {
            this.mLit = lit;
        }

        public void clearLiteral() {
            this.mLit = null;
        }

        public void setAxiomProof(Term term, Term proof, IAnnotation annot, boolean negated) {
            this.mProof = proof == null ? annot : new ProofData(term, proof, annot, negated);
        }

        boolean isAxiomProofAvailable() {
            return this.mProof != null;
        }

        public ProofNode getAxiomProof(IProofTracker tracker, Term idx, Literal lit) {
            if (this.mProof instanceof IAnnotation) {
                return new LeafNode(-1, (IAnnotation)this.mProof);
            }
            ProofData pd = (ProofData)this.mProof;
            Theory t = pd.mTerm.getTheory();
            IProofTracker sub = tracker.getDescendent();
            Term unquoted = pd.mTerm;
            if (pd.mNegated && this.testFlags(1)) {
                sub.negation(t.term(t.mNot, unquoted), unquoted, 14);
            }
            sub.intern(idx, lit);
            return new LeafNode(-1, new SourceAnnotation((SourceAnnotation)pd.mAnnot, sub.clause(pd.mAxiomProof)));
        }

        public void clearAxiomProof() {
            this.mProof = null;
        }

        private static class ProofData {
            private final Term mTerm;
            private final Term mAxiomProof;
            private final IAnnotation mAnnot;
            private final boolean mNegated;

            public ProofData(Term term, Term axiomProof, IAnnotation annot, boolean neg) {
                this.mTerm = term;
                this.mAxiomProof = axiomProof;
                this.mAnnot = annot;
                this.mNegated = neg;
            }
        }
    }

    private class RemoveAtom
    extends TrailObject {
        private final Term mTerm;

        public RemoveAtom(TrailObject prev, Term term) {
            super(prev);
            this.mTerm = term;
        }

        public void undo() {
            Clausifier.this.mLiteralData.remove(this.mTerm);
        }
    }

    private class RemoveAxiomProof
    extends TrailObject {
        private final ClausifierInfo mCi;

        public RemoveAxiomProof(TrailObject prev, ClausifierInfo ci) {
            super(prev);
            this.mCi = ci;
        }

        public void undo() {
            this.mCi.clearAxiomProof();
        }
    }

    private class RemoveLiteral
    extends TrailObject {
        private final ClausifierInfo mCi;

        public RemoveLiteral(TrailObject prev, ClausifierInfo ci) {
            super(prev);
            this.mCi = ci;
        }

        public void undo() {
            this.mCi.clearLiteral();
        }
    }

    private class RemoveFlag
    extends TrailObject {
        private final ClausifierInfo mCi;
        private final int mFlag;

        public RemoveFlag(TrailObject prev, ClausifierInfo ci, int flag) {
            super(prev);
            this.mCi = ci;
            this.mFlag = flag;
        }

        public void undo() {
            this.mCi.clearFlag(this.mFlag);
        }
    }

    private class RemoveClausifierInfo
    extends TrailObject {
        private final Term mTerm;

        public RemoveClausifierInfo(TrailObject prev, Term term) {
            super(prev);
            this.mTerm = term;
        }

        public void undo() {
            Clausifier.this.mClauseData.remove(this.mTerm);
        }
    }

    private class ScopeMarker
    extends TrailObject {
        public ScopeMarker(TrailObject prev) {
            super(prev);
        }

        public void undo() {
        }

        public boolean isScopeMarker() {
            return true;
        }
    }

    private class RemoveTheory
    extends TrailObject {
        public RemoveTheory(TrailObject prev) {
            super(prev);
        }

        public void undo() {
            Clausifier.this.mEngine.removeTheory();
        }
    }

    static abstract class TrailObject {
        private TrailObject mPrev;

        protected TrailObject() {
            this.mPrev = this;
        }

        protected TrailObject(TrailObject prev) {
            this.mPrev = prev;
        }

        public abstract void undo();

        public TrailObject getPrevious() {
            return this.mPrev;
        }

        void setPrevious(TrailObject prev) {
            this.mPrev = prev;
        }

        public boolean isScopeMarker() {
            return false;
        }
    }

    public class CCTermBuilder {
        private final ArrayDeque<Operation> mOps = new ArrayDeque();
        private final ArrayDeque<CCTerm> mConverted = new ArrayDeque();

        public CCTermBuilder() {
            if (Clausifier.this.mCClosure == null) {
                Clausifier.this.setupCClosure();
            }
        }

        public CCTerm convert(Term t) {
            this.mOps.push(new BuildCCTerm(t));
            while (!this.mOps.isEmpty()) {
                this.mOps.pop().perform();
            }
            CCTerm res = this.mConverted.pop();
            assert (this.mConverted.isEmpty());
            return res;
        }

        private class BuildCCAppTerm
        implements Operation {
            private final boolean mIsFunc;

            public BuildCCAppTerm(boolean isFunc) {
                this.mIsFunc = isFunc;
            }

            public void perform() {
                CCTerm arg = (CCTerm)CCTermBuilder.this.mConverted.pop();
                CCTerm func = (CCTerm)CCTermBuilder.this.mConverted.pop();
                CCTermBuilder.this.mConverted.push(Clausifier.this.mCClosure.createAppTerm(this.mIsFunc, func, arg));
            }
        }

        private class SaveCCTerm
        implements Operation {
            private final SharedTerm mShared;

            public SaveCCTerm(SharedTerm shared) {
                this.mShared = shared;
            }

            public void perform() {
                this.mShared.setCCTerm((CCTerm)CCTermBuilder.this.mConverted.peek());
                Clausifier.this.mCClosure.addTerm(this.mShared.mCCterm, this.mShared);
                Term t = this.mShared.getTerm();
                if (t.getSort().isArraySort()) {
                    ApplicationTerm at = (ApplicationTerm)t;
                    Clausifier.this.mArrayTheory.notifyArray(this.mShared.mCCterm, at.getFunction().getName().equals("store"));
                }
                if (t instanceof ApplicationTerm && ((ApplicationTerm)t).getFunction().getName().equals("@diff")) {
                    Clausifier.this.mArrayTheory.notifyDiff((CCAppTerm)this.mShared.mCCterm);
                }
            }
        }

        private class BuildCCTerm
        implements Operation {
            private Term mTerm;

            public BuildCCTerm(Term term) {
                this.mTerm = term;
            }

            public void perform() {
                SharedTerm shared = Clausifier.this.getSharedTerm(this.mTerm, true);
                if (shared.mCCterm == null) {
                    FunctionSymbol fs = this.getSymbol();
                    if (fs == null) {
                        CCTerm res = Clausifier.this.mCClosure.createAnonTerm(shared);
                        shared.setCCTerm(res);
                        CCTermBuilder.this.mConverted.push(res);
                        if (this.mTerm.getSort().isArraySort()) {
                            Clausifier.this.mArrayTheory.notifyArray(res, false);
                        }
                    } else {
                        CCTermBuilder.this.mOps.push(new SaveCCTerm(shared));
                        ApplicationTerm at = (ApplicationTerm)this.mTerm;
                        Term[] args = at.getParameters();
                        for (int i = args.length - 1; i >= 0; --i) {
                            CCTermBuilder.this.mOps.push(new BuildCCAppTerm(i != args.length - 1));
                            CCTermBuilder.this.mOps.push(new BuildCCTerm(args[i]));
                        }
                        CCTermBuilder.this.mConverted.push(Clausifier.this.mCClosure.getFuncTerm(fs));
                    }
                } else {
                    CCTermBuilder.this.mConverted.push(shared.mCCterm);
                }
            }

            private FunctionSymbol getSymbol() {
                ApplicationTerm at;
                FunctionSymbol fs;
                if (this.mTerm instanceof SMTAffineTerm) {
                    this.mTerm = ((SMTAffineTerm)this.mTerm).internalize(Clausifier.this.mCompiler);
                }
                if (this.mTerm instanceof ApplicationTerm && Clausifier.needCCTerm(fs = (at = (ApplicationTerm)this.mTerm).getFunction())) {
                    return fs;
                }
                return null;
            }
        }
    }

    private final class AddDiffAxiom
    implements Operation {
        private final ApplicationTerm mDiff;

        public AddDiffAxiom(ApplicationTerm diff) {
            this.mDiff = diff;
        }

        public void perform() {
            SharedTerm sharedB;
            Term a = this.mDiff.getParameters()[0];
            Term b = this.mDiff.getParameters()[1];
            SharedTerm sharedA = Clausifier.this.getSharedTerm(a);
            EqualityProxy eparray = Clausifier.this.createEqualityProxy(sharedA, sharedB = Clausifier.this.getSharedTerm(b));
            if (eparray == EqualityProxy.getTrueProxy()) {
                return;
            }
            IProofTracker sub = Clausifier.this.mTracker.getDescendent();
            Theory t = this.mDiff.getTheory();
            ApplicationTerm selecta = t.term("select", a, this.mDiff);
            ApplicationTerm selectb = t.term("select", b, this.mDiff);
            SharedTerm sharedSelectA = Clausifier.this.getSharedTerm(selecta);
            SharedTerm sharedSelectB = Clausifier.this.getSharedTerm(selectb);
            EqualityProxy epselect = Clausifier.this.createEqualityProxy(sharedSelectA, sharedSelectB);
            Literal[] lits = new Literal[]{eparray.getLiteral(), epselect.getLiteral().negate()};
            Term prf = sub.auxAxiom(21, null, this.mDiff, null, null);
            Clausifier.this.addClause(lits, null, Clausifier.this.getProofNewSource(21, sub.clause(prf)));
        }
    }

    private final class AddStoreAxioms
    implements Operation {
        private final ApplicationTerm mStore;

        public AddStoreAxioms(ApplicationTerm store) {
            this.mStore = store;
        }

        public void perform() {
            IProofTracker sub = Clausifier.this.mTracker.getDescendent();
            Term i = this.mStore.getParameters()[1];
            Term v = this.mStore.getParameters()[2];
            ApplicationTerm selstore = Clausifier.this.mTheory.term("select", this.mStore, i);
            EqualityProxy ep = Clausifier.this.createEqualityProxy(Clausifier.this.getSharedTerm(selstore), Clausifier.this.getSharedTerm(v));
            DPLLAtom lit = ep.getLiteral();
            Term prf = sub.auxAxiom(20, null, this.mStore, null, null);
            Clausifier.this.addClause(new Literal[]{lit}, null, Clausifier.this.getProofNewSource(20, sub.clause(prf)));
            if (v.getSort() == Clausifier.this.mTheory.getBooleanSort()) {
                Term a = this.mStore.getParameters()[0];
                ApplicationTerm sel = Clausifier.this.mTheory.term("select", a, i);
                Clausifier.this.getSharedTerm(sel);
            }
        }
    }
}

