/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.convert;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.InternTermTransformer;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArithDelay
extends InternTermTransformer {
    private final ScopedHashMap<Rational, Term> mArithConsts = new ScopedHashMap();

    private Term replace(Rational constant, Theory t, Sort s) {
        Term replacement = this.mArithConsts.get(constant);
        if (replacement == null) {
            String rep = "@" + constant.toString();
            FunctionSymbol fsym = t.getFunction(rep, new Sort[0]);
            if (fsym == null) {
                fsym = t.declareFunction(rep, Script.EMPTY_SORT_ARRAY, s);
            }
            replacement = t.term(fsym, new Term[0]);
            this.mArithConsts.put(constant, replacement);
        }
        return replacement;
    }

    @Override
    public void convertApplicationTerm(ApplicationTerm appTerm, Term[] newArgs) {
        Theory t = appTerm.getTheory();
        if (appTerm.getFunction().getName().equals("<=")) {
            SMTAffineTerm arg0 = (SMTAffineTerm)newArgs[0];
            if (arg0.getConstant().compareTo(Rational.ZERO) != 0) {
                Rational constant = arg0.getConstant();
                Term replacement = this.replace(constant, t, arg0.getSort());
                HashMap<Term, Rational> summands = new HashMap<Term, Rational>(arg0.getSummands());
                summands.put(replacement, Rational.ONE);
                SMTAffineTerm res = SMTAffineTerm.create(summands, Rational.ZERO, arg0.getSort());
                this.setResult(t.term(appTerm.getFunction(), res, newArgs[1]));
                return;
            }
        } else if (appTerm.getFunction().getName().equals("=")) {
            Term[] args = newArgs;
            for (int i = 0; i < newArgs.length; ++i) {
                SMTAffineTerm arg;
                if (!(args[i] instanceof SMTAffineTerm) || !(arg = (SMTAffineTerm)args[i]).isConstant()) continue;
                if (newArgs == args) {
                    args = (Term[])newArgs.clone();
                }
                args[i] = this.replace(arg.getConstant(), t, arg.getSort());
            }
            this.setResult(t.term(appTerm.getFunction(), args));
            return;
        }
        super.convertApplicationTerm(appTerm, newArgs);
    }

    public Iterable<Term> getReplacedEqs() {
        return new Iterable<Term>(){

            @Override
            public Iterator<Term> iterator() {
                return new Iterator<Term>(){
                    private final Iterator<Map.Entry<Rational, Term>> mIt;
                    {
                        this.mIt = ArithDelay.this.mArithConsts.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.mIt.hasNext();
                    }

                    @Override
                    public Term next() {
                        Map.Entry<Rational, Term> me = this.mIt.next();
                        Term val = me.getValue();
                        Theory t = val.getTheory();
                        return t.term("=", me.getKey().toTerm(val.getSort()), val);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public TermTransformer getReverter() {
        final HashMap<Term, Term> reverted = new HashMap<Term, Term>();
        for (Map.Entry<Rational, Term> me : this.mArithConsts.entrySet()) {
            Term nkey = me.getValue();
            reverted.put(nkey, me.getKey().toTerm(nkey.getSort()));
        }
        return new InternTermTransformer(){

            public void convertApplicationTerm(ApplicationTerm appTerm, Term[] newArgs) {
                Term rep = (Term)reverted.get(appTerm);
                if (rep == null) {
                    super.convertApplicationTerm(appTerm, newArgs);
                } else {
                    this.setResult(rep);
                }
            }
        };
    }

    public boolean isEmpty() {
        return this.mArithConsts.isEmpty();
    }

    public void push() {
        this.mArithConsts.beginScope();
    }

    public void pop() {
        this.mArithConsts.endScope();
    }
}

