/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.aiger;

import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.Model;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.IParser;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.OptionMap;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class AIGERFrontEnd
implements IParser {
    private static final int BUFFER_SIZE = 4096;
    private static final boolean USE_DEFINITIONS = true;
    private static final int TT_MAGIC = 0;
    private static final int TT_SPACE = 1;
    private static final int TT_NUMBER = 2;
    private static final int TT_NEWLINE = 3;
    private static final int TT_EOF = 4;
    private static final int TT_STS = 5;
    private static final int TT_STRING = 6;
    private static final int TT_COMMENT = 7;
    private static final int TT_BNUMBER = 8;
    private int mLine = 1;
    private int mCol = 0;
    private String mFilename;
    private InputStream mInputStream;
    private Script mSolver;
    private BigInteger mNumAnds;
    private String[] mInputs;
    private byte[] mBuffer = new byte[4096];
    private int mBufpos = 0;
    private int mBufsize = -1;

    private void reportError(String msg) {
        System.err.print(this.mFilename);
        System.err.print(':');
        System.err.print(this.mLine);
        System.err.print(':');
        System.err.print(this.mCol);
        System.err.print(':');
        System.err.println(msg);
        System.exit(2);
    }

    private final int nextChar() throws IOException {
        if (this.mBufpos >= this.mBufsize) {
            this.mBufsize = this.mInputStream.read(this.mBuffer);
            if (this.mBufsize == -1) {
                return -1;
            }
            this.mBufpos = 0;
        }
        ++this.mCol;
        return this.mBuffer[this.mBufpos++] & 0xFF;
    }

    private final void ungetLastChar() {
        assert (this.mBufpos > 0);
        --this.mCol;
        --this.mBufpos;
    }

    private Object nextToken(int expected) {
        try {
            int ch = this.nextChar();
            switch (expected) {
                case 0: {
                    if (ch != 97) {
                        return null;
                    }
                    ch = this.nextChar();
                    if (ch != 105) {
                        return null;
                    }
                    ch = this.nextChar();
                    if (ch != 103) {
                        return null;
                    }
                    return "aig";
                }
                case 1: {
                    if (ch == 32) {
                        return " ";
                    }
                    this.ungetLastChar();
                    return null;
                }
                case 2: {
                    StringBuilder buffer = new StringBuilder();
                    while (ch != -1 && Character.isDigit((char)ch)) {
                        buffer.append((char)ch);
                        ch = this.nextChar();
                    }
                    this.ungetLastChar();
                    if (buffer.length() == 0) {
                        return null;
                    }
                    String result = buffer.toString();
                    return result;
                }
                case 4: {
                    if (ch == -1) {
                        return "";
                    }
                    this.ungetLastChar();
                    return null;
                }
                case 3: {
                    if (ch == 10) {
                        ++this.mLine;
                        this.mCol = 0;
                        return "\n";
                    }
                    this.ungetLastChar();
                    return null;
                }
                case 5: {
                    if (ch == 105 || ch == 108 || ch == 111) {
                        return Character.toString((char)ch);
                    }
                    this.ungetLastChar();
                    return null;
                }
                case 6: {
                    StringBuilder buffer = new StringBuilder();
                    while (ch != -1 && ch != 10) {
                        buffer.append((char)ch);
                        ch = this.nextChar();
                    }
                    this.ungetLastChar();
                    String result = buffer.toString();
                    return result;
                }
                case 7: {
                    if (ch == 99) {
                        return "c";
                    }
                    this.ungetLastChar();
                    return null;
                }
                case 8: {
                    BigInteger tmp;
                    BigInteger x = BigInteger.ZERO;
                    int i = 0;
                    while ((ch & 0x80) != 0) {
                        tmp = BigInteger.valueOf(ch & 0x7F);
                        assert (7 * i >= 0);
                        tmp = tmp.shiftLeft(7 * i++);
                        x = x.or(tmp);
                        ch = this.nextChar();
                        if (ch != -1) continue;
                        System.err.println("File corrupted");
                        System.exit(5);
                    }
                    tmp = BigInteger.valueOf(ch & 0x7F);
                    assert (7 * i >= 0);
                    tmp = tmp.shiftLeft(7 * i);
                    x = x.or(tmp);
                    return x;
                }
            }
            this.ungetLastChar();
            return null;
        }
        catch (IOException eioe) {
            System.err.println(eioe.getMessage());
            System.exit(1);
            return null;
        }
    }

    private final void getOneSpace() {
        if (this.nextToken(1) == null) {
            this.reportError("Expected one space");
        }
    }

    private final void getNewline() {
        if (this.nextToken(3) == null) {
            this.reportError("Expected newline");
        }
    }

    private final String getNumber() {
        String res = (String)this.nextToken(2);
        if (res == null) {
            this.reportError("Expected a number");
        }
        return res;
    }

    private void parseHeader() {
        if (this.nextToken(0) == null) {
            this.reportError("Expected magic (\"aig\")");
        }
        this.getOneSpace();
        BigInteger maxVarNum = new BigInteger(this.getNumber());
        this.getOneSpace();
        this.mInputs = new String[Integer.parseInt(this.getNumber())];
        this.getOneSpace();
        if (!this.getNumber().equals("0")) {
            System.err.println("No latches allowed for SAT checking");
            System.exit(3);
        }
        this.getOneSpace();
        if (!this.getNumber().equals("1")) {
            System.err.println("Only one output allowed for SAT checking");
            System.exit(3);
        }
        this.getOneSpace();
        this.mNumAnds = new BigInteger(this.getNumber());
        this.getNewline();
        if (!maxVarNum.equals(this.mNumAnds.add(BigInteger.valueOf(this.mInputs.length)))) {
            System.err.println("File header corrupted!");
            System.exit(5);
        }
    }

    private void parseSymbolTable() {
        String sts;
        while ((sts = (String)this.nextToken(5)) != null) {
            String num = this.getNumber();
            this.getOneSpace();
            String name = (String)this.nextToken(6);
            if (name == null) {
                this.reportError("Expected a string");
                System.exit(2);
            }
            this.getNewline();
            if (!sts.equals("i")) continue;
            int idx = Integer.parseInt(num);
            this.mInputs[idx] = name;
        }
    }

    private void parseCommentSection() {
        block1: {
            if (this.nextToken(7) == null) break block1;
            do {
                this.getNewline();
            } while (this.nextToken(6) != null);
        }
    }

    private Term toTerm(BigInteger lit) {
        if (lit.equals(BigInteger.ZERO)) {
            return this.mSolver.term("false", new Term[0]);
        }
        if (lit.equals(BigInteger.ONE)) {
            return this.mSolver.term("true", new Term[0]);
        }
        Term res = this.mSolver.term(lit.shiftRight(1).toString(), new Term[0]);
        if (lit.testBit(0)) {
            res = this.mSolver.term("not", res);
        }
        return res;
    }

    private void parse() {
        this.parseHeader();
        Sort bool = this.mSolver.sort("Bool", new Sort[0]);
        Sort[] empty = new Sort[]{};
        for (int i = 0; i < this.mInputs.length; ++i) {
            this.mSolver.declareFun(Integer.toString(i + 1), empty, bool);
        }
        BigInteger output = new BigInteger(this.getNumber());
        this.getNewline();
        TermVariable[] emptyVars = new TermVariable[]{};
        BigInteger start = BigInteger.valueOf(this.mInputs.length);
        BigInteger end = start.add(this.mNumAnds);
        start = start.add(BigInteger.ONE);
        while (start.compareTo(end) <= 0) {
            BigInteger delta0 = (BigInteger)this.nextToken(8);
            BigInteger delta1 = (BigInteger)this.nextToken(8);
            BigInteger rhs0 = start.shiftLeft(1).subtract(delta0);
            assert (start.shiftLeft(1).compareTo(rhs0) > 0);
            Term[] args = new Term[2];
            args[0] = this.toTerm(rhs0);
            BigInteger rhs1 = rhs0.subtract(delta1);
            assert (rhs0.compareTo(rhs1) >= 0);
            args[1] = this.toTerm(rhs1);
            this.mSolver.defineFun(start.toString(), emptyVars, bool, this.mSolver.term("and", args));
            start = start.add(BigInteger.ONE);
        }
        this.parseSymbolTable();
        this.parseCommentSection();
        this.mBuffer = null;
        System.err.println("Finished parsing");
        Term formula = this.toTerm(output);
        FormulaUnLet unlet = new FormulaUnLet(FormulaUnLet.UnletType.EXPAND_DEFINITIONS);
        this.mSolver.assertTerm(unlet.unlet(formula));
        System.err.println("Asserted formula");
    }

    public int run(Script solver, String filename, OptionMap options) {
        this.mSolver = solver;
        if (filename == null) {
            filename = "<stdin>";
            this.mInputStream = System.in;
        } else {
            try {
                this.mInputStream = new FileInputStream(filename);
            }
            catch (FileNotFoundException efnfe) {
                System.err.println(efnfe.getMessage());
                return 4;
            }
        }
        this.mFilename = filename;
        this.mSolver.setOption(":produce-models", Boolean.TRUE);
        this.mSolver.setLogic(Logics.CORE);
        this.parse();
        Script.LBool isSat = this.mSolver.checkSat();
        System.out.println((Object)isSat);
        if (isSat == Script.LBool.SAT) {
            System.out.println("Stimuli:");
            Model m = this.mSolver.getModel();
            Term trueTerm = this.mSolver.term("true", new Term[0]);
            for (int i = 0; i < this.mInputs.length; ++i) {
                Term var = this.mSolver.term(Integer.toString(i), new Term[0]);
                if (m.evaluate(var) != trueTerm) {
                    System.out.print("not ");
                }
                System.out.println(this.mInputs[i] == null ? Integer.valueOf(i + 1) : this.mInputs[i]);
            }
        }
        return 0;
    }
}

