/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol;

import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.smtinterpol.DefaultLogger;
import de.uni_freiburg.informatik.ultimate.smtinterpol.IParser;
import de.uni_freiburg.informatik.ultimate.smtinterpol.aiger.AIGERFrontEnd;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dimacs.DIMACSParser;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.OptionMap;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib.SMTLIBParser;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.SMTInterpol;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.SMTLIB2Parser;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class Main {
    public static Properties sVersionInfo = new Properties();

    private Main() {
    }

    public static final String getVersion() {
        String version = sVersionInfo.getProperty("version", "unknown version");
        return version;
    }

    private static void usage() {
        System.err.println("USAGE: smtinterpol [OPTION]... [INPUTFILE]");
        System.err.println("If no INPUTFILE is given, stdin is used.");
        System.err.println("  -script <class>      Send the input to another Java class implementing Script.");
        System.err.println("  -no-success          Don't print success messages.");
        System.err.println("  -o <opt>=<value>     Set option :opt to value. The default value is true.");
        System.err.println("  -q                   Only print error messages.");
        System.err.println("  -w                   Don't print statistics and models.");
        System.err.println("  -v                   Print debugging messages.");
        System.err.println("  -t <num>             Set the timeout per check-sat call to <num> milliseconds.");
        System.err.println("  -r <num>             Use a different random seed.");
        System.err.println("  -smt2                Parse input as SMTLIB 2 script.");
        System.err.println("  -smt                 Parse input as SMTLIB 1 benchmark.");
        System.err.println("  -d                   Parse input as DIMACS benchmark.");
        System.err.println("  -version             Print version and exit.");
    }

    private static void version() {
        String date = sVersionInfo.getProperty("build.date");
        System.err.println("SMTInterpol " + Main.getVersion());
        if (date != null) {
            System.err.println("  built on " + date);
        }
    }

    public static void main(String[] param) throws Exception {
        int paramctr;
        DefaultLogger logger = new DefaultLogger();
        OptionMap options = new OptionMap(logger, true);
        IParser parser = new SMTLIB2Parser();
        Script solver = null;
        for (paramctr = 0; paramctr < param.length && param[paramctr].startsWith("-"); ++paramctr) {
            if (param[paramctr].equals("--")) {
                ++paramctr;
                break;
            }
            if (param[paramctr].equals("-script") && paramctr + 1 < param.length) {
                Class<?> scriptClass = Class.forName(param[++paramctr]);
                solver = (Script)scriptClass.newInstance();
                continue;
            }
            if (param[paramctr].equals("-no-success")) {
                options.set(":print-success", false);
                continue;
            }
            if (param[paramctr].equals("-v")) {
                options.set(":verbosity", 5);
                continue;
            }
            if (param[paramctr].equals("-w")) {
                options.set(":verbosity", 3);
                continue;
            }
            if (param[paramctr].equals("-q")) {
                options.set(":verbosity", 2);
                continue;
            }
            if (param[paramctr].equals("-t") && ++paramctr < param.length) {
                options.set(":timeout", param[paramctr]);
                continue;
            }
            if (param[paramctr].equals("-r") && ++paramctr < param.length) {
                options.set(":random-seed", param[paramctr]);
                continue;
            }
            if (param[paramctr].equals("-o") && paramctr + 1 < param.length) {
                Object value;
                String name;
                String opt;
                int eq;
                if ((eq = (opt = param[++paramctr]).indexOf(61)) == -1) {
                    name = opt;
                    value = Boolean.TRUE;
                } else {
                    name = opt.substring(0, eq);
                    value = opt.substring(eq + 1);
                }
                try {
                    options.set(":" + name, value);
                    continue;
                }
                catch (UnsupportedOperationException ex) {
                    System.err.println("Unknown option :" + name + ".");
                    return;
                }
                catch (SMTLIBException ex) {
                    System.err.println(ex.getMessage());
                    return;
                }
            }
            if (param[paramctr].equals("-smt2")) {
                parser = new SMTLIB2Parser();
                continue;
            }
            if (param[paramctr].equals("-smt")) {
                parser = new SMTLIBParser();
                continue;
            }
            if (param[paramctr].equals("-d")) {
                parser = new DIMACSParser();
                continue;
            }
            if (param[paramctr].equals("-a")) {
                parser = new AIGERFrontEnd();
                continue;
            }
            if (param[paramctr].equals("-trace")) {
                options.set(":verbosity", 6);
                continue;
            }
            if (param[paramctr].equals("-version")) {
                Main.version();
                return;
            }
            Main.usage();
            return;
        }
        String filename = null;
        if (paramctr < param.length) {
            filename = param[paramctr++];
        }
        if (paramctr != param.length) {
            Main.usage();
            return;
        }
        options.started();
        if (solver == null) {
            solver = new SMTInterpol(null, options);
        }
        int exitCode = parser.run(solver, filename, options);
        System.exit(exitCode);
    }

    static {
        try {
            InputStream is = Main.class.getResourceAsStream("Version.properties");
            if (is != null) {
                sVersionInfo.load(is);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

