/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol;

import de.uni_freiburg.informatik.ultimate.logic.FormulaLet;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.LoggingScript;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.DefaultLogger;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.OptionMap;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.ParseEnvironment;
import java.io.FileNotFoundException;

public class DefinitionExpander
extends LoggingScript {
    private final FormulaUnLet mUnletter = new FormulaUnLet(FormulaUnLet.UnletType.EXPAND_DEFINITIONS);
    private final FormulaLet mLetter = new FormulaLet();

    public DefinitionExpander(String outfile) throws FileNotFoundException {
        super(outfile, true);
    }

    public Script.LBool assertTerm(Term term) throws SMTLIBException {
        return super.assertTerm(this.mLetter.let(this.mUnletter.unlet(term)));
    }

    public static void main(String[] args) {
        String infile = args[0];
        String outfile = args[1];
        OptionMap options = new OptionMap(new DefaultLogger(), true);
        try {
            ParseEnvironment pe = new ParseEnvironment(new DefinitionExpander(outfile), options);
            pe.parseScript(infile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }
}

