/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol;

import de.uni_freiburg.informatik.ultimate.smtinterpol.ChannelUtil;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Formatter;

public class DefaultLogger
implements LogProxy {
    private static final Object LOCK = new Object();
    private static final String[] LEVELS = new String[]{"FATAL", "ERROR", "WARN", "INFO", "DEBUG", "TRACE"};
    private PrintWriter mWriter = new PrintWriter(System.err);
    private Formatter mFormat = new Formatter(this.mWriter);
    private String mDest = "stderr";
    private int mLevel = 4;

    public void setLoglevel(int level) {
        this.mLevel = level;
    }

    public int getLoglevel() {
        return this.mLevel;
    }

    private final boolean isEnabled(int lvl) {
        return lvl <= this.mLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void log(int lvl, Object msg) {
        Object object = LOCK;
        synchronized (object) {
            this.mWriter.print(LEVELS[lvl - 1]);
            this.mWriter.print(" - ");
            this.mWriter.println(msg);
            this.mWriter.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void log(int lvl, String msg, Object[] params) {
        if (params.length == 0) {
            this.log(lvl, msg);
        }
        Object object = LOCK;
        synchronized (object) {
            this.mWriter.print(LEVELS[lvl - 1]);
            this.mWriter.print(" - ");
            this.mFormat.format(msg, params);
            this.mWriter.println();
            this.mWriter.flush();
        }
    }

    public boolean isFatalEnabled() {
        return this.isEnabled(1);
    }

    public void fatal(String msg, Object ... params) {
        if (this.isFatalEnabled()) {
            this.log(1, msg, params);
        }
    }

    public void fatal(Object msg) {
        if (this.isFatalEnabled()) {
            this.log(1, msg);
        }
    }

    public void outOfMemory(String msg) {
        if (this.isFatalEnabled()) {
            this.log(1, msg);
        }
    }

    public boolean isErrorEnabled() {
        return this.isEnabled(2);
    }

    public void error(String msg, Object ... params) {
        if (this.isErrorEnabled()) {
            this.log(2, msg, params);
        }
    }

    public void error(Object msg) {
        if (this.isErrorEnabled()) {
            this.log(2, msg);
        }
    }

    public boolean isWarnEnabled() {
        return this.isEnabled(3);
    }

    public void warn(String msg, Object ... params) {
        if (this.isWarnEnabled()) {
            this.log(3, msg, params);
        }
    }

    public void warn(Object msg) {
        if (this.isWarnEnabled()) {
            this.log(3, msg);
        }
    }

    public boolean isInfoEnabled() {
        return this.isEnabled(4);
    }

    public void info(String msg, Object ... params) {
        if (this.isInfoEnabled()) {
            this.log(4, msg, params);
        }
    }

    public void info(Object msg) {
        if (this.isInfoEnabled()) {
            this.log(4, msg);
        }
    }

    public boolean isDebugEnabled() {
        return this.isEnabled(5);
    }

    public void debug(String msg, Object ... params) {
        if (this.isDebugEnabled()) {
            this.log(5, msg, params);
        }
    }

    public void debug(Object msg) {
        if (this.isDebugEnabled()) {
            this.log(5, msg);
        }
    }

    public boolean isTraceEnabled() {
        return this.isEnabled(6);
    }

    public void trace(String msg, Object ... params) {
        if (this.isTraceEnabled()) {
            this.log(6, msg, params);
        }
    }

    public void trace(Object msg) {
        if (this.isTraceEnabled()) {
            this.log(6, msg);
        }
    }

    public boolean canChangeDestination() {
        return true;
    }

    public void changeDestination(String newDest) throws IOException {
        this.mWriter = ChannelUtil.createChannel(newDest);
        this.mFormat = new Formatter(this.mWriter);
        this.mDest = newDest;
    }

    public String getDestination() {
        return this.mDest;
    }
}

