/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic.simplification;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import de.uni_freiburg.informatik.ultimate.util.PushPopChecker;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public class SimplifyDDA
extends NonRecursive {
    HashMap<Term, TermInfo> mTermInfos;
    Term mResult;
    final Script mScript;
    final Term mTrue;
    final Term mFalse;
    final boolean mSimplifyRepeatedly;
    protected boolean mInconsistencyOfContextDetected;

    public SimplifyDDA(Script script) {
        this(script, true);
    }

    public SimplifyDDA(Script script, boolean simplifyRepeatedly) {
        this.mScript = script;
        this.mTrue = this.mScript.term("true", new Term[0]);
        this.mFalse = this.mScript.term("false", new Term[0]);
        this.mSimplifyRepeatedly = simplifyRepeatedly;
    }

    public Script.LBool checkEquivalence(Term termA, Term termB) {
        Term equivalentTestTerm = this.mScript.term("=", termA, termB);
        String checktype = null;
        try {
            checktype = (String)this.mScript.getOption(":check-type");
            this.mScript.setOption(":check-type", "FULL");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Script.LBool areTermsEquivalent = Util.checkSat(this.mScript, Util.not(this.mScript, equivalentTestTerm));
        if (checktype != null) {
            this.mScript.setOption(":check-type", checktype);
        }
        return areTermsEquivalent;
    }

    protected Redundancy getRedundancy(Term term) {
        if (this.mInconsistencyOfContextDetected) {
            return Redundancy.NON_CONSTRAINING;
        }
        Script.LBool isTermConstraining = Util.checkSat(this.mScript, Util.not(this.mScript, term));
        if (isTermConstraining == Script.LBool.UNSAT) {
            return Redundancy.NON_CONSTRAINING;
        }
        Script.LBool isTermRelaxing = Util.checkSat(this.mScript, term);
        if (isTermRelaxing == Script.LBool.UNSAT) {
            return Redundancy.NON_RELAXING;
        }
        return Redundancy.NOT_REDUNDANT;
    }

    private static Term termVariable2constant(Script script, TermVariable tv) {
        String name = tv.getName() + "_const_" + tv.hashCode();
        Sort[] paramSorts = new Sort[]{};
        Sort resultSort = tv.getSort();
        script.declareFun(name, paramSorts, resultSort);
        Term result = script.term(name, new Term[0]);
        return result;
    }

    public Term simplifyOnce(Term term) {
        this.mInconsistencyOfContextDetected = false;
        this.mTermInfos = new HashMap();
        this.run(new TermCounter(term));
        this.run(new ContextCollector(false, term, new ArrayDeque<Term>()));
        this.run(new PrepareSimplifier(false, term));
        this.run(new Simplifier(false, term));
        Term output = this.popResult();
        this.mTermInfos = null;
        return output;
    }

    public Term getSimplifiedTerm(Term inputTerm) throws SMTLIBException {
        if (!inputTerm.getSort().getName().equals("Bool")) {
            return inputTerm;
        }
        int lvl = 0;
        assert ((lvl = PushPopChecker.currentLevel(this.mScript)) >= -1);
        Term term = inputTerm;
        this.mScript.echo(new QuotedObject("Begin Simplifier"));
        this.mScript.push(1);
        final TermVariable[] vars = term.getFreeVars();
        final Term[] values = new Term[vars.length];
        for (int i = 0; i < vars.length; ++i) {
            values[i] = SimplifyDDA.termVariable2constant(this.mScript, vars[i]);
        }
        term = this.mScript.let(vars, values, term);
        term = new FormulaUnLet().unlet(term);
        Term output = this.simplifyOnce(term);
        if (this.mSimplifyRepeatedly) {
            while (output != term) {
                term = output;
                output = this.simplifyOnce(term);
            }
        } else {
            term = output;
        }
        term = new TermTransformer(){

            public void convert(Term term) {
                for (int i = 0; i < vars.length; ++i) {
                    if (term != values[i]) continue;
                    term = vars[i];
                }
                super.convert(term);
            }
        }.transform(term);
        this.mScript.pop(1);
        assert (this.checkEquivalence(inputTerm, term) != Script.LBool.SAT) : "Simplification unsound?";
        this.mScript.echo(new QuotedObject("End Simplifier"));
        assert (PushPopChecker.atLevel(this.mScript, lvl));
        return term;
    }

    private Term negateSibling(Term sibling, String connective, int i, int n) {
        boolean negate;
        boolean bl = negate = connective == "or" || connective == "=>" && i == n - 1;
        if (negate) {
            return Util.not(this.mScript, sibling);
        }
        return sibling;
    }

    void pushContext(Term ... context) {
        this.mScript.push(1);
        for (Term t : context) {
            Script.LBool sat = this.mScript.assertTerm(t);
            if (sat != Script.LBool.UNSAT) continue;
            this.mInconsistencyOfContextDetected = true;
            return;
        }
    }

    void popContext() {
        this.mInconsistencyOfContextDetected = false;
        this.mScript.pop(1);
    }

    void setResult(boolean negated, Term term) {
        if (negated) {
            term = Util.not(this.mScript, term);
        }
        assert (this.mResult == null);
        this.mResult = term;
    }

    Term popResult() {
        Term result = this.mResult;
        this.mResult = null;
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Redundancy {
        NON_RELAXING,
        NON_CONSTRAINING,
        NOT_REDUNDANT;

    }

    private static class Simplifier
    implements NonRecursive.Walker {
        final boolean mNegated;
        final Term mTerm;
        final Term[] mContext;
        int mParamCtr;
        Term[] mSimplifiedParams;

        public Simplifier(boolean negated, Term term, Term[] context) {
            ApplicationTerm appTerm;
            while (term instanceof ApplicationTerm && (appTerm = (ApplicationTerm)term).getFunction().getName() == "not") {
                term = appTerm.getParameters()[0];
                negated ^= true;
            }
            this.mNegated = negated;
            this.mTerm = term;
            this.mContext = context;
            this.mParamCtr = 0;
        }

        public Simplifier(boolean negated, Term term) {
            ApplicationTerm appTerm;
            while (term instanceof ApplicationTerm && (appTerm = (ApplicationTerm)term).getFunction().getName() == "not") {
                term = appTerm.getParameters()[0];
                negated ^= true;
            }
            this.mNegated = negated;
            this.mTerm = term;
            this.mContext = null;
            this.mParamCtr = 0;
        }

        public void walk(NonRecursive engine) {
            Redundancy red;
            SimplifyDDA simplifier = (SimplifyDDA)engine;
            if (this.mParamCtr > 0) {
                this.walkParam(simplifier);
                return;
            }
            if (this.mContext == null) {
                red = simplifier.getRedundancy(this.mTerm);
                if (red != Redundancy.NOT_REDUNDANT) {
                    if (red == Redundancy.NON_RELAXING) {
                        simplifier.setResult(this.mNegated, simplifier.mFalse);
                    } else {
                        simplifier.setResult(this.mNegated, simplifier.mTrue);
                    }
                    return;
                }
                TermInfo info = simplifier.mTermInfos.get(this.mTerm);
                if (info.mNumPredecessors > 1) {
                    assert (info.mSimplified != null);
                    simplifier.setResult(this.mNegated, info.mSimplified);
                    return;
                }
            }
            if (this.mContext != null) {
                simplifier.pushContext(this.mContext);
                red = simplifier.getRedundancy(this.mTerm);
                if (red != Redundancy.NOT_REDUNDANT) {
                    if (red == Redundancy.NON_RELAXING) {
                        simplifier.setResult(this.mNegated, simplifier.mFalse);
                    } else {
                        simplifier.setResult(this.mNegated, simplifier.mTrue);
                    }
                    simplifier.popContext();
                    return;
                }
            }
            if (this.mTerm instanceof ApplicationTerm) {
                ApplicationTerm appTerm = (ApplicationTerm)this.mTerm;
                String connective = appTerm.getFunction().getName();
                Term[] params = appTerm.getParameters();
                if (connective == "ite" || connective == "and" || connective == "or" || connective == "=>") {
                    this.mSimplifiedParams = new Term[params.length];
                    this.walkParam(simplifier);
                    return;
                }
            }
            simplifier.setResult(this.mNegated, this.mTerm);
            if (this.mContext != null) {
                simplifier.popContext();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void walkParam(SimplifyDDA simplifier) {
            ApplicationTerm appTerm = (ApplicationTerm)this.mTerm;
            String connective = appTerm.getFunction().getName();
            Term[] params = appTerm.getParameters();
            if (this.mParamCtr > 0) {
                this.mSimplifiedParams[this.mParamCtr - 1] = simplifier.popResult();
            }
            if (connective == "ite") {
                switch (this.mParamCtr++) {
                    case 0: {
                        simplifier.enqueueWalker(this);
                        simplifier.enqueueWalker(new Simplifier(false, params[0]));
                        return;
                    }
                    case 1: {
                        if (this.mSimplifiedParams[0] != simplifier.mFalse) {
                            simplifier.enqueueWalker(this);
                            simplifier.pushContext(this.mSimplifiedParams[0]);
                            simplifier.enqueueWalker(new Simplifier(this.mNegated, params[1]));
                            return;
                        }
                        this.mSimplifiedParams[this.mParamCtr - 1] = simplifier.mFalse;
                        ++this.mParamCtr;
                    }
                    case 2: {
                        if (this.mSimplifiedParams[0] != simplifier.mFalse) {
                            simplifier.popContext();
                        }
                        if (this.mSimplifiedParams[0] != simplifier.mTrue) {
                            simplifier.enqueueWalker(this);
                            simplifier.pushContext(Util.not(simplifier.mScript, this.mSimplifiedParams[0]));
                            simplifier.enqueueWalker(new Simplifier(this.mNegated, params[2]));
                            return;
                        }
                        this.mSimplifiedParams[this.mParamCtr - 1] = simplifier.mFalse;
                        ++this.mParamCtr;
                    }
                    case 3: {
                        if (this.mSimplifiedParams[0] != simplifier.mTrue) {
                            simplifier.popContext();
                        }
                        Term result = Util.ite(simplifier.mScript, this.mSimplifiedParams[0], this.mSimplifiedParams[1], this.mSimplifiedParams[2]);
                        simplifier.setResult(false, result);
                        if (this.mContext == null) return;
                        simplifier.popContext();
                        return;
                    }
                    default: {
                        throw new InternalError("BUG!");
                    }
                }
            }
            assert (connective == "and" || connective == "or" || connective == "=>");
            if (this.mParamCtr == params.length) {
                simplifier.popContext();
                ArrayList<Term> newparams = new ArrayList<Term>();
                Term result = null;
                for (int i = 0; i < this.mSimplifiedParams.length; ++i) {
                    Term param = this.mSimplifiedParams[i];
                    if (param == simplifier.mTrue) {
                        if (connective == "and" || connective == "=>" && i < this.mSimplifiedParams.length - 1) continue;
                        if (connective == "or" || connective == "=>" && i == this.mSimplifiedParams.length - 1) {
                            result = simplifier.mTrue;
                            break;
                        }
                    } else if (param == simplifier.mFalse) {
                        if (connective == "or") continue;
                        if (connective == "and") {
                            result = simplifier.mFalse;
                            break;
                        }
                        if (connective == "=>" && i < this.mSimplifiedParams.length - 1) {
                            result = simplifier.mTrue;
                            break;
                        }
                    }
                    newparams.add(param);
                }
                if (result == null) {
                    if (newparams.isEmpty()) {
                        result = connective == "and" ? simplifier.mTrue : simplifier.mFalse;
                    } else if (newparams.size() == 1) {
                        result = (Term)newparams.get(0);
                    } else {
                        Term[] p = newparams.toArray(new Term[newparams.size()]);
                        result = simplifier.mScript.term(connective, p);
                    }
                }
                simplifier.setResult(this.mNegated, result);
                if (this.mContext == null) return;
                simplifier.popContext();
                return;
            }
            if (this.mParamCtr == 0) {
                simplifier.pushContext(new Term[0]);
                for (int i = params.length - 1; i >= 1; --i) {
                    Term sibling = simplifier.negateSibling(params[i], connective, i, params.length);
                    simplifier.pushContext(sibling);
                }
            } else {
                simplifier.popContext();
                for (int i = 0; i < this.mParamCtr; ++i) {
                    Term sibling = simplifier.negateSibling(this.mSimplifiedParams[i], connective, i, params.length);
                    Script.LBool sat = simplifier.mScript.assertTerm(sibling);
                    if (sat != Script.LBool.UNSAT) continue;
                    simplifier.mInconsistencyOfContextDetected = true;
                    break;
                }
            }
            simplifier.enqueueWalker(this);
            simplifier.enqueueWalker(new Simplifier(false, params[this.mParamCtr]));
            ++this.mParamCtr;
        }

        public String toString() {
            return "Simplifier[" + this.mTerm + ", param: " + this.mParamCtr + "]";
        }
    }

    private static class StoreSimplified
    implements NonRecursive.Walker {
        Term mTerm;

        public StoreSimplified(Term term) {
            this.mTerm = term;
        }

        public void walk(NonRecursive engine) {
            SimplifyDDA simplifier = (SimplifyDDA)engine;
            TermInfo info = simplifier.mTermInfos.get(this.mTerm);
            info.mSimplified = simplifier.popResult();
        }

        public String toString() {
            return "StoreSimplified[" + this.mTerm + "]";
        }
    }

    private static class PrepareSimplifier
    implements NonRecursive.Walker {
        final Term mTerm;

        public PrepareSimplifier(boolean negated, Term term) {
            ApplicationTerm appTerm;
            while (term instanceof ApplicationTerm && (appTerm = (ApplicationTerm)term).getFunction().getName() == "not") {
                term = appTerm.getParameters()[0];
            }
            this.mTerm = term;
        }

        public void walk(NonRecursive engine) {
            SimplifyDDA simplifier = (SimplifyDDA)engine;
            TermInfo info = simplifier.mTermInfos.get(this.mTerm);
            if (info.mPrepared++ > 0) {
                return;
            }
            if (info.mNumPredecessors > 1) {
                engine.enqueueWalker(new StoreSimplified(this.mTerm));
                engine.enqueueWalker(new Simplifier(false, this.mTerm, info.mContext));
            }
            if (this.mTerm instanceof ApplicationTerm) {
                ApplicationTerm appTerm = (ApplicationTerm)this.mTerm;
                String connective = appTerm.getFunction().getName();
                Term[] params = appTerm.getParameters();
                if (connective == "ite" || connective == "and" || connective == "or" || connective == "=>") {
                    for (int i = 0; i < params.length; ++i) {
                        engine.enqueueWalker(new PrepareSimplifier(false, params[i]));
                    }
                }
            }
        }

        public String toString() {
            return "PrepareSimplifier[" + this.mTerm + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContextCollector
    implements NonRecursive.Walker {
        final boolean mNegated;
        final Term mTerm;
        ArrayDeque<Term> mContext;
        int mParamCtr;

        public ContextCollector(boolean negated, Term term, ArrayDeque<Term> context) {
            ApplicationTerm appTerm;
            while (term instanceof ApplicationTerm && (appTerm = (ApplicationTerm)term).getFunction().getName() == "not") {
                term = appTerm.getParameters()[0];
                negated ^= true;
            }
            this.mNegated = negated;
            this.mTerm = term;
            this.mContext = context;
            this.mParamCtr = 0;
        }

        @Override
        public void walk(NonRecursive engine) {
            SimplifyDDA simplifier = (SimplifyDDA)engine;
            if (this.mParamCtr > 0) {
                this.walkNextParameter(simplifier);
                return;
            }
            TermInfo info = simplifier.mTermInfos.get(this.mTerm);
            assert (info != null);
            ++info.mSeen;
            assert (info.mSeen <= info.mNumPredecessors);
            if (info.mNumPredecessors > 1) {
                if (info.mContext == null) {
                    info.mContext = this.mContext.toArray(new Term[this.mContext.size()]);
                } else {
                    HashSet<Term> oldContext = new HashSet<Term>(info.mContext.length);
                    oldContext.addAll(Arrays.asList(info.mContext));
                    ArrayDeque<Term> newContext = new ArrayDeque<Term>(info.mContext.length);
                    for (Term t : this.mContext) {
                        if (!oldContext.contains(t)) continue;
                        newContext.add(t);
                    }
                    this.mContext = newContext;
                    info.mContext = newContext.toArray(new Term[newContext.size()]);
                }
                if (info.mSeen < info.mNumPredecessors) {
                    return;
                }
            }
            if (this.mTerm instanceof ApplicationTerm) {
                this.walkNextParameter(simplifier);
            }
        }

        public void walkNextParameter(SimplifyDDA simplifier) {
            ApplicationTerm appTerm = (ApplicationTerm)this.mTerm;
            String connective = appTerm.getFunction().getName();
            Term[] params = appTerm.getParameters();
            if (connective == "ite") {
                Term cond = params[0];
                if (this.mParamCtr == 0) {
                    simplifier.enqueueWalker(this);
                    simplifier.enqueueWalker(new ContextCollector(false, cond, this.mContext));
                } else if (this.mParamCtr == 1) {
                    this.mContext.push(cond);
                    simplifier.enqueueWalker(this);
                    simplifier.enqueueWalker(new ContextCollector(this.mNegated, params[1], this.mContext));
                } else if (this.mParamCtr == 2) {
                    this.mContext.pop();
                    this.mContext.push(Util.not(simplifier.mScript, cond));
                    simplifier.enqueueWalker(this);
                    simplifier.enqueueWalker(new ContextCollector(this.mNegated, params[2], this.mContext));
                } else if (this.mParamCtr == 3) {
                    this.mContext.pop();
                }
                ++this.mParamCtr;
            } else if (connective == "and" || connective == "or" || connective == "=>") {
                if (this.mParamCtr == 0) {
                    for (int i = params.length - 1; i > 0; --i) {
                        Term sibling = simplifier.negateSibling(params[i], connective, i, params.length);
                        this.mContext.push(sibling);
                    }
                    simplifier.enqueueWalker(this);
                    simplifier.enqueueWalker(new ContextCollector(this.mNegated, params[this.mParamCtr], this.mContext));
                } else if (this.mParamCtr < params.length) {
                    this.mContext.pop();
                    simplifier.enqueueWalker(this);
                    simplifier.enqueueWalker(new ContextCollector(this.mNegated, params[this.mParamCtr], this.mContext));
                }
                ++this.mParamCtr;
            }
        }
    }

    private static class TermCounter
    implements NonRecursive.Walker {
        protected Term mTerm;

        public TermCounter(Term term) {
            ApplicationTerm appTerm;
            while (term instanceof ApplicationTerm && (appTerm = (ApplicationTerm)term).getFunction().getName() == "not") {
                term = appTerm.getParameters()[0];
            }
            this.mTerm = term;
        }

        public void walk(NonRecursive engine) {
            SimplifyDDA simplifier = (SimplifyDDA)engine;
            TermInfo info = simplifier.mTermInfos.get(this.mTerm);
            if (info == null) {
                ApplicationTerm appTerm;
                String connective;
                info = new TermInfo();
                simplifier.mTermInfos.put(this.mTerm, info);
                if (this.mTerm instanceof ApplicationTerm && ((connective = (appTerm = (ApplicationTerm)this.mTerm).getFunction().getName()) == "ite" || connective == "and" || connective == "or" || connective == "=>")) {
                    for (Term subTerm : appTerm.getParameters()) {
                        engine.enqueueWalker(new TermCounter(subTerm));
                    }
                }
            }
            ++info.mNumPredecessors;
        }
    }

    private static class TermInfo {
        int mNumPredecessors;
        int mSeen;
        int mPrepared;
        Term[] mContext;
        Term mSimplified;

        private TermInfo() {
        }

        public String toString() {
            return "TermInfo[" + this.mNumPredecessors + "," + this.mSeen + "," + this.mPrepared + (this.mContext == null ? "" : ",context:" + Arrays.toString(this.mContext)) + (this.mSimplified == null ? "" : "->" + this.mSimplified) + "]";
        }
    }
}

