/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;

public class TermEquivalence
extends NonRecursive {
    private final ScopedHashMap<TermVariable, TermVariable> mRenaming = new ScopedHashMap();

    private void beginScope() {
        this.mRenaming.beginScope();
    }

    private void endScope() {
        this.mRenaming.endScope();
    }

    private void addRenaming(TermVariable lvar, TermVariable rvar) {
        this.mRenaming.put(lvar, rvar);
    }

    private boolean checkRenaming(TermVariable lvar, TermVariable rvar) {
        return this.mRenaming.get(lvar) == rvar;
    }

    public boolean equal(Term lhs, Term rhs) {
        try {
            this.run(new TermEq(lhs, rhs));
            return true;
        }
        catch (NotEq ignored) {
            this.reset();
            return false;
        }
    }

    private static final class TermEq
    implements NonRecursive.Walker {
        private final Term mLhs;
        private final Term mRhs;

        public TermEq(Term lhs, Term rhs) {
            this.mLhs = lhs;
            this.mRhs = rhs;
        }

        private final void notEqual() {
            throw new NotEq();
        }

        public void walk(NonRecursive engine) {
            TermEquivalence te = (TermEquivalence)engine;
            if (this.mLhs != this.mRhs) {
                TermVariable rv;
                TermVariable lv;
                if (this.mLhs.getClass() != this.mRhs.getClass()) {
                    this.notEqual();
                }
                if (this.mLhs instanceof ApplicationTerm) {
                    Term[] rparams;
                    Term[] lparams;
                    ApplicationTerm l = (ApplicationTerm)this.mLhs;
                    ApplicationTerm r = (ApplicationTerm)this.mRhs;
                    if (l.getFunction() != r.getFunction()) {
                        this.notEqual();
                    }
                    if ((lparams = l.getParameters()).length != (rparams = r.getParameters()).length) {
                        this.notEqual();
                    }
                    for (int i = 0; i < lparams.length; ++i) {
                        te.enqueueWalker(new TermEq(lparams[i], rparams[i]));
                    }
                } else if (this.mLhs instanceof AnnotatedTerm) {
                    AnnotatedTerm l = (AnnotatedTerm)this.mLhs;
                    AnnotatedTerm r = (AnnotatedTerm)this.mRhs;
                    Annotation[] lannot = l.getAnnotations();
                    Annotation[] rannot = r.getAnnotations();
                    if (rannot.length != lannot.length) {
                        this.notEqual();
                    }
                    for (int i = 0; i < lannot.length; ++i) {
                        if (!lannot[i].getKey().equals(rannot[i].getKey())) {
                            this.notEqual();
                        }
                        if (lannot[i].getValue() instanceof Term && rannot[i].getValue() instanceof Term) {
                            te.enqueueWalker(new TermEq((Term)lannot[i].getValue(), (Term)rannot[i].getValue()));
                            continue;
                        }
                        if (lannot[i].getValue() instanceof Term[] && rannot[i].getValue() instanceof Term[]) {
                            Term[] rv2;
                            Term[] lv2 = (Term[])lannot[i].getValue();
                            if (lv2.length != (rv2 = (Term[])lannot[i].getValue()).length) {
                                this.notEqual();
                            }
                            for (int j = 0; j < lv2.length; ++j) {
                                te.enqueueWalker(new TermEq(lv2[j], rv2[j]));
                            }
                            continue;
                        }
                        if (lannot[i].getValue().equals(rannot[i].getValue())) continue;
                        this.notEqual();
                    }
                } else if (this.mLhs instanceof LetTerm) {
                    TermVariable[] rvars;
                    LetTerm llet = (LetTerm)this.mLhs;
                    LetTerm rlet = (LetTerm)this.mRhs;
                    TermVariable[] lvars = llet.getVariables();
                    if (lvars.length != (rvars = rlet.getVariables()).length) {
                        this.notEqual();
                    }
                    te.enqueueWalker(EndScope.INSTANCE);
                    te.enqueueWalker(new TermEq(llet.getSubTerm(), rlet.getSubTerm()));
                    Term[] lvals = llet.getValues();
                    Term[] rvals = rlet.getValues();
                    for (int i = 0; i < lvars.length; ++i) {
                        te.enqueueWalker(new AddRenaming(lvars[i], rvars[i]));
                        te.enqueueWalker(new TermEq(lvals[i], rvals[i]));
                    }
                    te.beginScope();
                } else if (this.mLhs instanceof QuantifiedFormula) {
                    TermVariable[] rv3;
                    TermVariable[] lv3;
                    QuantifiedFormula lq = (QuantifiedFormula)this.mLhs;
                    QuantifiedFormula rq = (QuantifiedFormula)this.mRhs;
                    if (lq.getQuantifier() != rq.getQuantifier()) {
                        this.notEqual();
                    }
                    if ((lv3 = lq.getVariables()).length != (rv3 = rq.getVariables()).length) {
                        this.notEqual();
                    }
                    te.enqueueWalker(EndScope.INSTANCE);
                    te.beginScope();
                    for (int i = 0; i < lv3.length; ++i) {
                        if (lv3[i] == rv3[i]) continue;
                        if (lv3[i].getSort() != rv3[i].getSort()) {
                            this.notEqual();
                        }
                        te.addRenaming(lv3[i], rv3[i]);
                    }
                    te.enqueueWalker(new TermEq(lq.getSubformula(), rq.getSubformula()));
                } else if (this.mLhs instanceof TermVariable && !te.checkRenaming(lv = (TermVariable)this.mLhs, rv = (TermVariable)this.mRhs)) {
                    this.notEqual();
                }
            }
        }
    }

    private static final class AddRenaming
    implements NonRecursive.Walker {
        private final TermVariable mLvar;
        private final TermVariable mRvar;

        public AddRenaming(TermVariable lvar, TermVariable rvar) {
            this.mLvar = lvar;
            this.mRvar = rvar;
        }

        public void walk(NonRecursive engine) {
            TermEquivalence te = (TermEquivalence)engine;
            te.addRenaming(this.mLvar, this.mRvar);
        }
    }

    private static final class EndScope
    implements NonRecursive.Walker {
        public static final EndScope INSTANCE = new EndScope();

        private EndScope() {
        }

        public void walk(NonRecursive engine) {
            TermEquivalence te = (TermEquivalence)engine;
            te.endScope();
        }
    }

    private static final class NotEq
    extends RuntimeException {
        private NotEq() {
        }
    }
}

