/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayDeque;

public class NonRecursive {
    private final ArrayDeque<Walker> mTodo = new ArrayDeque();

    protected void reset() {
        this.mTodo.clear();
    }

    public void enqueueWalker(Walker item) {
        this.mTodo.addLast(item);
    }

    public void run(Walker item) {
        this.mTodo.addLast(item);
        this.run();
    }

    public void run() {
        while (!this.mTodo.isEmpty()) {
            this.mTodo.removeLast().walk(this);
        }
    }

    public String toString() {
        return this.mTodo.toString();
    }

    public static abstract class TermWalker
    implements Walker {
        protected Term mTerm;

        public TermWalker(Term term) {
            this.mTerm = term;
        }

        public void walk(NonRecursive walker) {
            if (this.mTerm instanceof ApplicationTerm) {
                this.walk(walker, (ApplicationTerm)this.mTerm);
            } else if (this.mTerm instanceof LetTerm) {
                this.walk(walker, (LetTerm)this.mTerm);
            } else if (this.mTerm instanceof AnnotatedTerm) {
                this.walk(walker, (AnnotatedTerm)this.mTerm);
            } else if (this.mTerm instanceof QuantifiedFormula) {
                this.walk(walker, (QuantifiedFormula)this.mTerm);
            } else if (this.mTerm instanceof ConstantTerm) {
                this.walk(walker, (ConstantTerm)this.mTerm);
            } else if (this.mTerm instanceof TermVariable) {
                this.walk(walker, (TermVariable)this.mTerm);
            }
        }

        public abstract void walk(NonRecursive var1, ConstantTerm var2);

        public abstract void walk(NonRecursive var1, AnnotatedTerm var2);

        public abstract void walk(NonRecursive var1, ApplicationTerm var2);

        public abstract void walk(NonRecursive var1, LetTerm var2);

        public abstract void walk(NonRecursive var1, QuantifiedFormula var2);

        public abstract void walk(NonRecursive var1, TermVariable var2);

        public Term getTerm() {
            return this.mTerm;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ":" + this.mTerm;
        }
    }

    protected static interface Walker {
        public void walk(NonRecursive var1);
    }
}

