/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormulaUnLet
extends TermTransformer {
    private final ScopedHashMap<TermVariable, Term> mLetMap = new ScopedHashMap(false);
    private final UnletType mType;

    public FormulaUnLet() {
        this(UnletType.SMTLIB);
    }

    public FormulaUnLet(UnletType type) {
        this.mType = type;
    }

    public void addSubstitutions(Map<TermVariable, Term> termSubst) {
        this.mLetMap.putAll(termSubst);
    }

    public Term unlet(Term term) {
        return this.transform(term);
    }

    @Override
    public void convert(Term term) {
        if (term instanceof TermVariable) {
            Term value = this.mLetMap.get(term);
            if (value == null) {
                this.setResult(term);
            } else if (this.mType.mIsLazy) {
                this.pushTerm(value);
            } else {
                this.setResult(value);
            }
        } else if (this.mType.mIsLazy && term instanceof LetTerm) {
            LetTerm letTerm = (LetTerm)term;
            this.preConvertLet(letTerm, letTerm.getValues());
        } else if (term instanceof QuantifiedFormula) {
            QuantifiedFormula qf = (QuantifiedFormula)term;
            TermVariable[] vars = qf.getVariables();
            Theory theory = term.getTheory();
            HashSet<TermVariable> used = new HashSet<TermVariable>();
            for (Map.Entry<TermVariable, Term> substTerms : this.mLetMap.entrySet()) {
                if (Arrays.asList(vars).contains(substTerms.getKey())) continue;
                used.addAll(Arrays.asList(substTerms.getValue().getFreeVars()));
            }
            this.mLetMap.beginScope();
            for (int i = 0; i < vars.length; ++i) {
                if (used.contains(vars[i])) {
                    this.mLetMap.put(vars[i], theory.createFreshTermVariable("unlet", vars[i].getSort()));
                    continue;
                }
                if (!this.mLetMap.containsKey(vars[i])) continue;
                this.mLetMap.remove(vars[i]);
            }
            super.convert(term);
        } else if (term instanceof ApplicationTerm) {
            ApplicationTerm appTerm = (ApplicationTerm)term;
            if (this.mType.mExpandDefinitions && appTerm.getFunction().getDefinition() != null) {
                FunctionSymbol defed = appTerm.getFunction();
                Term fakeLet = appTerm.getTheory().let(defed.getDefinitionVars(), appTerm.getParameters(), defed.getDefinition());
                this.pushTerm(fakeLet);
                return;
            }
            super.convert(term);
        } else {
            super.convert(term);
        }
    }

    @Override
    public void preConvertLet(LetTerm oldLet, Term[] newValues) {
        this.mLetMap.beginScope();
        TermVariable[] vars = oldLet.getVariables();
        for (int i = 0; i < vars.length; ++i) {
            this.mLetMap.put(vars[i], newValues[i]);
        }
        super.preConvertLet(oldLet, newValues);
    }

    @Override
    public void postConvertLet(LetTerm oldLet, Term[] newValues, Term newBody) {
        this.setResult(newBody);
        this.mLetMap.endScope();
    }

    @Override
    public void postConvertQuantifier(QuantifiedFormula old, Term newBody) {
        TermVariable[] vars;
        TermVariable[] newVars = vars = old.getVariables();
        for (int i = 0; i < vars.length; ++i) {
            Term newVar = this.mLetMap.get(vars[i]);
            if (newVar == null) continue;
            if (vars == newVars) {
                newVars = (TermVariable[])vars.clone();
            }
            newVars[i] = (TermVariable)newVar;
        }
        this.mLetMap.endScope();
        if (vars == newVars && old.getSubformula() == newBody) {
            this.setResult(old);
        } else {
            Theory theory = old.getTheory();
            this.setResult(old.getQuantifier() == 0 ? theory.exists(newVars, newBody) : theory.forall(newVars, newBody));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UnletType {
        SMTLIB(false, false),
        LAZY(true, false),
        EXPAND_DEFINITIONS(false, true);

        final boolean mIsLazy;
        final boolean mExpandDefinitions;

        private UnletType(boolean lazy, boolean expandDefinitions) {
            this.mIsLazy = lazy;
            this.mExpandDefinitions = expandDefinitions;
        }
    }
}

