/*
 * Decompiled with CFR 0.152.
 */
package com.github.jhoenicke.javacup.runtime;

import com.github.jhoenicke.javacup.runtime.DefaultSymbolFactory;
import com.github.jhoenicke.javacup.runtime.Scanner;
import com.github.jhoenicke.javacup.runtime.Symbol;
import com.github.jhoenicke.javacup.runtime.SymbolFactory;
import com.github.jhoenicke.javacup.runtime.TableDecoder;
import com.github.jhoenicke.javacup.runtime.VirtualParseStack;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LRParser {
    public SymbolFactory symbolFactory;
    private static final int ERROR = 0;
    private static final int EOF = 1;
    private boolean _done_parsing = false;
    protected Symbol cur_token;
    protected ArrayList<Symbol> stack = new ArrayList();
    private int[] base_table;
    private short[] action_table;
    private short[] reduce_table;
    private short[] production_table;
    private Scanner _scanner;

    public LRParser() {
        this(null);
    }

    public LRParser(Scanner scanner) {
        this(scanner, new DefaultSymbolFactory());
    }

    public LRParser(Scanner scanner, SymbolFactory symbolFactory) {
        this.symbolFactory = symbolFactory;
        this.setScanner(scanner);
    }

    public SymbolFactory getSymbolFactory() {
        return this.symbolFactory;
    }

    protected int error_sync_size() {
        return 3;
    }

    public void done_parsing() {
        this._done_parsing = true;
    }

    public void setScanner(Scanner scanner) {
        this._scanner = scanner;
    }

    public Scanner getScanner() {
        return this._scanner;
    }

    public abstract Symbol do_action(int var1, ArrayList<Symbol> var2) throws Exception;

    protected abstract String[] action_table();

    public void user_init() throws Exception {
    }

    protected abstract void init_actions() throws Exception;

    public Symbol scan() throws Exception {
        Symbol symbol = this.getScanner().next_token();
        return symbol != null ? symbol : this.getSymbolFactory().newSymbol("END_OF_FILE", 0);
    }

    public void report_fatal_error(String string, Object object) throws Exception {
        this.done_parsing();
        this.report_error(string, object);
        throw new Exception("Can't recover from previous error(s)");
    }

    public void report_error(String string, Object object) {
        System.err.print(string);
        System.err.flush();
        if (object instanceof Symbol) {
            if (((Symbol)object).left != -1) {
                System.err.println(" at character " + ((Symbol)object).left + " of input");
            } else {
                System.err.println("");
            }
        } else {
            System.err.println("");
        }
    }

    public void syntax_error(Symbol symbol) {
        this.report_error("Syntax error", symbol);
    }

    public void unrecovered_syntax_error(Symbol symbol) throws Exception {
        this.report_fatal_error("Couldn't repair and continue parse", symbol);
    }

    private final short get_action(int n, int n2) {
        int n3 = this.base_table[n] + 2 * n2;
        if (this.action_table[n3] == n) {
            return this.action_table[n3 + 1];
        }
        return this.action_table[n];
    }

    private final short get_reduce(int n, int n2) {
        return this.reduce_table[this.reduce_table[n] + n2];
    }

    public Symbol parse() throws Exception {
        this.init_actions();
        this.user_init();
        this.unpackStrings(this.action_table());
        this.cur_token = this.scan();
        this.stack.clear();
        this.stack.add(this.getSymbolFactory().startSymbol("START", 0, 0));
        int n = 0;
        this._done_parsing = false;
        while (!this._done_parsing) {
            int n2 = this.get_action(n, this.cur_token.sym);
            if ((n2 & 1) != 0) {
                this.cur_token.parse_state = n = n2 >> 1;
                this.stack.add(this.cur_token);
                this.cur_token = this.scan();
                continue;
            }
            if (n2 != 0) {
                n2 = (n2 >> 1) - 1;
                Symbol symbol = this.do_action(n2, this.stack);
                int n3 = this.production_table[2 * n2 + 1];
                while (n3-- > 0) {
                    this.stack.remove(this.stack.size() - 1);
                }
                symbol.parse_state = n = (int)this.get_reduce(this.stack.get((int)(this.stack.size() - 1)).parse_state, symbol.sym);
                this.stack.add(symbol);
                continue;
            }
            this.error_recovery(false);
            if (this.stack.isEmpty()) continue;
            n = this.stack.get((int)(this.stack.size() - 1)).parse_state;
        }
        this.production_table = null;
        this.action_table = null;
        this.reduce_table = null;
        return this.stack.isEmpty() ? null : this.stack.get(this.stack.size() - 1);
    }

    public void debug_message(String string) {
        System.err.println(string);
    }

    public void dump_stack() {
        if (this.stack == null) {
            this.debug_message("# Stack dump requested, but stack is null");
            return;
        }
        this.debug_message("============ Parse Stack Dump ============");
        for (int i = 0; i < this.stack.size(); ++i) {
            this.debug_message("Symbol: " + this.stack.get((int)i).sym + " State: " + this.stack.get((int)i).parse_state);
        }
        this.debug_message("==========================================");
    }

    public void debug_reduce(int n, Symbol symbol, int n2) {
        this.debug_message("# Reduce with prod #" + n + " [NT=" + symbol + ", " + "SZ=" + n2 + "]");
    }

    public void debug_shift(Symbol symbol) {
        this.debug_message("# Shift under term " + symbol + " to state #" + symbol.parse_state);
    }

    public void debug_stack() {
        StringBuffer stringBuffer = new StringBuffer("## STACK:");
        for (int i = 0; i < this.stack.size(); ++i) {
            Symbol symbol = this.stack.get(i);
            stringBuffer.append(" <state " + symbol.parse_state + ", sym " + symbol.sym + ">");
            if (i % 3 != 2 && i != this.stack.size() - 1) continue;
            this.debug_message(stringBuffer.toString());
            stringBuffer = new StringBuffer("         ");
        }
    }

    public Symbol debug_parse() throws Exception {
        this.debug_message("# Initializing parser");
        this.init_actions();
        this.user_init();
        this.unpackStrings(this.action_table());
        this.cur_token = this.scan();
        this.debug_message("# Current Symbol is #" + this.cur_token.sym);
        this.stack.clear();
        this.stack.add(this.getSymbolFactory().startSymbol("START", 0, 0));
        int n = 0;
        this._done_parsing = false;
        while (!this._done_parsing) {
            if (this.cur_token.used_by_parser) {
                throw new Error("Symbol recycling detected (fix your scanner).");
            }
            int n2 = this.get_action(n, this.cur_token.sym);
            if ((n2 & 1) != 0) {
                this.cur_token.parse_state = n = n2 >> 1;
                this.cur_token.used_by_parser = true;
                this.debug_shift(this.cur_token);
                this.stack.add(this.cur_token);
                this.cur_token = this.scan();
                this.debug_message("# Current token is " + this.cur_token);
                continue;
            }
            if (n2 != 0) {
                n2 = (n2 >> 1) - 1;
                Symbol symbol = this.do_action(n2, this.stack);
                int n3 = this.production_table[2 * n2 + 1];
                this.debug_reduce(n2, symbol, n3);
                while (n3-- > 0) {
                    this.stack.remove(this.stack.size() - 1);
                }
                n2 = this.get_reduce(this.stack.get((int)(this.stack.size() - 1)).parse_state, symbol.sym);
                this.debug_message("# Reduce rule: top state " + this.stack.get((int)(this.stack.size() - 1)).parse_state + ", lhs sym " + symbol.sym + " -> state " + n2);
                symbol.parse_state = n = n2;
                symbol.used_by_parser = true;
                this.stack.add(symbol);
                this.debug_message("# Goto state #" + n2);
                continue;
            }
            this.error_recovery(true);
            if (this.stack.isEmpty()) continue;
            n = this.stack.get((int)(this.stack.size() - 1)).parse_state;
        }
        this.production_table = null;
        this.action_table = null;
        this.reduce_table = null;
        return this.stack.isEmpty() ? null : this.stack.get(this.stack.size() - 1);
    }

    private void error_recovery(boolean bl) throws Exception {
        int n;
        this.syntax_error(this.cur_token);
        if (bl) {
            this.debug_message("# Attempting error recovery");
        }
        if (!this.find_recovery_config(bl)) {
            if (bl) {
                this.debug_message("# Error recovery fails");
            }
            this.unrecovered_syntax_error(this.cur_token);
            this.done_parsing();
            return;
        }
        Symbol[] symbolArray = new Symbol[this.error_sync_size()];
        symbolArray[0] = this.cur_token;
        for (n = 1; n < symbolArray.length; ++n) {
            symbolArray[n] = this.scan();
        }
        while (true) {
            if (bl) {
                this.debug_message("# Trying to parse ahead");
            }
            if (this.try_parse_ahead(bl, symbolArray)) break;
            if (symbolArray[0].sym == 1) {
                if (bl) {
                    this.debug_message("# Error recovery fails at EOF");
                }
                this.unrecovered_syntax_error(this.cur_token);
                this.done_parsing();
                return;
            }
            if (bl) {
                this.debug_message("# Consuming Symbol #" + symbolArray[0].sym);
            }
            for (n = 1; n < symbolArray.length; ++n) {
                symbolArray[n - 1] = symbolArray[n];
            }
            symbolArray[symbolArray.length - 1] = this.scan();
        }
        if (bl) {
            this.debug_message("# Parse-ahead ok, going back to normal parse");
        }
        this.parse_lookahead(bl, symbolArray);
    }

    private boolean find_recovery_config(boolean bl) throws Exception {
        int n;
        if (bl) {
            this.debug_message("# Finding recovery state on stack");
        }
        Symbol symbol = this.stack.get(this.stack.size() - 1);
        Symbol symbol2 = this.cur_token;
        while (((n = this.get_action(this.stack.get((int)(this.stack.size() - 1)).parse_state, 0)) & 1) == 0) {
            if (n == 0) {
                if (bl) {
                    this.debug_message("# Pop stack by one, state was # " + this.stack.get((int)(this.stack.size() - 1)).parse_state);
                }
                symbol2 = this.stack.remove(this.stack.size() - 1);
                if (!this.stack.isEmpty()) continue;
                if (bl) {
                    this.debug_message("# No recovery state found on stack");
                }
                return false;
            }
            n = (n >> 1) - 1;
            Symbol symbol3 = this.do_action(n, this.stack);
            int n2 = this.production_table[2 * n + 1];
            if (bl) {
                this.debug_reduce(n, symbol3, n2);
            }
            while (n2-- > 0) {
                this.stack.remove(this.stack.size() - 1);
            }
            symbol3.parse_state = n = (int)this.get_reduce(this.stack.get((int)(this.stack.size() - 1)).parse_state, symbol3.sym);
            symbol3.used_by_parser = true;
            this.stack.add(symbol3);
            if (!bl) continue;
            this.debug_message("# Goto state #" + n);
        }
        if (bl) {
            this.debug_message("# Recover state found (#" + this.stack.get((int)(this.stack.size() - 1)).parse_state + ")");
            this.debug_message("# Shifting on error to state #" + (n - 1));
        }
        Symbol symbol4 = this.getSymbolFactory().newSymbol("ERROR", 1, symbol2, symbol);
        symbol4.parse_state = n >> 1;
        symbol4.used_by_parser = true;
        this.stack.add(symbol4);
        return true;
    }

    private boolean try_parse_ahead(boolean bl, Symbol[] symbolArray) throws Exception {
        VirtualParseStack virtualParseStack = new VirtualParseStack(this.stack);
        int n = virtualParseStack.top();
        int n2 = 0;
        this.cur_token = symbolArray[n2++];
        while (true) {
            int n3;
            if (((n3 = this.get_action(n, this.cur_token.sym)) & 1) != 0) {
                n = n3 >> 1;
                virtualParseStack.push(n);
                if (bl) {
                    this.debug_message("# Parse-ahead shifts Symbol #" + this.cur_token.sym + " into state #" + n);
                }
                if (n2 == symbolArray.length) {
                    return true;
                }
                this.cur_token = symbolArray[n2++];
                continue;
            }
            if (n3 <= 0) break;
            if ((n3 = (n3 >> 1) - 1) == 0) {
                if (bl) {
                    this.debug_message("# Parse-ahead accepts");
                }
                return true;
            }
            short s = this.production_table[2 * n3];
            short s2 = this.production_table[2 * n3 + 1];
            virtualParseStack.pop(s2);
            if (bl) {
                this.debug_message("# Parse-ahead reduces: handle size = " + s2 + " lhs = #" + s + " from state #" + virtualParseStack.top());
            }
            n = this.get_reduce(virtualParseStack.top(), s);
            virtualParseStack.push(n);
            if (!bl) continue;
            this.debug_message("# Goto state #" + virtualParseStack.top());
        }
        return false;
    }

    private void parse_lookahead(boolean bl, Symbol[] symbolArray) throws Exception {
        Symbol symbol = null;
        int n = 0;
        this.cur_token = symbolArray[n++];
        if (bl) {
            this.debug_message("# Reparsing saved input with actions");
            this.debug_message("# Current Symbol is #" + this.cur_token.sym);
            this.debug_message("# Current state is #" + this.stack.get((int)(this.stack.size() - 1)).parse_state);
        }
        while (!this._done_parsing && n < symbolArray.length) {
            int n2 = this.get_action(this.stack.get((int)(this.stack.size() - 1)).parse_state, this.cur_token.sym);
            if ((n2 & 1) != 0) {
                this.cur_token.parse_state = n2 >> 1;
                this.cur_token.used_by_parser = true;
                if (bl) {
                    this.debug_shift(this.cur_token);
                }
                this.stack.add(this.cur_token);
                this.cur_token = symbolArray[n++];
                if (!bl) continue;
                this.debug_message("# Current Symbol is #" + this.cur_token.sym);
                continue;
            }
            n2 = (n2 >> 1) - 1;
            symbol = this.do_action(n2, this.stack);
            int n3 = this.production_table[2 * n2 + 1];
            if (bl) {
                this.debug_reduce(n2, symbol, n3);
            }
            while (n3-- > 0) {
                this.stack.remove(this.stack.size() - 1);
            }
            symbol.parse_state = n2 = (int)this.get_reduce(this.stack.get((int)(this.stack.size() - 1)).parse_state, symbol.sym);
            symbol.used_by_parser = true;
            this.stack.add(symbol);
            if (!bl) continue;
            this.debug_message("# Goto state #" + n2);
        }
        if (bl) {
            this.debug_message("# Completed reparse");
        }
    }

    private void unpackStrings(String[] stringArray) {
        TableDecoder tableDecoder = new TableDecoder(stringArray);
        this.production_table = tableDecoder.decodeShortArray();
        this.base_table = tableDecoder.decodeIntArray();
        this.action_table = tableDecoder.decodeShortArray();
        this.reduce_table = tableDecoder.decodeShortArray();
    }
}

